/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.annotation.GeneratedValue;
import io.micronaut.data.annotation.JsonRepresentation;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.annotation.TypeDef;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.PersistentElement;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.runtime.convert.AttributeConverter;
import java.util.List;
import org.jspecify.annotations.Nullable;

public interface PersistentProperty
extends PersistentElement {
    public String getName();

    @Deprecated(forRemoval=true)
    default public String getCapitilizedName() {
        return NameUtils.capitalize((String)this.getName());
    }

    default public String getCapitalizedName() {
        return NameUtils.capitalize((String)this.getName());
    }

    public String getTypeName();

    public PersistentEntity getOwner();

    default public boolean isOptional() {
        return PersistentProperty.isNullableMetadata(this.getAnnotationMetadata());
    }

    default public boolean isRequired() {
        return !this.isOptional() && !this.isGenerated() && !this.getAnnotationMetadata().hasStereotype(AutoPopulated.class);
    }

    default public boolean isReadOnly() {
        return this.isGenerated();
    }

    default public boolean isConstructorArgument() {
        return false;
    }

    default public boolean isGenerated() {
        return this.getAnnotationMetadata().hasAnnotation(GeneratedValue.class);
    }

    default public boolean isAutoPopulated() {
        return !this.isGenerated() && this.getAnnotationMetadata().hasStereotype(AutoPopulated.class);
    }

    public boolean isAssignable(String var1);

    default public boolean isAssignable(Class<?> type) {
        return this.isAssignable(type.getName());
    }

    default public DataType getDataType() {
        if (this instanceof Association) {
            return DataType.ENTITY;
        }
        AnnotationMetadata annotationMetadata = this.getAnnotationMetadata();
        return annotationMetadata.enumValue(MappedProperty.class, "type", DataType.class).orElseGet(() -> {
            DataType dt = annotationMetadata.enumValue(TypeDef.class, "type", DataType.class).orElse(null);
            if (dt != null) {
                return dt;
            }
            if (this.isEnum()) {
                return DataType.STRING;
            }
            return DataType.OBJECT;
        });
    }

    default public JsonDataType getJsonDataType() {
        AnnotationMetadata annotationMetadata = this.getAnnotationMetadata();
        return annotationMetadata.enumValue(JsonRepresentation.class, "type", JsonDataType.class).orElse(JsonDataType.DEFAULT);
    }

    default public boolean isEnum() {
        return false;
    }

    default public List<EnumConstant> getEnumConstants() {
        return List.of();
    }

    default public @Nullable AttributeConverter<Object, Object> getConverter() {
        return null;
    }

    public static boolean isNullableMetadata(AnnotationMetadata metadata) {
        return metadata.getDeclaredAnnotationNames().stream().anyMatch(n -> NameUtils.getSimpleName((String)n).equalsIgnoreCase("nullable"));
    }

    default public @Nullable String getAlias() {
        return this.getAnnotationMetadata().stringValue(MappedProperty.class, "alias").orElse(null);
    }

    default public boolean isEmbedded() {
        return false;
    }

    public static interface EnumConstant {
        public String name();

        public int ordinal();
    }
}

