/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.predicate;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.PredicateVisitor;
import io.micronaut.data.model.jpa.criteria.impl.predicate.AbstractPersistentPropertyPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PredicateUnaryOp;
import jakarta.persistence.criteria.Predicate;

@Internal
public final class PersistentPropertyUnaryPredicate<T>
extends AbstractPersistentPropertyPredicate<T> {
    private final PredicateUnaryOp op;

    public PersistentPropertyUnaryPredicate(PersistentPropertyPath<T> persistentPropertyPath, PredicateUnaryOp op) {
        super(persistentPropertyPath);
        this.op = op;
    }

    public PredicateUnaryOp getOp() {
        return this.op;
    }

    @Override
    public Predicate not() {
        PredicateUnaryOp negatedOp = this.op.negate();
        if (negatedOp != null) {
            return new PersistentPropertyUnaryPredicate(this.getPropertyPath(), negatedOp);
        }
        return super.not();
    }

    @Override
    public void visitPredicate(PredicateVisitor predicateVisitor) {
        predicateVisitor.visit(this);
    }

    public String toString() {
        return "PersistentPropertyUnaryPredicate{persistentPropertyPath=" + this.persistentPropertyPath + ", op=" + this.op + "}";
    }
}

