/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.predicate;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.PredicateVisitor;
import io.micronaut.data.model.jpa.criteria.impl.predicate.AbstractPersistentPropertyPredicate;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Internal
public final class PersistentPropertyInPredicate<T>
extends AbstractPersistentPropertyPredicate<T>
implements CriteriaBuilder.In<T> {
    private final List<Expression<?>> values;
    private final CriteriaBuilder criteriaBuilder;

    public PersistentPropertyInPredicate(PersistentPropertyPath<T> propertyPath, CriteriaBuilder criteriaBuilder) {
        this(propertyPath, Collections.emptyList(), criteriaBuilder);
    }

    public PersistentPropertyInPredicate(PersistentPropertyPath<T> propertyPath, Collection<Expression<?>> values, CriteriaBuilder criteriaBuilder) {
        super(propertyPath);
        this.values = new ArrayList(values);
        this.criteriaBuilder = criteriaBuilder;
    }

    @NonNull
    public List<Expression<?>> getValues() {
        return this.values;
    }

    public Expression<T> getExpression() {
        return this.getPropertyPath();
    }

    public PersistentPropertyInPredicate<T> value(T value) {
        this.values.add(this.criteriaBuilder.literal(value));
        return this;
    }

    public PersistentPropertyInPredicate<T> value(Expression<? extends T> value) {
        this.values.add(value);
        return this;
    }

    @Override
    public void visitPredicate(PredicateVisitor predicateVisitor) {
        predicateVisitor.visit(this);
    }

    public String toString() {
        return "PersistentPropertyInPredicate{persistentPropertyPath=" + this.persistentPropertyPath + ", values=" + this.values + "}";
    }
}

