/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.IExpression;
import io.micronaut.data.model.jpa.criteria.IPredicate;
import io.micronaut.data.model.jpa.criteria.ISelection;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaDelete;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.QueryResultPersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.impl.predicate.ConjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.query.QueryModelPredicateVisitor;
import io.micronaut.data.model.jpa.criteria.impl.query.QueryModelSelectionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.selection.CompoundSelection;
import io.micronaut.data.model.jpa.criteria.impl.util.Joiner;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryBuilder2;
import io.micronaut.data.model.query.builder.QueryResult;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.EntityType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

@Internal
public abstract class AbstractPersistentEntityCriteriaDelete<T>
implements PersistentEntityCriteriaDelete<T>,
QueryResultPersistentEntityCriteriaQuery {
    protected Predicate predicate;
    protected PersistentEntityRoot<T> entityRoot;
    protected Selection<?> returning;

    @Override
    @NonNull
    public QueryModel getQueryModel() {
        if (this.entityRoot == null) {
            throw new IllegalStateException("The root entity must be specified!");
        }
        QueryModel qm = QueryModel.from(this.entityRoot.getPersistentEntity());
        Joiner joiner = new Joiner();
        Selection<?> selection = this.predicate;
        if (selection instanceof IPredicate) {
            IPredicate predicateVisitable = (IPredicate)selection;
            predicateVisitable.visitPredicate(this.createPredicateVisitor(qm));
            predicateVisitable.visitPredicate(joiner);
        }
        if ((selection = this.returning) instanceof ISelection) {
            ISelection selectionVisitable = (ISelection)selection;
            selectionVisitable.visitSelection(new QueryModelSelectionVisitor(qm, false));
            selectionVisitable.visitSelection(joiner);
        }
        for (Map.Entry<String, Joiner.Joined> e : joiner.getJoins().entrySet()) {
            qm.join(e.getKey(), Optional.ofNullable(e.getValue().getType()).orElse(Join.Type.DEFAULT), e.getValue().getAlias());
        }
        return qm;
    }

    @NonNull
    protected QueryModelPredicateVisitor createPredicateVisitor(QueryModel queryModel) {
        return new QueryModelPredicateVisitor(queryModel);
    }

    @Override
    public QueryResult buildQuery(AnnotationMetadata annotationMetadata, QueryBuilder queryBuilder) {
        QueryBuilder2 queryBuilder2 = QueryResultPersistentEntityCriteriaQuery.findQueryBuilder2(queryBuilder);
        if (queryBuilder2 == null) {
            return queryBuilder.buildDelete(annotationMetadata, this.getQueryModel());
        }
        return this.buildQuery(annotationMetadata, queryBuilder2);
    }

    @Override
    public QueryResult buildQuery(AnnotationMetadata annotationMetadata, QueryBuilder2 queryBuilder) {
        return queryBuilder.buildDelete(annotationMetadata, new DeleteQueryDefinitionImpl(this.entityRoot.getPersistentEntity(), this.predicate, this.returning));
    }

    @Override
    public abstract PersistentEntityRoot<T> from(Class<T> var1);

    @Override
    public abstract PersistentEntityRoot<T> from(PersistentEntity var1);

    @Override
    public PersistentEntityRoot<T> from(EntityType<T> entity) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public PersistentEntityCriteriaDelete<T> where(Expression<Boolean> restriction) {
        this.predicate = new ConjunctionPredicate(Collections.singleton((IExpression)restriction));
        return this;
    }

    @Override
    public PersistentEntityCriteriaDelete<T> where(Predicate ... restrictions) {
        Objects.requireNonNull(restrictions);
        this.predicate = restrictions.length > 0 ? (restrictions.length == 1 ? restrictions[0] : new ConjunctionPredicate(((Stream)Arrays.stream(restrictions).sequential()).map(x -> (IExpression)x).toList())) : null;
        return this;
    }

    @Override
    public PersistentEntityRoot<T> getRoot() {
        return this.entityRoot;
    }

    public Predicate getRestriction() {
        return this.predicate;
    }

    public <U> Subquery<U> subquery(Class<U> type) {
        throw new IllegalStateException("Unsupported!");
    }

    public final boolean hasVersionRestriction() {
        if (this.entityRoot.getPersistentEntity().getVersion() == null) {
            return false;
        }
        return CriteriaUtils.hasVersionPredicate(this.predicate);
    }

    @Override
    public PersistentEntityCriteriaDelete<T> returning(Selection<? extends T> selection) {
        Objects.requireNonNull(selection);
        this.returning = selection;
        return this;
    }

    @Override
    public PersistentEntityCriteriaDelete<T> returningMulti(List<Selection<?>> selectionList) {
        Objects.requireNonNull(selectionList);
        this.returning = !selectionList.isEmpty() ? new CompoundSelection(selectionList) : null;
        return this;
    }

    @Override
    public PersistentEntityCriteriaDelete<T> returningMulti(Selection<?> ... selections) {
        Objects.requireNonNull(selections);
        this.returning = selections.length != 0 ? new CompoundSelection(List.of(selections)) : null;
        return this;
    }

    private static final class DeleteQueryDefinitionImpl
    extends AbstractPersistentEntityCriteriaQuery.BaseQueryDefinitionImpl
    implements QueryBuilder2.DeleteQueryDefinition {
        private final Selection<?> returningSelection;

        DeleteQueryDefinitionImpl(PersistentEntity persistentEntity, Predicate predicate, Selection<?> returningSelection) {
            super(persistentEntity, predicate, Map.of());
            this.returningSelection = returningSelection;
        }

        @Override
        public Selection<?> returningSelection() {
            return this.returningSelection;
        }
    }
}

