/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.Criteria;
import io.micronaut.data.model.query.DefaultQuery;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.ProjectionList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Deprecated(forRemoval=true, since="4.9")
public interface QueryModel
extends Criteria {
    @Override
    @NonNull
    public QueryModel idEq(Object var1);

    @Override
    @NonNull
    public QueryModel versionEq(Object var1);

    @Override
    @NonNull
    public QueryModel isEmpty(@NonNull String var1);

    @Override
    @NonNull
    public QueryModel isNotEmpty(@NonNull String var1);

    @Override
    @NonNull
    public QueryModel isNull(@NonNull String var1);

    @Override
    @NonNull
    public QueryModel isTrue(@NonNull String var1);

    @Override
    @NonNull
    public QueryModel isFalse(@NonNull String var1);

    @Override
    @NonNull
    public QueryModel isNotNull(String var1);

    @Override
    @NonNull
    public QueryModel eq(String var1, Object var2);

    @Override
    @NonNull
    public QueryModel ne(@NonNull String var1, @NonNull Object var2);

    @Override
    @NonNull
    public QueryModel between(@NonNull String var1, @NonNull Object var2, @NonNull Object var3);

    @Override
    @NonNull
    public QueryModel gte(@NonNull String var1, @NonNull Object var2);

    @Override
    @NonNull
    public QueryModel ge(@NonNull String var1, @NonNull Object var2);

    @Override
    @NonNull
    public QueryModel gt(@NonNull String var1, @NonNull Object var2);

    @Override
    @NonNull
    public QueryModel lte(@NonNull String var1, @NonNull Object var2);

    @Override
    @NonNull
    public QueryModel le(@NonNull String var1, @NonNull Object var2);

    @Override
    @NonNull
    public QueryModel lt(@NonNull String var1, @NonNull Object var2);

    @Override
    @NonNull
    public QueryModel like(@NonNull String var1, @NonNull Object var2);

    @Override
    @NonNull
    public QueryModel startsWith(@NonNull String var1, @NonNull Object var2);

    @Override
    @NonNull
    public QueryModel endsWith(@NonNull String var1, @NonNull Object var2);

    @Override
    @NonNull
    public QueryModel contains(@NonNull String var1, @NonNull Object var2);

    @Override
    @NonNull
    public QueryModel ilike(@NonNull String var1, @NonNull Object var2);

    @Override
    @NonNull
    public QueryModel rlike(@NonNull String var1, @NonNull Object var2);

    @Override
    @NonNull
    public QueryModel and(@NonNull Criteria var1);

    @Override
    @NonNull
    public QueryModel or(@NonNull Criteria var1);

    @Override
    @NonNull
    public QueryModel not(@NonNull Criteria var1);

    @Override
    @NonNull
    public QueryModel inList(@NonNull String var1, @NonNull QueryModel var2);

    @Override
    @NonNull
    public QueryModel inList(@NonNull String var1, @NonNull Object var2);

    @Override
    @NonNull
    public QueryModel notIn(@NonNull String var1, @NonNull QueryModel var2);

    @Override
    @NonNull
    public QueryModel sizeEq(@NonNull String var1, @NonNull Object var2);

    @Override
    @NonNull
    public QueryModel sizeGt(@NonNull String var1, @NonNull Object var2);

    @Override
    @NonNull
    public QueryModel sizeGe(@NonNull String var1, @NonNull Object var2);

    @Override
    @NonNull
    public QueryModel sizeLe(@NonNull String var1, @NonNull Object var2);

    @Override
    @NonNull
    public QueryModel sizeLt(@NonNull String var1, @NonNull Object var2);

    @Override
    @NonNull
    public QueryModel sizeNe(@NonNull String var1, @NonNull Object var2);

    @Override
    @NonNull
    public QueryModel eqProperty(@NonNull String var1, @NonNull String var2);

    @Override
    @NonNull
    public QueryModel neProperty(@NonNull String var1, @NonNull String var2);

    @Override
    @NonNull
    public QueryModel gtProperty(@NonNull String var1, @NonNull String var2);

    @Override
    @NonNull
    public QueryModel geProperty(@NonNull String var1, @NonNull String var2);

    @Override
    @NonNull
    public QueryModel ltProperty(@NonNull String var1, @NonNull String var2);

    @Override
    @NonNull
    public QueryModel leProperty(String var1, @NonNull String var2);

    @Override
    @NonNull
    public QueryModel allEq(@NonNull Map<String, Object> var1);

    @Override
    @NonNull
    public QueryModel eqAll(@NonNull String var1, @NonNull Criteria var2);

    @Override
    @NonNull
    public QueryModel gtAll(@NonNull String var1, @NonNull Criteria var2);

    @Override
    @NonNull
    public QueryModel ltAll(@NonNull String var1, @NonNull Criteria var2);

    @Override
    @NonNull
    public QueryModel geAll(@NonNull String var1, @NonNull Criteria var2);

    @Override
    @NonNull
    public QueryModel leAll(@NonNull String var1, @NonNull Criteria var2);

    @Override
    @NonNull
    public QueryModel gtSome(@NonNull String var1, @NonNull Criteria var2);

    @Override
    @NonNull
    public QueryModel geSome(@NonNull String var1, @NonNull Criteria var2);

    @Override
    @NonNull
    public QueryModel ltSome(@NonNull String var1, @NonNull Criteria var2);

    @Override
    @NonNull
    public QueryModel leSome(@NonNull String var1, @NonNull Criteria var2);

    public Collection<JoinPath> getJoinPaths();

    @NonNull
    public PersistentEntity getPersistentEntity();

    @NonNull
    public Junction getCriteria();

    @NonNull
    public List<Projection> getProjections();

    public Optional<JoinPath> getJoinPath(String var1);

    @NonNull
    public JoinPath join(String var1, @NonNull Join.Type var2, @Nullable String var3);

    @NonNull
    default public JoinPath join(@NonNull Association association, @NonNull Join.Type joinType) {
        if (this.getPersistentEntity() != association.getOwner()) {
            throw new IllegalArgumentException("The association " + association + " must be owned by: " + this.getPersistentEntity());
        }
        return this.join(association.getName(), joinType, null);
    }

    @NonNull
    default public JoinPath join(@NonNull Association association) {
        return this.join(association.getName(), Join.Type.DEFAULT, null);
    }

    @NonNull
    public ProjectionList projections();

    @NonNull
    public QueryModel add(@NonNull Criterion var1);

    public QueryModel max(int var1);

    public QueryModel offset(long var1);

    default public Sort getSort() {
        return Sort.unsorted();
    }

    @NonNull
    public QueryModel sort(@NonNull Sort var1);

    @NonNull
    public static QueryModel from(@NonNull PersistentEntity entity) {
        ArgumentUtils.requireNonNull((String)"entity", (Object)entity);
        return new DefaultQuery(entity);
    }

    public int getMax();

    public long getOffset();

    public void forUpdate();

    public boolean isForUpdate();

    public static class ArrayContains
    extends PropertyCriterion {
        private QueryModel subquery;

        public ArrayContains(String name, Object parameter) {
            super(name, parameter);
        }

        public ArrayContains(String name, QueryModel subquery) {
            super(name, subquery);
            this.subquery = subquery;
        }

        public String getName() {
            return this.getProperty();
        }

        @Nullable
        public QueryModel getSubquery() {
            return this.subquery;
        }
    }

    public static class SumProjection
    extends PropertyProjection {
        public SumProjection(String propertyName) {
            super(propertyName);
        }
    }

    public static class MinProjection
    extends PropertyProjection {
        public MinProjection(String propertyName) {
            super(propertyName);
        }
    }

    public static class MaxProjection
    extends PropertyProjection {
        public MaxProjection(String propertyName) {
            super(propertyName);
        }
    }

    public static class AvgProjection
    extends PropertyProjection {
        public AvgProjection(String propertyName) {
            super(propertyName);
        }
    }

    public static class GroupPropertyProjection
    extends PropertyProjection {
        public GroupPropertyProjection(String property) {
            super(property);
        }
    }

    public static class CountDistinctRootProjection
    extends Projection {
    }

    public static class CountDistinctProjection
    extends PropertyProjection {
        public CountDistinctProjection(String property) {
            super(property);
        }
    }

    public static class PropertyProjection
    extends Projection {
        private final String propertyName;
        private String alias;
        private boolean compound;

        public PropertyProjection(String propertyName) {
            this(propertyName, false);
        }

        public PropertyProjection(String propertyName, boolean compound) {
            this.propertyName = propertyName;
            this.compound = compound;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public PropertyProjection aliased() {
            this.alias = this.propertyName;
            return this;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public Optional<String> getAlias() {
            return Optional.ofNullable(this.alias);
        }

        public boolean isCompound() {
            return this.compound;
        }
    }

    public static class DistinctProjection
    extends Projection {
    }

    public static class CountProjection
    extends Projection {
    }

    public static class LiteralProjection
    extends Projection {
        private final Object value;

        public LiteralProjection(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static class RootEntityProjection
    extends Projection {
    }

    public static class IdProjection
    extends Projection {
    }

    public static class Projection {
    }

    public static class Negation
    extends Junction {
    }

    public static class Disjunction
    extends Junction {
    }

    public static class Conjunction
    extends Junction {
    }

    public static abstract class Junction
    implements Criterion {
        private List<Criterion> criteria = new ArrayList<Criterion>();

        protected Junction() {
        }

        public Junction(List<Criterion> criteria) {
            this.criteria = criteria;
        }

        public Junction add(Criterion c) {
            if (c != null) {
                this.criteria.add(c);
            }
            return this;
        }

        public List<Criterion> getCriteria() {
            return this.criteria;
        }

        public boolean isEmpty() {
            return this.criteria.isEmpty();
        }
    }

    public static class RLike
    extends Like {
        public RLike(String name, Object expression) {
            super(name, expression);
        }
    }

    public static class ILike
    extends Like {
        public ILike(String name, Object expression) {
            super(name, expression);
        }
    }

    public static class EndsWith
    extends PropertyCriterion {
        public EndsWith(String name, Object expression) {
            super(name, expression);
        }
    }

    public static class Contains
    extends PropertyCriterion {
        public Contains(String name, Object expression) {
            super(name, expression);
        }
    }

    public static class StartsWith
    extends PropertyCriterion {
        public StartsWith(String name, Object expression) {
            super(name, expression);
        }
    }

    public static class Regex
    extends PropertyCriterion {
        public Regex(String name, Object expression) {
            super(name, expression);
        }
    }

    public static class Like
    extends PropertyCriterion {
        public Like(String name, Object expression) {
            super(name, expression);
        }
    }

    public static class Between
    extends PropertyCriterion {
        private final String property;
        private final Object from;
        private final Object to;

        public Between(String property, Object from, Object to) {
            super(property, from);
            this.property = property;
            this.from = from;
            this.to = to;
        }

        @Override
        public String getProperty() {
            return this.property;
        }

        public Object getFrom() {
            return this.from;
        }

        public Object getTo() {
            return this.to;
        }
    }

    public static class LessThanEquals
    extends PropertyCriterion {
        public LessThanEquals(String name, Object value) {
            super(name, value);
        }
    }

    public static class LessThan
    extends PropertyCriterion {
        public LessThan(String name, Object value) {
            super(name, value);
        }
    }

    public static class GreaterThanEquals
    extends PropertyCriterion {
        public GreaterThanEquals(String name, Object value) {
            super(name, value);
        }
    }

    public static class GreaterThan
    extends PropertyCriterion {
        public GreaterThan(String name, Object value) {
            super(name, value);
        }
    }

    public static class NotExists
    implements Criterion {
        private final QueryModel subquery;

        public NotExists(QueryModel subquery) {
            this.subquery = subquery;
        }

        public QueryModel getSubquery() {
            return this.subquery;
        }
    }

    public static class Exists
    implements Criterion {
        private final QueryModel subquery;

        public Exists(QueryModel subquery) {
            this.subquery = subquery;
        }

        public QueryModel getSubquery() {
            return this.subquery;
        }
    }

    public static class NotIn
    extends PropertyCriterion {
        private QueryModel subquery;

        public NotIn(String name, Object parameter) {
            super(name, parameter);
        }

        public NotIn(String name, QueryModel subquery) {
            super(name, subquery);
            this.subquery = subquery;
        }

        public String getName() {
            return this.getProperty();
        }

        public QueryModel getSubquery() {
            return this.subquery;
        }
    }

    public static class In
    extends PropertyCriterion {
        private QueryModel subquery;

        public In(String name, Object parameter) {
            super(name, parameter);
        }

        public In(String name, QueryModel subquery) {
            super(name, subquery);
            this.subquery = subquery;
        }

        public String getName() {
            return this.getProperty();
        }

        @Nullable
        public QueryModel getSubquery() {
            return this.subquery;
        }
    }

    public static class NotEquals
    extends PropertyCriterion {
        public NotEquals(String name, Object value) {
            super(name, value);
        }
    }

    public static class VersionEquals
    extends PropertyCriterion {
        private static final String VERSION = "version";

        public VersionEquals(Object value) {
            super(VERSION, value);
        }
    }

    public static class IdEquals
    extends PropertyCriterion {
        private static final String ID = "id";

        public IdEquals(Object value) {
            super(ID, value);
        }
    }

    public static class SizeLessThan
    extends PropertyCriterion {
        public SizeLessThan(String name, Object parameter) {
            super(name, parameter);
        }
    }

    public static class SizeLessThanEquals
    extends PropertyCriterion {
        public SizeLessThanEquals(String name, Object parameter) {
            super(name, parameter);
        }
    }

    public static class SizeGreaterThanEquals
    extends PropertyCriterion {
        public SizeGreaterThanEquals(String name, Object parameter) {
            super(name, parameter);
        }
    }

    public static class SizeGreaterThan
    extends PropertyCriterion {
        public SizeGreaterThan(String name, Object parameter) {
            super(name, parameter);
        }
    }

    public static class SizeNotEquals
    extends PropertyCriterion {
        public SizeNotEquals(String name, Object parameter) {
            super(name, parameter);
        }
    }

    public static class SizeEquals
    extends PropertyCriterion {
        public SizeEquals(String name, Object parameter) {
            super(name, parameter);
        }
    }

    public static class Equals
    extends PropertyCriterion {
        public Equals(String name, Object parameter) {
            super(name, parameter);
        }
    }

    public static class LessThanEqualsAll
    extends SubqueryCriterion {
        public LessThanEqualsAll(String name, QueryModel value) {
            super(name, value);
        }
    }

    public static class GreaterThanEqualsAll
    extends SubqueryCriterion {
        public GreaterThanEqualsAll(String name, QueryModel value) {
            super(name, value);
        }
    }

    public static class LessThanAll
    extends SubqueryCriterion {
        public LessThanAll(String name, QueryModel value) {
            super(name, value);
        }
    }

    public static class LessThanEqualsSome
    extends SubqueryCriterion {
        public LessThanEqualsSome(String name, QueryModel value) {
            super(name, value);
        }
    }

    public static class LessThanSome
    extends SubqueryCriterion {
        public LessThanSome(String name, QueryModel value) {
            super(name, value);
        }
    }

    public static class GreaterThanEqualsSome
    extends SubqueryCriterion {
        public GreaterThanEqualsSome(String name, QueryModel value) {
            super(name, value);
        }
    }

    public static class GreaterThanSome
    extends SubqueryCriterion {
        public GreaterThanSome(String name, QueryModel value) {
            super(name, value);
        }
    }

    public static class GreaterThanAll
    extends SubqueryCriterion {
        public GreaterThanAll(String name, QueryModel value) {
            super(name, value);
        }
    }

    public static class NotEqualsAll
    extends SubqueryCriterion {
        public NotEqualsAll(String name, QueryModel value) {
            super(name, value);
        }
    }

    public static class EqualsAll
    extends SubqueryCriterion {
        public EqualsAll(String name, QueryModel value) {
            super(name, value);
        }
    }

    public static class SubqueryCriterion
    extends PropertyCriterion {
        public SubqueryCriterion(String name, QueryModel value) {
            super(name, value);
        }

        @Override
        public QueryModel getValue() {
            return (QueryModel)super.getValue();
        }
    }

    public static class PropertyCriterion
    extends PropertyNameCriterion {
        protected Object value;
        private boolean ignoreCase = false;

        public PropertyCriterion(String name, Object value) {
            super(name);
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object v) {
            this.value = v;
        }

        public boolean isIgnoreCase() {
            return this.ignoreCase;
        }

        public PropertyCriterion ignoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            return this;
        }
    }

    public static class LessThanEqualsProperty
    extends PropertyComparisonCriterion {
        public LessThanEqualsProperty(String property, String otherProperty) {
            super(property, otherProperty);
        }
    }

    public static class LessThanProperty
    extends PropertyComparisonCriterion {
        public LessThanProperty(String property, String otherProperty) {
            super(property, otherProperty);
        }
    }

    public static class GreaterThanEqualsProperty
    extends PropertyComparisonCriterion {
        public GreaterThanEqualsProperty(String property, String otherProperty) {
            super(property, otherProperty);
        }
    }

    public static class GreaterThanProperty
    extends PropertyComparisonCriterion {
        public GreaterThanProperty(String property, String otherProperty) {
            super(property, otherProperty);
        }
    }

    public static class NotEqualsProperty
    extends PropertyComparisonCriterion {
        public NotEqualsProperty(String property, String otherProperty) {
            super(property, otherProperty);
        }
    }

    public static class EqualsProperty
    extends PropertyComparisonCriterion {
        public EqualsProperty(String property, String otherProperty) {
            super(property, otherProperty);
        }
    }

    public static class PropertyComparisonCriterion
    extends PropertyNameCriterion {
        final String otherProperty;

        protected PropertyComparisonCriterion(String property, String otherProperty) {
            super(property);
            this.otherProperty = otherProperty;
        }

        public String getOtherProperty() {
            return this.otherProperty;
        }
    }

    public static class PropertyNameCriterion
    implements Criterion {
        protected String name;

        public PropertyNameCriterion(String name) {
            this.name = name;
        }

        public String getProperty() {
            return this.name;
        }
    }

    public static class IsFalse
    extends PropertyNameCriterion {
        public IsFalse(String name) {
            super(name);
        }
    }

    public static class IsTrue
    extends PropertyNameCriterion {
        public IsTrue(String name) {
            super(name);
        }
    }

    public static class IsNotNull
    extends PropertyNameCriterion {
        public IsNotNull(String name) {
            super(name);
        }
    }

    public static class IsNotEmpty
    extends PropertyNameCriterion {
        public IsNotEmpty(String name) {
            super(name);
        }
    }

    public static class IsEmpty
    extends PropertyNameCriterion {
        public IsEmpty(String name) {
            super(name);
        }
    }

    public static class IsNull
    extends PropertyNameCriterion {
        public IsNull(String name) {
            super(name);
        }
    }

    public static interface Criterion {
    }
}

