/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.jpa.criteria.PersistentEntityFrom;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.ExpressionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.expression.IdExpression;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;

public interface PersistentEntityRoot<T>
extends Root<T>,
PersistentEntityFrom<T, T> {
    @NonNull
    default public <Y> Expression<Y> id() {
        PersistentEntity persistentEntity = this.getPersistentEntity();
        if (persistentEntity.hasIdentity()) {
            return this.get(persistentEntity.getIdentity());
        }
        if (persistentEntity.hasCompositeIdentity()) {
            return new IdExpression(this);
        }
        throw new IllegalStateException("No identity is present");
    }

    @NonNull
    default public <Y> PersistentPropertyPath<Y> version() {
        PersistentEntity persistentEntity = this.getPersistentEntity();
        PersistentProperty version = persistentEntity.getVersion();
        if (version == null) {
            throw new IllegalStateException("No version is present");
        }
        return this.get(version);
    }

    @NonNull
    default public <Y> PersistentPropertyPath<Y> get(@NonNull PersistentProperty persistentProperty) {
        return this.get(persistentProperty.getName());
    }

    @Override
    default public void visitExpression(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }
}

