/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.data.annotation.sql.JoinColumns;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;

@Internal
public final class PersistentEntityUtils {
    private static final String UNDERSCORE = "_";

    private PersistentEntityUtils() {
    }

    public static boolean isAccessibleWithoutJoin(Association association, PersistentProperty persistentProperty) {
        return association.getAssociatedEntity().getIdentity() == persistentProperty && !association.isForeignKey();
    }

    public static void traversePersistentProperties(PersistentProperty property, BiConsumer<List<Association>, PersistentProperty> consumer) {
        PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), property, consumer);
    }

    public static void traversePersistentProperties(PersistentEntity persistentEntity, BiConsumer<List<Association>, PersistentProperty> consumer) {
        for (PersistentProperty persistentProperty : persistentEntity.getIdentityProperties()) {
            PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), persistentProperty, consumer);
        }
        if (persistentEntity.getVersion() != null) {
            PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), persistentEntity.getVersion(), consumer);
        }
        for (PersistentProperty persistentProperty : persistentEntity.getPersistentProperties()) {
            PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), persistentProperty, consumer);
        }
    }

    public static void traversePersistentProperties(PersistentEntity persistentEntity, boolean includeIdentity, boolean includeVersion, BiConsumer<List<Association>, PersistentProperty> consumer) {
        if (includeIdentity) {
            for (PersistentProperty persistentProperty : persistentEntity.getIdentityProperties()) {
                PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), persistentProperty, consumer);
            }
        }
        if (includeVersion && persistentEntity.getVersion() != null) {
            PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), persistentEntity.getVersion(), consumer);
        }
        for (PersistentProperty persistentProperty : persistentEntity.getPersistentProperties()) {
            PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), persistentProperty, consumer);
        }
    }

    public static void traversePersistentProperties(List<Association> associations, PersistentProperty property, BiConsumer<List<Association>, PersistentProperty> consumerProperty) {
        if (property instanceof Embedded) {
            Embedded embedded = (Embedded)property;
            PersistentEntity embeddedEntity = embedded.getAssociatedEntity();
            Collection<? extends PersistentProperty> embeddedProperties = embeddedEntity.getPersistentProperties();
            ArrayList<Association> newAssociations = new ArrayList<Association>(associations);
            newAssociations.add((Association)property);
            for (PersistentProperty persistentProperty : embeddedProperties) {
                PersistentEntityUtils.traversePersistentProperties(newAssociations, persistentProperty, consumerProperty);
            }
        } else if (property instanceof Association) {
            Association association = (Association)property;
            if (association.isForeignKey()) {
                return;
            }
            ArrayList<Association> newAssociations = new ArrayList<Association>(associations);
            newAssociations.add((Association)property);
            PersistentEntity associatedEntity = association.getAssociatedEntity();
            PersistentProperty assocIdentity = associatedEntity.getIdentity();
            if (assocIdentity == null) {
                throw new IllegalStateException("Identity cannot be missing for: " + associatedEntity);
            }
            if (assocIdentity instanceof Association) {
                PersistentEntityUtils.traversePersistentProperties(newAssociations, assocIdentity, consumerProperty);
            } else {
                PersistentProperty joinColumnAssocIdentity = PersistentEntityUtils.getJoinColumnAssocIdentity(property, associatedEntity);
                if (joinColumnAssocIdentity != null) {
                    consumerProperty.accept(newAssociations, joinColumnAssocIdentity);
                } else {
                    consumerProperty.accept(newAssociations, assocIdentity);
                }
            }
        } else {
            consumerProperty.accept(associations, property);
        }
    }

    public static Optional<String> getPersistentPropertyPath(PersistentEntity entity, String path) {
        String assocPath;
        PersistentProperty pp;
        String decapitalizedPath = NameUtils.decapitalize((String)path);
        if (entity.getPropertyByName(decapitalizedPath) != null) {
            return Optional.of(decapitalizedPath);
        }
        String[] entityPaths = path.split(UNDERSCORE);
        if (entityPaths.length > 1 && (pp = entity.getPropertyByName(assocPath = entityPaths[0])) instanceof Association) {
            String restPath;
            Association assoc = (Association)pp;
            PersistentEntity assocEntity = assoc.getAssociatedEntity();
            Optional<String> tailPath = PersistentEntityUtils.getPersistentPropertyPath(assocEntity, restPath = path.replaceFirst(assocPath + UNDERSCORE, ""));
            if (tailPath.isPresent()) {
                return Optional.of(assocPath + "." + tailPath.get());
            }
            throw new IllegalArgumentException("Invalid path [" + restPath + "] of [" + assocEntity + "]");
        }
        return entity.getPath(path);
    }

    private static PersistentProperty getJoinColumnAssocIdentity(PersistentProperty property, PersistentEntity associatedEntity) {
        AnnotationMetadata propertyAnnotationMetadata = property.getAnnotationMetadata();
        AnnotationValue joinColumnsAnnotationValue = propertyAnnotationMetadata.getAnnotation(JoinColumns.class);
        if (joinColumnsAnnotationValue == null) {
            return null;
        }
        List joinColumnsAnnotationValueAnnotations = joinColumnsAnnotationValue.getAnnotations("value");
        if (joinColumnsAnnotationValueAnnotations.size() != 1) {
            return null;
        }
        AnnotationValue joinColumnAnnotationValue = (AnnotationValue)joinColumnsAnnotationValueAnnotations.get(0);
        String fieldName = joinColumnAnnotationValue.stringValue("referencedColumnName").orElse(null);
        if (fieldName == null) {
            return null;
        }
        Collection<? extends PersistentProperty> assocPersistentProperties = associatedEntity.getPersistentProperties();
        for (PersistentProperty persistentProperty : assocPersistentProperties) {
            if (!fieldName.equals(persistentProperty.getPersistedName())) continue;
            return persistentProperty;
        }
        return null;
    }
}

