/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.operations.reactive;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.propagation.ReactorPropagation;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.data.operations.BlockingCriteriaCapableRepository;
import io.micronaut.data.operations.CriteriaRepositoryOperations;
import io.micronaut.data.operations.reactive.ReactorCriteriaCapableRepository;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import java.util.List;
import java.util.Optional;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public interface BlockingReactorCriteriaRepositoryOperations
extends CriteriaRepositoryOperations,
BlockingCriteriaCapableRepository,
ReactorCriteriaCapableRepository {
    @Override
    default public CriteriaRepositoryOperations blocking() {
        return this;
    }

    @NonNull
    private ContextView getContextView() {
        return ReactorPropagation.addPropagatedContext((Context)Context.empty(), (PropagatedContext)PropagatedContext.getOrEmpty());
    }

    @Override
    @Nullable
    default public <R> R findOne(@NonNull CriteriaQuery<R> query) {
        return (R)this.reactive().findOne(query).contextWrite(this.getContextView()).block();
    }

    @Override
    default public <T> List<T> findAll(@NonNull CriteriaQuery<T> query) {
        return this.reactive().findAll(query).collectList().contextWrite(this.getContextView()).blockOptional().orElseGet(List::of);
    }

    @Override
    default public Optional<Number> updateAll(@NonNull CriteriaUpdate<Number> query) {
        return this.reactive().updateAll(query).contextWrite(this.getContextView()).blockOptional();
    }

    @Override
    default public Optional<Number> deleteAll(@NonNull CriteriaDelete<Number> query) {
        return this.reactive().deleteAll(query).contextWrite(this.getContextView()).blockOptional();
    }
}

