/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.operations.reactive;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.reactive.ReactorReactiveCapableRepository;
import io.micronaut.data.operations.reactive.ReactorReactiveRepositoryOperations;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import reactor.core.publisher.Mono;

public interface BlockingExecutorReactorRepositoryOperations
extends RepositoryOperations,
ReactorReactiveCapableRepository {
    public <T> T block(Function<ReactorReactiveRepositoryOperations, Mono<T>> var1);

    public <T> Optional<T> blockOptional(Function<ReactorReactiveRepositoryOperations, Mono<T>> var1);

    @Override
    @Nullable
    default public <T> T findOne(@NonNull Class<T> type, @NonNull Object id) {
        return this.block(reactive -> reactive.findOne(type, id));
    }

    @Override
    @Nullable
    default public <T, R> R findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (R)this.block(reactive -> reactive.findOne(preparedQuery));
    }

    @Override
    @NonNull
    default public <T, R> Iterable<R> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (Iterable)this.block(reactive -> reactive.findAll(preparedQuery).collectList());
    }

    @Override
    @NonNull
    default public <T, R> Stream<R> findStream(@NonNull PreparedQuery<T, R> preparedQuery) {
        return ((List)this.block(reactive -> reactive.findAll(preparedQuery).collectList())).stream();
    }

    @Override
    @NonNull
    default public <T> T persist(@NonNull InsertOperation<T> operation) {
        return (T)this.blockOptional(reactive -> reactive.persist(operation)).orElseGet(operation::getEntity);
    }

    @Override
    @NonNull
    default public <T> T update(@NonNull UpdateOperation<T> operation) {
        return (T)this.blockOptional(reactive -> reactive.update(operation)).orElseGet(operation::getEntity);
    }

    @Override
    default public <T> Iterable<T> updateAll(UpdateBatchOperation<T> operation) {
        return this.blockOptional(reactive -> reactive.updateAll(operation).collectList().map(it -> it)).orElse(operation);
    }

    @Override
    @NonNull
    default public <T> Iterable<T> persistAll(@NonNull InsertBatchOperation<T> operation) {
        return this.blockOptional(reactive -> reactive.persistAll(operation).collectList().map(it -> it)).orElse(operation);
    }

    @Override
    @NonNull
    default public Optional<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return this.blockOptional(reactive -> reactive.executeUpdate(preparedQuery));
    }

    @Override
    default public Optional<Number> executeDelete(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return this.blockOptional(reactive -> reactive.executeDelete(preparedQuery));
    }

    @Override
    default public <R> List<R> execute(PreparedQuery<?, R> preparedQuery) {
        return (List)this.block(reactive -> reactive.execute(preparedQuery).collectList());
    }

    @Override
    default public <T> int delete(@NonNull DeleteOperation<T> operation) {
        return ((Number)this.blockOptional(reactive -> reactive.delete(operation)).orElse(0)).intValue();
    }

    @Override
    default public <T> Optional<Number> deleteAll(@NonNull DeleteBatchOperation<T> operation) {
        return this.blockOptional(reactive -> reactive.deleteAll(operation));
    }

    @Override
    default public <T> boolean exists(@NonNull PreparedQuery<T, Boolean> preparedQuery) {
        return this.blockOptional(reactive -> reactive.exists(preparedQuery)).orElse(false);
    }

    @Override
    default public <R> Page<R> findPage(@NonNull PagedQuery<R> query) {
        return (Page)this.block(reactive -> reactive.findPage(query));
    }

    @Override
    @NonNull
    default public <T> Iterable<T> findAll(@NonNull PagedQuery<T> query) {
        return (Iterable)this.block(reactive -> reactive.findAll(query).collectList());
    }

    @Override
    default public <T> long count(PagedQuery<T> pagedQuery) {
        return this.blockOptional(reactive -> reactive.count(pagedQuery)).orElse(0L);
    }

    @Override
    @NonNull
    default public <T> Stream<T> findStream(@NonNull PagedQuery<T> query) {
        return ((List)this.block(reactive -> reactive.findAll(query).collectList())).stream();
    }
}

