/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.predicate;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.PredicateVisitor;
import io.micronaut.data.model.jpa.criteria.impl.predicate.AbstractPredicate;
import jakarta.persistence.criteria.Expression;

@Internal
public final class BetweenPredicate
extends AbstractPredicate {
    private final Expression<?> value;
    private final Expression<?> from;
    private final Expression<?> to;

    public BetweenPredicate(Expression<?> value, Expression<?> from, Expression<?> to) {
        this.value = value;
        this.from = from;
        this.to = to;
        CriteriaUtils.requireComparableExpression(value);
        CriteriaUtils.requireComparableExpression(from);
        CriteriaUtils.requireComparableExpression(to);
    }

    public Expression<?> getValue() {
        return this.value;
    }

    public Expression<?> getFrom() {
        return this.from;
    }

    public Expression<?> getTo() {
        return this.to;
    }

    @Override
    public void visitPredicate(PredicateVisitor predicateVisitor) {
        predicateVisitor.visit(this);
    }

    public String toString() {
        return "BetweenPredicate{value=" + String.valueOf(this.value) + ", from=" + String.valueOf(this.from) + ", to=" + String.valueOf(this.to) + "}";
    }
}

