/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import java.util.Objects;
import java.util.Optional;

@Introspected
final class DefaultPageable
implements Pageable {
    private final boolean requestTotal;
    private final int max;
    private final int number;
    private final Sort sort;

    @Creator
    DefaultPageable(int page, int size, @Nullable Sort sort, @Nullable Boolean requestTotal) {
        if (page < 0) {
            throw new IllegalArgumentException("Page index cannot be negative");
        }
        if (size == 0) {
            throw new IllegalArgumentException("Size cannot be 0");
        }
        this.max = size;
        this.number = page;
        this.sort = sort == null ? Sort.unsorted() : sort;
        this.requestTotal = requestTotal == null || requestTotal != false;
    }

    @Override
    public int getSize() {
        return this.max;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public Optional<Pageable.Cursor> cursor() {
        return Optional.empty();
    }

    @Override
    public boolean requestTotal() {
        return this.requestTotal;
    }

    @Override
    @NonNull
    public Sort getSort() {
        return this.sort;
    }

    @Override
    public Pageable withTotal() {
        if (this.requestTotal) {
            return this;
        }
        return new DefaultPageable(this.number, this.max, this.sort, true);
    }

    @Override
    public Pageable withoutTotal() {
        if (!this.requestTotal) {
            return this;
        }
        return new DefaultPageable(this.number, this.max, this.sort, false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultPageable)) {
            return false;
        }
        DefaultPageable that = (DefaultPageable)o;
        return this.max == that.max && this.number == that.number && Objects.equals(this.sort, that.sort);
    }

    public int hashCode() {
        return Objects.hash(this.max, this.number, this.sort);
    }

    public String toString() {
        return "DefaultPageable{max=" + this.max + ", page=" + this.number + ", sort=" + String.valueOf(this.sort) + "}";
    }
}

