/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder.sql;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.DataAnnotationUtils;
import io.micronaut.data.annotation.DataTransformer;
import io.micronaut.data.annotation.EntityRepresentation;
import io.micronaut.data.annotation.IgnoreWhere;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.Where;
import io.micronaut.data.annotation.repeatable.WhereSpecifications;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.PersistentAssociationPath;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentEntityUtils;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.jpa.criteria.IExpression;
import io.micronaut.data.model.jpa.criteria.IPredicate;
import io.micronaut.data.model.jpa.criteria.ISelection;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentEntitySubquery;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityQuery;
import io.micronaut.data.model.jpa.criteria.impl.BoundPathParameterExpression;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.DefaultOrder;
import io.micronaut.data.model.jpa.criteria.impl.DefaultPersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.ExpressionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.IParameterExpression;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.expression.BinaryExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.FunctionExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.IdExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.LiteralExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.SubqueryExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.UnaryExpression;
import io.micronaut.data.model.jpa.criteria.impl.predicate.BinaryPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.ConjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.DisjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.ExistsSubqueryPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.InPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.LikePredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.NegatedPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PredicateBinaryOp;
import io.micronaut.data.model.jpa.criteria.impl.selection.AliasedSelection;
import io.micronaut.data.model.jpa.criteria.impl.selection.CompoundSelection;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.query.BindingParameter;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.model.query.builder.QueryBuilder2;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.PropertyParameterCreator;
import io.micronaut.data.model.query.builder.sql.RenderablePredicate;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilderUtils;
import io.micronaut.data.model.query.impl.AdvancedPredicateVisitor;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Selection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

@Internal
public abstract class AbstractSqlLikeQueryBuilder2
implements QueryBuilder2 {
    public static final String ORDER_BY_CLAUSE = " ORDER BY ";
    protected static final String SELECT_CLAUSE = "SELECT ";
    protected static final String AS_CLAUSE = " AS ";
    protected static final String FROM_CLAUSE = " FROM ";
    protected static final String WHERE_CLAUSE = " WHERE ";
    protected static final char COMMA = ',';
    protected static final char CLOSE_BRACKET = ')';
    protected static final char OPEN_BRACKET = '(';
    protected static final char SPACE = ' ';
    protected static final char DOT = '.';
    protected static final String NOT = "NOT";
    protected static final String AND = "AND";
    protected static final String LOGICAL_AND = " AND ";
    protected static final String RETURNING = " RETURNING ";
    protected static final String OR = "OR";
    protected static final String LOGICAL_OR = " OR ";
    protected static final String DISTINCT = "DISTINCT ";
    protected static final String ALIAS_REPLACE_QUOTED = "@\\.";
    protected static final String CANNOT_QUERY_ON_ID_WITH_ENTITY_THAT_HAS_NO_ID = "Cannot query on ID with entity that has no ID";
    private static final String UNSUPPORTED_EXPRESSION = "Unsupported expression: ";

    protected Dialect getDialect() {
        return Dialect.ANSI;
    }

    protected boolean traverseEmbedded() {
        return true;
    }

    @NonNull
    protected String asLiteral(@Nullable Object value) {
        if (value instanceof LiteralExpression) {
            LiteralExpression literalExpression = (LiteralExpression)value;
            value = literalExpression.getValue();
        }
        if (value instanceof Expression) {
            Expression expression = (Expression)value;
            throw new IllegalArgumentException(UNSUPPORTED_EXPRESSION + String.valueOf(expression));
        }
        if (value == null) {
            return "NULL";
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Long.toString(number.longValue());
        }
        if (value instanceof Boolean) {
            return value.toString().toUpperCase(Locale.ROOT);
        }
        return "'" + String.valueOf(value) + "'";
    }

    protected final QueryPropertyPath asQueryPropertyPath(String tableAlias, PersistentProperty persistentProperty) {
        return new QueryPropertyPath(this.asPersistentPropertyPath(persistentProperty), tableAlias);
    }

    private PersistentPropertyPath asPersistentPropertyPath(PersistentProperty persistentProperty) {
        return PersistentPropertyPath.of(Collections.emptyList(), persistentProperty, persistentProperty.getName());
    }

    @Override
    public QueryResult buildSelect(AnnotationMetadata annotationMetadata, QueryBuilder2.SelectQueryDefinition definition) {
        QueryBuilder queryBuilder = new QueryBuilder();
        boolean appendOrder = this.shouldAppendOrder(definition);
        boolean appendLimit = this.supportsLimitQuery() && appendOrder && !AbstractSqlLikeQueryBuilder2.parameterInRoleModifiesLimit(definition.parametersInRole());
        QueryState queryState = this.buildQuery(annotationMetadata, definition, queryBuilder, appendLimit, appendOrder, null);
        return QueryResult.of(queryState.getFinalQuery(), queryState.getQueryParts(), queryState.getParameterBindings(), appendLimit ? -1 : definition.limit(), appendLimit ? 0L : (long)definition.offset(), appendOrder ? Sort.UNSORTED : definition.asSort(), queryState.getJoinPaths());
    }

    protected boolean shouldAppendOrder(QueryBuilder2.SelectQueryDefinition definition) {
        return !AbstractSqlLikeQueryBuilder2.parameterInRoleModifiesOrder(definition.parametersInRole());
    }

    protected static boolean parameterInRoleModifiesOrder(Map<Integer, String> parametersInRole) {
        return parametersInRole.containsValue("sort") || parametersInRole.containsValue("pageable") || parametersInRole.containsValue("pageableRequired");
    }

    protected static boolean parameterInRoleModifiesLimit(Map<Integer, String> parametersInRole) {
        return parametersInRole.containsValue("pageable") || parametersInRole.containsValue("pageableRequired") || parametersInRole.containsValue("querylimit");
    }

    @NonNull
    protected final QueryState buildQuery(AnnotationMetadata annotationMetadata, QueryBuilder2.SelectQueryDefinition definition, QueryBuilder queryBuilder, boolean appendLimit, boolean appendOrder, @Nullable String tableAliasPrefix) {
        QueryState queryState = new QueryState(queryBuilder, definition, true, true, tableAliasPrefix);
        Predicate predicate = definition.predicate();
        Selection<?> selection = definition.selection();
        Objects.requireNonNull(selection, "Select query selection must not be null");
        ArrayList<JoinPath> joinPaths = new ArrayList<JoinPath>(definition.getJoinPaths());
        joinPaths.sort((o1, o2) -> Comparator.comparingInt(String::length).thenComparing(String::compareTo).compare(o1.getPath(), o2.getPath()));
        for (JoinPath joinPath : joinPaths) {
            queryState.applyJoin(joinPath);
        }
        StringBuilder query = queryState.getQuery();
        query.append(SELECT_CLAUSE);
        this.buildSelectClause(annotationMetadata, definition, queryState);
        this.appendForUpdate(QueryPosition.AFTER_TABLE_NAME, definition, query);
        queryState.generateJoinQuery();
        if (predicate != null || annotationMetadata.hasStereotype(WhereSpecifications.class) || queryState.getEntity().getAnnotationMetadata().hasStereotype(WhereSpecifications.class)) {
            this.buildWhereClause(annotationMetadata, predicate, queryState);
        }
        this.appendLimitAndOrder(annotationMetadata, definition, appendLimit, appendOrder, queryState);
        this.appendForUpdate(QueryPosition.END_OF_QUERY, definition, queryState.getQuery());
        return queryState;
    }

    protected boolean supportsLimitQuery() {
        return true;
    }

    protected void appendLimitAndOrder(AnnotationMetadata annotationMetadata, QueryBuilder2.SelectQueryDefinition definition, boolean appendLimit, boolean appendOrder, QueryState queryState) {
    }

    protected abstract String getTableName(PersistentEntity var1);

    protected String getUnescapedTableName(PersistentEntity entity) {
        return entity.getPersistedName();
    }

    protected String getAliasName(PersistentEntity entity) {
        return entity.getAnnotationMetadata().stringValue(MappedEntity.class, "alias").orElseGet(() -> this.getTableName(entity) + "_");
    }

    public String getAliasName(JoinPath joinPath) {
        return joinPath.getAlias().orElseGet(() -> {
            String joinPathAlias = this.getPathOnlyAliasName(joinPath);
            if (joinPath.getAssociationPath()[0].hasDeclaredAliasName()) {
                return joinPathAlias;
            }
            PersistentEntity owner = joinPath.getAssociationPath()[0].getOwner();
            String ownerAlias = this.getAliasName(owner);
            if (ownerAlias.endsWith("_") && joinPathAlias.startsWith("_")) {
                return ownerAlias + joinPathAlias.substring(1);
            }
            return ownerAlias + joinPathAlias;
        });
    }

    @NonNull
    protected String getPathOnlyAliasName(JoinPath joinPath) {
        return joinPath.getAlias().orElseGet(() -> {
            StringBuilder p = new StringBuilder();
            for (Association ass : joinPath.getAssociationPath()) {
                p.append(ass.getAliasName());
                if (!ass.hasDeclaredAliasName() || ass == joinPath.getAssociation()) continue;
                p.append('_');
            }
            return p.toString();
        });
    }

    protected void buildJoin(String joinType, StringBuilder query, QueryState queryState, PersistentAssociationPath joinAssociation, PersistentEntity associationOwner, String currentJoinAlias, String lastJoinAlias) {
    }

    protected abstract String getColumnName(PersistentProperty var1);

    private String escapeColumnIfNeeded(String column, boolean escape) {
        if (escape) {
            return this.quote(column);
        }
        return column;
    }

    private void buildSelectClause(AnnotationMetadata annotationMetadata, QueryBuilder2.SelectQueryDefinition definition, QueryState queryState) {
        this.buildSelect(annotationMetadata, queryState, definition.selection(), definition.isDistinct());
        queryState.getQuery().append(FROM_CLAUSE).append(this.getTableName(queryState.getEntity())).append(this.getTableAsKeyword()).append(queryState.getRootAlias());
    }

    protected boolean shouldEscape(@NonNull PersistentEntity entity) {
        return entity.getAnnotationMetadata().booleanValue(MappedEntity.class, "escape").orElse(true);
    }

    protected String getTableAsKeyword() {
        return AS_CLAUSE;
    }

    protected String quote(String persistedName) {
        return this.quote(persistedName, false);
    }

    protected String quote(String persistedName, boolean supportsDynamicValues) {
        return "\"" + persistedName + "\"";
    }

    protected void buildSelect(AnnotationMetadata annotationMetadata, QueryState queryState, Selection<?> selection, boolean distinct) {
        if (!(selection instanceof ISelection)) {
            throw new IllegalStateException("Unknown selection type: " + selection.getClass().getName());
        }
        ISelection selectionVisitable = (ISelection)selection;
        selectionVisitable.visitSelection(this.createSelectionVisitor(annotationMetadata, queryState, distinct));
    }

    protected SqlSelectionVisitor createSelectionVisitor(AnnotationMetadata annotationMetadata, QueryState queryState, boolean distinct) {
        return new SqlSelectionVisitor(queryState, annotationMetadata, distinct);
    }

    protected NamingStrategy getNamingStrategy(PersistentPropertyPath propertyPath) {
        return propertyPath.getNamingStrategy();
    }

    protected NamingStrategy getNamingStrategy(PersistentEntity entity) {
        return entity.getNamingStrategy();
    }

    @NonNull
    protected String getMappedName(@NonNull NamingStrategy namingStrategy, @NonNull Association association) {
        return namingStrategy.mappedName(association);
    }

    @NonNull
    protected String getMappedName(@NonNull NamingStrategy namingStrategy, @NonNull List<Association> associations, @NonNull PersistentProperty property) {
        return namingStrategy.mappedName(associations, property);
    }

    @NonNull
    protected String getMappedName(@NonNull NamingStrategy namingStrategy, @NonNull PersistentPropertyPath propertyPath) {
        return namingStrategy.mappedName(propertyPath.getAssociations(), propertyPath.getProperty());
    }

    protected void buildWhereClause(AnnotationMetadata annotationMetadata, Predicate predicate, QueryState queryState) {
        String additionalWhere = this.buildAdditionalWhereClause(queryState, annotationMetadata);
        RenderablePredicate additionalWherePredicate = this.findAdditionalPredicate(additionalWhere);
        if (additionalWherePredicate != null) {
            predicate = predicate == null ? new ConjunctionPredicate(List.of(additionalWherePredicate)) : new ConjunctionPredicate(List.of(predicate, additionalWherePredicate));
        }
        if (predicate != null) {
            queryState.getQuery().append(WHERE_CLAUSE);
            if (predicate instanceof IPredicate) {
                IPredicate predicateVisitable = (IPredicate)predicate;
                predicateVisitable.visitPredicate(this.createPredicateVisitor(annotationMetadata, queryState));
            } else {
                throw new IllegalStateException("Unsupported predicate type: " + predicate.getClass().getName());
            }
        }
    }

    protected SqlPredicateVisitor createPredicateVisitor(AnnotationMetadata annotationMetadata, QueryState queryState) {
        return new SqlPredicateVisitor(queryState, annotationMetadata);
    }

    protected String buildAdditionalWhereClause(QueryState queryState, AnnotationMetadata annotationMetadata) {
        return this.buildAdditionalWhereString(queryState.getRootAlias(), queryState.getEntity(), annotationMetadata);
    }

    @Nullable
    private RenderablePredicate findAdditionalPredicate(final String additionalWhere) {
        if (StringUtils.isEmpty((CharSequence)additionalWhere)) {
            return null;
        }
        return new RenderablePredicate(){

            @Override
            void render(StringBuilder query, PropertyParameterCreator propertyParameterCreator) {
                Matcher matcher = io.micronaut.data.model.query.builder.QueryBuilder.VARIABLE_PATTERN.matcher(additionalWhere);
                int index = 0;
                while (matcher.find()) {
                    query.append(additionalWhere, index, matcher.start(2));
                    index = matcher.end(2);
                    String name = matcher.group(3);
                    propertyParameterCreator.pushAdditionalParameter(name);
                }
                if (index < additionalWhere.length()) {
                    query.append(additionalWhere, index, additionalWhere.length());
                }
            }
        };
    }

    protected String buildAdditionalWhereString(String alias, PersistentEntity entity, AnnotationMetadata annotationMetadata) {
        if (annotationMetadata.hasAnnotation(IgnoreWhere.class)) {
            return "";
        }
        String whereStr = this.resolveWhereForAnnotationMetadata(alias, annotationMetadata);
        if (StringUtils.isNotEmpty((CharSequence)whereStr)) {
            return whereStr;
        }
        return this.resolveWhereForAnnotationMetadata(alias, entity.getAnnotationMetadata());
    }

    protected final String buildAdditionalWhereString(JoinPath joinPath, AnnotationMetadata annotationMetadata) {
        if (annotationMetadata.hasAnnotation(IgnoreWhere.class)) {
            return "";
        }
        Association association = joinPath.getAssociation();
        if (association == null) {
            return "";
        }
        String alias = this.getAliasName(joinPath);
        return this.resolveWhereForAnnotationMetadata(alias, association.getAssociatedEntity().getAnnotationMetadata());
    }

    protected final String resolveWhereForAnnotationMetadata(String alias, AnnotationMetadata annotationMetadata) {
        return annotationMetadata.getAnnotationValuesByType(Where.class).stream().flatMap(av -> av.stringValue().stream()).map(val -> this.replaceAlias(alias, (String)val)).filter(StringUtils::isNotEmpty).collect(Collectors.joining(LOGICAL_AND));
    }

    protected void appendOrder(AnnotationMetadata annotationMetadata, List<Order> orders, QueryState queryState) {
        if (orders.isEmpty()) {
            return;
        }
        StringBuilder buff = queryState.getQuery();
        buff.append(ORDER_BY_CLAUSE);
        String jsonEntityColumn = this.getJsonEntityColumn(annotationMetadata);
        Iterator<Order> i = orders.iterator();
        while (i.hasNext()) {
            DefaultOrder defaultOrder;
            boolean ignoreCase;
            Order order = i.next();
            QueryPropertyPath propertyPath = queryState.findProperty(CriteriaUtils.requireProperty(order.getExpression()).getPropertyPath());
            String currentAlias = propertyPath.getTableAlias();
            boolean bl = ignoreCase = order instanceof DefaultOrder && (defaultOrder = (DefaultOrder)order).isIgnoreCase();
            if (ignoreCase) {
                buff.append("LOWER(");
            }
            if (currentAlias != null) {
                buff.append(currentAlias).append('.');
            }
            if (jsonEntityColumn != null) {
                buff.append(jsonEntityColumn).append('.');
            }
            if (this.computePropertyPaths() && jsonEntityColumn == null) {
                buff.append(propertyPath.getColumnName());
            } else {
                buff.append(propertyPath.getPath());
                if (jsonEntityColumn != null) {
                    this.appendJsonProjection(buff, propertyPath.getProperty().getDataType());
                }
            }
            if (ignoreCase) {
                buff.append(")");
            }
            buff.append(' ');
            if (order.isAscending()) {
                buff.append("ASC");
            } else {
                buff.append("DESC");
            }
            if (!i.hasNext()) continue;
            buff.append(",");
        }
    }

    protected void appendForUpdate(QueryPosition queryPosition, QueryBuilder2.SelectQueryDefinition definition, StringBuilder queryBuilder) {
        if (definition.isForUpdate()) {
            throw new IllegalStateException("For update not supported for current query builder: " + this.getClass().getSimpleName());
        }
    }

    private String getJsonEntityColumn(AnnotationMetadata annotationMetadata) {
        AnnotationValue entityRepresentationAnnotationValue = annotationMetadata.getAnnotation(EntityRepresentation.class);
        if (entityRepresentationAnnotationValue != null) {
            return (String)entityRepresentationAnnotationValue.getRequiredValue("column", String.class);
        }
        return null;
    }

    private void buildUpdateStatement(AnnotationMetadata annotationMetadata, QueryState queryState, Map<String, Object> propertiesToUpdate) {
        StringBuilder queryString = queryState.getQuery();
        queryString.append(' ').append("SET").append(' ');
        PersistentEntity entity = queryState.getEntity();
        boolean jsonEntity = this.isJsonEntity(annotationMetadata, queryState.getEntity());
        if (jsonEntity && propertiesToUpdate.size() == 1) {
            this.checkDialectSupportsJsonEntity(entity);
            String name = propertiesToUpdate.keySet().iterator().next();
            String jsonEntityColumn = this.getJsonEntityColumn(annotationMetadata);
            if (name.equals(jsonEntityColumn)) {
                Object value = propertiesToUpdate.get(name);
                queryString.append(queryState.getRootAlias()).append('.').append(jsonEntityColumn).append("=");
                if (value instanceof BindingParameter) {
                    final int key = 1;
                    queryState.pushParameter(new QueryParameterBinding(){

                        @Override
                        public String getName() {
                            return String.valueOf(key);
                        }

                        @Override
                        public String getKey() {
                            return String.valueOf(key);
                        }

                        @Override
                        public DataType getDataType() {
                            return DataType.JSON;
                        }

                        @Override
                        public JsonDataType getJsonDataType() {
                            return JsonDataType.DEFAULT;
                        }
                    });
                } else {
                    queryString.append(this.asLiteral(value));
                }
                return;
            }
        }
        List update = propertiesToUpdate.entrySet().stream().map(e -> {
            Association association;
            QueryPropertyPath propertyPath = queryState.findProperty((String)e.getKey());
            PersistentProperty patt0$temp = propertyPath.getProperty();
            if (patt0$temp instanceof Association && (association = (Association)patt0$temp).isForeignKey()) {
                throw new IllegalArgumentException("Foreign key associations cannot be updated as part of a batch update statement");
            }
            return new AbstractMap.SimpleEntry(propertyPath, e.getValue());
        }).filter(e -> !(e.getValue() instanceof QueryParameter) || !((QueryPropertyPath)e.getKey()).getProperty().isGenerated()).collect(Collectors.toList());
        boolean[] needsTrimming = new boolean[]{false};
        if (!this.computePropertyPaths() || jsonEntity) {
            String jsonViewColumnName = this.getJsonEntityColumn(annotationMetadata);
            if (jsonViewColumnName != null) {
                queryString.append(queryState.getRootAlias()).append('.').append(jsonViewColumnName).append("= json_transform(").append(jsonViewColumnName);
            }
            for (Map.Entry entry : update) {
                QueryPropertyPath propertyPath = (QueryPropertyPath)entry.getKey();
                PersistentProperty prop = propertyPath.getProperty();
                String tableAlias = propertyPath.getTableAlias();
                if (jsonViewColumnName != null) {
                    queryString.append(", SET '$.").append(propertyPath.getPath()).append("' = ");
                } else {
                    if (tableAlias != null) {
                        queryString.append(tableAlias).append('.');
                    }
                    queryString.append(propertyPath.getPath()).append('=');
                }
                Object value = entry.getValue();
                if (value instanceof BindingParameter) {
                    BindingParameter bindingParameter = (BindingParameter)value;
                    this.appendUpdateSetParameter(queryString, tableAlias, prop, () -> queryState.pushParameter(bindingParameter, this.newBindingContext(propertyPath.propertyPath)));
                } else if (value instanceof IExpression) {
                    IExpression expression = (IExpression)value;
                    new ExpressionAppender(queryState, annotationMetadata).appendExpression(expression, new DefaultPersistentPropertyPath(propertyPath.propertyPath, null));
                } else {
                    queryString.append(this.asLiteral(value));
                }
                if (jsonViewColumnName != null) continue;
                queryString.append(',');
                needsTrimming[0] = true;
            }
            if (jsonViewColumnName != null) {
                queryString.append(')');
            }
        } else {
            NamingStrategy namingStrategy = this.getNamingStrategy(queryState.getEntity());
            for (Map.Entry entry : update) {
                QueryPropertyPath propertyPath = (QueryPropertyPath)entry.getKey();
                Object tableAlias = entry.getValue();
                if (tableAlias instanceof BindingParameter) {
                    BindingParameter bindingParameter = (BindingParameter)tableAlias;
                    PersistentEntityUtils.traversePersistentProperties(propertyPath.getPropertyPath(), this.traverseEmbedded(), (associations, property) -> {
                        boolean generated = SqlQueryBuilderUtils.isGeneratedProperty(property, associations);
                        if (generated) {
                            return;
                        }
                        String tableAlias = propertyPath.getTableAlias();
                        if (tableAlias != null) {
                            queryString.append(tableAlias).append('.');
                        }
                        String columnName = this.getMappedName(namingStrategy, (List<Association>)associations, (PersistentProperty)property);
                        if (queryState.escape) {
                            columnName = this.quote(columnName);
                        }
                        queryString.append(columnName).append('=');
                        this.appendUpdateSetParameter(queryString, tableAlias, (PersistentProperty)property, () -> queryState.pushParameter(bindingParameter, this.newBindingContext(propertyPath.propertyPath, PersistentPropertyPath.of(associations, property))));
                        queryString.append(',');
                        needsTrimming[0] = true;
                    });
                    continue;
                }
                tableAlias = propertyPath.getTableAlias();
                if (tableAlias != null) {
                    queryString.append((String)tableAlias).append('.');
                }
                queryString.append(propertyPath.getColumnName()).append('=');
                Object value = entry.getValue();
                if (value instanceof IExpression) {
                    IExpression expression = (IExpression)value;
                    new ExpressionAppender(queryState, annotationMetadata).appendExpression(expression, new DefaultPersistentPropertyPath(propertyPath.propertyPath, null));
                } else {
                    queryString.append(this.asLiteral(value));
                }
                queryString.append(',');
                needsTrimming[0] = true;
            }
        }
        if (needsTrimming[0]) {
            queryString.setLength(queryString.length() - 1);
        }
    }

    protected void appendUpdateSetParameter(StringBuilder sb, String alias, PersistentProperty prop, Runnable appendParameter) {
        Optional<String> dataTransformerWriteValue = this.getDataTransformerWriteValue(alias, prop);
        if (dataTransformerWriteValue.isPresent()) {
            this.appendTransformed(sb, dataTransformerWriteValue.get(), appendParameter);
        } else {
            appendParameter.run();
        }
    }

    protected void appendTransformed(StringBuilder sb, String transformed, Runnable appendParameter) {
        int parameterPosition = transformed.indexOf(63);
        if (parameterPosition > -1) {
            if (transformed.lastIndexOf(63) != parameterPosition) {
                throw new IllegalStateException("Only one parameter placeholder is allowed!");
            }
            sb.append(transformed, 0, parameterPosition);
            appendParameter.run();
            sb.append(transformed.substring(parameterPosition + 1));
        } else {
            sb.append(transformed);
        }
    }

    protected abstract boolean computePropertyPaths();

    @Override
    public QueryResult buildUpdate(@NonNull AnnotationMetadata annotationMetadata, @NonNull QueryBuilder2.UpdateQueryDefinition definition) {
        Map<String, Object> propertiesToUpdate = definition.propertiesToUpdate();
        if (propertiesToUpdate.isEmpty()) {
            throw new IllegalArgumentException("No properties specified to update");
        }
        boolean useAlias = this.isAliasForBatch(definition.persistentEntity(), annotationMetadata);
        QueryState queryState = new QueryState(definition, false, useAlias);
        StringBuilder queryString = queryState.getQuery();
        String tableAlias = queryState.getRootAlias();
        String tableName = this.getTableName(definition.persistentEntity());
        queryString.append("UPDATE ").append(tableName);
        if (tableAlias != null) {
            queryString.append(' ').append(tableAlias);
        }
        this.buildUpdateStatement(annotationMetadata, queryState, propertiesToUpdate);
        this.buildWhereClause(annotationMetadata, definition.predicate(), queryState);
        Selection<?> returningSelection = definition.returningSelection();
        if (returningSelection != null) {
            if (!this.getDialect().supportsUpdateReturning()) {
                throw new IllegalStateException("Dialect: " + String.valueOf((Object)this.getDialect()) + " doesn't support UPDATE ... RETURNING clause");
            }
            queryString.append(RETURNING);
            this.buildSelect(annotationMetadata, queryState, returningSelection, false);
        }
        return QueryResult.of(queryState.getFinalQuery(), queryState.getQueryParts(), queryState.getParameterBindings());
    }

    @Override
    public QueryResult buildDelete(@NonNull AnnotationMetadata annotationMetadata, @NonNull QueryBuilder2.DeleteQueryDefinition definition) {
        boolean useAlias = this.isAliasForBatch(definition.persistentEntity(), annotationMetadata);
        QueryState queryState = new QueryState(definition, false, useAlias);
        StringBuilder queryString = queryState.getQuery();
        String tableAlias = queryState.getRootAlias();
        StringBuilder query = this.appendDeleteClause(queryString);
        String tableName = this.getTableName(definition.persistentEntity());
        query.append(tableName).append(' ');
        if (tableAlias != null) {
            query.append(this.getTableAsKeyword()).append(tableAlias);
        }
        this.buildWhereClause(annotationMetadata, definition.predicate(), queryState);
        Selection<?> returningSelection = definition.returningSelection();
        if (returningSelection != null) {
            if (!this.getDialect().supportsDeleteReturning()) {
                throw new IllegalStateException("Dialect: " + String.valueOf((Object)this.getDialect()) + " doesn't support DELETE ... RETURNING clause");
            }
            queryString.append(RETURNING);
            this.buildSelect(annotationMetadata, queryState, returningSelection, false);
        }
        return QueryResult.of(queryState.getFinalQuery(), queryState.getQueryParts(), queryState.getParameterBindings());
    }

    protected abstract boolean isAliasForBatch(PersistentEntity var1, AnnotationMetadata var2);

    @NonNull
    protected StringBuilder appendDeleteClause(StringBuilder queryString) {
        return queryString.append("DELETE ").append(FROM_CLAUSE);
    }

    @NonNull
    public String buildOrderBy(String query, @NonNull PersistentEntity entity, @NonNull AnnotationMetadata annotationMetadata, @NonNull Sort sort, boolean nativeQuery, @Nullable String tableAlias) {
        ArgumentUtils.requireNonNull((String)"entity", (Object)entity);
        ArgumentUtils.requireNonNull((String)"sort", (Object)sort);
        List<Sort.Order> orders = sort.getOrderBy();
        if (CollectionUtils.isEmpty(orders)) {
            throw new IllegalArgumentException("Sort is empty");
        }
        StringBuilder buff = new StringBuilder(ORDER_BY_CLAUSE);
        Iterator<Sort.Order> i = orders.iterator();
        while (i.hasNext()) {
            Sort.Order order = i.next();
            String property = order.getProperty();
            boolean ignoreCase = order.isIgnoreCase();
            if (ignoreCase) {
                buff.append("LOWER(");
            }
            buff.append(this.buildPropertyByName(property, query, entity, annotationMetadata, nativeQuery, tableAlias));
            if (ignoreCase) {
                buff.append(")");
            }
            buff.append(' ').append((Object)order.getDirection());
            if (!i.hasNext()) continue;
            buff.append(",");
        }
        return buff.toString();
    }

    public String buildPropertyByName(@NonNull String propertyName, @NonNull String query, @NonNull PersistentEntity entity, @NonNull AnnotationMetadata annotationMetadata, boolean nativeQuery, @Nullable String tableAlias) {
        String aliasName;
        if (nativeQuery) {
            return propertyName;
        }
        PersistentPropertyPath path = entity.getPropertyPath(propertyName);
        if (path == null) {
            throw new IllegalArgumentException("Cannot sort on non-existent property path: " + propertyName);
        }
        ArrayList<Association> associations = new ArrayList<Association>(path.getAssociations());
        int assocCount = associations.size();
        if (assocCount > 0 && this.computePropertyPaths() && ((Association)associations.get(assocCount - 1)).isEmbedded()) {
            associations.remove(assocCount - 1);
        }
        StringBuilder buff = new StringBuilder();
        String string = aliasName = tableAlias == null ? this.getAliasName(entity) : tableAlias;
        if (associations.isEmpty()) {
            buff.append(aliasName);
        } else {
            StringJoiner joiner = new StringJoiner(".");
            for (Association association : associations) {
                joiner.add(association.getName());
            }
            String joinAlias = this.getAliasName(new JoinPath(joiner.toString(), associations.toArray(new Association[0]), Join.Type.DEFAULT, null));
            if (!this.computePropertyPaths()) {
                if (!query.contains(" " + joinAlias + " ") && !query.endsWith(" " + joinAlias)) {
                    buff.append(aliasName).append('.');
                    StringJoiner pathJoiner = new StringJoiner(".");
                    for (Association association : associations) {
                        pathJoiner.add(association.getName());
                    }
                    buff.append(pathJoiner);
                } else {
                    buff.append(joinAlias);
                }
            } else {
                buff.append(joinAlias);
            }
        }
        buff.append('.');
        String jsonEntityColumn = this.getJsonEntityColumn(annotationMetadata);
        if (jsonEntityColumn != null) {
            buff.append(jsonEntityColumn).append('.');
        }
        if (!this.computePropertyPaths() || jsonEntityColumn != null) {
            buff.append(path.getProperty().getName());
            if (jsonEntityColumn != null) {
                this.appendJsonProjection(buff, path.getProperty().getDataType());
            }
        } else {
            buff.append(this.getColumnName(path.getProperty()));
        }
        return buff.toString();
    }

    protected static String asPath(List<Association> associations, PersistentProperty property) {
        if (associations.isEmpty()) {
            return property.getName();
        }
        StringJoiner joiner = new StringJoiner(".");
        for (Association association : associations) {
            joiner.add(association.getName());
        }
        joiner.add(property.getName());
        return joiner.toString();
    }

    private static String asPath(List<Association> associations) {
        StringJoiner joiner = new StringJoiner(".");
        for (Association association : associations) {
            joiner.add(association.getName());
        }
        return joiner.toString();
    }

    private Optional<String> getDataTransformerValue(String alias, PersistentProperty prop, String val) {
        return prop.getAnnotationMetadata().stringValue(DataTransformer.class, val).map(v -> this.replaceAlias(alias, (String)v));
    }

    private String replaceAlias(String alias, String v) {
        return v.replaceAll(ALIAS_REPLACE_QUOTED, (String)(alias == null ? "" : alias + "."));
    }

    private BindingParameter.BindingContext newBindingContext(@Nullable PersistentPropertyPath ref, @Nullable PersistentPropertyPath persistentPropertyPath) {
        return BindingParameter.BindingContext.create().incomingMethodParameterProperty(ref).outgoingQueryParameterProperty(persistentPropertyPath);
    }

    protected BindingParameter.BindingContext newBindingContext(@Nullable PersistentPropertyPath ref) {
        return BindingParameter.BindingContext.create().incomingMethodParameterProperty(ref).outgoingQueryParameterProperty(ref);
    }

    protected Optional<String> getDataTransformerReadValue(String alias, PersistentProperty prop) {
        return this.getDataTransformerValue(alias, prop, "read");
    }

    protected Optional<String> getDataTransformerWriteValue(String alias, PersistentProperty prop) {
        return this.getDataTransformerValue(alias, prop, "write");
    }

    protected abstract Placeholder formatParameter(int var1);

    public abstract String resolveJoinType(Join.Type var1);

    protected final String getColumnAlias(PersistentProperty property) {
        return property.getAlias();
    }

    protected void checkDialectSupportsJsonEntity(PersistentEntity entity) {
        if (!this.getDialect().supportsJsonEntity()) {
            throw new IllegalArgumentException("Json representation for entity " + entity.getSimpleName() + " is not supported by the dialect " + String.valueOf((Object)this.getDialect()));
        }
    }

    protected boolean isJsonEntity(AnnotationMetadata annotationMetadata, PersistentEntity entity) {
        boolean jsonEntity = DataAnnotationUtils.hasJsonEntityRepresentationAnnotation(annotationMetadata);
        if (jsonEntity) {
            this.checkDialectSupportsJsonEntity(entity);
        }
        return jsonEntity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void appendExpression(AnnotationMetadata annotationMetadata, StringBuilder query, QueryState queryState, Expression<?> expression, boolean isProjection) {
        if (expression instanceof io.micronaut.data.model.jpa.criteria.PersistentPropertyPath) {
            io.micronaut.data.model.jpa.criteria.PersistentPropertyPath persistentPropertyPath = (io.micronaut.data.model.jpa.criteria.PersistentPropertyPath)expression;
            this.appendPropertyRef(annotationMetadata, query, queryState, persistentPropertyPath.getPropertyPath(), isProjection);
            return;
        } else if (expression instanceof ParameterExpression) {
            ParameterExpression parameterExpression = (ParameterExpression)expression;
            if (!(expression instanceof BindingParameter)) throw new IllegalArgumentException("Unknown parameter: " + String.valueOf(parameterExpression));
            BindingParameter bindingParameter = (BindingParameter)expression;
            queryState.pushParameter(bindingParameter, this.newBindingContext(null));
            return;
        } else {
            if (!(expression instanceof LiteralExpression)) throw new IllegalArgumentException("Unsupported expression type: " + String.valueOf(expression.getClass()));
            LiteralExpression literalExpression = (LiteralExpression)expression;
            query.append(this.asLiteral(literalExpression.getValue()));
        }
    }

    protected final void appendPropertyRef(AnnotationMetadata annotationMetadata, StringBuilder query, QueryState queryState, PersistentPropertyPath pp, boolean isProjection) {
        String readTransformer;
        if (this.computePropertyPaths() && pp.getProperty() instanceof Embedded) {
            throw new IllegalArgumentException("Embedded are not allowed as an expression!");
        }
        QueryPropertyPath propertyPath = queryState.findProperty(pp);
        String tableAlias = propertyPath.getTableAlias();
        String string = readTransformer = isProjection ? (String)this.getDataTransformerReadValue(tableAlias, propertyPath.getProperty()).orElse(null) : null;
        if (readTransformer != null) {
            query.append(readTransformer);
            return;
        }
        if (tableAlias != null) {
            query.append(tableAlias).append('.');
        }
        boolean computePropertyPaths = this.computePropertyPaths();
        boolean jsonEntity = this.isJsonEntity(annotationMetadata, queryState.entity);
        if (computePropertyPaths && !jsonEntity) {
            query.append(propertyPath.getColumnName());
        } else if (jsonEntity) {
            String jsonEntityColumn = this.getJsonEntityColumn(annotationMetadata);
            if (jsonEntityColumn != null) {
                query.append(jsonEntityColumn).append('.');
                PersistentProperty property = propertyPath.getProperty();
                if (property == queryState.entity.getIdentity()) {
                    query.append('\"').append(property.getPersistedName()).append('\"');
                } else {
                    query.append(propertyPath.getPath());
                }
                DataType dataType = propertyPath.getProperty().getDataType();
                this.appendJsonProjection(query, dataType);
            }
        } else {
            query.append(propertyPath.getPath());
        }
    }

    private void appendJsonProjection(StringBuilder sb, DataType dataType) {
        if (dataType.isNumeric() || dataType == DataType.BOOLEAN) {
            sb.append(".numberOnly()");
        } else if (dataType == DataType.STRING) {
            sb.append(".stringOnly()");
        } else if (dataType == DataType.TIMESTAMP) {
            sb.append(".timestamp()");
        } else if (dataType == DataType.DATE) {
            sb.append(".date()");
        }
    }

    private void appendConcat(StringBuilder writer, Collection<Runnable> partsWriters) {
        if (this.getDialect() == Dialect.ORACLE) {
            Iterator<Runnable> iterator = partsWriters.iterator();
            while (iterator.hasNext()) {
                iterator.next().run();
                if (!iterator.hasNext()) continue;
                writer.append(" || ");
            }
        } else {
            writer.append("CONCAT(");
            Iterator<Runnable> iterator = partsWriters.iterator();
            while (iterator.hasNext()) {
                iterator.next().run();
                if (!iterator.hasNext()) continue;
                writer.append(',');
            }
            writer.append(")");
        }
    }

    @Override
    public String buildLimitAndOffset(long limit, long offset) {
        StringBuilder builder = new StringBuilder();
        this.appendLimitAndOffset(this.getDialect(), limit, offset, builder);
        return builder.toString();
    }

    protected void appendLimitAndOffset(Dialect dialect, long limit, long offset, StringBuilder builder) {
        boolean hasOffset;
        boolean hasLimit = limit > 0L;
        boolean bl = hasOffset = offset > 0L;
        if (!hasLimit && !hasOffset) {
            return;
        }
        builder.append(' ');
        switch (dialect) {
            case SQL_SERVER: {
                if (hasOffset) {
                    builder.append("OFFSET ").append(offset).append(" ROWS ");
                } else {
                    builder.append("OFFSET 0 ROWS ");
                }
                if (!hasLimit) break;
                builder.append("FETCH NEXT ").append(limit).append(" ROWS ONLY");
                break;
            }
            case ORACLE: {
                if (hasOffset) {
                    builder.append("OFFSET ").append(offset).append(" ROWS");
                }
                if (!hasLimit) break;
                if (hasOffset) {
                    builder.append(" ");
                }
                builder.append("FETCH NEXT ").append(limit).append(" ROWS ONLY");
                break;
            }
            default: {
                if (hasLimit) {
                    builder.append("LIMIT ").append(limit);
                }
                if (!hasOffset) break;
                if (hasLimit) {
                    builder.append(" ");
                }
                builder.append("OFFSET ").append(offset);
            }
        }
    }

    protected class QueryPropertyPath {
        private final PersistentPropertyPath propertyPath;
        private final String tableAlias;

        public QueryPropertyPath(@Nullable PersistentPropertyPath propertyPath, String tableAlias) {
            this.propertyPath = propertyPath;
            this.tableAlias = tableAlias;
        }

        @NonNull
        public List<Association> getAssociations() {
            return this.propertyPath.getAssociations();
        }

        @NonNull
        public PersistentProperty getProperty() {
            return this.propertyPath.getProperty();
        }

        @NonNull
        public String getPath() {
            return this.propertyPath.getPath();
        }

        @Nullable
        public String getTableAlias() {
            return this.tableAlias;
        }

        public String getColumnName() {
            String columnName = AbstractSqlLikeQueryBuilder2.this.getMappedName(this.getNamingStrategy(), this.propertyPath.getAssociations(), this.propertyPath.getProperty());
            if (this.shouldEscape()) {
                return AbstractSqlLikeQueryBuilder2.this.quote(columnName);
            }
            return columnName;
        }

        public NamingStrategy getNamingStrategy() {
            return AbstractSqlLikeQueryBuilder2.this.getNamingStrategy(this.propertyPath);
        }

        public boolean shouldEscape() {
            return AbstractSqlLikeQueryBuilder2.this.shouldEscape(this.propertyPath.findPropertyOwner().orElse(this.propertyPath.getProperty().getOwner()));
        }

        public PersistentPropertyPath getPropertyPath() {
            return this.propertyPath;
        }
    }

    protected record QueryBuilder(AtomicInteger position, List<QueryParameterBinding> parameterBindings, StringBuilder query, List<String> queryParts) {
        public QueryBuilder() {
            this(new AtomicInteger(0), new ArrayList<QueryParameterBinding>(), new StringBuilder(), new ArrayList<String>());
        }
    }

    @Internal
    protected final class QueryState
    implements PropertyParameterCreator {
        private final QueryBuilder queryBuilder;
        private final String rootAlias;
        private final Map<String, JoinPath> appliedJoinPaths = new LinkedHashMap<String, JoinPath>();
        private final boolean allowJoins;
        private final QueryBuilder2.BaseQueryDefinition baseQueryDefinition;
        private final boolean escape;
        private final PersistentEntity entity;
        private List<JoinPath> joinPaths = new ArrayList<JoinPath>();

        private QueryState(QueryBuilder queryBuilder, QueryBuilder2.BaseQueryDefinition query, boolean allowJoins, boolean useAlias) {
            this(queryBuilder, query, allowJoins, useAlias, null);
        }

        private QueryState(QueryBuilder queryBuilder, QueryBuilder2.BaseQueryDefinition query, boolean allowJoins, boolean useAlias, String tableAliasPrefix) {
            this.queryBuilder = queryBuilder;
            this.allowJoins = allowJoins;
            this.baseQueryDefinition = query;
            this.entity = query.persistentEntity();
            this.escape = AbstractSqlLikeQueryBuilder2.this.shouldEscape(this.entity);
            this.rootAlias = useAlias || tableAliasPrefix != null ? (tableAliasPrefix == null ? "" : tableAliasPrefix) + AbstractSqlLikeQueryBuilder2.this.getAliasName(this.entity) : null;
        }

        public QueryState(QueryBuilder2.BaseQueryDefinition query, boolean allowJoins, boolean useAlias) {
            this(new QueryBuilder(), query, allowJoins, useAlias);
        }

        @Nullable
        public String getRootAlias() {
            return this.rootAlias;
        }

        public PersistentEntity getEntity() {
            return this.entity;
        }

        public String getFinalQuery() {
            if (!this.queryBuilder.query.isEmpty() || !this.queryBuilder.queryParts.isEmpty()) {
                this.queryBuilder.queryParts.add(this.queryBuilder.query.toString());
                this.queryBuilder.query.setLength(0);
            }
            StringBuilder sb = new StringBuilder(this.queryBuilder.queryParts.get(0));
            int i = 1;
            for (int k = 1; k < this.queryBuilder.queryParts.size(); ++k) {
                QueryParameterBinding queryParameterBinding = this.queryBuilder.parameterBindings.get(i - 1);
                if (queryParameterBinding.getRole() != null) continue;
                Placeholder placeholder = AbstractSqlLikeQueryBuilder2.this.formatParameter(i++);
                sb.append(placeholder.name);
                sb.append(this.queryBuilder.queryParts.get(k));
            }
            return sb.toString();
        }

        public List<String> getQueryParts() {
            return this.queryBuilder.queryParts;
        }

        public StringBuilder getQuery() {
            return this.queryBuilder.query;
        }

        public boolean isAllowJoins() {
            return this.allowJoins;
        }

        public QueryBuilder2.BaseQueryDefinition baseQueryDefinition() {
            return this.baseQueryDefinition;
        }

        private Placeholder newParameter() {
            return AbstractSqlLikeQueryBuilder2.this.formatParameter(this.queryBuilder.position.incrementAndGet());
        }

        @Nullable
        public String findJoinAlias(String path) {
            JoinPath joinPath = this.appliedJoinPaths.get(path);
            return joinPath == null ? null : joinPath.getAlias().orElseThrow();
        }

        @NonNull
        public String getJoinAlias(String path) {
            String joinAlias = this.findJoinAlias(path);
            if (joinAlias == null) {
                throw new IllegalArgumentException("Property is not joined at path: " + path);
            }
            return joinAlias;
        }

        public void applyJoin(@NonNull JoinPath joinPath) {
            this.joinPaths.add(joinPath);
            if (this.appliedJoinPaths.containsKey(joinPath.getPath())) {
                return;
            }
            Optional<JoinPath> ojp = this.baseQueryDefinition().getJoinPath(joinPath.getPath());
            if (ojp.isPresent()) {
                joinPath = ojp.get();
            }
            Join.Type jt = joinPath.getJoinType();
            String jpAlias = joinPath.getAlias().orElse(null);
            Object[] associationPath = joinPath.getAssociationPath();
            if (ArrayUtils.isEmpty((Object[])associationPath)) {
                throw new IllegalArgumentException("Invalid association path [" + joinPath.getPath() + "]");
            }
            StringJoiner pathSoFar = new StringJoiner(".");
            for (int i = 0; i < associationPath.length; ++i) {
                String currentPath;
                JoinPath existingJoinPath;
                Object association = associationPath[i];
                pathSoFar.add(association.getName());
                if (association.isEmbedded() || (existingJoinPath = this.appliedJoinPaths.get(currentPath = pathSoFar.toString())) != null) continue;
                JoinPath joinPathToUse = this.baseQueryDefinition.getJoinPath(currentPath).orElse(null);
                if (joinPathToUse == null) {
                    joinPathToUse = new JoinPath(currentPath, (Association[])Arrays.copyOfRange(associationPath, 0, i + 1), jt, jpAlias);
                }
                String currentAlias = this.getAliasName(joinPathToUse);
                joinPathToUse = joinPathToUse.withAlias(currentAlias);
                this.appliedJoinPaths.put(currentPath, joinPathToUse);
            }
        }

        private String getAliasName(JoinPath joinPath) {
            return joinPath.getAlias().orElseGet(() -> {
                String joinPathAlias = AbstractSqlLikeQueryBuilder2.this.getPathOnlyAliasName(joinPath);
                if (joinPath.getAssociationPath()[0].hasDeclaredAliasName()) {
                    return joinPathAlias;
                }
                PersistentEntity owner = joinPath.getAssociationPath()[0].getOwner();
                String ownerAlias = owner.equals(this.entity) ? (this.rootAlias == null ? AbstractSqlLikeQueryBuilder2.this.getAliasName(owner) : this.rootAlias) : AbstractSqlLikeQueryBuilder2.this.getAliasName(owner);
                if (ownerAlias.endsWith("_") && joinPathAlias.startsWith("_")) {
                    return ownerAlias + joinPathAlias.substring(1);
                }
                return ownerAlias + joinPathAlias;
            });
        }

        public void generateJoinQuery() {
            for (JoinPath joinPath : this.appliedJoinPaths.values()) {
                String lastJoinAlias;
                List<Association> joinedTablePath = new ArrayList<Association>(5);
                ArrayList<Association> joinAssociationsPath = new ArrayList<Association>(5);
                List<Association> previousAssociations = joinPath.getLeadingAssociations();
                int i = previousAssociations.size();
                while (i-- > 0) {
                    Association association = previousAssociations.get(i);
                    if (association.isEmbedded()) {
                        joinAssociationsPath.add(0, association);
                        continue;
                    }
                    joinedTablePath = previousAssociations.subList(0, i + 1);
                    break;
                }
                if (joinedTablePath.isEmpty()) {
                    lastJoinAlias = this.rootAlias;
                } else {
                    String associatedJoinedTablePath = AbstractSqlLikeQueryBuilder2.asPath(joinedTablePath);
                    JoinPath joinPath1 = this.appliedJoinPaths.get(associatedJoinedTablePath);
                    if (joinPath1 == null) {
                        throw new IllegalStateException("Path " + associatedJoinedTablePath + " not found. All: " + String.valueOf(this.appliedJoinPaths.keySet()));
                    }
                    lastJoinAlias = joinPath1.getAlias().orElseThrow();
                }
                this.generateJoin(joinPath, new PersistentAssociationPath(joinAssociationsPath, joinPath.getAssociation()), lastJoinAlias);
            }
        }

        private void generateJoin(JoinPath joinPath, PersistentAssociationPath joinAssociation, String lastJoinAlias) {
            AbstractSqlLikeQueryBuilder2.this.buildJoin(AbstractSqlLikeQueryBuilder2.this.resolveJoinType(joinPath.getJoinType()), this.queryBuilder.query, this, joinAssociation, this.findOwner(this.entity, joinAssociation), joinPath.getAlias().orElseThrow(), lastJoinAlias);
        }

        private PersistentEntity findOwner(PersistentEntity mainEntity, PersistentAssociationPath joinAssociation) {
            PersistentEntity owner = joinAssociation.getAssociation().getOwner();
            if (!owner.isEmbeddable()) {
                return owner;
            }
            List<Association> associations = joinAssociation.getAssociations();
            ListIterator<Association> listIterator = associations.listIterator(associations.size());
            while (listIterator.hasPrevious()) {
                Association association = listIterator.previous();
                if (association.getOwner().isEmbeddable()) continue;
                return association.getOwner();
            }
            return mainEntity;
        }

        public boolean isJoined(String associationPath) {
            return this.appliedJoinPaths.containsKey(associationPath);
        }

        public boolean shouldEscape() {
            return this.escape;
        }

        public List<QueryParameterBinding> getParameterBindings() {
            return this.queryBuilder.parameterBindings;
        }

        @Override
        public void pushParameter(@NonNull BindingParameter bindingParameter, @NonNull BindingParameter.BindingContext bindingContext) {
            Placeholder placeholder = this.newParameter();
            if ((bindingContext = bindingContext.index(this.queryBuilder.position.get() + 1)).getName() == null) {
                bindingContext = bindingContext.name(placeholder.key());
            }
            this.queryBuilder.parameterBindings.add(bindingParameter.bind(bindingContext));
            this.queryBuilder.queryParts.add(this.queryBuilder.query.toString());
            this.queryBuilder.query.setLength(0);
        }

        public void pushParameter(@NonNull QueryParameterBinding parameterBinding) {
            this.queryBuilder.parameterBindings.add(parameterBinding);
            this.queryBuilder.queryParts.add(this.queryBuilder.query.toString());
            this.queryBuilder.query.setLength(0);
        }

        public List<JoinPath> getJoinPaths() {
            return this.joinPaths;
        }

        public void setJoinPaths(List<JoinPath> joinPaths) {
            this.joinPaths = joinPaths;
        }

        @NonNull
        private QueryPropertyPath findProperty(String propertyPath) {
            PersistentPropertyPath pp = this.entity.getPropertyPath(propertyPath);
            if (pp != null) {
                return this.findPropertyInternal(pp);
            }
            if ("id".equals(propertyPath) && this.entity.getIdentity() != null) {
                return new QueryPropertyPath(new PersistentPropertyPath(Collections.emptyList(), this.entity.getIdentity(), this.entity.getIdentity().getName()), this.rootAlias);
            }
            throw new IllegalArgumentException("Cannot select or update non-existent property path: " + propertyPath);
        }

        @NonNull
        private QueryPropertyPath findProperty(PersistentPropertyPath propertyPath) {
            return this.findPropertyInternal(propertyPath);
        }

        @NonNull
        private QueryPropertyPath findPropertyInternal(PersistentPropertyPath propertyPath) {
            if (propertyPath.getAssociations().isEmpty()) {
                return new QueryPropertyPath(propertyPath, this.rootAlias);
            }
            PersistentProperty property = propertyPath.getProperty();
            ArrayList<Association> joinPath = new ArrayList<Association>(propertyPath.getAssociations());
            ListIterator listIterator = joinPath.listIterator(joinPath.size());
            while (listIterator.hasPrevious()) {
                Association association = (Association)listIterator.previous();
                if (association.isEmbedded()) {
                    listIterator.remove();
                    continue;
                }
                if (!PersistentEntityUtils.isAccessibleWithoutJoin(association, property)) break;
                property = association;
                listIterator.remove();
            }
            if (!joinPath.isEmpty()) {
                return new QueryPropertyPath(new PersistentPropertyPath(Collections.emptyList(), property), this.getRequiredJoinPathAlias(AbstractSqlLikeQueryBuilder2.asPath(joinPath)));
            }
            return new QueryPropertyPath(propertyPath, this.rootAlias);
        }

        @NonNull
        private String getRequiredJoinPathAlias(String path) {
            if (!this.isAllowJoins()) {
                throw new IllegalArgumentException("Joins cannot be used in a DELETE or UPDATE operation and path: " + path);
            }
            return this.getJoinAlias(path);
        }
    }

    protected static enum QueryPosition {
        AFTER_TABLE_NAME,
        END_OF_QUERY;

    }

    protected class SqlSelectionVisitor
    implements SelectionVisitor {
        protected final QueryState queryState;
        protected final StringBuilder query;
        protected final AnnotationMetadata annotationMetadata;
        protected final boolean distinct;
        protected final String tableAlias;
        protected final PersistentEntity entity;
        protected String columnAlias;
        private boolean isCompound;

        public SqlSelectionVisitor(QueryState queryState, AnnotationMetadata annotationMetadata, boolean distinct) {
            this.queryState = queryState;
            this.query = queryState.getQuery();
            this.annotationMetadata = annotationMetadata;
            this.distinct = distinct;
            this.tableAlias = queryState.getRootAlias();
            this.entity = queryState.getEntity();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void visit(io.micronaut.data.model.jpa.criteria.PersistentPropertyPath<?> persistentPropertyPath) {
            PersistentPropertyPath propertyPath = persistentPropertyPath.getPropertyPath();
            PersistentProperty property = propertyPath.getProperty();
            if (this.isCompound) {
                if (property instanceof Association) {
                    Association association = (Association)property;
                    if (!property.isEmbedded()) {
                        if (this.queryState.isJoined(propertyPath.getPath())) {
                            this.appendCompoundAssociationProjection(new PersistentAssociationPath(propertyPath.getAssociations(), association));
                            return;
                        }
                        this.query.setLength(this.query.length() - 1);
                        return;
                    }
                }
                if (!propertyPath.getAssociations().isEmpty() && this.queryState.isJoined(propertyPath.getAssociationsPath())) {
                    this.appendPropertyProjection(this.findProperty(propertyPath.getPath()));
                    return;
                }
                this.appendCompoundPropertyProjection(propertyPath);
                return;
            }
            if (this.distinct) {
                this.query.append(AbstractSqlLikeQueryBuilder2.DISTINCT);
            }
            if (property instanceof Association) {
                Association association = (Association)property;
                if (!property.isEmbedded()) {
                    this.appendAssociationProjection(new PersistentAssociationPath(propertyPath.getAssociations(), association));
                    return;
                }
            }
            this.appendPropertyProjection(this.findProperty(propertyPath.getPath()));
        }

        @Override
        public void visit(AliasedSelection<?> aliasedSelection) {
            this.columnAlias = aliasedSelection.getAlias();
            aliasedSelection.getSelection().visitSelection(this);
            this.columnAlias = null;
        }

        @Override
        public void visit(PersistentEntityRoot<?> entityRoot) {
            if (this.distinct) {
                this.query.append(AbstractSqlLikeQueryBuilder2.DISTINCT);
            }
            this.selectAllColumnsAndJoined();
        }

        @Override
        public void visit(PersistentEntitySubquery<?> subquery) {
            throw new IllegalStateException("Subquery not supported in selection");
        }

        @Override
        public void visit(CompoundSelection<?> compoundSelection) {
            if (this.distinct) {
                this.query.append(AbstractSqlLikeQueryBuilder2.DISTINCT);
            }
            this.isCompound = true;
            Iterator<Selection<?>> iterator = compoundSelection.getCompoundSelectionItems().iterator();
            while (iterator.hasNext()) {
                Selection<?> selection = iterator.next();
                if (!(selection instanceof ISelection)) {
                    throw new IllegalStateException("Unknown selection object: " + String.valueOf(selection));
                }
                ISelection selectionVisitable = (ISelection)selection;
                selectionVisitable.visitSelection(this);
                if (!iterator.hasNext()) continue;
                this.query.append(',');
            }
            this.isCompound = false;
        }

        @Override
        public void visit(LiteralExpression<?> literalExpression) {
            this.query.append(AbstractSqlLikeQueryBuilder2.this.asLiteral(literalExpression.getValue()));
        }

        @Override
        public void visit(UnaryExpression<?> unaryExpression) {
            Expression<?> expression = unaryExpression.getExpression();
            switch (unaryExpression.getType()) {
                case LENGTH: {
                    if (AbstractSqlLikeQueryBuilder2.this.getDialect() == Dialect.SQL_SERVER) {
                        this.appendFunction("LEN", expression);
                        break;
                    }
                    this.appendFunction("LENGTH", expression);
                    break;
                }
                case SUM: 
                case AVG: 
                case MAX: 
                case MIN: 
                case UPPER: 
                case LOWER: {
                    this.appendFunction(unaryExpression.getType().name(), expression);
                    break;
                }
                case COUNT: {
                    if (expression instanceof PersistentEntityRoot) {
                        this.appendRowCount(this.tableAlias);
                        break;
                    }
                    if (expression instanceof io.micronaut.data.model.jpa.criteria.PersistentPropertyPath) {
                        io.micronaut.data.model.jpa.criteria.PersistentPropertyPath persistentPropertyPath = (io.micronaut.data.model.jpa.criteria.PersistentPropertyPath)expression;
                        this.appendFunction("COUNT", persistentPropertyPath);
                        break;
                    }
                    throw new IllegalStateException("Illegal expression: " + String.valueOf(expression) + " for count selection!");
                }
                case COUNT_DISTINCT: {
                    if (expression instanceof PersistentEntityRoot) {
                        this.appendRowCountDistinct(this.tableAlias);
                        break;
                    }
                    if (expression instanceof io.micronaut.data.model.jpa.criteria.PersistentPropertyPath) {
                        io.micronaut.data.model.jpa.criteria.PersistentPropertyPath persistentPropertyPath = (io.micronaut.data.model.jpa.criteria.PersistentPropertyPath)expression;
                        this.appendFunction("COUNT(DISTINCT", persistentPropertyPath);
                        this.query.append(')');
                        break;
                    }
                    throw new IllegalStateException("Illegal expression: " + String.valueOf(expression) + " for count distinct selection!");
                }
                default: {
                    throw new IllegalStateException(AbstractSqlLikeQueryBuilder2.UNSUPPORTED_EXPRESSION + String.valueOf((Object)unaryExpression.getType()));
                }
            }
        }

        @Override
        public void visit(BinaryExpression<?> binaryExpression) {
            Expression<?> left = binaryExpression.getLeft();
            Expression<?> right = binaryExpression.getRight();
            switch (binaryExpression.getType()) {
                case SUM: {
                    this.appendExpression(left);
                    this.query.append(" + ");
                    this.appendExpression(right);
                    break;
                }
                case DIFF: {
                    this.appendExpression(left);
                    this.query.append(" - ");
                    this.appendExpression(right);
                    break;
                }
                case QUOT: {
                    this.appendExpression(left);
                    this.query.append(" / ");
                    this.appendExpression(right);
                    break;
                }
                case PROD: {
                    this.appendExpression(left);
                    this.query.append(" * ");
                    this.appendExpression(right);
                    break;
                }
                case CONCAT: {
                    this.appendFunction("CONCAT", List.of(left, right));
                    break;
                }
                default: {
                    throw new IllegalStateException(AbstractSqlLikeQueryBuilder2.UNSUPPORTED_EXPRESSION + String.valueOf((Object)binaryExpression.getType()));
                }
            }
        }

        @Override
        public void visit(IdExpression<?, ?> idExpression) {
            if (this.entity.hasCompositeIdentity()) {
                for (PersistentProperty identity : this.entity.getCompositeIdentity()) {
                    this.appendPropertyProjection(AbstractSqlLikeQueryBuilder2.this.asQueryPropertyPath(this.queryState.getRootAlias(), identity));
                    this.query.append(',');
                }
                this.query.setLength(this.query.length() - 1);
            } else if (this.entity.hasIdentity()) {
                List<PersistentProperty> identityProperties = this.entity.getIdentityProperties();
                if (identityProperties.isEmpty()) {
                    throw new IllegalArgumentException(AbstractSqlLikeQueryBuilder2.CANNOT_QUERY_ON_ID_WITH_ENTITY_THAT_HAS_NO_ID);
                }
                for (PersistentProperty identity : identityProperties) {
                    this.appendPropertyProjection(AbstractSqlLikeQueryBuilder2.this.asQueryPropertyPath(this.queryState.getRootAlias(), identity));
                }
            } else {
                throw new IllegalArgumentException(AbstractSqlLikeQueryBuilder2.CANNOT_QUERY_ON_ID_WITH_ENTITY_THAT_HAS_NO_ID);
            }
        }

        @Override
        public void visit(FunctionExpression<?> functionExpression) {
            this.appendFunction(functionExpression.getName(), functionExpression.getExpressions());
        }

        @Internal
        protected void appendCompoundPropertyProjection(PersistentPropertyPath propertyPath) {
            PersistentEntity entity = propertyPath.getProperty().getOwner();
            boolean escape = AbstractSqlLikeQueryBuilder2.this.shouldEscape(entity);
            NamingStrategy namingStrategy = AbstractSqlLikeQueryBuilder2.this.getNamingStrategy(entity);
            int[] propertiesCount = new int[1];
            PersistentEntityUtils.traversePersistentProperties(propertyPath, AbstractSqlLikeQueryBuilder2.this.traverseEmbedded(), (associations, p) -> {
                this.appendProperty(this.query, (List<Association>)associations, (PersistentProperty)p, namingStrategy, this.queryState.rootAlias, escape);
                propertiesCount[0] = propertiesCount[0] + 1;
            });
            this.query.setLength(this.query.length() - 1);
            if (StringUtils.isNotEmpty((CharSequence)this.columnAlias)) {
                if (propertiesCount[0] > 1) {
                    throw new IllegalStateException("Cannot apply a column alias: " + this.columnAlias + " with expanded property: " + String.valueOf(propertyPath));
                }
                if (propertiesCount[0] == 1) {
                    this.query.append(AbstractSqlLikeQueryBuilder2.AS_CLAUSE).append(this.columnAlias);
                }
            }
        }

        @Internal
        protected void appendCompoundAssociationProjection(PersistentAssociationPath propertyPath) {
            if (!this.query.isEmpty() && this.query.charAt(this.query.length() - 1) == ',') {
                this.query.setLength(this.query.length() - 1);
            }
            this.selectAllColumnsFromJoinPaths(this.queryState.baseQueryDefinition().getJoinPaths(), null);
        }

        @Internal
        protected void appendCompoundProjection(PersistentPropertyPath propertyPath) {
            if (!this.query.isEmpty() && this.query.charAt(this.query.length() - 1) == ',') {
                this.query.setLength(this.query.length() - 1);
            }
            this.selectAllColumnsFromJoinPaths(this.queryState.baseQueryDefinition().getJoinPaths(), null);
        }

        protected void appendPropertyProjection(QueryPropertyPath propertyPath) {
            boolean jsonEntity = AbstractSqlLikeQueryBuilder2.this.isJsonEntity(this.annotationMetadata, this.entity);
            if (!AbstractSqlLikeQueryBuilder2.this.computePropertyPaths() || jsonEntity) {
                this.query.append(propertyPath.getTableAlias()).append('.');
                String jsonEntityColumn = null;
                if (jsonEntity) {
                    jsonEntityColumn = AbstractSqlLikeQueryBuilder2.this.getJsonEntityColumn(this.annotationMetadata);
                    if (jsonEntityColumn != null) {
                        AbstractSqlLikeQueryBuilder2.this.checkDialectSupportsJsonEntity(this.entity);
                    }
                    this.query.append(jsonEntityColumn).append('.');
                }
                this.query.append(propertyPath.getPath());
                if (jsonEntityColumn != null) {
                    AbstractSqlLikeQueryBuilder2.this.appendJsonProjection(this.query, propertyPath.getProperty().getDataType());
                }
                return;
            }
            String tableAlias = propertyPath.getTableAlias();
            boolean escape = propertyPath.shouldEscape();
            NamingStrategy namingStrategy = propertyPath.getNamingStrategy();
            boolean[] needsTrimming = new boolean[]{false};
            int[] propertiesCount = new int[1];
            PersistentEntityUtils.traversePersistentProperties(propertyPath.getAssociations(), propertyPath.getProperty(), AbstractSqlLikeQueryBuilder2.this.traverseEmbedded(), (associations, property) -> {
                this.appendProperty(this.query, (List<Association>)associations, (PersistentProperty)property, namingStrategy, tableAlias, escape);
                needsTrimming[0] = true;
                propertiesCount[0] = propertiesCount[0] + 1;
            });
            if (needsTrimming[0]) {
                this.query.setLength(this.query.length() - 1);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.columnAlias)) {
                if (propertiesCount[0] > 1) {
                    throw new IllegalStateException("Cannot apply a column alias: " + this.columnAlias + " with expanded property: " + String.valueOf(propertyPath));
                }
                if (propertiesCount[0] == 1) {
                    this.query.append(AbstractSqlLikeQueryBuilder2.AS_CLAUSE).append(this.columnAlias);
                }
            }
        }

        protected void appendAssociationProjection(PersistentAssociationPath associationPath) {
            String joinedPath = associationPath.getPath();
            if (!this.queryState.isJoined(joinedPath)) {
                this.query.setLength(this.query.length() - 1);
                return;
            }
            String joinAlias = this.queryState.findJoinAlias(associationPath.getPath());
            this.selectAllColumns(AnnotationMetadata.EMPTY_METADATA, associationPath.getAssociation().getAssociatedEntity(), joinAlias);
            Collection<JoinPath> joinPaths = this.queryState.baseQueryDefinition().getJoinPaths();
            ArrayList<JoinPath> newJoinPaths = new ArrayList<JoinPath>(joinPaths.size());
            HashMap<JoinPath, String> joinAliasOverride = new HashMap<JoinPath, String>();
            for (JoinPath joinPath : joinPaths) {
                if (!joinPath.getPath().startsWith(joinedPath) || joinPath.getPath().equals(joinedPath)) continue;
                int removedItems = 1;
                for (int k = 0; k < joinedPath.length(); ++k) {
                    if (joinedPath.charAt(k) != '.') continue;
                    ++removedItems;
                }
                JoinPath newJoinPath = new JoinPath(joinPath.getPath().substring(joinedPath.length() + 1), Arrays.copyOfRange(joinPath.getAssociationPath(), removedItems, joinPath.getAssociationPath().length), joinPath.getJoinType(), joinPath.getAlias().orElse(null));
                newJoinPaths.add(newJoinPath);
                joinAliasOverride.put(newJoinPath, AbstractSqlLikeQueryBuilder2.this.getAliasName(joinPath));
            }
            this.queryState.setJoinPaths(newJoinPaths);
            this.selectAllColumnsFromJoinPaths(newJoinPaths, joinAliasOverride);
        }

        protected void appendRowCount(String logicalName) {
            throw new IllegalStateException("Not supported!");
        }

        protected void appendRowCountDistinct(String logicalName) {
            throw new IllegalStateException("Not supported!");
        }

        protected void selectAllColumns(AnnotationMetadata annotationMetadata, PersistentEntity persistentEntity, String tableAlias) {
            throw new IllegalStateException("Not supported!");
        }

        protected void selectAllColumnsAndJoined() {
            throw new IllegalStateException("Not supported!");
        }

        protected void selectAllColumnsFromJoinPaths(Collection<JoinPath> allPaths, @Nullable Map<JoinPath, String> joinAliasOverride) {
        }

        protected final void appendProperty(StringBuilder sb, List<Association> associations, PersistentProperty property, NamingStrategy namingStrategy, String tableAlias, boolean escape) {
            String transformed = AbstractSqlLikeQueryBuilder2.this.getDataTransformerReadValue(tableAlias, property).orElse(null);
            String columnAlias = AbstractSqlLikeQueryBuilder2.this.getColumnAlias(property);
            boolean useAlias = StringUtils.isNotEmpty((CharSequence)columnAlias);
            if (transformed != null) {
                sb.append(transformed).append(AbstractSqlLikeQueryBuilder2.AS_CLAUSE).append(useAlias ? columnAlias : property.getPersistedName());
            } else {
                String column = AbstractSqlLikeQueryBuilder2.this.getMappedName(namingStrategy, associations, property);
                column = AbstractSqlLikeQueryBuilder2.this.escapeColumnIfNeeded(column, escape);
                if (tableAlias == null) {
                    sb.append(column);
                } else {
                    sb.append(tableAlias).append('.').append(column);
                }
                if (useAlias) {
                    sb.append(AbstractSqlLikeQueryBuilder2.AS_CLAUSE).append(columnAlias);
                }
            }
            sb.append(',');
        }

        private void appendFunction(String functionName, Expression<?> expression) {
            this.appendFunction(functionName, List.of(expression));
        }

        private void appendFunction(String functionName, List<Expression<?>> expressions) {
            this.query.append(functionName).append('(');
            Iterator<Expression<?>> iterator = expressions.iterator();
            while (iterator.hasNext()) {
                Expression<?> expression = iterator.next();
                this.appendExpression(expression);
                if (!iterator.hasNext()) continue;
                this.query.append(',');
            }
            this.query.append(')');
            if (this.columnAlias != null) {
                this.query.append(AbstractSqlLikeQueryBuilder2.AS_CLAUSE).append(this.columnAlias);
            }
        }

        private void appendExpression(Expression<?> expression) {
            AbstractSqlLikeQueryBuilder2.this.appendExpression(this.annotationMetadata, this.query, this.queryState, expression, true);
        }

        private QueryPropertyPath findProperty(String propertyPath) {
            return this.queryState.findProperty(propertyPath);
        }
    }

    protected class SqlPredicateVisitor
    extends ExpressionAppender
    implements AdvancedPredicateVisitor<PersistentPropertyPath> {
        protected SqlPredicateVisitor(QueryState queryState, AnnotationMetadata annotationMetadata) {
            super(queryState, annotationMetadata);
        }

        private void visitPredicate(IExpression<Boolean> expression) {
            if (expression instanceof RenderablePredicate) {
                RenderablePredicate renderablePredicate = (RenderablePredicate)expression;
                renderablePredicate.render(this.query, this.queryState);
            } else if (expression instanceof IPredicate) {
                IPredicate predicateVisitable = (IPredicate)expression;
                predicateVisitable.visitPredicate(this);
            } else if (expression instanceof io.micronaut.data.model.jpa.criteria.PersistentPropertyPath) {
                this.visitIsTrue(expression);
            } else {
                throw new IllegalStateException("Unknown boolean expression: " + String.valueOf(expression));
            }
        }

        @Override
        public void visit(ConjunctionPredicate conjunction) {
            boolean requiresBracket;
            if (conjunction.getPredicates().isEmpty()) {
                return;
            }
            boolean bl = requiresBracket = this.query.charAt(this.query.length() - 1) != '(';
            if (requiresBracket) {
                this.query.append('(');
            }
            this.visitConjunctionPredicates(conjunction.getPredicates());
            if (requiresBracket) {
                this.query.append(')');
            }
        }

        private void visitConjunctionPredicates(Collection<? extends IExpression<Boolean>> predicates) {
            Iterator<? extends IExpression<Boolean>> iterator = predicates.iterator();
            boolean appendLogicalAnd = true;
            while (iterator.hasNext()) {
                IExpression<Boolean> expression = iterator.next();
                if (expression instanceof ConjunctionPredicate) {
                    ConjunctionPredicate conjunctionPredicate = (ConjunctionPredicate)expression;
                    Collection<? extends IExpression<Boolean>> conjunctionPredicates = conjunctionPredicate.getPredicates();
                    if (CollectionUtils.isEmpty(conjunctionPredicates)) {
                        appendLogicalAnd = false;
                    } else {
                        this.visitConjunctionPredicates(conjunctionPredicates);
                    }
                } else {
                    this.visitPredicate(expression);
                }
                if (!appendLogicalAnd || !iterator.hasNext()) continue;
                this.query.append(AbstractSqlLikeQueryBuilder2.LOGICAL_AND);
            }
        }

        @Override
        public void visit(DisjunctionPredicate disjunction) {
            if (disjunction.getPredicates().isEmpty()) {
                return;
            }
            this.query.append('(');
            this.visitDisjunctionPredicates(disjunction.getPredicates());
            this.query.append(')');
        }

        private void visitDisjunctionPredicates(Collection<? extends IExpression<Boolean>> predicates) {
            Iterator<? extends IExpression<Boolean>> iterator = predicates.iterator();
            while (iterator.hasNext()) {
                IExpression<Boolean> expression = iterator.next();
                if (expression instanceof DisjunctionPredicate) {
                    DisjunctionPredicate disjunctionPredicate = (DisjunctionPredicate)expression;
                    this.visitDisjunctionPredicates(disjunctionPredicate.getPredicates());
                } else {
                    this.visitPredicate(expression);
                }
                if (!iterator.hasNext()) continue;
                this.query.append(AbstractSqlLikeQueryBuilder2.LOGICAL_OR);
            }
        }

        @Override
        public void visit(NegatedPredicate negate) {
            IExpression<Boolean> negated = negate.getNegated();
            if (negated instanceof InPredicate) {
                InPredicate p = (InPredicate)negated;
                this.visitIn(p.getExpression(), p.getValues(), true);
            } else {
                this.query.append(AbstractSqlLikeQueryBuilder2.NOT).append('(');
                if (negated instanceof ConjunctionPredicate) {
                    ConjunctionPredicate conjunctionPredicate = (ConjunctionPredicate)negated;
                    this.visitConjunctionPredicates(conjunctionPredicate.getPredicates());
                } else if (negated instanceof DisjunctionPredicate) {
                    DisjunctionPredicate disjunctionPredicate = (DisjunctionPredicate)negated;
                    this.visitDisjunctionPredicates(disjunctionPredicate.getPredicates());
                } else {
                    this.visitPredicate(negated);
                }
                this.query.append(')');
            }
        }

        @Override
        public void visit(LikePredicate likePredicate) {
            boolean isCaseInsensitive;
            boolean supportsILike = AbstractSqlLikeQueryBuilder2.this.getDialect() == Dialect.POSTGRES;
            boolean bl = isCaseInsensitive = !supportsILike && likePredicate.isCaseInsensitive();
            if (isCaseInsensitive) {
                this.query.append("LOWER(");
            }
            this.appendExpression(likePredicate.getExpression());
            if (isCaseInsensitive) {
                this.query.append(")");
            }
            if (likePredicate.isNegated()) {
                this.query.append(" NOT");
            }
            if (likePredicate.isCaseInsensitive() && supportsILike) {
                this.query.append(" ILIKE ");
            } else {
                this.query.append(" LIKE ");
            }
            Expression<String> pattern = likePredicate.getPattern();
            if (isCaseInsensitive) {
                if (pattern instanceof LiteralExpression) {
                    LiteralExpression literalExpression = (LiteralExpression)pattern;
                    this.query.append(((String)literalExpression.getValue()).toUpperCase());
                } else {
                    this.query.append("LOWER(");
                    this.appendExpression(pattern);
                    this.query.append(")");
                }
            } else {
                this.appendExpression(pattern);
            }
            Expression<Character> escapeChar = likePredicate.getEscapeChar();
            if (escapeChar != null) {
                this.query.append(" ESCAPE ");
                this.appendExpression(escapeChar);
            }
        }

        @Override
        public void visit(ExistsSubqueryPredicate existsSubqueryPredicate) {
            this.query.append("EXISTS");
            this.appendExpression((Expression<?>)existsSubqueryPredicate.getSubquery());
        }

        @Override
        public void visitEquals(Expression<?> leftExpression, Expression<?> rightExpression, boolean ignoreCase) {
            if (leftExpression instanceof io.micronaut.data.model.jpa.criteria.PersistentPropertyPath) {
                String typeName;
                String stringValue;
                LiteralExpression literalExpression;
                Object t;
                io.micronaut.data.model.jpa.criteria.PersistentPropertyPath persistentPropertyPath = (io.micronaut.data.model.jpa.criteria.PersistentPropertyPath)leftExpression;
                PersistentPropertyPath propertyPath = persistentPropertyPath.getPropertyPath();
                PersistentProperty property = propertyPath.getProperty();
                if (AbstractSqlLikeQueryBuilder2.this.computePropertyPaths() && property instanceof Association) {
                    ArrayList predicates = new ArrayList();
                    Expression<?> finalRightExpression = rightExpression;
                    PersistentEntityUtils.traverse(propertyPath, pp -> predicates.add(new BinaryPredicate(new DefaultPersistentPropertyPath((PersistentPropertyPath)pp, null), finalRightExpression, ignoreCase ? PredicateBinaryOp.EQUALS_IGNORE_CASE : PredicateBinaryOp.EQUALS)));
                    if (predicates.size() == 1) {
                        ((IPredicate)predicates.iterator().next()).visitPredicate(this);
                    } else {
                        this.visit(new ConjunctionPredicate(predicates));
                    }
                    return;
                }
                if (property.isEnum() && rightExpression instanceof LiteralExpression && (t = (literalExpression = (LiteralExpression)rightExpression).getValue()) instanceof String && (stringValue = (String)t).startsWith(typeName = property.getTypeName().replace("$", "."))) {
                    for (PersistentProperty.EnumConstant enumConstant : property.getEnumConstants()) {
                        if (!stringValue.equals(typeName + "." + enumConstant.name())) continue;
                        if (property.getDataType() == DataType.STRING) {
                            rightExpression = new LiteralExpression<String>(enumConstant.name());
                        }
                        if (property.getDataType() != DataType.INTEGER) break;
                        rightExpression = new LiteralExpression<Integer>(enumConstant.ordinal());
                        break;
                    }
                }
            }
            if (ignoreCase) {
                this.appendCaseInsensitiveOp(leftExpression, rightExpression, " = ");
            } else {
                this.appendBinaryOperation(" = ", leftExpression, rightExpression);
            }
        }

        @Override
        public void visitNotEquals(Expression<?> leftExpression, Expression<?> rightExpression, boolean ignoreCase) {
            if (leftExpression instanceof io.micronaut.data.model.jpa.criteria.PersistentPropertyPath) {
                io.micronaut.data.model.jpa.criteria.PersistentPropertyPath persistentPropertyPath = (io.micronaut.data.model.jpa.criteria.PersistentPropertyPath)leftExpression;
                PersistentPropertyPath propertyPath = persistentPropertyPath.getPropertyPath();
                PersistentProperty property = propertyPath.getProperty();
                if (AbstractSqlLikeQueryBuilder2.this.computePropertyPaths() && property instanceof Association) {
                    ArrayList predicates = new ArrayList();
                    PersistentEntityUtils.traverse(propertyPath, pp -> predicates.add(new BinaryPredicate(new DefaultPersistentPropertyPath((PersistentPropertyPath)pp, null), rightExpression, ignoreCase ? PredicateBinaryOp.NOT_EQUALS_IGNORE_CASE : PredicateBinaryOp.NOT_EQUALS)));
                    if (predicates.size() == 1) {
                        ((IPredicate)predicates.iterator().next()).visitPredicate(this);
                    } else {
                        this.visit(new ConjunctionPredicate(predicates));
                    }
                    return;
                }
            }
            if (ignoreCase) {
                this.appendCaseInsensitiveOp(leftExpression, rightExpression, " != ");
            } else {
                this.appendBinaryOperation(" != ", leftExpression, rightExpression);
            }
        }

        @Override
        public void visitGreaterThan(Expression<?> leftExpression, Expression<?> rightExpression) {
            this.appendBinaryOperation(" > ", leftExpression, rightExpression);
        }

        @Override
        public void visitGreaterThanOrEquals(Expression<?> leftExpression, Expression<?> rightExpression) {
            this.appendBinaryOperation(" >= ", leftExpression, rightExpression);
        }

        @Override
        public void visitLessThan(Expression<?> leftExpression, Expression<?> rightExpression) {
            this.appendBinaryOperation(" < ", leftExpression, rightExpression);
        }

        @Override
        public void visitLessThanOrEquals(Expression<?> leftExpression, Expression<?> rightExpression) {
            this.appendBinaryOperation(" <= ", leftExpression, rightExpression);
        }

        @Override
        public void visitStartsWith(Expression<?> leftExpression, Expression<?> rightExpression, boolean ignoreCase) {
            this.appendLikeConcatComparison(leftExpression, rightExpression, ignoreCase, "?", "'%'");
        }

        @Override
        public void visitContains(Expression<?> leftExpression, Expression<?> expression, boolean ignoreCase) {
            this.appendLikeConcatComparison(leftExpression, expression, ignoreCase, "'%'", "?", "'%'");
        }

        @Override
        public void visitEndsWith(Expression<?> leftExpression, Expression<?> expression, boolean ignoreCase) {
            this.appendLikeConcatComparison(leftExpression, expression, ignoreCase, "'%'", "?");
        }

        private void appendLikeConcatComparison(Expression<?> leftExpression, Expression<?> expression, boolean ignoreCase, String ... parts) {
            boolean isPostgres;
            boolean bl = isPostgres = AbstractSqlLikeQueryBuilder2.this.getDialect() == Dialect.POSTGRES;
            if (ignoreCase && !isPostgres) {
                this.query.append("LOWER(");
                this.appendExpression(leftExpression);
                this.query.append(")");
            } else {
                this.appendExpression(leftExpression);
            }
            if (isPostgres) {
                this.query.append(" ILIKE ");
            } else {
                this.query.append(" LIKE ");
            }
            AbstractSqlLikeQueryBuilder2.this.appendConcat(this.query, Arrays.stream(parts).map(p -> {
                if ("?".equals(p)) {
                    if (ignoreCase && !isPostgres) {
                        return () -> {
                            this.query.append("LOWER(");
                            this.appendExpression(expression, leftExpression);
                            this.query.append(")");
                        };
                    }
                    return () -> this.appendExpression(expression, leftExpression);
                }
                return () -> this.query.append((String)p);
            }).toList());
        }

        @Override
        public void visitIdEquals(Expression<?> expression) {
            if (this.persistentEntity.hasCompositeIdentity()) {
                if (!(expression instanceof IParameterExpression)) {
                    throw new IllegalStateException("Composite identity expressions can only be used with parameters");
                }
                IParameterExpression parameterExpression = (IParameterExpression)expression;
                new ConjunctionPredicate(Arrays.stream(this.persistentEntity.getCompositeIdentity()).map(prop -> {
                    PersistentPropertyPath propertyPath = AbstractSqlLikeQueryBuilder2.this.asPersistentPropertyPath((PersistentProperty)prop);
                    return new BinaryPredicate(new DefaultPersistentPropertyPath(propertyPath, null), new BoundPathParameterExpression(parameterExpression, propertyPath), PredicateBinaryOp.EQUALS);
                }).toList()).visitPredicate(this);
            } else if (this.persistentEntity.hasIdentity()) {
                new BinaryPredicate(new DefaultPersistentPropertyPath(new PersistentPropertyPath(this.persistentEntity.getIdentity()), null), expression, PredicateBinaryOp.EQUALS).visitPredicate(this);
            } else {
                throw new IllegalStateException("No ID found for entity: " + this.persistentEntity.getName());
            }
        }

        private void appendCaseInsensitiveOp(Expression<?> leftExpression, Expression<?> expression, String operator) {
            this.query.append("LOWER(");
            this.appendExpression(leftExpression);
            this.query.append(")").append(operator).append("LOWER(");
            this.appendExpression(expression, leftExpression);
            this.query.append(")");
        }

        @Override
        public void visitIsFalse(Expression<?> expression) {
            this.appendUnaryCondition(" = FALSE", expression);
        }

        @Override
        public void visitIsNotNull(Expression<?> expression) {
            this.appendUnaryCondition(" IS NOT NULL", expression);
        }

        @Override
        public void visitIsNull(Expression<?> expression) {
            this.appendUnaryCondition(" IS NULL", expression);
        }

        @Override
        public void visitIsTrue(Expression<?> expression) {
            this.appendUnaryCondition(" = TRUE", expression);
        }

        @Override
        public void visitIsEmpty(Expression<?> expression) {
            this.appendEmptyExpression(" IS NULL OR ", " = ''", " IS EMPTY", expression);
        }

        @Override
        public void visitIsNotEmpty(Expression<?> expression) {
            if (AbstractSqlLikeQueryBuilder2.this.getDialect() == Dialect.ORACLE) {
                PersistentPropertyPath propertyPath = CriteriaUtils.requireProperty(expression).getPropertyPath();
                if (propertyPath.getProperty().isAssignable(CharSequence.class)) {
                    this.appendPropertyRef(propertyPath);
                    this.query.append(" IS NOT NULL");
                } else {
                    this.appendPropertyRef(propertyPath);
                    this.query.append(" IS NOT EMPTY");
                }
            } else {
                this.appendEmptyExpression(" IS NOT NULL AND ", " <> ''", " IS NOT EMPTY", expression);
            }
        }

        private void appendEmptyExpression(String charSequencePrefix, String charSequenceSuffix, String listSuffix, Expression<?> expression) {
            if (((IExpression)expression).getExpressionType().isTextual()) {
                this.appendExpression(expression);
                this.query.append(charSequencePrefix);
                this.appendExpression(expression);
                this.query.append(charSequenceSuffix);
            } else {
                this.appendExpression(expression);
                this.query.append(listSuffix);
            }
        }

        private void appendUnaryCondition(String sqlOp, Expression<?> expression) {
            this.appendExpression(expression);
            this.query.append(sqlOp);
        }

        @Override
        public void visitInBetween(Expression<?> value, Expression<?> from, Expression<?> to, boolean negated) {
            if (negated) {
                this.query.append(AbstractSqlLikeQueryBuilder2.NOT);
                this.query.append(" ");
            }
            this.query.append('(');
            this.appendExpression(value);
            this.query.append(" >= ");
            this.appendExpression(from, value);
            this.query.append(AbstractSqlLikeQueryBuilder2.LOGICAL_AND);
            this.appendExpression(value);
            this.query.append(" <= ");
            this.appendExpression(to, value);
            this.query.append(')');
        }

        @Override
        public void visitIn(Expression<?> expression, Collection<?> values, boolean negated) {
            if (values.isEmpty()) {
                return;
            }
            PersistentPropertyPath propertyPath = CriteriaUtils.requireProperty(expression).getPropertyPath();
            this.appendExpression(expression);
            this.query.append(negated ? " NOT IN (" : " IN (");
            boolean hasOneParameter = values.stream().filter(v -> v instanceof ParameterExpression).count() == 1L;
            Iterator<?> iterator = values.iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                if (value instanceof ParameterExpression) {
                    BindingParameter.BindingContext bindingContext = AbstractSqlLikeQueryBuilder2.this.newBindingContext(propertyPath);
                    if (hasOneParameter) {
                        bindingContext = bindingContext.expandable();
                    }
                    this.queryState.pushParameter((BindingParameter)value, bindingContext);
                } else {
                    this.appendExpression((Expression)value);
                }
                if (!iterator.hasNext()) continue;
                this.query.append(',');
            }
            this.query.append(')');
        }
    }

    protected class ExpressionAppender
    implements ExpressionVisitor {
        protected final PersistentEntity persistentEntity;
        protected final String tableAlias;
        protected final StringBuilder query;
        protected final QueryState queryState;
        protected final AnnotationMetadata annotationMetadata;
        @Nullable
        private Expression<?> boundedExpression;

        protected ExpressionAppender(QueryState queryState, AnnotationMetadata annotationMetadata) {
            this.queryState = queryState;
            this.annotationMetadata = annotationMetadata;
            this.persistentEntity = queryState.getEntity();
            this.tableAlias = queryState.getRootAlias();
            this.query = queryState.getQuery();
        }

        public final PersistentPropertyPath getRequiredProperty(io.micronaut.data.model.jpa.criteria.PersistentPropertyPath<?> persistentPropertyPath) {
            return persistentPropertyPath.getPropertyPath();
        }

        protected final void appendPropertyRef(PersistentPropertyPath propertyPath) {
            AbstractSqlLikeQueryBuilder2.this.appendPropertyRef(this.annotationMetadata, this.query, this.queryState, propertyPath, false);
        }

        protected final void appendBinaryOperation(@NonNull String operator, @NonNull Expression<?> leftExpression, @NonNull Expression<?> rightExpression) {
            this.appendExpression(leftExpression, null);
            this.query.append(operator);
            this.appendExpression(rightExpression, leftExpression);
        }

        protected final void appendExpression(Expression<?> expression) {
            this.appendExpression(expression, null);
        }

        protected final void appendExpression(Expression<?> expression, @Nullable Expression<?> boundedExpression) {
            this.boundedExpression = boundedExpression;
            CriteriaUtils.requireIExpression(expression).visitExpression(this);
            this.boundedExpression = null;
        }

        protected final PersistentPropertyPath findParameterBoundProperty(Expression<?> binaryOpExpression) {
            if (binaryOpExpression == null) {
                return null;
            }
            if (binaryOpExpression instanceof UnaryExpression) {
                UnaryExpression unaryExpression = (UnaryExpression)binaryOpExpression;
                return this.findParameterBoundProperty(unaryExpression.getExpression());
            }
            if (binaryOpExpression instanceof io.micronaut.data.model.jpa.criteria.PersistentPropertyPath) {
                io.micronaut.data.model.jpa.criteria.PersistentPropertyPath persistentPropertyPath = (io.micronaut.data.model.jpa.criteria.PersistentPropertyPath)binaryOpExpression;
                return persistentPropertyPath.getPropertyPath();
            }
            return null;
        }

        protected final void appendFunction(String functionName, Expression<?> expression) {
            this.appendFunction(functionName, List.of(expression));
        }

        protected final void appendFunction(String functionName, List<Expression<?>> expressions) {
            this.query.append(functionName).append('(');
            Iterator<Expression<?>> iterator = expressions.iterator();
            while (iterator.hasNext()) {
                Expression<?> expression = iterator.next();
                this.appendExpression(expression);
                if (!iterator.hasNext()) continue;
                this.query.append(',');
            }
            this.query.append(')');
        }

        protected final void appendBindingParameter(BindingParameter bindingParameter, @Nullable PersistentPropertyPath entityPropertyPath) {
            Runnable pushParameter = () -> this.queryState.pushParameter(bindingParameter, AbstractSqlLikeQueryBuilder2.this.newBindingContext(null, entityPropertyPath));
            if (entityPropertyPath == null) {
                pushParameter.run();
            } else {
                QueryPropertyPath qpp = this.queryState.findProperty(entityPropertyPath);
                String writeTransformer = AbstractSqlLikeQueryBuilder2.this.getDataTransformerWriteValue(qpp.tableAlias, entityPropertyPath.getProperty()).orElse(null);
                if (writeTransformer != null) {
                    AbstractSqlLikeQueryBuilder2.this.appendTransformed(this.query, writeTransformer, pushParameter);
                } else {
                    pushParameter.run();
                }
            }
        }

        @Override
        public void visit(io.micronaut.data.model.jpa.criteria.PersistentPropertyPath<?> persistentPropertyPath) {
            this.appendPropertyRef(persistentPropertyPath.getPropertyPath());
        }

        @Override
        public void visit(PersistentEntityRoot<?> entityRoot) {
            this.visit(new IdExpression(entityRoot));
        }

        @Override
        public void visit(LiteralExpression<?> literalExpression) {
            this.query.append(AbstractSqlLikeQueryBuilder2.this.asLiteral(literalExpression));
        }

        @Override
        public void visit(UnaryExpression<?> unaryExpression) {
            Expression<?> expression = unaryExpression.getExpression();
            switch (unaryExpression.getType()) {
                case LENGTH: {
                    if (AbstractSqlLikeQueryBuilder2.this.getDialect() == Dialect.SQL_SERVER) {
                        this.appendFunction("LEN", expression);
                        break;
                    }
                    this.appendFunction("LENGTH", expression);
                    break;
                }
                case SUM: 
                case AVG: 
                case MAX: 
                case MIN: 
                case UPPER: 
                case LOWER: {
                    this.appendFunction(unaryExpression.getType().name(), expression);
                    break;
                }
                default: {
                    throw new IllegalStateException(AbstractSqlLikeQueryBuilder2.UNSUPPORTED_EXPRESSION + String.valueOf((Object)unaryExpression.getType()));
                }
            }
        }

        @Override
        public void visit(BinaryExpression<?> binaryExpression) {
            Expression<?> left = binaryExpression.getLeft();
            Expression<?> right = binaryExpression.getRight();
            switch (binaryExpression.getType()) {
                case SUM: {
                    this.appendExpression(left);
                    this.query.append(" + ");
                    this.appendExpression(right);
                    break;
                }
                case DIFF: {
                    this.appendExpression(left);
                    this.query.append(" - ");
                    this.appendExpression(right);
                    break;
                }
                case QUOT: {
                    this.appendExpression(left);
                    this.query.append(" / ");
                    this.appendExpression(right);
                    break;
                }
                case PROD: {
                    this.appendExpression(left);
                    this.query.append(" * ");
                    this.appendExpression(right);
                    break;
                }
                case CONCAT: {
                    this.appendFunction("CONCAT", List.of(left, right));
                    break;
                }
                default: {
                    throw new IllegalStateException(AbstractSqlLikeQueryBuilder2.UNSUPPORTED_EXPRESSION + String.valueOf((Object)binaryExpression.getType()));
                }
            }
        }

        @Override
        public void visit(IdExpression<?, ?> idExpression) {
            PersistentEntity persistentEntity = idExpression.getRoot().getPersistentEntity();
            if (persistentEntity.hasCompositeIdentity()) {
                throw new IllegalStateException("ID expression with composite IDs not allowed");
            }
            if (persistentEntity.getIdentityProperties().size() > 1) {
                throw new IllegalStateException("ID expression with multiple IDs not allowed");
            }
            PersistentProperty identity = persistentEntity.getIdentity();
            this.appendPropertyRef(new PersistentPropertyPath(identity));
        }

        @Override
        public void visit(FunctionExpression<?> functionExpression) {
            this.appendFunction(functionExpression.getName(), functionExpression.getExpressions());
        }

        @Override
        public void visit(IParameterExpression<?> parameterExpression) {
            this.appendBindingParameter(parameterExpression, this.findParameterBoundProperty(this.boundedExpression));
        }

        @Override
        public void visit(SubqueryExpression<?> subqueryExpression) {
            this.query.append(subqueryExpression.getType().name());
            this.visit(subqueryExpression.getSubquery());
        }

        @Override
        public void visit(PersistentEntitySubquery<?> subquery) {
            boolean requiresBrackets;
            AbstractPersistentEntityQuery abstractPersistentEntityQuery = (AbstractPersistentEntityQuery)((Object)subquery);
            QueryBuilder2.SelectQueryDefinition selectQueryDefinition = abstractPersistentEntityQuery.toSelectQueryDefinition();
            String outerAlias = this.queryState.getRootAlias();
            if (outerAlias == null) {
                outerAlias = AbstractSqlLikeQueryBuilder2.this.getAliasName(this.queryState.getEntity());
            }
            boolean bl = requiresBrackets = this.query.charAt(this.query.length() - 1) != '(';
            if (requiresBrackets) {
                this.query.append("(");
            }
            AbstractSqlLikeQueryBuilder2.this.buildQuery(AnnotationMetadata.EMPTY_METADATA, selectQueryDefinition, this.queryState.queryBuilder, false, true, outerAlias);
            if (requiresBrackets) {
                this.query.append(")");
            }
        }
    }

    public record Placeholder(String name, String key) {
        @Override
        public String toString() {
            return this.name;
        }
    }
}

