/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.ExpressionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.predicate.InPredicate;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.Bindable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Internal
public class DefaultPersistentPropertyPath<T>
implements io.micronaut.data.model.jpa.criteria.PersistentPropertyPath<T> {
    private final PersistentPropertyPath propertyPath;
    private final CriteriaBuilder criteriaBuilder;

    public DefaultPersistentPropertyPath(PersistentProperty persistentProperty, List<Association> associations, CriteriaBuilder criteriaBuilder) {
        this(new PersistentPropertyPath(associations, persistentProperty), criteriaBuilder);
    }

    public DefaultPersistentPropertyPath(PersistentPropertyPath propertyPath, CriteriaBuilder criteriaBuilder) {
        this.propertyPath = propertyPath;
        this.criteriaBuilder = criteriaBuilder;
    }

    @Override
    public Predicate in(Object ... values) {
        return this.in(Arrays.asList(Objects.requireNonNull(values)));
    }

    @Override
    public Predicate in(Collection<?> values) {
        List<Expression<?>> expressions = Objects.requireNonNull(values).stream().map(arg_0 -> ((CriteriaBuilder)this.criteriaBuilder).literal(arg_0)).collect(Collectors.toList());
        return new InPredicate(this, expressions, this.criteriaBuilder);
    }

    @Override
    public Predicate in(Expression<?> ... values) {
        return new InPredicate(this, Arrays.asList(values), this.criteriaBuilder);
    }

    @Override
    public Predicate in(Expression<Collection<?>> values) {
        return new InPredicate(this, List.of(Objects.requireNonNull(values)), this.criteriaBuilder);
    }

    @Override
    public PersistentProperty getProperty() {
        return this.propertyPath.getProperty();
    }

    @Override
    public List<Association> getAssociations() {
        return this.propertyPath.getAssociations();
    }

    @Override
    public PersistentPropertyPath getPropertyPath() {
        return this.propertyPath;
    }

    public Bindable<T> getModel() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Path<?> getParentPath() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<Class<? extends T>> type() {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public <Y> io.micronaut.data.model.jpa.criteria.PersistentPropertyPath<Y> get(String attributeName) {
        throw new IllegalArgumentException("Property path doesn't support get operation: " + String.valueOf(this.propertyPath));
    }

    @Override
    public Class<? extends T> getJavaType() {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public void visitExpression(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        return "PersistentPropertyPath{" + String.valueOf(this.propertyPath) + "}";
    }
}

