/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.intercept.annotation;

import io.micronaut.context.annotation.Property;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.annotation.DataMethodQueryParameter;
import io.micronaut.data.model.DataType;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.ANNOTATION_TYPE})
@Internal
@Inherited
public @interface DataMethod {
    public static final String NAME = DataMethod.class.getName();
    public static final String META_MEMBER_PROCEDURE = "procedure";
    public static final String META_MEMBER_EXPANDABLE_QUERY = "expandableQuery";
    public static final String META_MEMBER_EXPANDABLE_COUNT_QUERY = "expandableCountQuery";
    public static final String META_MEMBER_COUNT_QUERY = "countQuery";
    public static final String META_MEMBER_RESULT_TYPE = "resultType";
    public static final String META_MEMBER_RESULT_DATA_TYPE = "resultDataType";
    public static final String META_MEMBER_ROOT_ENTITY = "rootEntity";
    public static final String META_MEMBER_INTERCEPTOR = "interceptor";
    @Deprecated(forRemoval=true)
    public static final String META_MEMBER_PARAMETER_BINDING = "parameterBinding";
    @Deprecated(forRemoval=true, since="4.10")
    public static final String META_MEMBER_ID_TYPE = "idType";
    @Deprecated(forRemoval=true, since="4.10")
    public static final String META_MEMBER_PAGE_SIZE = "pageSize";
    @Deprecated(forRemoval=true, since="4.10")
    public static final String META_MEMBER_PAGE_INDEX = "pageIndex";
    public static final String META_MEMBER_OFFSET = "offset";
    public static final String META_MEMBER_LIMIT = "limit";
    @Deprecated(forRemoval=true, since="4.10")
    public static final String META_MEMBER_ENTITY = "entity";
    @Deprecated(forRemoval=true, since="4.10")
    public static final String META_MEMBER_ID = "id";
    public static final String META_MEMBER_DTO = "dto";
    public static final String META_MEMBER_OPTIMISTIC_LOCK = "optimisticLock";
    public static final String META_MEMBER_QUERY_BUILDER = "queryBuilder";
    public static final String META_MEMBER_RAW_QUERY = "rawQuery";
    public static final String META_MEMBER_RAW_COUNT_QUERY = "rawCountQuery";
    @Deprecated(forRemoval=true)
    public static final String META_MEMBER_PARAMETER_TYPE_DEFS = "parameterTypeDefs";
    @Deprecated(forRemoval=true)
    public static final String META_MEMBER_PARAMETER_CONVERTERS = "parameterConverters";
    public static final String META_MEMBER_PARAMETERS = "parameters";
    public static final String META_MEMBER_OPERATION_TYPE = "opType";

    public Class<? extends DataInterceptor> interceptor();

    public Class<?> rootEntity() default void.class;

    public Class<?> resultType() default void.class;

    public DataType resultDataType() default DataType.OBJECT;

    @Deprecated(forRemoval=true)
    public Property[] parameterBinding() default {};

    @Deprecated(forRemoval=true, since="4.10")
    public String pageable() default "";

    @Deprecated(forRemoval=true, since="4.10")
    public String entity() default "";

    @Deprecated(forRemoval=true, since="4.10")
    public String id() default "";

    @Deprecated(forRemoval=true, since="4.10")
    public int pageSize() default -1;

    @Deprecated(forRemoval=true, since="4.10")
    public long pageIndex() default 0L;

    public DataMethodQueryParameter[] parameters() default {};

    public boolean procedure() default false;

    public static enum OperationType {
        QUERY,
        COUNT,
        EXISTS,
        UPDATE,
        UPDATE_RETURNING,
        DELETE,
        DELETE_RETURNING,
        INSERT,
        INSERT_RETURNING;

    }
}

