/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.expression;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import jakarta.persistence.criteria.Expression;

@Internal
public enum UnaryExpressionType {
    AVG,
    SUM,
    MAX,
    MIN,
    COUNT,
    COUNT_DISTINCT,
    UPPER,
    LOWER,
    LENGTH;


    void validate(Expression<?> expression) {
        switch (this) {
            case AVG: 
            case SUM: {
                CriteriaUtils.requireNumericExpression(expression);
                break;
            }
            case MAX: 
            case MIN: {
                CriteriaUtils.requireComparableExpression(expression);
                break;
            }
            case UPPER: 
            case LOWER: 
            case LENGTH: {
                CriteriaUtils.requireStringExpression(expression);
                break;
            }
            case COUNT: 
            case COUNT_DISTINCT: {
                CriteriaUtils.requirePropertyOrRoot(expression);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this));
            }
        }
    }
}

