/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.DataAnnotationUtils;
import io.micronaut.data.annotation.DataTransformer;
import io.micronaut.data.annotation.EntityRepresentation;
import io.micronaut.data.annotation.IgnoreWhere;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.Where;
import io.micronaut.data.annotation.repeatable.WhereSpecifications;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentEntityUtils;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.jpa.criteria.impl.expression.LiteralExpression;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.query.AssociationQuery;
import io.micronaut.data.model.query.BindingParameter;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.sql.Dialect;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

public abstract class AbstractSqlLikeQueryBuilder
implements QueryBuilder {
    public static final String ORDER_BY_CLAUSE = " ORDER BY ";
    protected static final String SELECT_CLAUSE = "SELECT ";
    protected static final String AS_CLAUSE = " AS ";
    protected static final String FROM_CLAUSE = " FROM ";
    protected static final String WHERE_CLAUSE = " WHERE ";
    protected static final char COMMA = ',';
    protected static final char CLOSE_BRACKET = ')';
    protected static final char OPEN_BRACKET = '(';
    protected static final char SPACE = ' ';
    protected static final char DOT = '.';
    protected static final String NOT = "NOT";
    protected static final String AND = "AND";
    protected static final String LOGICAL_AND = " AND ";
    protected static final String UPDATE_CLAUSE = "UPDATE ";
    protected static final String DELETE_CLAUSE = "DELETE ";
    protected static final String RETURNING = " RETURNING ";
    protected static final String OR = "OR";
    protected static final String LOGICAL_OR = " OR ";
    protected static final String FUNCTION_COUNT = "COUNT";
    protected static final String AVG = "AVG";
    protected static final String DISTINCT = "DISTINCT";
    protected static final String SUM = "SUM";
    protected static final String MIN = "MIN";
    protected static final String MAX = "MAX";
    protected static final String COUNT_DISTINCT = "COUNT(DISTINCT";
    protected static final String IS_NOT_NULL = " IS NOT NULL";
    protected static final String IS_EMPTY = " IS EMPTY";
    protected static final String IS_NOT_EMPTY = " IS NOT EMPTY";
    protected static final String IS_NULL = " IS NULL";
    protected static final String EQUALS_TRUE = " = TRUE";
    protected static final String EQUALS_FALSE = " = FALSE";
    protected static final String GREATER_THAN_OR_EQUALS = " >= ";
    protected static final String LESS_THAN_OR_EQUALS = " <= ";
    protected static final String LESS_THAN = " < ";
    protected static final String GREATER_THAN = " > ";
    protected static final String EQUALS = " = ";
    protected static final String NOT_EQUALS = " != ";
    protected static final String ALIAS_REPLACE_QUOTED = "@\\.";
    protected static final String JSON_COLUMN = "column";
    protected static final String CANNOT_QUERY_ON_ID_WITH_ENTITY_THAT_HAS_NO_ID = "Cannot query on ID with entity that has no ID";
    protected final Map<Class, CriterionHandler> queryHandlers = new HashMap<Class, CriterionHandler>(30);

    public AbstractSqlLikeQueryBuilder() {
        this.addCriterionHandler(AssociationQuery.class, this::handleAssociationCriteria);
        this.addCriterionHandler(QueryModel.Negation.class, (ctx, negation) -> {
            ctx.query().append(NOT).append('(');
            this.handleJunction(ctx, (QueryModel.Junction)negation);
            ctx.query().append(')');
        });
        this.addCriterionHandler(QueryModel.Conjunction.class, (ctx, conjunction) -> {
            ctx.query().append('(');
            this.handleJunction(ctx, (QueryModel.Junction)conjunction);
            ctx.query().append(')');
        });
        this.addCriterionHandler(QueryModel.Disjunction.class, (ctx, disjunction) -> {
            ctx.query().append('(');
            this.handleJunction(ctx, (QueryModel.Junction)disjunction);
            ctx.query().append(')');
        });
        this.addCriterionHandler(QueryModel.Equals.class, this.optionalCaseValueComparison(EQUALS));
        this.addCriterionHandler(QueryModel.NotEquals.class, this.optionalCaseValueComparison(NOT_EQUALS));
        this.addCriterionHandler(QueryModel.EqualsProperty.class, this.comparison("="));
        this.addCriterionHandler(QueryModel.NotEqualsProperty.class, this.comparison("!="));
        this.addCriterionHandler(QueryModel.GreaterThanProperty.class, this.comparison(">"));
        this.addCriterionHandler(QueryModel.GreaterThanEqualsProperty.class, this.comparison(">="));
        this.addCriterionHandler(QueryModel.LessThanProperty.class, this.comparison("<"));
        this.addCriterionHandler(QueryModel.LessThanEqualsProperty.class, this.comparison("<="));
        this.addCriterionHandler(QueryModel.IsNull.class, this.expression(IS_NULL));
        this.addCriterionHandler(QueryModel.IsTrue.class, this.expression(EQUALS_TRUE));
        this.addCriterionHandler(QueryModel.IsFalse.class, this.expression(EQUALS_FALSE));
        this.addCriterionHandler(QueryModel.IsNotNull.class, this.expression(IS_NOT_NULL));
        this.addCriterionHandler(QueryModel.IsEmpty.class, (ctx, isEmpty) -> this.appendEmptyExpression(ctx, " IS NULL OR ", " = ''", IS_EMPTY, isEmpty.getProperty()));
        this.addCriterionHandler(QueryModel.IsNotEmpty.class, (ctx, isNotEmpty) -> {
            if (this.getDialect() == Dialect.ORACLE) {
                QueryPropertyPath propertyPath = ctx.getRequiredProperty(isNotEmpty.getProperty(), QueryModel.IsEmpty.class);
                StringBuilder whereClause = ctx.query();
                if (propertyPath.getProperty().isAssignable(CharSequence.class)) {
                    this.appendPropertyRef(whereClause, ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), propertyPath);
                    whereClause.append(IS_NOT_NULL);
                } else {
                    this.appendPropertyRef(whereClause, ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), propertyPath);
                    whereClause.append(IS_NOT_EMPTY);
                }
            } else {
                this.appendEmptyExpression(ctx, " IS NOT NULL AND ", " <> ''", IS_NOT_EMPTY, isNotEmpty.getProperty());
            }
        });
        this.addCriterionHandler(QueryModel.IdEquals.class, (ctx, idEquals) -> {
            StringBuilder whereClause = ctx.query();
            PersistentEntity persistentEntity = ctx.getPersistentEntity();
            if (persistentEntity.hasCompositeIdentity()) {
                for (PersistentProperty prop : persistentEntity.getCompositeIdentity()) {
                    this.appendCriteriaForOperator(whereClause, ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), ctx, null, this.asQueryPropertyPath(ctx.getCurrentTableAlias(), prop), idEquals.getValue(), EQUALS);
                    whereClause.append(LOGICAL_AND);
                }
                whereClause.setLength(whereClause.length() - LOGICAL_AND.length());
            } else if (persistentEntity.hasIdentity()) {
                this.appendCriteriaForOperator(whereClause, ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), ctx, ctx.getRequiredProperty(persistentEntity.getIdentity().getName(), idEquals.getClass()), idEquals.getValue(), EQUALS);
            } else {
                throw new IllegalStateException("No ID found for entity: " + persistentEntity.getName());
            }
        });
        this.addCriterionHandler(QueryModel.VersionEquals.class, (ctx, criterion) -> {
            PersistentProperty prop = ctx.getPersistentEntity().getVersion();
            if (prop == null) {
                throw new IllegalStateException("No Version found for entity: " + ctx.getPersistentEntity().getName());
            }
            this.appendCriteriaForOperator(ctx.query(), ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), ctx, this.asQueryPropertyPath(ctx.getCurrentTableAlias(), prop), criterion.getValue(), EQUALS);
        });
        this.addCriterionHandler(QueryModel.GreaterThan.class, this.valueComparison(GREATER_THAN));
        this.addCriterionHandler(QueryModel.LessThanEquals.class, this.valueComparison(LESS_THAN_OR_EQUALS));
        this.addCriterionHandler(QueryModel.GreaterThanEquals.class, this.valueComparison(GREATER_THAN_OR_EQUALS));
        this.addCriterionHandler(QueryModel.LessThan.class, this.valueComparison(LESS_THAN));
        this.addCriterionHandler(QueryModel.Like.class, this.valueComparison(" LIKE "));
        this.addCriterionHandler(QueryModel.ILike.class, (context, criterion) -> {
            if (this.getDialect() == Dialect.POSTGRES) {
                this.valueComparison(" ILIKE ").handle(context, (QueryModel.ILike)criterion);
            } else {
                this.caseInsensitiveValueComparison(" LIKE ").handle(context, (QueryModel.ILike)criterion);
            }
        });
        this.addCriterionHandler(QueryModel.Between.class, (ctx, between) -> {
            QueryPropertyPath prop = ctx.getRequiredProperty((QueryModel.PropertyNameCriterion)between);
            StringBuilder whereClause = ctx.query();
            whereClause.append('(');
            this.appendPropertyRef(whereClause, ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), prop);
            whereClause.append(GREATER_THAN_OR_EQUALS);
            this.appendPlaceholderOrLiteral(ctx, prop, between.getFrom());
            whereClause.append(LOGICAL_AND);
            this.appendPropertyRef(whereClause, ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), prop);
            whereClause.append(LESS_THAN_OR_EQUALS);
            this.appendPlaceholderOrLiteral(ctx, prop, between.getTo());
            whereClause.append(')');
        });
        this.addCriterionHandler(QueryModel.StartsWith.class, this.likeConcatComparison("?", "'%'"));
        this.addCriterionHandler(QueryModel.Contains.class, this.likeConcatComparison("'%'", "?", "'%'"));
        this.addCriterionHandler(QueryModel.EndsWith.class, this.likeConcatComparison("'%'", "?"));
        this.addCriterionHandler(QueryModel.In.class, (ctx, inQuery) -> {
            QueryPropertyPath propertyPath = ctx.getRequiredProperty(inQuery.getProperty(), QueryModel.In.class);
            StringBuilder whereClause = ctx.query();
            this.appendPropertyRef(whereClause, ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), propertyPath);
            whereClause.append(" IN (");
            Object value = inQuery.getValue();
            if (value instanceof BindingParameter) {
                BindingParameter bindingParameter = (BindingParameter)value;
                ctx.pushParameter(bindingParameter, this.newBindingContext(propertyPath.propertyPath).expandable());
            } else {
                this.asLiterals(ctx.query(), value);
            }
            whereClause.append(')');
        });
        this.addCriterionHandler(QueryModel.NotIn.class, (ctx, inQuery) -> {
            QueryPropertyPath propertyPath = ctx.getRequiredProperty(inQuery.getProperty(), QueryModel.In.class);
            StringBuilder whereClause = ctx.query();
            this.appendPropertyRef(whereClause, ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), propertyPath);
            whereClause.append(" NOT IN (");
            Object value = inQuery.getValue();
            if (value instanceof BindingParameter) {
                BindingParameter bindingParameter = (BindingParameter)value;
                ctx.pushParameter(bindingParameter, this.newBindingContext(propertyPath.propertyPath).expandable());
            } else {
                this.asLiterals(ctx.query(), value);
            }
            whereClause.append(')');
        });
        this.addCriterionHandler(QueryModel.ArrayContains.class, (ctx, criterion) -> {
            throw new UnsupportedOperationException("ArrayContains is not supported by this implementation.");
        });
    }

    protected Dialect getDialect() {
        return Dialect.ANSI;
    }

    protected void asLiterals(StringBuilder sb, @Nullable Object value) {
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                sb.append(this.asLiteral(o));
                if (!iterator.hasNext()) continue;
                sb.append(",");
            }
        } else if (value instanceof Object[]) {
            Object[] objects = (Object[])value;
            for (int i = 0; i < objects.length; ++i) {
                Object o = objects[i];
                sb.append(this.asLiteral(o));
                if (i + 1 == objects.length) continue;
                sb.append(",");
            }
        } else {
            sb.append(this.asLiteral(value));
        }
    }

    @NonNull
    protected String asLiteral(@Nullable Object value) {
        if (value instanceof LiteralExpression) {
            LiteralExpression literalExpression = (LiteralExpression)value;
            value = literalExpression.getValue();
        }
        if (value == null) {
            return "NULL";
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Long.toString(number.longValue());
        }
        if (value instanceof Boolean) {
            return value.toString().toUpperCase(Locale.ROOT);
        }
        return "'" + value + "'";
    }

    private <T extends QueryModel.PropertyCriterion> CriterionHandler<T> likeConcatComparison(String ... parts) {
        return (ctx, propertyCriterion) -> {
            QueryPropertyPath propertyPath = ctx.getRequiredProperty((QueryModel.PropertyNameCriterion)propertyCriterion);
            boolean isPostgres = this.getDialect() == Dialect.POSTGRES;
            StringBuilder query = ctx.query();
            if (propertyCriterion.isIgnoreCase() && !isPostgres) {
                query.append("LOWER(");
                this.appendPropertyRef(query, ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), propertyPath);
                query.append(")");
            } else {
                this.appendPropertyRef(query, ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), propertyPath);
            }
            if (isPostgres) {
                query.append(" ILIKE ");
            } else {
                query.append(" LIKE ");
            }
            this.concat(query, Arrays.stream(parts).map(p -> {
                if ("?".equals(p)) {
                    if (propertyCriterion.isIgnoreCase() && !isPostgres) {
                        return () -> {
                            query.append("LOWER(");
                            this.appendPlaceholderOrLiteral(ctx, propertyPath, propertyCriterion.getValue());
                            query.append(")");
                        };
                    }
                    return () -> this.appendPlaceholderOrLiteral(ctx, propertyPath, propertyCriterion.getValue());
                }
                return () -> query.append((String)p);
            }).toList());
        };
    }

    private <T extends QueryModel.PropertyCriterion> CriterionHandler<T> valueComparison(String op) {
        return (ctx, propertyCriterion) -> {
            QueryPropertyPath prop = ctx.getRequiredProperty((QueryModel.PropertyNameCriterion)propertyCriterion);
            this.appendCriteriaForOperator(ctx.query(), ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), ctx, prop, propertyCriterion.getValue(), op);
        };
    }

    private <T extends QueryModel.PropertyCriterion> CriterionHandler<T> optionalCaseValueComparison(String op) {
        return (ctx, propertyCriterion) -> {
            if (propertyCriterion.isIgnoreCase()) {
                this.appendCaseInsensitiveCriterion(ctx, (QueryModel.PropertyCriterion)propertyCriterion, op);
            } else {
                this.valueComparison(op).handle(ctx, (QueryModel.PropertyCriterion)propertyCriterion);
            }
        };
    }

    private <T extends QueryModel.PropertyCriterion> CriterionHandler<T> caseInsensitiveValueComparison(String op) {
        return (ctx, propertyCriterion) -> this.appendCaseInsensitiveCriterion(ctx, (QueryModel.PropertyCriterion)propertyCriterion, op);
    }

    private <T extends QueryModel.PropertyComparisonCriterion> CriterionHandler<T> comparison(String operator) {
        return (ctx, comparisonCriterion) -> this.appendPropertyComparison(ctx, (QueryModel.PropertyComparisonCriterion)comparisonCriterion, operator);
    }

    private <T extends QueryModel.PropertyNameCriterion> CriterionHandler<T> expression(String expression) {
        return (ctx, expressionCriterion) -> {
            this.appendPropertyRef(ctx.query(), ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), ctx.getRequiredProperty((QueryModel.PropertyNameCriterion)expressionCriterion));
            ctx.query().append(expression);
        };
    }

    protected final QueryPropertyPath asQueryPropertyPath(String tableAlias, PersistentProperty persistentProperty) {
        return new QueryPropertyPath(this.asPersistentPropertyPath(persistentProperty), tableAlias);
    }

    private PersistentPropertyPath asPersistentPropertyPath(PersistentProperty persistentProperty) {
        return PersistentPropertyPath.of(Collections.emptyList(), persistentProperty, persistentProperty.getName());
    }

    protected void concat(StringBuilder writer, Collection<Runnable> partsWriters) {
        writer.append("CONCAT(");
        Iterator<Runnable> iterator = partsWriters.iterator();
        while (iterator.hasNext()) {
            Runnable partWriter = iterator.next();
            partWriter.run();
            if (!iterator.hasNext()) continue;
            writer.append(",");
        }
        writer.append(")");
    }

    private void appendEmptyExpression(CriteriaContext ctx, String charSequencePrefix, String charSequenceSuffix, String listSuffix, String name) {
        QueryPropertyPath propertyPath = ctx.getRequiredProperty(name, QueryModel.IsEmpty.class);
        StringBuilder whereClause = ctx.query();
        if (propertyPath.getProperty().isAssignable(CharSequence.class)) {
            this.appendPropertyRef(whereClause, ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), propertyPath);
            whereClause.append(charSequencePrefix);
            this.appendPropertyRef(whereClause, ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), propertyPath);
            whereClause.append(charSequenceSuffix);
        } else {
            this.appendPropertyRef(whereClause, ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), propertyPath);
            whereClause.append(listSuffix);
        }
    }

    @Override
    public QueryResult buildQuery(@NonNull AnnotationMetadata annotationMetadata, @NonNull QueryModel query) {
        ArgumentUtils.requireNonNull((String)"annotationMetadata", (Object)annotationMetadata);
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        QueryState queryState = this.newQueryState(query, true, true);
        ArrayList<JoinPath> joinPaths = new ArrayList<JoinPath>(query.getJoinPaths());
        joinPaths.sort((o1, o2) -> Comparator.comparingInt(String::length).thenComparing(String::compareTo).compare(o1.getPath(), o2.getPath()));
        for (JoinPath joinPath : joinPaths) {
            queryState.applyJoin(joinPath);
        }
        StringBuilder select = new StringBuilder(SELECT_CLAUSE);
        this.buildSelectClause(annotationMetadata, query, queryState, select);
        this.appendForUpdate(QueryPosition.AFTER_TABLE_NAME, query, select);
        queryState.getQuery().insert(0, select);
        QueryModel.Junction criteria = query.getCriteria();
        if (!criteria.isEmpty() || annotationMetadata.hasStereotype(WhereSpecifications.class) || queryState.getEntity().getAnnotationMetadata().hasStereotype(WhereSpecifications.class)) {
            this.buildWhereClause(annotationMetadata, criteria, queryState);
        }
        this.appendOrder(annotationMetadata, query, queryState);
        this.appendForUpdate(QueryPosition.END_OF_QUERY, query, queryState.getQuery());
        return QueryResult.of(queryState.getFinalQuery(), queryState.getQueryParts(), queryState.getParameterBindings(), queryState.getAdditionalRequiredParameters(), query.getMax(), query.getOffset(), queryState.getJoinPaths());
    }

    protected abstract String getTableName(PersistentEntity var1);

    protected String getUnescapedTableName(PersistentEntity entity) {
        return entity.getPersistedName();
    }

    protected String getAliasName(PersistentEntity entity) {
        return entity.getAnnotationMetadata().stringValue(MappedEntity.class, "alias").orElseGet(() -> this.getTableName(entity) + "_");
    }

    public String getAliasName(JoinPath joinPath) {
        return joinPath.getAlias().orElseGet(() -> {
            String joinPathAlias = this.getPathOnlyAliasName(joinPath);
            if (joinPath.getAssociationPath()[0].hasDeclaredAliasName()) {
                return joinPathAlias;
            }
            PersistentEntity owner = joinPath.getAssociationPath()[0].getOwner();
            String ownerAlias = this.getAliasName(owner);
            if (ownerAlias.endsWith("_") && joinPathAlias.startsWith("_")) {
                return ownerAlias + joinPathAlias.substring(1);
            }
            return ownerAlias + joinPathAlias;
        });
    }

    @NonNull
    protected String getPathOnlyAliasName(JoinPath joinPath) {
        return joinPath.getAlias().orElseGet(() -> {
            StringBuilder p = new StringBuilder();
            for (Association ass : joinPath.getAssociationPath()) {
                p.append(ass.getAliasName());
                if (!ass.hasDeclaredAliasName() || ass == joinPath.getAssociation()) continue;
                p.append('_');
            }
            return p.toString();
        });
    }

    protected abstract String[] buildJoin(String var1, JoinPath var2, String var3, StringBuilder var4, Map<String, String> var5, QueryState var6);

    protected abstract String getColumnName(PersistentProperty var1);

    protected abstract void selectAllColumns(AnnotationMetadata var1, QueryState var2, StringBuilder var3);

    protected void selectAllColumns(PersistentEntity entity, String alias, StringBuilder queryBuffer) {
        this.selectAllColumns(AnnotationMetadata.EMPTY_METADATA, entity, alias, queryBuffer);
    }

    protected abstract void selectAllColumns(AnnotationMetadata var1, PersistentEntity var2, String var3, StringBuilder var4);

    @Internal
    protected void selectAllColumnsFromJoinPaths(QueryState queryState, StringBuilder queryBuffer, Collection<JoinPath> allPaths, @Nullable Map<JoinPath, String> joinAliasOverride) {
    }

    protected final void appendProperty(StringBuilder sb, List<Association> associations, PersistentProperty property, NamingStrategy namingStrategy, String tableAlias, boolean escape) {
        String transformed = this.getDataTransformerReadValue(tableAlias, property).orElse(null);
        String columnAlias = this.getColumnAlias(property);
        boolean useAlias = StringUtils.isNotEmpty((CharSequence)columnAlias);
        if (transformed != null) {
            sb.append(transformed).append(AS_CLAUSE).append(useAlias ? columnAlias : property.getPersistedName());
        } else {
            String column = this.getMappedName(namingStrategy, associations, property);
            column = this.escapeColumnIfNeeded(column, escape);
            if (tableAlias == null) {
                sb.append(column);
            } else {
                sb.append(tableAlias).append('.').append(column);
            }
            if (useAlias) {
                sb.append(AS_CLAUSE).append(columnAlias);
            }
        }
        sb.append(',');
    }

    private String escapeColumnIfNeeded(String column, boolean escape) {
        if (escape) {
            return this.quote(column);
        }
        return column;
    }

    private QueryState newQueryState(@NonNull QueryModel query, boolean allowJoins, boolean useAlias) {
        return new QueryState(query, allowJoins, useAlias);
    }

    private void buildSelectClause(AnnotationMetadata annotationMetadata, QueryModel query, QueryState queryState, StringBuilder queryString) {
        String logicalName = queryState.getRootAlias();
        PersistentEntity entity = queryState.getEntity();
        this.buildSelect(annotationMetadata, queryState, queryString, query.getProjections(), logicalName, entity);
        String tableName = this.getTableName(entity);
        queryString.append(FROM_CLAUSE).append(tableName).append(this.getTableAsKeyword()).append(logicalName);
    }

    protected boolean shouldEscape(@NonNull PersistentEntity entity) {
        return entity.getAnnotationMetadata().booleanValue(MappedEntity.class, "escape").orElse(true);
    }

    protected String getTableAsKeyword() {
        return AS_CLAUSE;
    }

    protected String quote(String persistedName) {
        return this.quote(persistedName, false);
    }

    protected String quote(String persistedName, boolean supportsDynamicValues) {
        return "\"" + persistedName + "\"";
    }

    /*
     * Unable to fully structure code
     */
    protected void buildSelect(AnnotationMetadata annotationMetadata, QueryState queryState, StringBuilder queryString, List<QueryModel.Projection> projectionList, String tableAlias, PersistentEntity entity) {
        block16: {
            block15: {
                if (!projectionList.isEmpty()) break block15;
                this.selectAllColumns(annotationMetadata, queryState, queryString);
                break block16;
            }
            projectionCount = projectionList.size();
            i = projectionList.iterator();
            while (i.hasNext()) {
                block18: {
                    block30: {
                        block29: {
                            block28: {
                                block27: {
                                    block26: {
                                        block25: {
                                            block22: {
                                                block24: {
                                                    block23: {
                                                        block21: {
                                                            block20: {
                                                                block19: {
                                                                    block17: {
                                                                        appendComma = true;
                                                                        removeComma = false;
                                                                        projection = i.next();
                                                                        if (projection instanceof QueryModel.RootEntityProjection) {
                                                                            this.selectAllColumns(annotationMetadata, queryState, queryString);
                                                                            return;
                                                                        }
                                                                        if (!(projection instanceof QueryModel.LiteralProjection)) break block17;
                                                                        literalProjection = (QueryModel.LiteralProjection)projection;
                                                                        queryString.append(this.asLiteral(literalProjection.getValue()));
                                                                        break block18;
                                                                    }
                                                                    if (!(projection instanceof QueryModel.CountProjection)) break block19;
                                                                    this.appendProjectionRowCount(queryString, tableAlias);
                                                                    break block18;
                                                                }
                                                                if (!(projection instanceof QueryModel.DistinctProjection)) break block20;
                                                                queryString.append("DISTINCT ");
                                                                if (projectionCount == 1) {
                                                                    queryString.append(tableAlias).append('.').append("*");
                                                                }
                                                                appendComma = false;
                                                                break block18;
                                                            }
                                                            if (!(projection instanceof QueryModel.CountDistinctRootProjection)) break block21;
                                                            this.appendProjectionRowCountDistinct(queryString, queryState, entity, annotationMetadata, tableAlias);
                                                            break block18;
                                                        }
                                                        if (!(projection instanceof QueryModel.IdProjection)) break block22;
                                                        if (!entity.hasCompositeIdentity()) break block23;
                                                        for (PersistentProperty identity : entity.getCompositeIdentity()) {
                                                            this.appendPropertyProjection(annotationMetadata, entity, queryString, this.asQueryPropertyPath(queryState.getRootAlias(), identity), null);
                                                            queryString.append(',');
                                                        }
                                                        queryString.setLength(queryString.length() - 1);
                                                        break block18;
                                                    }
                                                    if (!entity.hasIdentity()) break block24;
                                                    identityProperties = entity.getIdentityProperties();
                                                    if (identityProperties.isEmpty()) {
                                                        throw new IllegalArgumentException("Cannot query on ID with entity that has no ID");
                                                    }
                                                    for (PersistentProperty identity : identityProperties) {
                                                        this.appendPropertyProjection(annotationMetadata, queryState.getEntity(), queryString, this.asQueryPropertyPath(queryState.getRootAlias(), identity), null);
                                                    }
                                                    break block18;
                                                }
                                                throw new IllegalArgumentException("Cannot query on ID with entity that has no ID");
                                            }
                                            if (!(projection instanceof QueryModel.PropertyProjection)) break block18;
                                            pp = (QueryModel.PropertyProjection)projection;
                                            alias = pp.getAlias().orElse(null);
                                            if (!(projection instanceof QueryModel.AvgProjection)) break block25;
                                            this.appendFunctionProjection(annotationMetadata, queryState.getEntity(), "AVG", pp, tableAlias, alias, queryString);
                                            break block18;
                                        }
                                        if (!(projection instanceof QueryModel.SumProjection)) break block26;
                                        this.appendFunctionProjection(annotationMetadata, queryState.getEntity(), "SUM", pp, tableAlias, alias, queryString);
                                        break block18;
                                    }
                                    if (!(projection instanceof QueryModel.MinProjection)) break block27;
                                    this.appendFunctionProjection(annotationMetadata, queryState.getEntity(), "MIN", pp, tableAlias, alias, queryString);
                                    break block18;
                                }
                                if (!(projection instanceof QueryModel.MaxProjection)) break block28;
                                this.appendFunctionProjection(annotationMetadata, queryState.getEntity(), "MAX", pp, tableAlias, alias, queryString);
                                break block18;
                            }
                            if (!(projection instanceof QueryModel.CountDistinctProjection)) break block29;
                            this.appendFunctionProjection(annotationMetadata, queryState.getEntity(), "COUNT(DISTINCT", pp, tableAlias, alias, queryString);
                            queryString.append(')');
                            break block18;
                        }
                        propertyName = pp.getPropertyName();
                        propertyPath = entity.getPropertyPath(propertyName);
                        if (propertyPath == null) {
                            throw new IllegalArgumentException("Cannot project on non-existent property: " + propertyName);
                        }
                        property = propertyPath.getProperty();
                        if (!pp.isCompound()) break block30;
                        if (!(property instanceof Association)) ** GOTO lbl-1000
                        association = (Association)property;
                        if (!(property instanceof Embedded)) {
                            if (queryState.isJoined(propertyPath.getPath())) {
                                this.appendCompoundAssociationProjection(queryState, queryString, association, propertyPath, alias);
                            } else {
                                removeComma = true;
                            }
                        } else lbl-1000:
                        // 2 sources

                        {
                            this.appendCompoundPropertyProjection(queryState, queryString, property, propertyPath, alias);
                        }
                        break block18;
                    }
                    if (property instanceof Association && !(property instanceof Embedded)) {
                        if (!this.appendAssociationProjection(queryState, queryString, property, propertyPath, alias)) {
                            continue;
                        }
                    } else {
                        this.appendPropertyProjection(annotationMetadata, queryState.getEntity(), queryString, this.findProperty(queryState, propertyName, null), alias);
                    }
                }
                if (removeComma) {
                    queryString.setLength(queryString.length() - 1);
                }
                if (!appendComma || !i.hasNext()) continue;
                queryString.append(',');
            }
        }
    }

    @Internal
    protected void appendCompoundPropertyProjection(QueryState queryState, StringBuilder queryString, PersistentProperty property, PersistentPropertyPath propertyPath, String columnAlias) {
        PersistentEntity entity = property.getOwner();
        boolean escape = this.shouldEscape(entity);
        NamingStrategy namingStrategy = this.getNamingStrategy(entity);
        int[] propertiesCount = new int[1];
        this.traversePersistentProperties(propertyPath.getAssociations(), property, (List<Association> associations, PersistentProperty p) -> {
            this.appendProperty(queryString, (List<Association>)associations, (PersistentProperty)p, namingStrategy, queryState.rootAlias, escape);
            propertiesCount[0] = propertiesCount[0] + 1;
        });
        queryString.setLength(queryString.length() - 1);
        if (StringUtils.isNotEmpty((CharSequence)columnAlias)) {
            if (propertiesCount[0] > 1) {
                throw new IllegalStateException("Cannot apply a column alias: " + columnAlias + " with expanded property: " + propertyPath);
            }
            if (propertiesCount[0] == 1) {
                queryString.append(AS_CLAUSE).append(columnAlias);
            }
        }
    }

    @Internal
    protected void appendCompoundAssociationProjection(QueryState queryState, StringBuilder queryString, Association association, PersistentPropertyPath propertyPath, String columnAlias) {
        if (!queryString.isEmpty() && queryString.charAt(queryString.length() - 1) == ',') {
            queryString.setLength(queryString.length() - 1);
        }
        this.selectAllColumnsFromJoinPaths(queryState, queryString, queryState.getQueryModel().getJoinPaths(), null);
    }

    protected final void appendPropertyProjection(AnnotationMetadata annotationMetadata, PersistentEntity entity, StringBuilder sb, QueryPropertyPath propertyPath, String columnAlias) {
        boolean jsonEntity = this.isJsonEntity(annotationMetadata, entity);
        if (!this.computePropertyPaths() || jsonEntity) {
            sb.append(propertyPath.getTableAlias()).append('.');
            String jsonEntityColumn = null;
            if (jsonEntity) {
                jsonEntityColumn = this.getJsonEntityColumn(annotationMetadata);
                if (jsonEntityColumn != null) {
                    this.checkDialectSupportsJsonEntity(entity);
                }
                sb.append(jsonEntityColumn).append('.');
            }
            sb.append(propertyPath.getPath());
            if (jsonEntityColumn != null) {
                this.appendJsonProjection(sb, propertyPath.getProperty().getDataType());
            }
            return;
        }
        String tableAlias = propertyPath.getTableAlias();
        boolean escape = propertyPath.shouldEscape();
        NamingStrategy namingStrategy = propertyPath.getNamingStrategy();
        boolean[] needsTrimming = new boolean[]{false};
        int[] propertiesCount = new int[1];
        this.traversePersistentProperties(propertyPath.getAssociations(), propertyPath.getProperty(), (List<Association> associations, PersistentProperty property) -> {
            this.appendProperty(sb, (List<Association>)associations, (PersistentProperty)property, namingStrategy, tableAlias, escape);
            needsTrimming[0] = true;
            propertiesCount[0] = propertiesCount[0] + 1;
        });
        if (needsTrimming[0]) {
            sb.setLength(sb.length() - 1);
        }
        if (StringUtils.isNotEmpty((CharSequence)columnAlias)) {
            if (propertiesCount[0] > 1) {
                throw new IllegalStateException("Cannot apply a column alias: " + columnAlias + " with expanded property: " + propertyPath);
            }
            if (propertiesCount[0] == 1) {
                sb.append(AS_CLAUSE).append(columnAlias);
            }
        }
    }

    protected boolean appendAssociationProjection(QueryState queryState, StringBuilder queryString, PersistentProperty property, PersistentPropertyPath propertyPath, String columnAlias) {
        String joinedPath = propertyPath.getPath();
        if (!queryState.isJoined(joinedPath)) {
            queryString.setLength(queryString.length() - 1);
            return false;
        }
        String joinAlias = queryState.computeAlias(propertyPath.getPath());
        this.selectAllColumns(((Association)property).getAssociatedEntity(), joinAlias, queryString);
        Collection<JoinPath> joinPaths = queryState.getQueryModel().getJoinPaths();
        ArrayList<JoinPath> newJoinPaths = new ArrayList<JoinPath>(joinPaths.size());
        HashMap<JoinPath, String> joinAliasOverride = new HashMap<JoinPath, String>();
        HashMap<JoinPath, String> columnAliasOverride = new HashMap<JoinPath, String>();
        for (JoinPath joinPath : joinPaths) {
            if (!joinPath.getPath().startsWith(joinedPath) || joinPath.getPath().equals(joinedPath)) continue;
            int removedItems = 1;
            for (int k = 0; k < joinedPath.length(); ++k) {
                if (joinedPath.charAt(k) != '.') continue;
                ++removedItems;
            }
            JoinPath newJoinPath = new JoinPath(joinPath.getPath().substring(joinedPath.length() + 1), Arrays.copyOfRange(joinPath.getAssociationPath(), removedItems, joinPath.getAssociationPath().length), joinPath.getJoinType(), joinPath.getAlias().orElse(null));
            newJoinPaths.add(newJoinPath);
            joinAliasOverride.put(newJoinPath, this.getAliasName(joinPath));
            columnAliasOverride.put(newJoinPath, this.getPathOnlyAliasName(joinPath));
        }
        queryState.setJoinPaths(newJoinPaths);
        this.selectAllColumnsFromJoinPaths(queryState, queryString, newJoinPaths, joinAliasOverride);
        return true;
    }

    protected NamingStrategy getNamingStrategy(PersistentPropertyPath propertyPath) {
        return propertyPath.getNamingStrategy();
    }

    protected NamingStrategy getNamingStrategy(PersistentEntity entity) {
        return entity.getNamingStrategy();
    }

    @NonNull
    protected String getMappedName(@NonNull NamingStrategy namingStrategy, @NonNull PersistentProperty property) {
        return namingStrategy.mappedName(property);
    }

    @NonNull
    protected String getMappedName(@NonNull NamingStrategy namingStrategy, @NonNull Association association) {
        return namingStrategy.mappedName(association);
    }

    @NonNull
    protected String getMappedName(@NonNull NamingStrategy namingStrategy, @NonNull List<Association> associations, @NonNull PersistentProperty property) {
        return namingStrategy.mappedName(associations, property);
    }

    private void appendFunctionProjection(AnnotationMetadata annotationMetadata, PersistentEntity entity, String functionName, QueryModel.PropertyProjection propertyProjection, String tableAlias, String columnAlias, StringBuilder queryString) {
        String columnName;
        PersistentPropertyPath propertyPath = entity.getPropertyPath(propertyProjection.getPropertyName());
        if (propertyPath == null) {
            throw new IllegalArgumentException("Cannot project on non-existent property: " + propertyProjection.getPropertyName());
        }
        boolean jsonEntity = this.isJsonEntity(annotationMetadata, entity);
        if (this.computePropertyPaths() && !jsonEntity) {
            columnName = this.getMappedName(this.getNamingStrategy(entity), propertyPath.getAssociations(), propertyPath.getProperty());
            if (this.shouldEscape(entity)) {
                columnName = this.quote(columnName);
            }
        } else {
            columnName = propertyPath.getPath();
        }
        String jsonEntityColumn = this.getJsonEntityColumn(annotationMetadata);
        queryString.append(functionName).append('(').append(tableAlias).append('.');
        if (jsonEntityColumn != null) {
            queryString.append(jsonEntityColumn).append('.');
        }
        queryString.append(columnName);
        if (jsonEntityColumn != null) {
            DataType dataType = propertyPath.getProperty().getDataType();
            this.appendJsonProjection(queryString, dataType);
        }
        queryString.append(')');
        if (columnAlias != null) {
            queryString.append(AS_CLAUSE).append(columnAlias);
        }
    }

    private void appendJsonProjection(StringBuilder sb, DataType dataType) {
        if (dataType == DataType.STRING) {
            sb.append(".string()");
        } else if (dataType.isNumeric() || dataType == DataType.BOOLEAN) {
            sb.append(".number()");
        } else if (dataType == DataType.TIMESTAMP) {
            sb.append(".timestamp()");
        } else if (dataType == DataType.DATE) {
            sb.append(".date()");
        }
    }

    protected abstract void appendProjectionRowCount(StringBuilder var1, String var2);

    protected abstract void appendProjectionRowCountDistinct(StringBuilder var1, QueryState var2, PersistentEntity var3, AnnotationMetadata var4, String var5);

    private void handleAssociationCriteria(final CriteriaContext ctx, AssociationQuery associationQuery) {
        final QueryState queryState = ctx.getQueryState();
        Association association = associationQuery.getAssociation();
        if (association == null) {
            return;
        }
        final String associationPath = associationQuery.getPath();
        CriteriaContext associatedContext = new CriteriaContext(){

            @Override
            public String getCurrentTableAlias() {
                return ctx.getCurrentTableAlias();
            }

            @Override
            public QueryState getQueryState() {
                return ctx.getQueryState();
            }

            @Override
            public PersistentEntity getPersistentEntity() {
                return ctx.getPersistentEntity();
            }

            @Override
            public QueryPropertyPath getRequiredProperty(String name, Class<?> criterionClazz) {
                if (StringUtils.isNotEmpty((CharSequence)associationPath)) {
                    name = associationPath + "." + (String)name;
                }
                return AbstractSqlLikeQueryBuilder.this.findPropertyInternal(queryState, this.getPersistentEntity(), this.getCurrentTableAlias(), (String)name, criterionClazz);
            }

            @Override
            public AnnotationMetadata getAnnotationMetadata() {
                return ctx.getAnnotationMetadata();
            }
        };
        this.handleJunction(associatedContext, associationQuery.getCriteria());
    }

    protected void buildWhereClause(final AnnotationMetadata annotationMetadata, QueryModel.Junction criteria, final QueryState queryState) {
        StringBuilder queryClause = queryState.getQuery();
        if (!criteria.isEmpty()) {
            queryClause.append(WHERE_CLAUSE);
            if (criteria instanceof QueryModel.Negation) {
                queryClause.append(NOT);
            }
            CriteriaContext ctx = new CriteriaContext(){

                @Override
                public String getCurrentTableAlias() {
                    return queryState.getRootAlias();
                }

                @Override
                public QueryState getQueryState() {
                    return queryState;
                }

                @Override
                public PersistentEntity getPersistentEntity() {
                    return queryState.getEntity();
                }

                @Override
                public QueryPropertyPath getRequiredProperty(String name, Class<?> criterionClazz) {
                    return AbstractSqlLikeQueryBuilder.this.findProperty(queryState, name, criterionClazz);
                }

                @Override
                public AnnotationMetadata getAnnotationMetadata() {
                    return annotationMetadata;
                }
            };
            queryClause.append('(');
            this.handleJunction(ctx, criteria);
            String additionalWhere = this.buildAdditionalWhereClause(queryState, annotationMetadata);
            this.appendAdditionalWhere(queryClause, queryState, additionalWhere);
        } else {
            String additionalWhere = this.buildAdditionalWhereClause(queryState, annotationMetadata);
            if (StringUtils.isNotEmpty((CharSequence)additionalWhere)) {
                queryClause.append(WHERE_CLAUSE).append('(');
                this.appendAdditionalWhere(queryClause, queryState, additionalWhere);
            }
        }
    }

    protected String buildAdditionalWhereClause(QueryState queryState, AnnotationMetadata annotationMetadata) {
        return this.buildAdditionalWhereString(queryState.getRootAlias(), queryState.getEntity(), annotationMetadata);
    }

    private void appendAdditionalWhere(StringBuilder queryClause, QueryState queryState, String additionalWhere) {
        String queryStr = queryClause.toString();
        if (StringUtils.isNotEmpty((CharSequence)additionalWhere)) {
            StringBuffer additionalWhereBuilder = new StringBuffer();
            Matcher matcher = QueryBuilder.VARIABLE_PATTERN.matcher(additionalWhere);
            while (matcher.find()) {
                String name = matcher.group(3);
                String placeholder = queryState.addAdditionalRequiredParameter(name);
                matcher.appendReplacement(additionalWhereBuilder, Matcher.quoteReplacement(placeholder));
            }
            matcher.appendTail(additionalWhereBuilder);
            additionalWhere = additionalWhereBuilder.toString();
        }
        if (queryStr.endsWith(" WHERE (")) {
            if (StringUtils.isNotEmpty((CharSequence)additionalWhere)) {
                queryClause.append(additionalWhere).append(')');
            }
        } else {
            if (StringUtils.isNotEmpty((CharSequence)additionalWhere)) {
                queryClause.append(LOGICAL_AND).append('(').append(additionalWhere).append(')');
            }
            queryClause.append(')');
        }
    }

    protected String buildAdditionalWhereString(String alias, PersistentEntity entity, AnnotationMetadata annotationMetadata) {
        if (annotationMetadata.hasAnnotation(IgnoreWhere.class)) {
            return "";
        }
        String whereStr = this.resolveWhereForAnnotationMetadata(alias, annotationMetadata);
        if (StringUtils.isNotEmpty((CharSequence)whereStr)) {
            return whereStr;
        }
        return this.resolveWhereForAnnotationMetadata(alias, entity.getAnnotationMetadata());
    }

    protected final String buildAdditionalWhereString(JoinPath joinPath, AnnotationMetadata annotationMetadata) {
        if (annotationMetadata.hasAnnotation(IgnoreWhere.class)) {
            return "";
        }
        Association association = joinPath.getAssociation();
        if (association == null) {
            return "";
        }
        String alias = this.getAliasName(joinPath);
        return this.resolveWhereForAnnotationMetadata(alias, association.getAssociatedEntity().getAnnotationMetadata());
    }

    protected final String resolveWhereForAnnotationMetadata(String alias, AnnotationMetadata annotationMetadata) {
        return annotationMetadata.getAnnotationValuesByType(Where.class).stream().map(av -> av.stringValue().orElse(null)).map(val -> this.replaceAlias(alias, (String)val)).filter(StringUtils::isNotEmpty).collect(Collectors.joining(LOGICAL_AND));
    }

    protected void appendOrder(AnnotationMetadata annotationMetadata, QueryModel query, QueryState queryState) {
        List<Sort.Order> orders = query.getSort().getOrderBy();
        if (!orders.isEmpty()) {
            StringBuilder buff = queryState.getQuery();
            buff.append(ORDER_BY_CLAUSE);
            Iterator<Sort.Order> i = orders.iterator();
            String jsonEntityColumn = this.getJsonEntityColumn(annotationMetadata);
            while (i.hasNext()) {
                Sort.Order order = i.next();
                QueryPropertyPath propertyPath = this.findProperty(queryState, order.getProperty(), Sort.Order.class);
                String currentAlias = propertyPath.getTableAlias();
                if (currentAlias != null) {
                    buff.append(currentAlias).append('.');
                }
                if (jsonEntityColumn != null) {
                    buff.append(jsonEntityColumn).append('.');
                }
                if (this.computePropertyPaths() && jsonEntityColumn == null) {
                    buff.append(propertyPath.getColumnName()).append(' ').append(order.getDirection().toString());
                } else {
                    buff.append(propertyPath.getPath()).append(' ').append(order.getDirection().toString());
                }
                if (!i.hasNext()) continue;
                buff.append(",");
            }
        }
    }

    protected void appendForUpdate(QueryPosition queryPosition, QueryModel query, StringBuilder queryBuilder) {
        if (query.isForUpdate() && !this.supportsForUpdate()) {
            throw new IllegalStateException("For update not supported for current query builder: " + this.getClass().getSimpleName());
        }
    }

    private void handleJunction(CriteriaContext ctx, QueryModel.Junction criteria) {
        StringBuilder whereClause = ctx.query();
        String operator = criteria instanceof QueryModel.Conjunction ? LOGICAL_AND : LOGICAL_OR;
        Iterator<QueryModel.Criterion> iterator = criteria.getCriteria().iterator();
        while (iterator.hasNext()) {
            QueryModel.Criterion criterion = iterator.next();
            CriterionHandler criterionHandler = this.queryHandlers.get(criterion.getClass());
            if (criterionHandler == null) {
                throw new IllegalArgumentException("Queries of type " + criterion.getClass().getSimpleName() + " are not supported by this implementation");
            }
            criterionHandler.handle(ctx, criterion);
            if (!iterator.hasNext()) continue;
            whereClause.append(operator);
        }
    }

    private void appendCriteriaForOperator(StringBuilder whereClause, AnnotationMetadata annotationMetadata, PersistentEntity persistentEntity, PropertyParameterCreator propertyParameterCreator, QueryPropertyPath propertyPath, Object value, String operator) {
        this.appendCriteriaForOperator(whereClause, annotationMetadata, persistentEntity, propertyParameterCreator, propertyPath.propertyPath, propertyPath, value, operator);
    }

    private void appendCriteriaForOperator(StringBuilder whereClause, AnnotationMetadata annotationMetadata, PersistentEntity persistentEntity, PropertyParameterCreator propertyParameterCreator, PersistentPropertyPath parameterPropertyPath, QueryPropertyPath propertyPath, Object value, String operator) {
        if (value instanceof BindingParameter) {
            BindingParameter bindingParameter = (BindingParameter)value;
            boolean computePropertyPaths = this.computePropertyPaths();
            boolean jsonEntity = this.isJsonEntity(annotationMetadata, persistentEntity);
            if (!computePropertyPaths || jsonEntity) {
                this.appendPropertyRef(whereClause, annotationMetadata, persistentEntity, propertyPath);
                whereClause.append(operator);
                propertyParameterCreator.pushParameter(bindingParameter, this.newBindingContext(parameterPropertyPath, propertyPath.propertyPath));
                return;
            }
            String currentAlias = propertyPath.getTableAlias();
            NamingStrategy namingStrategy = propertyPath.getNamingStrategy();
            boolean shouldEscape = propertyPath.shouldEscape();
            boolean[] needsTrimming = new boolean[]{false};
            this.traversePersistentPropertiesForCriteria(propertyPath.getAssociations(), propertyPath.getProperty(), (associations, property) -> {
                if (currentAlias != null) {
                    whereClause.append(currentAlias).append('.');
                }
                String columnName = this.getMappedName(namingStrategy, (List<Association>)associations, (PersistentProperty)property);
                if (shouldEscape) {
                    columnName = this.quote(columnName);
                }
                whereClause.append(columnName);
                whereClause.append(operator);
                String writeTransformer = this.getDataTransformerWriteValue(currentAlias, (PersistentProperty)property).orElse(null);
                Runnable pushParameter = () -> propertyParameterCreator.pushParameter(bindingParameter, this.newBindingContext(parameterPropertyPath, PersistentPropertyPath.of(associations, property)));
                if (writeTransformer != null) {
                    this.appendTransformed(whereClause, writeTransformer, pushParameter);
                } else {
                    pushParameter.run();
                }
                whereClause.append(LOGICAL_AND);
                needsTrimming[0] = true;
            });
            if (needsTrimming[0]) {
                whereClause.setLength(whereClause.length() - LOGICAL_AND.length());
            }
        } else {
            this.appendPropertyRef(whereClause, annotationMetadata, persistentEntity, propertyPath);
            whereClause.append(operator).append(this.asLiteral(value));
        }
    }

    protected void appendPropertyRef(StringBuilder sb, AnnotationMetadata annotationMetadata, PersistentEntity entity, QueryPropertyPath propertyPath) {
        String tableAlias = propertyPath.getTableAlias();
        String readTransformer = this.getDataTransformerReadValue(tableAlias, propertyPath.getProperty()).orElse(null);
        if (readTransformer != null) {
            sb.append(readTransformer);
            return;
        }
        if (tableAlias != null) {
            sb.append(tableAlias).append('.');
        }
        boolean computePropertyPaths = this.computePropertyPaths();
        boolean jsonEntity = this.isJsonEntity(annotationMetadata, entity);
        if (computePropertyPaths && !jsonEntity) {
            sb.append(propertyPath.getColumnName());
        } else if (jsonEntity) {
            String jsonEntityColumn = this.getJsonEntityColumn(annotationMetadata);
            if (jsonEntityColumn != null) {
                sb.append(jsonEntityColumn).append('.');
                PersistentProperty property = propertyPath.getProperty();
                if (property == entity.getIdentity()) {
                    sb.append("\"" + property.getPersistedName() + "\"");
                } else {
                    sb.append(propertyPath.getPath());
                }
            }
        } else {
            sb.append(propertyPath.getPath());
        }
    }

    private String getJsonEntityColumn(AnnotationMetadata annotationMetadata) {
        AnnotationValue entityRepresentationAnnotationValue = annotationMetadata.getAnnotation(EntityRepresentation.class);
        if (entityRepresentationAnnotationValue != null) {
            return (String)entityRepresentationAnnotationValue.getRequiredValue(JSON_COLUMN, String.class);
        }
        return null;
    }

    private void appendCaseInsensitiveCriterion(CriteriaContext ctx, QueryModel.PropertyCriterion criterion, String operator) {
        QueryPropertyPath propertyPath = ctx.getRequiredProperty(criterion);
        StringBuilder whereClause = ctx.query();
        whereClause.append("LOWER(");
        this.appendPropertyRef(whereClause, ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), propertyPath);
        whereClause.append(")").append(operator).append("LOWER(");
        this.appendPlaceholderOrLiteral(ctx, propertyPath, criterion.getValue());
        whereClause.append(")");
    }

    private void appendPlaceholderOrLiteral(CriteriaContext ctx, QueryPropertyPath propertyPath, Object value) {
        if (value instanceof BindingParameter) {
            BindingParameter bindingParameter = (BindingParameter)value;
            ctx.pushParameter(bindingParameter, this.newBindingContext(propertyPath.propertyPath));
            return;
        }
        ctx.query().append(this.asLiteral(value));
    }

    protected void handleSubQuery(CriteriaContext ctx, QueryModel.SubqueryCriterion subqueryCriterion, String comparisonExpression) {
        QueryPropertyPath propertyPath = ctx.getRequiredProperty(subqueryCriterion.getProperty(), QueryModel.In.class);
        StringBuilder whereClause = ctx.query();
        this.appendPropertyRef(whereClause, ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), propertyPath);
        whereClause.append(comparisonExpression);
        whereClause.append(')');
    }

    private void buildUpdateStatement(AnnotationMetadata annotationMetadata, QueryState queryState, Map<String, Object> propertiesToUpdate) {
        StringBuilder queryString = queryState.getQuery();
        queryString.append(' ').append("SET").append(' ');
        PersistentEntity entity = queryState.getEntity();
        boolean jsonEntity = this.isJsonEntity(annotationMetadata, queryState.getEntity());
        if (jsonEntity && propertiesToUpdate.size() == 1) {
            this.checkDialectSupportsJsonEntity(entity);
            String name = propertiesToUpdate.keySet().iterator().next();
            String jsonEntityColumn = this.getJsonEntityColumn(annotationMetadata);
            if (name.equals(jsonEntityColumn)) {
                Object value = propertiesToUpdate.get(name);
                queryString.append(queryState.getRootAlias()).append('.').append(jsonEntityColumn).append("=");
                if (value instanceof BindingParameter) {
                    final int key = 1;
                    queryState.pushParameter(new QueryParameterBinding(){

                        @Override
                        public String getName() {
                            return String.valueOf(key);
                        }

                        @Override
                        public String getKey() {
                            return String.valueOf(key);
                        }

                        @Override
                        public DataType getDataType() {
                            return DataType.JSON;
                        }

                        @Override
                        public JsonDataType getJsonDataType() {
                            return JsonDataType.DEFAULT;
                        }

                        @Override
                        public int getParameterIndex() {
                            return -1;
                        }
                    });
                } else {
                    queryString.append(this.asLiteral(value));
                }
                return;
            }
        }
        List update = propertiesToUpdate.entrySet().stream().map(e -> {
            Association association;
            QueryPropertyPath propertyPath = this.findProperty(queryState, (String)e.getKey(), null);
            PersistentProperty patt72859$temp = propertyPath.getProperty();
            if (patt72859$temp instanceof Association && (association = (Association)patt72859$temp).isForeignKey()) {
                throw new IllegalArgumentException("Foreign key associations cannot be updated as part of a batch update statement");
            }
            return new AbstractMap.SimpleEntry(propertyPath, e.getValue());
        }).filter(e -> !(e.getValue() instanceof QueryParameter) || !((QueryPropertyPath)e.getKey()).getProperty().isGenerated()).collect(Collectors.toList());
        boolean[] needsTrimming = new boolean[]{false};
        if (!this.computePropertyPaths() || jsonEntity) {
            String jsonViewColumnName = this.getJsonEntityColumn(annotationMetadata);
            if (jsonViewColumnName != null) {
                queryString.append(queryState.getRootAlias()).append('.').append(jsonViewColumnName).append("= json_transform(").append(jsonViewColumnName);
            }
            for (Map.Entry entry : update) {
                QueryPropertyPath propertyPath = (QueryPropertyPath)entry.getKey();
                PersistentProperty prop = propertyPath.getProperty();
                String tableAlias = propertyPath.getTableAlias();
                if (jsonViewColumnName != null) {
                    queryString.append(", SET '$.").append(propertyPath.getPath()).append("' = ");
                } else {
                    if (tableAlias != null) {
                        queryString.append(tableAlias).append('.');
                    }
                    queryString.append(propertyPath.getPath()).append('=');
                }
                Object v = entry.getValue();
                if (v instanceof BindingParameter) {
                    BindingParameter bindingParameter = (BindingParameter)v;
                    this.appendUpdateSetParameter(queryString, tableAlias, prop, () -> queryState.pushParameter(bindingParameter, this.newBindingContext(propertyPath.propertyPath)));
                } else {
                    queryString.append(this.asLiteral(entry.getValue()));
                }
                if (jsonViewColumnName != null) continue;
                queryString.append(',');
                needsTrimming[0] = true;
            }
            if (jsonViewColumnName != null) {
                queryString.append(')');
            }
        } else {
            NamingStrategy namingStrategy = this.getNamingStrategy(queryState.getEntity());
            for (Map.Entry entry : update) {
                QueryPropertyPath propertyPath = (QueryPropertyPath)entry.getKey();
                Object tableAlias = entry.getValue();
                if (tableAlias instanceof BindingParameter) {
                    BindingParameter bindingParameter = (BindingParameter)tableAlias;
                    this.traversePersistentProperties(propertyPath.getAssociations(), propertyPath.getProperty(), (List<Association> associations, PersistentProperty property) -> {
                        boolean generated = PersistentEntityUtils.isPropertyGenerated(entity, propertyPath.getProperty(), property);
                        if (generated) {
                            return;
                        }
                        String tableAlias = propertyPath.getTableAlias();
                        if (tableAlias != null) {
                            queryString.append(tableAlias).append('.');
                        }
                        String columnName = this.getMappedName(namingStrategy, (List<Association>)associations, (PersistentProperty)property);
                        if (queryState.escape) {
                            columnName = this.quote(columnName);
                        }
                        queryString.append(columnName).append('=');
                        this.appendUpdateSetParameter(queryString, tableAlias, (PersistentProperty)property, () -> queryState.pushParameter(bindingParameter, this.newBindingContext(propertyPath.propertyPath, PersistentPropertyPath.of(associations, property, this.asPath((List<Association>)associations, (PersistentProperty)property)))));
                        queryString.append(',');
                        needsTrimming[0] = true;
                    });
                    continue;
                }
                tableAlias = propertyPath.getTableAlias();
                if (tableAlias != null) {
                    queryString.append((String)tableAlias).append('.');
                }
                queryString.append(propertyPath.getColumnName()).append('=');
                queryString.append(this.asLiteral(entry.getValue()));
                queryString.append(',');
                needsTrimming[0] = true;
            }
        }
        if (needsTrimming[0]) {
            queryString.setLength(queryString.length() - 1);
        }
    }

    protected boolean isExpandEmbedded() {
        return false;
    }

    protected void appendUpdateSetParameter(StringBuilder sb, String alias, PersistentProperty prop, Runnable appendParameter) {
        Optional<String> dataTransformerWriteValue = this.getDataTransformerWriteValue(alias, prop);
        if (dataTransformerWriteValue.isPresent()) {
            this.appendTransformed(sb, dataTransformerWriteValue.get(), appendParameter);
        } else {
            appendParameter.run();
        }
    }

    protected void appendTransformed(StringBuilder sb, String transformed, Runnable appendParameter) {
        int parameterPosition = transformed.indexOf(63);
        if (parameterPosition > -1) {
            if (transformed.lastIndexOf(63) != parameterPosition) {
                throw new IllegalStateException("Only one parameter placeholder is allowed!");
            }
            sb.append(transformed, 0, parameterPosition);
            appendParameter.run();
            sb.append(transformed.substring(parameterPosition + 1));
        } else {
            sb.append(transformed);
        }
    }

    private void appendPropertyComparison(CriteriaContext ctx, QueryModel.PropertyComparisonCriterion comparisonCriterion, String operator) {
        StringBuilder sb = ctx.query();
        this.appendPropertyRef(sb, ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), ctx.getRequiredProperty(comparisonCriterion.getProperty(), comparisonCriterion.getClass()));
        sb.append(operator);
        this.appendPropertyRef(sb, ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), ctx.getRequiredProperty(comparisonCriterion.getOtherProperty(), comparisonCriterion.getClass()));
    }

    @NonNull
    private QueryPropertyPath findProperty(QueryState queryState, String propertypath, Class criterionType) {
        return this.findPropertyInternal(queryState, queryState.getEntity(), queryState.getRootAlias(), propertypath, criterionType);
    }

    private QueryPropertyPath findPropertyInternal(QueryState queryState, PersistentEntity entity, String tableAlias, String propertypath, Class criterionType) {
        PersistentPropertyPath propertyPath = entity.getPropertyPath(propertypath);
        if (propertyPath != null) {
            if (propertyPath.getAssociations().isEmpty()) {
                return new QueryPropertyPath(propertyPath, tableAlias);
            }
            PersistentProperty property = propertyPath.getProperty();
            Association joinAssociation = null;
            StringJoiner joinPathJoiner = new StringJoiner(".");
            String lastJoinAlias = null;
            for (Association association : propertyPath.getAssociations()) {
                String joinStringPath;
                if (association instanceof Embedded) {
                    joinPathJoiner.add(association.getName());
                    continue;
                }
                if (joinAssociation == null) {
                    joinPathJoiner.add(association.getName());
                    joinAssociation = association;
                    continue;
                }
                if (PersistentEntityUtils.isAccessibleWithoutJoin(association, propertyPath.getProperty())) {
                    if (lastJoinAlias == null) {
                        joinStringPath = joinPathJoiner.toString();
                        if (!queryState.isJoined(joinStringPath)) {
                            throw new IllegalArgumentException("Property is not joined at path: " + joinStringPath);
                        }
                        lastJoinAlias = this.joinInPath(queryState, joinPathJoiner.toString());
                    }
                    return new QueryPropertyPath(new PersistentPropertyPath(Collections.emptyList(), association), lastJoinAlias);
                }
                joinPathJoiner.add(association.getName());
                if (!queryState.isAllowJoins()) {
                    throw new IllegalArgumentException("Joins cannot be used in a DELETE or UPDATE operation" + (association.getAssociatedEntity().getIdentity() == propertyPath.getProperty()));
                }
                joinStringPath = joinPathJoiner.toString();
                if (!queryState.isJoined(joinStringPath)) {
                    throw new IllegalArgumentException("Property is not joined at path: " + joinStringPath);
                }
                lastJoinAlias = this.joinInPath(queryState, joinStringPath);
                joinAssociation = association;
            }
            if (joinAssociation != null) {
                if (!PersistentEntityUtils.isAccessibleWithoutJoin(joinAssociation, propertyPath.getProperty())) {
                    String joinStringPath = joinPathJoiner.toString();
                    if (!queryState.isJoined(joinStringPath)) {
                        throw new IllegalArgumentException("Property is not joined at path: " + joinStringPath);
                    }
                    if (lastJoinAlias == null) {
                        lastJoinAlias = this.joinInPath(queryState, joinPathJoiner.toString());
                    }
                }
                if (lastJoinAlias != null) {
                    return new QueryPropertyPath(new PersistentPropertyPath(Collections.emptyList(), property), lastJoinAlias);
                }
            }
        } else if ("id".equals(propertypath) && entity.getIdentity() != null) {
            return new QueryPropertyPath(new PersistentPropertyPath(Collections.emptyList(), entity.getIdentity(), entity.getIdentity().getName()), queryState.getRootAlias());
        }
        if (propertyPath == null) {
            if (criterionType == null || criterionType == Sort.Order.class) {
                throw new IllegalArgumentException("Cannot order on non-existent property path: " + propertypath);
            }
            throw new IllegalArgumentException("Cannot use [" + criterionType.getSimpleName() + "] criterion on non-existent property path: " + propertypath);
        }
        return new QueryPropertyPath(propertyPath, tableAlias);
    }

    private String joinInPath(QueryState queryState, String joinStringPath) {
        QueryModel queryModel = queryState.getQueryModel();
        JoinPath joinPath = queryModel.getJoinPath(joinStringPath).orElse(null);
        if (joinPath == null) {
            joinPath = queryModel.join(joinStringPath, Join.Type.DEFAULT, null);
        }
        if (queryState.isAllowJoins()) {
            return queryState.applyJoin(joinPath);
        }
        throw new IllegalArgumentException("Joins are not allowed for batch update queries");
    }

    protected abstract boolean computePropertyPaths();

    @Override
    public QueryResult buildUpdate(@NonNull AnnotationMetadata annotationMetadata, @NonNull QueryModel query, @NonNull List<String> propertiesToUpdate) {
        return this.buildUpdate(annotationMetadata, query, propertiesToUpdate.stream().collect(Collectors.toMap(prop -> prop, QueryParameter::new, (a, b) -> a, () -> new LinkedHashMap())));
    }

    @Override
    public QueryResult buildUpdate(@NonNull AnnotationMetadata annotationMetadata, @NonNull QueryModel query, @NonNull Map<String, Object> propertiesToUpdate) {
        if (propertiesToUpdate.isEmpty()) {
            throw new IllegalArgumentException("No properties specified to update");
        }
        PersistentEntity entity = query.getPersistentEntity();
        QueryState queryState = this.newQueryState(query, false, this.isAliasForBatch(entity, annotationMetadata));
        StringBuilder queryString = queryState.getQuery();
        String tableAlias = queryState.getRootAlias();
        String tableName = this.getTableName(entity);
        queryString.append(UPDATE_CLAUSE).append(tableName);
        if (tableAlias != null) {
            queryString.append(' ').append(tableAlias);
        }
        this.buildUpdateStatement(annotationMetadata, queryState, propertiesToUpdate);
        this.buildWhereClause(annotationMetadata, query.getCriteria(), queryState);
        if (!query.getProjections().isEmpty()) {
            if (!this.getDialect().supportsUpdateReturning()) {
                throw new IllegalStateException("Dialect: " + this.getDialect() + " doesn't support UPDATE ... RETURNING clause");
            }
            queryString.append(RETURNING);
            this.buildSelect(annotationMetadata, queryState, queryString, query.getProjections(), tableAlias, entity);
        }
        return QueryResult.of(queryState.getFinalQuery(), queryState.getQueryParts(), queryState.getParameterBindings(), queryState.getAdditionalRequiredParameters());
    }

    @Override
    public QueryResult buildDelete(@NonNull AnnotationMetadata annotationMetadata, @NonNull QueryModel query) {
        PersistentEntity entity = query.getPersistentEntity();
        QueryState queryState = this.newQueryState(query, false, this.isAliasForBatch(entity, annotationMetadata));
        StringBuilder queryString = queryState.getQuery();
        String tableAlias = queryState.getRootAlias();
        StringBuilder buffer = this.appendDeleteClause(queryString);
        String tableName = this.getTableName(entity);
        buffer.append(tableName).append(' ');
        if (tableAlias != null) {
            buffer.append(this.getTableAsKeyword()).append(tableAlias);
        }
        this.buildWhereClause(annotationMetadata, query.getCriteria(), queryState);
        if (!query.getProjections().isEmpty()) {
            if (!this.getDialect().supportsDeleteReturning()) {
                throw new IllegalStateException("Dialect: " + this.getDialect() + " doesn't support DELETE ... RETURNING clause");
            }
            queryString.append(RETURNING);
            this.buildSelect(annotationMetadata, queryState, queryString, query.getProjections(), tableAlias, entity);
        }
        return QueryResult.of(queryState.getFinalQuery(), queryState.getQueryParts(), queryState.getParameterBindings(), queryState.getAdditionalRequiredParameters());
    }

    protected abstract boolean isAliasForBatch(PersistentEntity var1, AnnotationMetadata var2);

    @NonNull
    protected StringBuilder appendDeleteClause(StringBuilder queryString) {
        return queryString.append(DELETE_CLAUSE).append(FROM_CLAUSE);
    }

    @Override
    @NonNull
    public QueryResult buildOrderBy(@NonNull PersistentEntity entity, @NonNull Sort sort) {
        return this.buildOrderBy("", entity, AnnotationMetadata.EMPTY_METADATA, sort, false);
    }

    @NonNull
    @Deprecated(forRemoval=true, since="4.2.0")
    public QueryResult buildOrderBy(String query, @NonNull PersistentEntity entity, @NonNull AnnotationMetadata annotationMetadata, @NonNull Sort sort) {
        return this.buildOrderBy(query, entity, annotationMetadata, sort, false);
    }

    @NonNull
    public QueryResult buildOrderBy(String query, @NonNull PersistentEntity entity, @NonNull AnnotationMetadata annotationMetadata, @NonNull Sort sort, boolean nativeQuery) {
        ArgumentUtils.requireNonNull((String)"entity", (Object)entity);
        ArgumentUtils.requireNonNull((String)"sort", (Object)sort);
        List<Sort.Order> orders = sort.getOrderBy();
        if (CollectionUtils.isEmpty(orders)) {
            throw new IllegalArgumentException("Sort is empty");
        }
        StringBuilder buff = new StringBuilder(ORDER_BY_CLAUSE);
        Iterator<Sort.Order> i = orders.iterator();
        while (i.hasNext()) {
            Sort.Order order = i.next();
            String property = order.getProperty();
            boolean ignoreCase = order.isIgnoreCase();
            if (ignoreCase) {
                buff.append("LOWER(");
            }
            buff.append(this.buildPropertyByName(property, query, entity, annotationMetadata, nativeQuery));
            if (ignoreCase) {
                buff.append(")");
            }
            buff.append(' ').append((Object)order.getDirection());
            if (!i.hasNext()) continue;
            buff.append(",");
        }
        return QueryResult.of(buff.toString(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap());
    }

    public String buildPropertyByName(@NonNull String propertyName, @NonNull String query, @NonNull PersistentEntity entity, @NonNull AnnotationMetadata annotationMetadata, boolean nativeQuery) {
        if (nativeQuery) {
            return propertyName;
        }
        PersistentPropertyPath path = entity.getPropertyPath(propertyName);
        if (path == null) {
            throw new IllegalArgumentException("Cannot sort on non-existent property path: " + propertyName);
        }
        ArrayList<Association> associations = new ArrayList<Association>(path.getAssociations());
        int assocCount = associations.size();
        if (assocCount > 0 && this.computePropertyPaths() && associations.get(assocCount - 1) instanceof Embedded) {
            associations.remove(assocCount - 1);
        }
        StringBuilder buff = new StringBuilder();
        if (associations.isEmpty()) {
            buff.append(this.getAliasName(entity));
        } else {
            StringJoiner joiner = new StringJoiner(".");
            for (Association association : associations) {
                joiner.add(association.getName());
            }
            String joinAlias = this.getAliasName(new JoinPath(joiner.toString(), associations.toArray(new Association[0]), Join.Type.DEFAULT, null));
            if (!this.computePropertyPaths()) {
                if (!query.contains(" " + joinAlias + " ") && !query.endsWith(" " + joinAlias)) {
                    buff.append(this.getAliasName(entity)).append('.');
                    StringJoiner pathJoiner = new StringJoiner(".");
                    for (Association association : associations) {
                        pathJoiner.add(association.getName());
                    }
                    buff.append(pathJoiner);
                } else {
                    buff.append(joinAlias);
                }
            } else {
                buff.append(joinAlias);
            }
        }
        buff.append('.');
        String jsonEntityColumn = this.getJsonEntityColumn(annotationMetadata);
        if (jsonEntityColumn != null) {
            buff.append(jsonEntityColumn).append('.');
        }
        if (!this.computePropertyPaths() || jsonEntityColumn != null) {
            buff.append(path.getProperty().getName());
        } else {
            buff.append(this.getColumnName(path.getProperty()));
        }
        return buff.toString();
    }

    protected String asPath(List<Association> associations, PersistentProperty property) {
        if (associations.isEmpty()) {
            return property.getName();
        }
        StringJoiner joiner = new StringJoiner(".");
        for (Association association : associations) {
            joiner.add(association.getName());
        }
        joiner.add(property.getName());
        return joiner.toString();
    }

    protected void traversePersistentProperties(PersistentProperty property, BiConsumer<List<Association>, PersistentProperty> consumer) {
        this.traversePersistentProperties(Collections.emptyList(), property, consumer);
    }

    protected void traversePersistentProperties(PersistentEntity persistentEntity, BiConsumer<List<Association>, PersistentProperty> consumer) {
        PersistentEntityUtils.traversePersistentProperties(persistentEntity, consumer);
    }

    protected void traversePersistentProperties(PersistentEntity persistentEntity, Predicate<Association> skipAssociationPredicate, BiConsumer<List<Association>, PersistentProperty> consumer) {
        PersistentEntityUtils.traversePersistentProperties(persistentEntity, skipAssociationPredicate, consumer);
    }

    protected void traversePersistentProperties(PersistentEntity persistentEntity, boolean includeIdentity, boolean includeVersion, BiConsumer<List<Association>, PersistentProperty> consumer) {
        PersistentEntityUtils.traversePersistentProperties(persistentEntity, includeIdentity, includeVersion, consumer);
    }

    private void traversePersistentPropertiesForCriteria(List<Association> associations, PersistentProperty property, BiConsumer<List<Association>, PersistentProperty> consumerProperty) {
        PersistentEntityUtils.traversePersistentProperties(associations, property, consumerProperty);
    }

    protected void traversePersistentProperties(List<Association> associations, PersistentProperty property, BiConsumer<List<Association>, PersistentProperty> consumerProperty) {
        PersistentEntityUtils.traversePersistentProperties(associations, property, consumerProperty);
    }

    private Optional<String> getDataTransformerValue(String alias, PersistentProperty prop, String val) {
        return prop.getAnnotationMetadata().stringValue(DataTransformer.class, val).map(v -> this.replaceAlias(alias, (String)v));
    }

    private String replaceAlias(String alias, String v) {
        return v.replaceAll(ALIAS_REPLACE_QUOTED, (String)(alias == null ? "" : alias + "."));
    }

    private BindingParameter.BindingContext newBindingContext(@Nullable PersistentPropertyPath ref, @Nullable PersistentPropertyPath persistentPropertyPath) {
        return BindingParameter.BindingContext.create().incomingMethodParameterProperty(ref).outgoingQueryParameterProperty(persistentPropertyPath);
    }

    protected BindingParameter.BindingContext newBindingContext(@Nullable PersistentPropertyPath ref) {
        return BindingParameter.BindingContext.create().incomingMethodParameterProperty(ref).outgoingQueryParameterProperty(ref);
    }

    protected Optional<String> getDataTransformerReadValue(String alias, PersistentProperty prop) {
        return this.getDataTransformerValue(alias, prop, "read");
    }

    protected Optional<String> getDataTransformerWriteValue(String alias, PersistentProperty prop) {
        return this.getDataTransformerValue(alias, prop, "write");
    }

    protected abstract Placeholder formatParameter(int var1);

    public abstract String resolveJoinType(Join.Type var1);

    protected <T extends QueryModel.Criterion> void addCriterionHandler(Class<T> clazz, CriterionHandler<T> handler) {
        this.queryHandlers.put(clazz, handler);
    }

    protected final String getColumnAlias(PersistentProperty property) {
        return property.getAlias();
    }

    protected void checkDialectSupportsJsonEntity(PersistentEntity entity) {
        if (!this.getDialect().supportsJsonEntity()) {
            throw new IllegalArgumentException("Json representation for entity " + entity.getSimpleName() + " is not supported by the dialect " + this.getDialect());
        }
    }

    protected boolean isJsonEntity(AnnotationMetadata annotationMetadata, PersistentEntity entity) {
        boolean jsonEntity = DataAnnotationUtils.hasJsonEntityRepresentationAnnotation(annotationMetadata);
        if (jsonEntity) {
            this.checkDialectSupportsJsonEntity(entity);
        }
        return jsonEntity;
    }

    protected static interface CriterionHandler<T extends QueryModel.Criterion> {
        public void handle(CriteriaContext var1, T var2);
    }

    protected class QueryPropertyPath {
        private final PersistentPropertyPath propertyPath;
        private final String tableAlias;

        public QueryPropertyPath(@Nullable PersistentPropertyPath propertyPath, String tableAlias) {
            this.propertyPath = propertyPath;
            this.tableAlias = tableAlias;
        }

        @NonNull
        public List<Association> getAssociations() {
            return this.propertyPath.getAssociations();
        }

        @NonNull
        public PersistentProperty getProperty() {
            return this.propertyPath.getProperty();
        }

        @NonNull
        public String getPath() {
            return this.propertyPath.getPath();
        }

        @Nullable
        public String getTableAlias() {
            return this.tableAlias;
        }

        public String getColumnName() {
            String columnName = AbstractSqlLikeQueryBuilder.this.getMappedName(this.getNamingStrategy(), this.propertyPath.getAssociations(), this.propertyPath.getProperty());
            if (this.shouldEscape()) {
                return AbstractSqlLikeQueryBuilder.this.quote(columnName);
            }
            return columnName;
        }

        public NamingStrategy getNamingStrategy() {
            return AbstractSqlLikeQueryBuilder.this.getNamingStrategy(this.propertyPath);
        }

        public boolean shouldEscape() {
            return AbstractSqlLikeQueryBuilder.this.shouldEscape(this.propertyPath.findPropertyOwner().orElse(this.propertyPath.getProperty().getOwner()));
        }

        public PersistentPropertyPath getPropertyPath() {
            return this.propertyPath;
        }
    }

    protected static interface CriteriaContext
    extends PropertyParameterCreator {
        public String getCurrentTableAlias();

        public QueryState getQueryState();

        public PersistentEntity getPersistentEntity();

        public QueryPropertyPath getRequiredProperty(String var1, Class<?> var2);

        @Override
        default public void pushParameter(@NonNull BindingParameter bindingParameter, @NonNull BindingParameter.BindingContext bindingContext) {
            this.getQueryState().pushParameter(bindingParameter, bindingContext);
        }

        default public QueryPropertyPath getRequiredProperty(QueryModel.PropertyNameCriterion propertyCriterion) {
            return this.getRequiredProperty(propertyCriterion.getProperty(), propertyCriterion.getClass());
        }

        default public StringBuilder query() {
            return this.getQueryState().getQuery();
        }

        public AnnotationMetadata getAnnotationMetadata();
    }

    @Internal
    protected final class QueryState
    implements PropertyParameterCreator {
        private final String rootAlias;
        private final Map<String, String> appliedJoinPaths = new HashMap<String, String>();
        private final AtomicInteger position = new AtomicInteger(0);
        private final Map<String, String> additionalRequiredParameters = new LinkedHashMap<String, String>();
        private final List<QueryParameterBinding> parameterBindings;
        private final StringBuilder query = new StringBuilder();
        private final List<String> queryParts = new ArrayList<String>();
        private final boolean allowJoins;
        private final QueryModel queryObject;
        private final boolean escape;
        private final PersistentEntity entity;
        private List<JoinPath> joinPaths = new ArrayList<JoinPath>();

        public QueryState(QueryModel query, boolean allowJoins, boolean useAlias) {
            this.allowJoins = allowJoins;
            this.queryObject = query;
            this.entity = query.getPersistentEntity();
            this.escape = AbstractSqlLikeQueryBuilder.this.shouldEscape(this.entity);
            this.rootAlias = useAlias ? AbstractSqlLikeQueryBuilder.this.getAliasName(this.entity) : null;
            this.parameterBindings = new ArrayList<QueryParameterBinding>(this.entity.getPersistentPropertyNames().size());
        }

        @Nullable
        public String getRootAlias() {
            return this.rootAlias;
        }

        public PersistentEntity getEntity() {
            return this.entity;
        }

        public String addAdditionalRequiredParameter(@NonNull String name) {
            Placeholder placeholder = this.newParameter();
            this.additionalRequiredParameters.put(placeholder.key, name);
            return placeholder.name;
        }

        public String getFinalQuery() {
            if (this.query.length() > 0) {
                this.queryParts.add(this.query.toString());
                this.query.setLength(0);
            }
            StringBuilder sb = new StringBuilder(this.queryParts.get(0));
            int i = 1;
            for (int k = 1; k < this.queryParts.size(); ++k) {
                Placeholder placeholder = AbstractSqlLikeQueryBuilder.this.formatParameter(i++);
                sb.append(placeholder.name);
                sb.append(this.queryParts.get(k));
            }
            return sb.toString();
        }

        public List<String> getQueryParts() {
            return this.queryParts;
        }

        public StringBuilder getQuery() {
            return this.query;
        }

        public boolean isAllowJoins() {
            return this.allowJoins;
        }

        public QueryModel getQueryModel() {
            return this.queryObject;
        }

        private Placeholder newParameter() {
            return AbstractSqlLikeQueryBuilder.this.formatParameter(this.position.incrementAndGet());
        }

        public String applyJoin(@NonNull JoinPath jp) {
            this.joinPaths.add(jp);
            String joinAlias = this.appliedJoinPaths.get(jp.getPath());
            if (joinAlias != null) {
                return joinAlias;
            }
            Optional<JoinPath> ojp = this.getQueryModel().getJoinPath(jp.getPath());
            if (ojp.isPresent()) {
                jp = ojp.get();
            }
            StringBuilder stringBuilder = this.getQuery();
            Join.Type jt = jp.getJoinType();
            String joinType = AbstractSqlLikeQueryBuilder.this.resolveJoinType(jt);
            String[] associationAlias = AbstractSqlLikeQueryBuilder.this.buildJoin(this.getRootAlias(), jp, joinType, stringBuilder, this.appliedJoinPaths, this);
            Association[] associationArray = jp.getAssociationPath();
            StringJoiner associationPath = new StringJoiner(".");
            String lastAlias = null;
            for (int i = 0; i < associationAlias.length; ++i) {
                associationPath.add(associationArray[i].getName());
                String computedAlias = associationAlias[i];
                this.appliedJoinPaths.put(associationPath.toString(), computedAlias);
                lastAlias = computedAlias;
            }
            return lastAlias;
        }

        @NonNull
        public String computeAlias(String associationPath) {
            String p;
            if (this.appliedJoinPaths.containsKey(associationPath)) {
                return this.appliedJoinPaths.get(associationPath);
            }
            int i = associationPath.indexOf(46);
            if (i > -1 && this.appliedJoinPaths.containsKey(p = associationPath.substring(0, i))) {
                return this.appliedJoinPaths.get(p) + "." + associationPath.substring(i + 1);
            }
            return this.getRootAlias() + "." + associationPath;
        }

        public boolean isJoined(String associationPath) {
            for (String joinPath : this.appliedJoinPaths.keySet()) {
                if (!joinPath.startsWith(associationPath)) continue;
                return true;
            }
            return this.appliedJoinPaths.containsKey(associationPath);
        }

        public boolean shouldEscape() {
            return this.escape;
        }

        @NonNull
        public Map<String, String> getAdditionalRequiredParameters() {
            return this.additionalRequiredParameters;
        }

        public List<QueryParameterBinding> getParameterBindings() {
            return this.parameterBindings;
        }

        @Override
        public void pushParameter(@NonNull BindingParameter bindingParameter, @NonNull BindingParameter.BindingContext bindingContext) {
            Placeholder placeholder = this.newParameter();
            bindingContext = bindingContext.index(this.position.get() + 1).name(placeholder.getKey());
            this.parameterBindings.add(bindingParameter.bind(bindingContext));
            this.queryParts.add(this.query.toString());
            this.query.setLength(0);
        }

        public void pushParameter(@NonNull QueryParameterBinding parameterBinding) {
            this.parameterBindings.add(parameterBinding);
            this.queryParts.add(this.query.toString());
            this.query.setLength(0);
        }

        public List<JoinPath> getJoinPaths() {
            return this.joinPaths;
        }

        public void setJoinPaths(List<JoinPath> joinPaths) {
            this.joinPaths = joinPaths;
        }
    }

    protected static enum QueryPosition {
        AFTER_TABLE_NAME,
        END_OF_QUERY;

    }

    private static interface PropertyParameterCreator {
        public void pushParameter(@NonNull BindingParameter var1, @NonNull BindingParameter.BindingContext var2);
    }

    public static final class Placeholder {
        private final String name;
        private final String key;

        public Placeholder(String name, String key) {
            this.name = name;
            this.key = key;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }
    }
}

