/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.expression;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.jpa.criteria.ExpressionType;
import io.micronaut.data.model.jpa.criteria.impl.ExpressionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.expression.AbstractExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.ClassExpressionType;

@Internal
public final class LiteralExpression<T>
extends AbstractExpression<T> {
    @Nullable
    private final T value;

    public LiteralExpression(Class<T> clazz) {
        super(clazz == null ? ExpressionType.OBJECT : new ClassExpressionType<T>(clazz));
        this.value = null;
    }

    public LiteralExpression(@Nullable T object) {
        super(object == null ? ExpressionType.OBJECT : new ClassExpressionType(object.getClass()));
        this.value = object;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public void visitExpression(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        return "LiteralExpression{value=" + this.value + "}";
    }
}

