/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.expression;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.model.jpa.criteria.PersistentEntitySubquery;
import io.micronaut.data.model.jpa.criteria.impl.ExpressionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.expression.AbstractExpression;

@Internal
public final class SubqueryExpression<T>
extends AbstractExpression<T> {
    private final Type type;
    private final PersistentEntitySubquery<T> subquery;

    public SubqueryExpression(@NonNull Type type, @NonNull PersistentEntitySubquery<T> subquery) {
        super(subquery.getExpressionType());
        this.type = type;
        this.subquery = subquery;
    }

    public PersistentEntitySubquery<T> getSubquery() {
        return this.subquery;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public Class<? extends T> getJavaType() {
        return super.getJavaType();
    }

    @Override
    public void visitExpression(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        return "SubqueryExpression{type=" + this.type + ", subquery=" + this.subquery + "}";
    }

    public static enum Type {
        ALL,
        SOME,
        ANY;

    }
}

