/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.TypeDef;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;

public final class DataType
extends Enum<DataType> {
    public static final /* enum */ DataType BIGDECIMAL;
    public static final /* enum */ DataType BOOLEAN;
    public static final /* enum */ DataType BYTE;
    public static final /* enum */ DataType BYTE_ARRAY;
    public static final /* enum */ DataType CHARACTER;
    public static final /* enum */ DataType DATE;
    public static final /* enum */ DataType TIMESTAMP;
    public static final /* enum */ DataType TIME;
    public static final /* enum */ DataType DOUBLE;
    public static final /* enum */ DataType FLOAT;
    public static final /* enum */ DataType INTEGER;
    public static final /* enum */ DataType LONG;
    public static final /* enum */ DataType SHORT;
    public static final /* enum */ DataType STRING;
    public static final /* enum */ DataType OBJECT;
    public static final /* enum */ DataType ENTITY;
    public static final /* enum */ DataType JSON;
    public static final /* enum */ DataType UUID;
    public static final /* enum */ DataType STRING_ARRAY;
    public static final /* enum */ DataType SHORT_ARRAY;
    public static final /* enum */ DataType INTEGER_ARRAY;
    public static final /* enum */ DataType LONG_ARRAY;
    public static final /* enum */ DataType FLOAT_ARRAY;
    public static final /* enum */ DataType DOUBLE_ARRAY;
    public static final /* enum */ DataType CHARACTER_ARRAY;
    public static final /* enum */ DataType BOOLEAN_ARRAY;
    public static final DataType[] EMPTY_DATA_TYPE_ARRAY;
    private static final Map<Class<?>, DataType> CLASS_DATA_TYPE_MAP;
    private final Set<Class<?>> javaTypes;
    private final boolean isArray;
    private static final /* synthetic */ DataType[] $VALUES;

    public static DataType[] values() {
        return (DataType[])$VALUES.clone();
    }

    public static DataType valueOf(String name) {
        return Enum.valueOf(DataType.class, name);
    }

    private DataType(Class<?> ... javaTypes) {
        this(false, javaTypes);
    }

    private DataType(boolean isArray, Class<?> ... javaTypes) {
        this.isArray = isArray;
        this.javaTypes = CollectionUtils.setOf((Object[])javaTypes);
    }

    public boolean isArray() {
        return this.isArray;
    }

    public static DataType forType(@NonNull Class<?> type) {
        Class wrapper = ReflectionUtils.getWrapperType(Objects.requireNonNull(type, "The type cannot be null"));
        TypeDef td = wrapper.getAnnotation(TypeDef.class);
        if (td != null) {
            return td.type();
        }
        return CLASS_DATA_TYPE_MAP.getOrDefault(wrapper, OBJECT);
    }

    static {
        DataType[] values;
        BIGDECIMAL = new DataType(BigDecimal.class, BigInteger.class);
        BOOLEAN = new DataType(Boolean.class);
        BYTE = new DataType(Byte.class);
        BYTE_ARRAY = new DataType(true, byte[].class);
        CHARACTER = new DataType(Character.class);
        DATE = new DataType(java.util.Date.class, Date.class, LocalDate.class);
        TIMESTAMP = new DataType(Timestamp.class, Instant.class, OffsetDateTime.class, ZonedDateTime.class);
        TIME = new DataType(Time.class);
        DOUBLE = new DataType(Double.class);
        FLOAT = new DataType(Float.class);
        INTEGER = new DataType(Integer.class);
        LONG = new DataType(Long.class);
        SHORT = new DataType(Short.class);
        STRING = new DataType(String.class, CharSequence.class, URL.class, URI.class, Locale.class, TimeZone.class, Charset.class);
        OBJECT = new DataType(new Class[0]);
        ENTITY = new DataType(new Class[0]);
        JSON = new DataType(new Class[0]);
        UUID = new DataType(UUID.class);
        STRING_ARRAY = new DataType(true, String[].class);
        SHORT_ARRAY = new DataType(true, short[].class, Short[].class);
        INTEGER_ARRAY = new DataType(true, int[].class, Integer[].class);
        LONG_ARRAY = new DataType(true, long[].class, Long[].class);
        FLOAT_ARRAY = new DataType(true, float[].class, Float[].class);
        DOUBLE_ARRAY = new DataType(true, double[].class, Double[].class);
        CHARACTER_ARRAY = new DataType(true, char[].class, Character[].class);
        BOOLEAN_ARRAY = new DataType(true, boolean[].class, Boolean[].class);
        $VALUES = new DataType[]{BIGDECIMAL, BOOLEAN, BYTE, BYTE_ARRAY, CHARACTER, DATE, TIMESTAMP, TIME, DOUBLE, FLOAT, INTEGER, LONG, SHORT, STRING, OBJECT, ENTITY, JSON, UUID, STRING_ARRAY, SHORT_ARRAY, INTEGER_ARRAY, LONG_ARRAY, FLOAT_ARRAY, DOUBLE_ARRAY, CHARACTER_ARRAY, BOOLEAN_ARRAY};
        EMPTY_DATA_TYPE_ARRAY = new DataType[0];
        CLASS_DATA_TYPE_MAP = new HashMap();
        for (DataType dt : values = DataType.values()) {
            for (Class<?> javaType : dt.javaTypes) {
                CLASS_DATA_TYPE_MAP.put(javaType, dt);
            }
        }
    }
}

