/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.runtime;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.DataType;

public interface QueryParameterBinding {
    @Nullable
    public String getName();

    @NonNull
    default public String getRequiredName() {
        String name = this.getName();
        if (name == null) {
            throw new IllegalStateException("Parameter name cannot be null for a query parameter: " + this);
        }
        return name;
    }

    @Nullable
    public DataType getDataType();

    @Nullable
    public Class<?> getParameterConverterClass();

    public int getParameterIndex();

    @Nullable
    public String[] getParameterBindingPath();

    @Nullable
    public String[] getPropertyPath();

    @NonNull
    default public String[] getRequiredPropertyPath() {
        String[] propertyPath = this.getPropertyPath();
        if (propertyPath == null) {
            throw new IllegalStateException("Property path cannot be null for a query parameter: " + this);
        }
        return propertyPath;
    }

    public boolean isAutoPopulated();

    public boolean isRequiresPreviousPopulatedValue();

    @Nullable
    public QueryParameterBinding getPreviousPopulatedValueParameter();

    default public boolean isExpandable() {
        return false;
    }
}

