/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.PersistentEntityFrom;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;

public interface PersistentEntityRoot<T>
extends Root<T>,
PersistentEntityFrom<T, T> {
    @NonNull
    default public <Y> Expression<Y> id() {
        PersistentEntity persistentEntity = this.getPersistentEntity();
        if (persistentEntity.hasIdentity()) {
            return this.get(persistentEntity.getIdentity().getName());
        }
        if (persistentEntity.hasCompositeIdentity()) {
            return this.get(persistentEntity.getCompositeIdentity()[0].getName());
        }
        throw new IllegalStateException("No identity is present");
    }

    @NonNull
    default public <Y> PersistentPropertyPath<Y> version() {
        PersistentEntity persistentEntity = this.getPersistentEntity();
        if (persistentEntity.getVersion() == null) {
            throw new IllegalStateException("No version is present");
        }
        return this.get(persistentEntity.getVersion().getName());
    }
}

