/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.runtime;

import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.annotation.Id;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.Transient;
import io.micronaut.data.annotation.Version;
import io.micronaut.data.exceptions.MappingException;
import io.micronaut.data.model.AbstractPersistentEntity;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimeEmbedded;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.convert.AttributeConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RuntimePersistentEntity<T>
extends AbstractPersistentEntity
implements PersistentEntity {
    private final BeanIntrospection<T> introspection;
    private final RuntimePersistentProperty<T>[] identity;
    private final Map<String, RuntimePersistentProperty<T>> allPersistentProperties;
    private final Map<String, RuntimePersistentProperty<T>> persistentProperties;
    private final RuntimePersistentProperty<T>[] constructorArguments;
    private final String aliasName;
    private final RuntimePersistentProperty<T> version;
    private Boolean hasAutoPopulatedProperties;
    private List<String> allPersistentPropertiesNames;
    private List<RuntimePersistentProperty<T>> persistentPropertiesValues;

    public RuntimePersistentEntity(@NonNull Class<T> type) {
        this(BeanIntrospection.getIntrospection(type));
    }

    public RuntimePersistentEntity(@NonNull BeanIntrospection<T> introspection) {
        super((AnnotationMetadataProvider)introspection);
        ArgumentUtils.requireNonNull((String)"introspection", introspection);
        this.introspection = introspection;
        Argument[] constructorArguments = introspection.getConstructorArguments();
        Set constructorArgumentNames = Arrays.stream(constructorArguments).map(Argument::getName).collect(Collectors.toSet());
        RuntimePersistentProperty version = null;
        LinkedList<RuntimePersistentProperty> ids = new LinkedList<RuntimePersistentProperty>();
        Collection beanProperties = introspection.getBeanProperties();
        this.persistentProperties = new LinkedHashMap<String, RuntimePersistentProperty<T>>(beanProperties.size());
        this.allPersistentProperties = new LinkedHashMap<String, RuntimePersistentProperty<T>>(beanProperties.size());
        for (BeanProperty bp : beanProperties) {
            if (bp.hasStereotype(Transient.class)) continue;
            if (bp.hasStereotype(Id.class)) {
                RuntimePersistentProperty id = this.isEmbedded(bp) ? new RuntimeEmbedded(this, bp, constructorArgumentNames.contains(bp.getName())) : new RuntimePersistentProperty(this, bp, constructorArgumentNames.contains(bp.getName()));
                ids.add(id);
                this.allPersistentProperties.put(id.getName(), id);
                continue;
            }
            if (bp.hasStereotype(Version.class)) {
                version = new RuntimePersistentProperty(this, bp, constructorArgumentNames.contains(bp.getName()));
                this.allPersistentProperties.put(version.getName(), version);
                continue;
            }
            RuntimeAssociation prop = bp.hasAnnotation(Relation.class) ? (this.isEmbedded(bp) ? new RuntimeEmbedded(this, bp, constructorArgumentNames.contains(bp.getName())) : new RuntimeAssociation(this, bp, constructorArgumentNames.contains(bp.getName()))) : new RuntimeAssociation(this, bp, constructorArgumentNames.contains(bp.getName()));
            this.allPersistentProperties.put(prop.getName(), prop);
            this.persistentProperties.put(prop.getName(), prop);
        }
        this.identity = ids.toArray(new RuntimePersistentProperty[0]);
        this.version = version;
        this.constructorArguments = new RuntimePersistentProperty[constructorArguments.length];
        for (int i = 0; i < constructorArguments.length; ++i) {
            Argument constructorArgument = constructorArguments[i];
            String argumentName = constructorArgument.getName();
            PersistentProperty prop = this.getPropertyByName(argumentName);
            if (prop == null) {
                throw new MappingException("Constructor argument [" + argumentName + "] for type [" + this.getName() + "] must have an associated getter");
            }
            this.constructorArguments[i] = prop;
        }
        this.aliasName = super.getAliasName();
    }

    @NonNull
    protected AttributeConverter<Object, Object> resolveConverter(@NonNull Class<?> converterClass) {
        throw new MappingException("Converters not supported");
    }

    public boolean hasPrePersistEventListeners() {
        return false;
    }

    public boolean hasPreRemoveEventListeners() {
        return false;
    }

    public boolean hasPreUpdateEventListeners() {
        return false;
    }

    public boolean hasPostPersistEventListeners() {
        return false;
    }

    public boolean hasPostUpdateEventListeners() {
        return false;
    }

    public boolean hasPostRemoveEventListeners() {
        return false;
    }

    public boolean hasPostLoadEventListeners() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    @NonNull
    public String getAliasName() {
        return this.aliasName;
    }

    public BeanIntrospection<T> getIntrospection() {
        return this.introspection;
    }

    @Override
    @NonNull
    public String getName() {
        return this.introspection.getBeanType().getName();
    }

    @Override
    public boolean hasCompositeIdentity() {
        return this.identity.length > 1;
    }

    @Override
    public boolean hasIdentity() {
        return this.identity.length == 1;
    }

    @Nullable
    public RuntimePersistentProperty<T>[] getCompositeIdentity() {
        return this.identity.length > 1 ? this.identity : null;
    }

    @Override
    @Nullable
    public RuntimePersistentProperty<T> getIdentity() {
        return this.identity.length == 1 ? this.identity[0] : null;
    }

    @Override
    @Nullable
    public RuntimePersistentProperty<T> getVersion() {
        return this.version;
    }

    @NonNull
    public Collection<RuntimePersistentProperty<T>> getPersistentProperties() {
        if (this.persistentPropertiesValues == null) {
            this.persistentPropertiesValues = Collections.unmodifiableList(new ArrayList<RuntimePersistentProperty<T>>(this.persistentProperties.values()));
        }
        return this.persistentPropertiesValues;
    }

    @NonNull
    public Collection<RuntimeAssociation<T>> getAssociations() {
        return super.getAssociations();
    }

    @Override
    @Nullable
    public RuntimePersistentProperty<T> getPropertyByName(String name) {
        return this.allPersistentProperties.get(name);
    }

    @Override
    @Nullable
    public RuntimePersistentProperty<T> getIdentityByName(String name) {
        return (RuntimePersistentProperty)super.getIdentityByName(name);
    }

    @NonNull
    public List<String> getPersistentPropertyNames() {
        if (this.allPersistentPropertiesNames == null) {
            this.allPersistentPropertiesNames = Collections.unmodifiableList(new ArrayList<String>(this.allPersistentProperties.keySet()));
        }
        return this.allPersistentPropertiesNames;
    }

    @Override
    public boolean isOwningEntity(PersistentEntity owner) {
        return true;
    }

    @Override
    @Nullable
    public PersistentEntity getParentEntity() {
        return null;
    }

    private boolean isEmbedded(BeanProperty bp) {
        return bp.enumValue(Relation.class, Relation.Kind.class).orElse(null) == Relation.Kind.EMBEDDED;
    }

    protected RuntimePersistentEntity<T> getEntity(Class<T> type) {
        return PersistentEntity.of(type);
    }

    public RuntimePersistentProperty<T>[] getConstructorArguments() {
        return this.constructorArguments;
    }

    public boolean hasAutoPopulatedProperties() {
        if (this.hasAutoPopulatedProperties == null) {
            this.hasAutoPopulatedProperties = this.allPersistentProperties.values().stream().anyMatch(PersistentProperty::isAutoPopulated);
        }
        return this.hasAutoPopulatedProperties;
    }
}

