/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.naming.NamingStrategy;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.StringJoiner;

public class PersistentPropertyPath {
    private final List<Association> associations;
    private final PersistentProperty property;
    private String path;

    public PersistentPropertyPath(List<Association> associations, @NonNull PersistentProperty property) {
        this(associations, property, null);
    }

    public PersistentPropertyPath(List<Association> associations, @NonNull PersistentProperty property, @Nullable String path) {
        this.associations = associations;
        this.property = property;
        this.path = path;
    }

    @NonNull
    public List<Association> getAssociations() {
        return this.associations;
    }

    @NonNull
    public PersistentProperty getProperty() {
        return this.property;
    }

    @NonNull
    public String getPath() {
        if (this.path == null) {
            if (this.associations.isEmpty()) {
                return this.property.getName();
            }
            StringJoiner joiner = new StringJoiner(".");
            for (Association association : this.associations) {
                joiner.add(association.getName());
            }
            joiner.add(this.property.getName());
            this.path = joiner.toString();
        }
        return this.path;
    }

    public Optional<PersistentEntity> findPropertyOwner() {
        PersistentEntity owner = this.property.getOwner();
        if (!owner.isEmbeddable()) {
            return Optional.of(owner);
        }
        ListIterator<Association> listIterator = this.associations.listIterator(this.associations.size());
        while (listIterator.hasPrevious()) {
            Association association = listIterator.previous();
            if (association.getOwner().isEmbeddable()) continue;
            return Optional.of(association.getOwner());
        }
        return Optional.empty();
    }

    public NamingStrategy getNamingStrategy() {
        PersistentEntity owner = this.property.getOwner();
        if (!owner.isEmbeddable()) {
            return owner.getNamingStrategy();
        }
        Optional<NamingStrategy> namingStrategy = owner.findNamingStrategy();
        if (namingStrategy.isPresent()) {
            return namingStrategy.get();
        }
        ListIterator<Association> listIterator = this.associations.listIterator(this.associations.size());
        while (listIterator.hasPrevious()) {
            Association association = listIterator.previous();
            if (!association.getOwner().isEmbeddable()) {
                return association.getOwner().getNamingStrategy();
            }
            Optional<NamingStrategy> embeddedNamingStrategy = owner.findNamingStrategy();
            if (!embeddedNamingStrategy.isPresent()) continue;
            return embeddedNamingStrategy.get();
        }
        return owner.getNamingStrategy();
    }
}

