/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.event;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.annotation.Indexed;
import io.micronaut.core.order.Ordered;
import io.micronaut.data.event.EntityEventContext;
import io.micronaut.data.event.QueryEventContext;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import java.lang.annotation.Annotation;
import java.util.EventListener;

@Indexed(value=EntityEventListener.class)
public interface EntityEventListener<T>
extends EventListener,
Ordered {
    public static final EntityEventListener<Object> NOOP = new EntityEventListener(){

        public boolean supports(RuntimePersistentEntity entity, Class eventType) {
            return false;
        }
    };

    default public boolean supports(RuntimePersistentEntity<T> entity, Class<? extends Annotation> eventType) {
        return true;
    }

    default public boolean prePersist(@NonNull EntityEventContext<T> context) {
        return true;
    }

    default public void postPersist(@NonNull EntityEventContext<T> context) {
    }

    default public void postLoad(@NonNull EntityEventContext<T> context) {
    }

    default public boolean preRemove(@NonNull EntityEventContext<T> context) {
        return true;
    }

    default public void postRemove(@NonNull EntityEventContext<T> context) {
    }

    default public boolean preUpdate(@NonNull EntityEventContext<T> context) {
        return true;
    }

    default public boolean preQuery(@NonNull QueryEventContext<T> context) {
        return true;
    }

    default public void postUpdate(@NonNull EntityEventContext<T> context) {
    }
}

