/*
 * Copyright 2017-2020 original authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.micronaut.data.model.query.builder.sql;


/**
 * Allows configuration of how SQL queries are generated.
 *
 * @since 2.2.0
 * @author graemerocher
 */
public @interface SqlQueryConfiguration {

    /**
     * Allow formatting of parameters for different dialects.
     * @return The formats
     */
    DialectConfiguration[] value() default {};

    @interface DialectConfiguration {
        /**
         * @return Format for a specific dialect.
         */
        Dialect dialect();

        /**
         * A String format (see {@link String#format(String, Object...)} to format the appearance
         * of position parameters. It receives exactly one parameter which is the parameter index (starting from 1).
         *
         * @return The position parameter format.
         */
        String positionalParameterFormat() default "?";

        /**
         * @return Whether automatically escape queries.
         */
        boolean escapeQueries() default true;
    }
}
