/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.naming.NamingStrategy;

public interface Association
extends PersistentProperty {
    default public String getAliasName() {
        return NamingStrategy.DEFAULT.mappedName(this.getName()) + "_";
    }

    @NonNull
    public PersistentEntity getAssociatedEntity();

    @NonNull
    default public Relation.Cascade getCascade() {
        return this.getAnnotationMetadata().enumValue(Relation.class, "cascade", Relation.Cascade.class).orElse(Relation.Cascade.NONE);
    }

    @NonNull
    default public Relation.Kind getKind() {
        return this.findAnnotation(Relation.class).flatMap(av -> av.enumValue(Relation.Kind.class)).orElse(Relation.Kind.ONE_TO_ONE);
    }

    default public boolean isForeignKey() {
        Relation.Kind kind = this.getKind();
        return kind == Relation.Kind.ONE_TO_MANY || kind == Relation.Kind.MANY_TO_MANY || kind == Relation.Kind.ONE_TO_ONE && this.getAnnotationMetadata().stringValue(Relation.class, "mappedBy").isPresent();
    }
}

