/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.data.model.DefaultPageable;
import io.micronaut.data.model.Sort;
import java.util.List;

@Introspected
@JsonIgnoreProperties(ignoreUnknown=true)
public interface Pageable
extends Sort {
    public static final Pageable UNPAGED = new Pageable(){

        @Override
        public int getNumber() {
            return 0;
        }

        @Override
        public int getSize() {
            return 0;
        }
    };

    public int getNumber();

    public int getSize();

    default public long getOffset() {
        return (long)this.getNumber() * (long)this.getSize();
    }

    @NonNull
    default public Sort getSort() {
        return Sort.unsorted();
    }

    @NonNull
    default public Pageable next() {
        int size = this.getSize();
        int newNumber = this.getNumber() + 1;
        if (newNumber < 0) {
            return Pageable.from(0, size, this.getSort());
        }
        return Pageable.from(newNumber, size, this.getSort());
    }

    @NonNull
    default public Pageable previous() {
        int size = this.getSize();
        int newNumber = this.getNumber() - size;
        if (newNumber < 0) {
            return Pageable.from(0, size, this.getSort());
        }
        return Pageable.from(newNumber, size, this.getSort());
    }

    @Override
    @NonNull
    default public Pageable order(@NonNull String propertyName) {
        Sort newSort = this.getSort().order(propertyName);
        return Pageable.from(this.getNumber(), this.getSize(), newSort);
    }

    @Override
    default public boolean isSorted() {
        return this.getSort().isSorted();
    }

    @Override
    @NonNull
    default public Pageable order(@NonNull Sort.Order order) {
        Sort newSort = this.getSort().order(order);
        return Pageable.from(this.getNumber(), this.getSize(), newSort);
    }

    @Override
    @NonNull
    default public Pageable order(@NonNull String propertyName, @NonNull Sort.Order.Direction direction) {
        Sort newSort = this.getSort().order(propertyName, direction);
        return Pageable.from(this.getNumber(), this.getSize(), newSort);
    }

    @Override
    @NonNull
    default public List<Sort.Order> getOrderBy() {
        return this.getSort().getOrderBy();
    }

    @NonNull
    public static Pageable from(int page) {
        return new DefaultPageable(page, 10, null);
    }

    @NonNull
    public static Pageable from(int page, int size) {
        return new DefaultPageable(page, size, null);
    }

    @JsonCreator
    @NonNull
    public static Pageable from(@JsonProperty(value="number") int page, @JsonProperty(value="size") int size, @JsonProperty(value="sort") @Nullable Sort sort) {
        return new DefaultPageable(page, size, sort);
    }

    @NonNull
    public static Pageable unpaged() {
        return UNPAGED;
    }
}

