/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jpa.repository.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.ReturnType;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.jpa.operations.JpaRepositoryOperations;
import io.micronaut.data.jpa.repository.criteria.Specification;
import io.micronaut.data.jpa.repository.intercept.AbstractSpecificationInterceptor;
import io.micronaut.data.operations.RepositoryOperations;
import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;

@Internal
public class DeleteSpecificationInterceptor
extends AbstractSpecificationInterceptor<Object, Number> {
    private final JpaRepositoryOperations jpaOperations;

    public DeleteSpecificationInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
        JpaRepositoryOperations jpaRepositoryOperations;
        if (!(operations instanceof JpaRepositoryOperations)) {
            throw new IllegalStateException("Repository operations must be na instance of JpaRepositoryOperations");
        }
        this.jpaOperations = jpaRepositoryOperations = (JpaRepositoryOperations)operations;
    }

    public Number intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Number> context) {
        EntityManager entityManager;
        CriteriaBuilder criteriaBuilder;
        CriteriaDelete criteriaDelete;
        Root root;
        Specification specification = this.getSpecification(context);
        Predicate predicate = specification.toPredicate(root = (criteriaDelete = (criteriaBuilder = (entityManager = this.jpaOperations.getCurrentEntityManager()).getCriteriaBuilder()).createCriteriaDelete(this.getRequiredRootEntity(context))).from(this.getRequiredRootEntity(context)), null, criteriaBuilder);
        if (predicate != null) {
            criteriaDelete.where((Expression)predicate);
        }
        int result = entityManager.createQuery(criteriaDelete).executeUpdate();
        ReturnType rt = context.getReturnType();
        Class returnType = rt.getType();
        if (returnType.isInstance(result)) {
            return result;
        }
        return (Number)this.operations.getConversionService().convertRequired((Object)result, rt.asArgument());
    }
}

