/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.runtime;

import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.jdbc.runtime.ConnectionCallback;
import io.micronaut.data.jdbc.runtime.PreparedStatementCallback;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface JdbcOperations {
    public @NonNull DataSource getDataSource();

    public @NonNull Connection getConnection();

    public <R> @NonNull R execute(@NonNull ConnectionCallback<R> var1);

    public <R> @NonNull R prepareStatement(@NonNull String var1, @NonNull PreparedStatementCallback<R> var2);

    public <T> @NonNull Stream<T> entityStream(@NonNull ResultSet var1, @Nullable String var2, @NonNull Class<T> var3);

    public <T> @NonNull Stream<T> entityStream(@NonNull ResultSet var1, @NonNull Class<T> var2);

    public <E> @NonNull E readEntity(@NonNull String var1, @NonNull ResultSet var2, @NonNull Class<E> var3) throws DataAccessException;

    default public <E> @NonNull E readEntity(@NonNull ResultSet resultSet, @NonNull Class<E> type) throws DataAccessException {
        return this.readEntity("", resultSet, type);
    }

    public <E, D> @NonNull D readDTO(@NonNull String var1, @NonNull ResultSet var2, @NonNull Class<E> var3, @NonNull Class<D> var4) throws DataAccessException;

    default public <E, D> @NonNull D readDTO(@NonNull ResultSet resultSet, @NonNull Class<E> rootEntity, @NonNull Class<D> dtoType) throws DataAccessException {
        return this.readDTO("", resultSet, rootEntity, dtoType);
    }
}

