/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.operations;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.exceptions.OptimisticLockException;
import io.micronaut.data.jdbc.operations.SqlExceptionMapper;
import io.micronaut.data.model.query.builder.sql.Dialect;
import jakarta.inject.Singleton;
import java.sql.SQLException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Singleton
@Internal
final class OracleSqlExceptionMapper
implements SqlExceptionMapper {
    private static final int JSON_VIEW_ETAG_NOT_MATCHING_ERROR = 42699;

    OracleSqlExceptionMapper() {
    }

    @Override
    public Dialect getDialect() {
        return Dialect.ORACLE;
    }

    @Override
    public @Nullable DataAccessException mapSqlException(@NonNull SQLException sqlException) {
        if (sqlException.getErrorCode() == 42699) {
            return new OptimisticLockException("ETAG did not match when updating record: " + sqlException.getMessage(), (Throwable)sqlException);
        }
        return null;
    }
}

