/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.mapper;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.data.runtime.mapper.sql.SqlJsonColumnReader;
import io.micronaut.data.runtime.mapper.sql.SqlJsonValueMapper;
import io.micronaut.data.runtime.operations.internal.sql.SqlPreparedQuery;
import io.micronaut.data.runtime.operations.internal.sql.SqlStoredQuery;
import io.micronaut.json.JsonMapper;
import io.micronaut.serde.oracle.jdbc.json.OracleJdbcJsonBinaryObjectMapper;
import io.micronaut.serde.oracle.jdbc.json.OracleJdbcJsonTextObjectMapper;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.sql.ResultSet;
import oracle.sql.json.OracleJsonParser;
import org.jspecify.annotations.Nullable;

@Singleton
@Requires(classes={OracleJdbcJsonBinaryObjectMapper.class, OracleJdbcJsonTextObjectMapper.class})
@Internal
final class OracleJdbcJsonColumnMapper
implements SqlJsonColumnReader<ResultSet>,
SqlJsonValueMapper {
    private final OracleJdbcJsonBinaryObjectMapper binaryObjectMapper;
    private final OracleJdbcJsonTextObjectMapper textObjectMapper;

    OracleJdbcJsonColumnMapper(OracleJdbcJsonBinaryObjectMapper binaryObjectMapper, OracleJdbcJsonTextObjectMapper textObjectMapper) {
        this.binaryObjectMapper = binaryObjectMapper;
        this.textObjectMapper = textObjectMapper;
    }

    public <T> @Nullable T readJsonColumn(ResultReader<ResultSet, String> resultReader, ResultSet resultSet, String columnName, JsonDataType jsonDataType, Argument<T> argument) {
        try {
            switch (jsonDataType) {
                case DEFAULT: {
                    OracleJsonParser jsonParser = resultSet.getObject(columnName, OracleJsonParser.class);
                    if (jsonParser == null) {
                        return null;
                    }
                    return (T)this.binaryObjectMapper.readValue(jsonParser, argument);
                }
                case BLOB: {
                    byte[] bytes = resultSet.getBytes(columnName);
                    if (bytes == null) {
                        return null;
                    }
                    return (T)this.textObjectMapper.readValue(bytes, argument);
                }
                case STRING: {
                    String data = resultReader.readString((Object)resultSet, (Object)columnName);
                    if (data == null || data.isEmpty() || data.equals("null")) {
                        return null;
                    }
                    if (argument.getType().equals(String.class)) {
                        return (T)data;
                    }
                    return (T)this.textObjectMapper.readValue(data, argument);
                }
            }
            throw new DataAccessException("Unexpected json type " + String.valueOf(jsonDataType) + " for JSON field [" + columnName + "]");
        }
        catch (Exception e) {
            throw new DataAccessException("Failed to read from JSON field [" + columnName + "].", (Throwable)e);
        }
    }

    public JsonMapper getJsonMapper() {
        return this.textObjectMapper;
    }

    public boolean supportsRead(SqlPreparedQuery<?, ?> sqlPreparedQuery) {
        return sqlPreparedQuery.getDialect() == Dialect.ORACLE;
    }

    public boolean supportsResultSetType(Class<ResultSet> resultSetType) {
        return ResultSet.class.isAssignableFrom(resultSetType);
    }

    public Object mapValue(Object object, JsonDataType jsonDataType) throws IOException {
        if (jsonDataType == JsonDataType.STRING) {
            return this.textObjectMapper.writeValueAsString(object);
        }
        if (jsonDataType == JsonDataType.BLOB) {
            return this.textObjectMapper.writeValueAsBytes(object);
        }
        return this.binaryObjectMapper.writeValueAsBytes(object);
    }

    public boolean supportsMapValue(SqlStoredQuery<?, ?> sqlStoredQuery, JsonDataType jsonDataType) {
        return sqlStoredQuery.getDialect() == Dialect.ORACLE;
    }
}

