/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.mapper;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import jakarta.persistence.Tuple;
import jakarta.persistence.TupleElement;
import java.util.List;
import java.util.Map;

@Internal
final class JdbcTuple
implements Tuple {
    private final ConversionService conversionService;
    private final Object[] values;
    private final Map<String, Integer> aliasToPosition;

    public JdbcTuple(ConversionService conversionService, Object[] values, Map<String, Integer> aliasToPosition) {
        this.conversionService = conversionService;
        this.values = values;
        this.aliasToPosition = aliasToPosition;
    }

    public <X> X get(TupleElement<X> tupleElement) {
        throw new UnsupportedOperationException();
    }

    public <X> X get(String alias, Class<X> type) {
        Object converted = this.conversionService.convertRequired(this.get(alias), type);
        if (converted == null) {
            throw new IllegalArgumentException("Cannot be converted to type: " + String.valueOf(type) + " for alias: " + alias);
        }
        return (X)converted;
    }

    public Object get(String alias) {
        Integer index = this.aliasToPosition.get(alias);
        if (index == null) {
            throw new IllegalArgumentException("No column found for alias: " + alias);
        }
        return this.get(index);
    }

    public <X> X get(int i, Class<X> type) {
        Object converted = this.conversionService.convertRequired(this.get(i), type);
        if (converted == null) {
            throw new IllegalArgumentException("Cannot be converted to type: " + String.valueOf(type) + " at index: " + i);
        }
        return (X)converted;
    }

    public Object get(int i) {
        return this.values[i];
    }

    public Object[] toArray() {
        return this.values;
    }

    public List<TupleElement<?>> getElements() {
        throw new UnsupportedOperationException();
    }
}

