/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.mapper;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.jdbc.config.DataJdbcConfiguration;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.mapper.QueryStatement;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import org.jspecify.annotations.Nullable;

public class JdbcQueryStatement
implements QueryStatement<PreparedStatement, Integer> {
    private final ConversionService conversionService;
    private final DataJdbcConfiguration jdbcConfiguration;

    public JdbcQueryStatement(DataConversionService conversionService) {
        this(conversionService, new DataJdbcConfiguration("default"));
    }

    public JdbcQueryStatement(DataConversionService conversionService, DataJdbcConfiguration jdbcConfiguration) {
        this.conversionService = conversionService;
        this.jdbcConfiguration = jdbcConfiguration;
    }

    @Internal
    public static int findSqlType(DataType dataType, Dialect dialect) {
        return switch (dataType) {
            case DataType.LONG -> -5;
            case DataType.STRING, DataType.JSON -> 12;
            case DataType.DATE -> 91;
            case DataType.BOOLEAN -> {
                if (dialect == Dialect.ORACLE) {
                    yield -7;
                }
                yield 16;
            }
            case DataType.INTEGER -> 4;
            case DataType.TIMESTAMP -> 93;
            case DataType.TIME -> 92;
            case DataType.OBJECT -> 1111;
            case DataType.CHARACTER -> 1;
            case DataType.DOUBLE -> 8;
            case DataType.BYTE_ARRAY -> -2;
            case DataType.FLOAT -> 6;
            case DataType.BIGDECIMAL -> 3;
            case DataType.BYTE -> -7;
            case DataType.SHORT -> -6;
            default -> -1;
        };
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public QueryStatement<PreparedStatement, Integer> setDynamic(PreparedStatement statement, Integer index, DataType dataType, @Nullable Object value) {
        if (value == null) {
            try {
                switch (dataType) {
                    case ENTITY: {
                        throw new IllegalStateException("Cannot set null value as ENTITY data type!");
                    }
                    case UUID: {
                        statement.setNull(index, 1111, "uuid");
                        return this;
                    }
                }
                int sqlType = JdbcQueryStatement.findSqlType(dataType, this.jdbcConfiguration.getDialect());
                if (sqlType != -1) {
                    statement.setNull(index, sqlType);
                } else if (dataType.isArray()) {
                    statement.setNull(index, 2003);
                } else {
                    statement.setNull(index, 0);
                }
                return this;
            }
            catch (SQLException e) {
                throw new DataAccessException("Error setting JDBC null value: " + e.getMessage(), (Throwable)e);
            }
        }
        return super.setDynamic((Object)statement, (Object)index, dataType, value);
    }

    public QueryStatement<PreparedStatement, Integer> setTimestamp(PreparedStatement statement, Integer name, @Nullable Instant instant) {
        try {
            if (instant == null) {
                statement.setNull(name, 93);
            } else {
                statement.setTimestamp(name, Timestamp.from(instant));
            }
        }
        catch (SQLException e) {
            throw this.newDataAccessException(e);
        }
        return this;
    }

    public QueryStatement<PreparedStatement, Integer> setTime(PreparedStatement statement, Integer name, @Nullable Time instant) {
        try {
            if (instant == null) {
                statement.setNull(name, 92);
            } else {
                statement.setTime(name, instant);
            }
        }
        catch (SQLException e) {
            throw this.newDataAccessException(e);
        }
        return this;
    }

    public QueryStatement<PreparedStatement, Integer> setValue(PreparedStatement statement, Integer index, @Nullable Object value) throws DataAccessException {
        try {
            if (value instanceof Clob) {
                Clob clob = (Clob)value;
                statement.setClob((int)index, clob);
            } else if (value instanceof Blob) {
                Blob blob = (Blob)value;
                statement.setBlob((int)index, blob);
            } else if (value instanceof Array) {
                Array array = (Array)value;
                statement.setArray(index, array);
            } else {
                if (value == null) {
                    throw new DataAccessException("Cannot set null value");
                }
                if (value.getClass().isEnum()) {
                    statement.setObject((int)index, value, 1111);
                } else {
                    statement.setObject(index, value);
                }
            }
        }
        catch (SQLException e) {
            throw this.newDataAccessException(e);
        }
        return this;
    }

    public QueryStatement<PreparedStatement, Integer> setLong(PreparedStatement statement, Integer name, @Nullable Long value) {
        try {
            if (value == null) {
                statement.setNull(name, -5);
            } else {
                statement.setLong(name, value);
            }
        }
        catch (SQLException e) {
            throw this.newDataAccessException(e);
        }
        return this;
    }

    public QueryStatement<PreparedStatement, Integer> setChar(PreparedStatement statement, Integer name, @Nullable Character value) {
        try {
            if (value == null) {
                statement.setNull(name, 1);
            } else {
                statement.setString(name, String.valueOf(value));
            }
        }
        catch (SQLException e) {
            throw this.newDataAccessException(e);
        }
        return this;
    }

    public QueryStatement<PreparedStatement, Integer> setDate(PreparedStatement statement, Integer name, @Nullable java.util.Date date) {
        try {
            if (date == null) {
                statement.setNull(name, 91);
            } else {
                statement.setDate(name, new Date(date.getTime()));
            }
        }
        catch (SQLException e) {
            throw this.newDataAccessException(e);
        }
        return this;
    }

    public QueryStatement<PreparedStatement, Integer> setString(PreparedStatement statement, Integer name, @Nullable String string) {
        try {
            if (string == null) {
                statement.setNull(name, 12);
            } else {
                statement.setString(name, string);
            }
        }
        catch (SQLException e) {
            throw this.newDataAccessException(e);
        }
        return this;
    }

    public QueryStatement<PreparedStatement, Integer> setInt(PreparedStatement statement, Integer name, @Nullable Integer integer) {
        try {
            if (integer == null) {
                statement.setNull(name, 4);
            } else {
                statement.setInt(name, integer);
            }
        }
        catch (SQLException e) {
            throw this.newDataAccessException(e);
        }
        return this;
    }

    public QueryStatement<PreparedStatement, Integer> setBoolean(PreparedStatement statement, Integer name, @Nullable Boolean bool) {
        try {
            if (bool == null) {
                statement.setNull(name, 16);
            } else {
                statement.setBoolean(name, bool);
            }
        }
        catch (SQLException e) {
            throw this.newDataAccessException(e);
        }
        return this;
    }

    public QueryStatement<PreparedStatement, Integer> setFloat(PreparedStatement statement, Integer name, @Nullable Float f) {
        try {
            if (f == null) {
                statement.setNull(name, 6);
            } else {
                statement.setFloat(name, f.floatValue());
            }
        }
        catch (SQLException e) {
            throw this.newDataAccessException(e);
        }
        return this;
    }

    public QueryStatement<PreparedStatement, Integer> setByte(PreparedStatement statement, Integer name, @Nullable Byte b) {
        try {
            if (b == null) {
                statement.setNull(name, -7);
            } else {
                statement.setByte(name, b);
            }
        }
        catch (SQLException e) {
            throw this.newDataAccessException(e);
        }
        return this;
    }

    public QueryStatement<PreparedStatement, Integer> setShort(PreparedStatement statement, Integer name, @Nullable Short s) {
        try {
            if (s == null) {
                statement.setNull(name, -6);
            } else {
                statement.setShort(name, s);
            }
        }
        catch (SQLException e) {
            throw this.newDataAccessException(e);
        }
        return this;
    }

    public QueryStatement<PreparedStatement, Integer> setDouble(PreparedStatement statement, Integer name, @Nullable Double d) {
        try {
            if (d == null) {
                statement.setNull(name, 8);
            } else {
                statement.setDouble(name, d);
            }
        }
        catch (SQLException e) {
            throw this.newDataAccessException(e);
        }
        return this;
    }

    public QueryStatement<PreparedStatement, Integer> setBigDecimal(PreparedStatement statement, Integer name, @Nullable BigDecimal bd) {
        try {
            statement.setBigDecimal(name, bd);
        }
        catch (SQLException e) {
            throw this.newDataAccessException(e);
        }
        return this;
    }

    public QueryStatement<PreparedStatement, Integer> setBytes(PreparedStatement statement, Integer name, byte @Nullable [] bytes) {
        try {
            statement.setBytes(name, bytes);
        }
        catch (SQLException e) {
            throw this.newDataAccessException(e);
        }
        return this;
    }

    public QueryStatement<PreparedStatement, Integer> setArray(PreparedStatement statement, Integer name, @Nullable Object array) {
        try {
            if (array == null) {
                statement.setNull(name, 2003);
            } else if (array instanceof Array) {
                Array array1 = (Array)array;
                statement.setArray(name, array1);
            } else {
                statement.setObject(name, array);
            }
        }
        catch (SQLException e) {
            throw this.newDataAccessException(e);
        }
        return this;
    }

    private DataAccessException newDataAccessException(SQLException e) {
        return new DataAccessException("Unable to set PreparedStatement value: " + e.getMessage(), (Throwable)e);
    }
}

