/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.mapper;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.jdbc.mapper.ColumnNameResultSetReader;
import io.micronaut.data.model.DataType;
import io.micronaut.data.runtime.mapper.AbstractDelegatingResultReader;
import io.micronaut.data.runtime.mapper.ResultReader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Set;
import org.jspecify.annotations.Nullable;

@Internal
public class ColumnNameExistenceAwareResultSetReader
extends AbstractDelegatingResultReader<ResultSet, String> {
    private @Nullable Set<String> knownColumns;

    public ColumnNameExistenceAwareResultSetReader() {
        super((ResultReader)new ColumnNameResultSetReader());
    }

    public @Nullable Object readDynamic(ResultSet resultSet, String index, DataType dataType) {
        if (!this.containsColumnName(resultSet, index)) {
            return null;
        }
        return super.readDynamic((Object)resultSet, (Object)index, dataType);
    }

    private boolean containsColumnName(ResultSet resultSet, String name) {
        if (this.knownColumns == null) {
            try {
                ResultSetMetaData rsmd = resultSet.getMetaData();
                int columnsCount = rsmd.getColumnCount();
                this.knownColumns = CollectionUtils.newHashSet((int)columnsCount);
                for (int x = 1; x <= columnsCount; ++x) {
                    String columnLabel = rsmd.getColumnLabel(x);
                    if (columnLabel == null) continue;
                    this.knownColumns.add(columnLabel.toLowerCase());
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return this.knownColumns.contains(name.toLowerCase());
    }
}

