/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.mapper;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.DataType;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.mapper.ResultReader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Date;
import org.jspecify.annotations.Nullable;

@Internal
public final class ColumnNameCallableResultReader
implements ResultReader<CallableStatement, String> {
    private final ConversionService conversionService;

    public ColumnNameCallableResultReader(DataConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public @Nullable Object readDynamic(CallableStatement cs, String index, DataType dataType) {
        Object val = super.readDynamic((Object)cs, (Object)index, dataType);
        try {
            return cs.wasNull() ? null : val;
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public boolean next(CallableStatement cs) {
        throw new IllegalStateException("Not supported!");
    }

    public <T> T convertRequired(Object value, Class<T> type) {
        Class wrapperType = ReflectionUtils.getWrapperType(type);
        if (wrapperType.isInstance(value)) {
            return (T)value;
        }
        return this.conversionService.convert(value, type).orElseThrow(() -> new DataAccessException("Cannot convert type [" + String.valueOf(value.getClass()) + "] with value [" + String.valueOf(value) + "] to target type: " + String.valueOf(type) + ". Consider defining a TypeConverter bean to handle this case."));
    }

    public @Nullable Date readTimestamp(CallableStatement cs, String index) {
        try {
            return cs.getTimestamp(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public @Nullable Time readTime(CallableStatement cs, String index) {
        try {
            return cs.getTime(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public long readLong(CallableStatement cs, String name) {
        try {
            return cs.getLong(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public char readChar(CallableStatement cs, String name) {
        try {
            String strValue = cs.getString(name);
            if (StringUtils.isNotEmpty((CharSequence)strValue)) {
                return strValue.charAt(0);
            }
            return '\u0000';
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public @Nullable Date readDate(CallableStatement cs, String name) {
        try {
            return cs.getDate(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public @Nullable String readString(CallableStatement cs, String name) {
        try {
            return cs.getString(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public int readInt(CallableStatement cs, String name) {
        try {
            return cs.getInt(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public boolean readBoolean(CallableStatement cs, String name) {
        try {
            return cs.getBoolean(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public float readFloat(CallableStatement cs, String name) {
        try {
            return cs.getFloat(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public byte readByte(CallableStatement cs, String name) {
        try {
            return cs.getByte(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public short readShort(CallableStatement cs, String name) {
        try {
            return cs.getShort(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public double readDouble(CallableStatement cs, String name) {
        try {
            return cs.getDouble(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public BigDecimal readBigDecimal(CallableStatement cs, String name) {
        try {
            return cs.getBigDecimal(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public byte[] readBytes(CallableStatement cs, String name) {
        try {
            return cs.getBytes(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public <T> @Nullable T getRequiredValue(CallableStatement cs, String name, Class<T> type) throws DataAccessException {
        try {
            Object o = Blob.class.isAssignableFrom(type) ? cs.getBlob(name) : (Clob.class.isAssignableFrom(type) ? cs.getClob(name) : cs.getObject(name));
            if (o == null) {
                return null;
            }
            if (type.isInstance(o)) {
                return (T)o;
            }
            return this.convertRequired(o, type);
        }
        catch (ConversionErrorException | SQLException e) {
            throw this.exceptionForColumn(name, (Exception)e);
        }
    }

    private DataAccessException exceptionForColumn(String name, Exception e) {
        return new DataAccessException("Error reading object for name [" + name + "] from result set: " + e.getMessage(), (Throwable)e);
    }
}

