/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.mapper;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.DataType;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.mapper.ResultReader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.jspecify.annotations.Nullable;

@Internal
public final class ColumnIndexCallableResultReader
implements ResultReader<CallableStatement, Integer> {
    private final ConversionService conversionService;

    public ColumnIndexCallableResultReader(DataConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public @Nullable Object readDynamic(CallableStatement cs, Integer index, DataType dataType) {
        Object val = super.readDynamic((Object)cs, (Object)index, dataType);
        try {
            return cs.wasNull() ? null : val;
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public @Nullable Timestamp readTimestamp(CallableStatement cs, Integer index) {
        try {
            return cs.getTimestamp(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public @Nullable Time readTime(CallableStatement cs, Integer index) {
        try {
            return cs.getTime(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public long readLong(CallableStatement cs, Integer index) {
        try {
            return cs.getLong(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public char readChar(CallableStatement cs, Integer index) {
        try {
            String strValue = cs.getString(index);
            if (StringUtils.isNotEmpty((CharSequence)strValue)) {
                return strValue.charAt(0);
            }
            return '\u0000';
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public @Nullable Date readDate(CallableStatement cs, Integer index) {
        try {
            return cs.getDate(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public @Nullable String readString(CallableStatement cs, Integer index) {
        try {
            return cs.getString(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public int readInt(CallableStatement cs, Integer index) {
        try {
            return cs.getInt(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public boolean readBoolean(CallableStatement cs, Integer index) {
        try {
            return cs.getBoolean(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public float readFloat(CallableStatement cs, Integer index) {
        try {
            return cs.getFloat(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public byte readByte(CallableStatement cs, Integer index) {
        try {
            return cs.getByte(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public short readShort(CallableStatement cs, Integer index) {
        try {
            return cs.getShort(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public double readDouble(CallableStatement cs, Integer index) {
        try {
            return cs.getDouble(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public @Nullable BigDecimal readBigDecimal(CallableStatement cs, Integer index) {
        try {
            return cs.getBigDecimal(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public byte[] readBytes(CallableStatement cs, Integer index) {
        try {
            return cs.getBytes(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public <T> @Nullable T getRequiredValue(CallableStatement cs, Integer index, Class<T> type) throws DataAccessException {
        try {
            Object o = Blob.class.isAssignableFrom(type) ? cs.getBlob(index) : (Clob.class.isAssignableFrom(type) ? cs.getClob(index) : cs.getObject(index));
            if (o == null) {
                return null;
            }
            if (type.isInstance(o)) {
                return (T)o;
            }
            return (T)this.convertRequired(o, type);
        }
        catch (ConversionErrorException | SQLException e) {
            throw this.exceptionForColumn(index, (Exception)e);
        }
    }

    public boolean next(CallableStatement cs) {
        throw new IllegalStateException("Not supported!");
    }

    private DataAccessException exceptionForColumn(Integer index, Exception e) {
        return new DataAccessException("Error reading object for index [" + index + "] from result set: " + e.getMessage(), (Throwable)e);
    }
}

