/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.config;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.JsonSubView;
import io.micronaut.data.annotation.JsonView;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.connection.jdbc.advice.DelegatingDataSource;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.jdbc.config.DataJdbcConfiguration;
import io.micronaut.data.jdbc.operations.JdbcSchemaHandler;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.IdentifierNamingStrategy;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.query.builder.sql.SqlSchemaUtils;
import io.micronaut.data.model.query.builder.sql.validation.SchemaValidationException;
import io.micronaut.data.model.query.builder.sql.validation.SqlTableMappingValidator;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.schema.sql.SqlTableMapping;
import io.micronaut.data.model.schema.sql.metadata.SqlColumnMetadata;
import io.micronaut.data.model.schema.sql.metadata.SqlTableMetadata;
import io.micronaut.data.runtime.config.DataSettings;
import io.micronaut.data.runtime.config.SchemaGenerate;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Context
@Internal
public class SchemaGenerator {
    private static final String MATCH_ALL = "%";
    private static final Logger LOG = LoggerFactory.getLogger(SchemaGenerator.class);
    private final List<DataJdbcConfiguration> configurations;
    private final JdbcSchemaHandler schemaHandler;
    private final Map<Dialect, SqlTableMappingValidator> dialectSqlTableMappingValidatorMap;
    private final PropertyPlaceholderResolver propertyPlaceholderResolver;

    public SchemaGenerator(List<DataJdbcConfiguration> configurations, JdbcSchemaHandler schemaHandler, List<SqlTableMappingValidator> sqlTableMappingValidators, Environment environment) {
        this.configurations = configurations == null ? Collections.emptyList() : configurations;
        this.schemaHandler = schemaHandler;
        this.propertyPlaceholderResolver = environment.getPlaceholderResolver();
        this.dialectSqlTableMappingValidatorMap = CollectionUtils.newHashMap((int)sqlTableMappingValidators.size());
        for (SqlTableMappingValidator sqlTableMappingValidator : sqlTableMappingValidators) {
            Dialect dialect = sqlTableMappingValidator.getSupportedDialect();
            if (this.dialectSqlTableMappingValidatorMap.containsKey(dialect)) {
                throw new IllegalStateException("More than one SqlTableMappingValidator is declared for dialect " + String.valueOf(dialect));
            }
            this.dialectSqlTableMappingValidatorMap.put(dialect, sqlTableMappingValidator);
        }
    }

    @PostConstruct
    public void createOrValidateSchema(BeanLocator beanLocator) {
        RuntimeEntityRegistry runtimeEntityRegistry = (RuntimeEntityRegistry)beanLocator.getBean(RuntimeEntityRegistry.class);
        for (DataJdbcConfiguration configuration : this.configurations) {
            boolean enabled = configuration.isEnabled();
            SchemaGenerate schemaGenerate = configuration.getSchemaGenerate();
            if (!enabled || schemaGenerate == null || schemaGenerate == SchemaGenerate.NONE) {
                if (enabled || !LOG.isDebugEnabled()) continue;
                LOG.debug("The datasource [{}] is disabled, skipping schema generator.", (Object)configuration.getName());
                continue;
            }
            Dialect dialect = configuration.getDialect();
            String name = configuration.getName();
            List<String> packages = configuration.getPackages();
            Collection introspections = CollectionUtils.isNotEmpty(packages) ? BeanIntrospector.SHARED.findIntrospections(MappedEntity.class, packages.toArray(new String[0])) : BeanIntrospector.SHARED.findIntrospections(MappedEntity.class);
            Object[] entities = (PersistentEntity[])introspections.stream().filter(i -> !i.getBeanType().getName().contains("$")).filter(i -> !Modifier.isAbstract(i.getBeanType().getModifiers())).filter(i -> !i.hasAnnotation(JsonSubView.class)).sorted(Comparator.comparing(i -> i.hasAnnotation(JsonView.class))).map(beanIntrospection -> runtimeEntityRegistry.getEntity(beanIntrospection.getBeanType())).toArray(PersistentEntity[]::new);
            if (!ArrayUtils.isNotEmpty((Object[])entities)) continue;
            DataSource dataSource = DelegatingDataSource.unwrapDataSource((DataSource)((DataSource)beanLocator.getBean(DataSource.class, Qualifiers.byName((String)name))));
            try {
                try {
                    Connection connection = dataSource.getConnection();
                    try {
                        if (configuration.getSchemaGenerateNames() != null && !configuration.getSchemaGenerateNames().isEmpty()) {
                            for (String schemaName : configuration.getSchemaGenerateNames()) {
                                if (schemaGenerate != SchemaGenerate.VALIDATE) {
                                    this.schemaHandler.createSchema(connection, dialect, schemaName);
                                }
                                this.schemaHandler.useSchema(connection, dialect, schemaName);
                                if (schemaGenerate == SchemaGenerate.VALIDATE) {
                                    SchemaGenerator.validate(connection, configuration, (PersistentEntity[])entities, this.dialectSqlTableMappingValidatorMap);
                                    continue;
                                }
                                SchemaGenerator.generate(connection, configuration, this.propertyPlaceholderResolver, (PersistentEntity[])entities);
                            }
                            continue;
                        }
                        if (configuration.getSchemaGenerateName() != null) {
                            if (schemaGenerate != SchemaGenerate.VALIDATE) {
                                this.schemaHandler.createSchema(connection, dialect, configuration.getSchemaGenerateName());
                            }
                            this.schemaHandler.useSchema(connection, dialect, configuration.getSchemaGenerateName());
                        }
                        if (schemaGenerate == SchemaGenerate.VALIDATE) {
                            SchemaGenerator.validate(connection, configuration, (PersistentEntity[])entities, this.dialectSqlTableMappingValidatorMap);
                            continue;
                        }
                        SchemaGenerator.generate(connection, configuration, this.propertyPlaceholderResolver, (PersistentEntity[])entities);
                    }
                    finally {
                        if (connection == null) continue;
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    throw new DataAccessException("Unable to create database schema: " + e.getMessage(), (Throwable)e);
                }
            }
            catch (NoSuchBeanException e) {
                throw new ConfigurationException("No DataSource configured for setting [datasources" + name + "]. Ensure the DataSource is configured correctly and try again.", (Throwable)e);
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static void generate(Connection connection, DataJdbcConfiguration configuration, PropertyPlaceholderResolver propertyPlaceholderResolver, PersistentEntity[] entities) throws SQLException {
        block45: {
            block46: {
                dialect = configuration.getDialect();
                builder = new SqlQueryBuilder(dialect);
                if (!dialect.allowBatch() || !configuration.isBatchGenerate()) break block46;
                switch (1.$SwitchMap$io$micronaut$data$runtime$config$SchemaGenerate[configuration.getSchemaGenerate().ordinal()]) {
                    case 1: {
                        try {
                            sql = SchemaGenerator.resolveSql(propertyPlaceholderResolver, builder.buildBatchDropTableStatement(entities));
                            if (DataSettings.QUERY_LOG.isDebugEnabled()) {
                                DataSettings.QUERY_LOG.debug("Dropping Tables: \n{}", (Object)sql);
                            }
                            ps = connection.prepareStatement(sql);
                            try {
                                ps.executeUpdate();
                            }
                            finally {
                                if (ps != null) {
                                    ps.close();
                                }
                            }
                        }
                        catch (SQLException e) {
                            if (!DataSettings.QUERY_LOG.isTraceEnabled()) ** GOTO lbl22
                            DataSettings.QUERY_LOG.trace("Drop Unsuccessful: " + e.getMessage());
                        }
                    }
lbl22:
                    // 4 sources

                    case 2: {
                        sql = SchemaGenerator.resolveSql(propertyPlaceholderResolver, builder.buildBatchCreateTableStatement(entities));
                        if (DataSettings.QUERY_LOG.isDebugEnabled()) {
                            DataSettings.QUERY_LOG.debug("Creating Tables: \n{}", (Object)sql);
                        }
                        ps = connection.prepareStatement(sql);
                        try {
                            ps.executeUpdate();
                            break block45;
                        }
                        finally {
                            if (ps != null) {
                                ps.close();
                            }
                        }
                    }
                }
                break block45;
            }
            switch (1.$SwitchMap$io$micronaut$data$runtime$config$SchemaGenerate[configuration.getSchemaGenerate().ordinal()]) {
                case 1: {
                    sql /* !! */  = entities;
                    var7_10 = sql /* !! */ .length;
                    for (var8_14 = 0; var8_14 < var7_10; ++var8_14) {
                        entity = sql /* !! */ [var8_14];
                        try {
                            for (String sql : statements = builder.buildDropTableStatements(entity)) {
                                sql = SchemaGenerator.resolveSql(propertyPlaceholderResolver, sql);
                                if (DataSettings.QUERY_LOG.isDebugEnabled()) {
                                    DataSettings.QUERY_LOG.debug("Dropping Table: \n{}", (Object)sql);
                                }
                                ps = connection.prepareStatement(sql);
                                try {
                                    ps.executeUpdate();
                                }
                                finally {
                                    if (ps != null) {
                                        ps.close();
                                    }
                                }
                            }
                            continue;
                        }
                        catch (SQLException e) {
                            if (!DataSettings.QUERY_LOG.isTraceEnabled()) continue;
                            DataSettings.QUERY_LOG.trace("Drop Unsuccessful: " + e.getMessage());
                        }
                    }
                }
                case 2: {
                    for (PersistentEntity stmt : sql /* !! */  = builder.buildCreateTableStatements(entities)) {
                        stmt /* !! */  = SchemaGenerator.resolveSql(propertyPlaceholderResolver, (String)stmt /* !! */ );
                        if (DataSettings.QUERY_LOG.isDebugEnabled()) {
                            DataSettings.QUERY_LOG.debug("Executing CREATE statement: \n{}", (Object)stmt /* !! */ );
                        }
                        try {
                            ps = connection.prepareStatement((String)stmt /* !! */ );
                            try {
                                ps.executeUpdate();
                            }
                            finally {
                                if (ps != null) {
                                    ps.close();
                                }
                            }
                        }
                        catch (SQLException e) {
                            if (!DataSettings.QUERY_LOG.isWarnEnabled()) continue;
                            DataSettings.QUERY_LOG.warn("CREATE Statement Unsuccessful: " + e.getMessage());
                        }
                    }
                    break;
                }
            }
        }
    }

    private static void validate(Connection connection, DataJdbcConfiguration configuration, PersistentEntity[] entities, Map<Dialect, SqlTableMappingValidator> dialectSqlTableMappingValidatorMap) throws SQLException {
        Dialect dialect = configuration.getDialect();
        SqlTableMappingValidator sqlTableMappingValidator = dialectSqlTableMappingValidatorMap.get(dialect);
        if (sqlTableMappingValidator == null) {
            throw new IllegalStateException("There is no supported SqlTableMappingValidator for dialect " + String.valueOf(dialect));
        }
        LinkedHashMap sqlTableMappingByTableName = CollectionUtils.newLinkedHashMap((int)entities.length);
        for (PersistentEntity entity : entities) {
            if (entity.getAnnotationMetadata().hasAnnotation(JsonView.class)) continue;
            List sqlTableMappings = SqlSchemaUtils.getSqlTableMappings((PersistentEntity)entity);
            for (SqlTableMapping sqlTableMapping : sqlTableMappings) {
                String tableName = sqlTableMapping.name();
                String tableNameLowerCase = tableName.toLowerCase();
                if (sqlTableMappingByTableName.containsKey(tableNameLowerCase)) {
                    SqlTableMapping existingSqlTableMapping = (SqlTableMapping)sqlTableMappingByTableName.get(tableNameLowerCase);
                    if (existingSqlTableMapping.type() == SqlTableMapping.TableType.JOIN) {
                        sqlTableMappingByTableName.remove(tableNameLowerCase);
                    } else if (sqlTableMapping.type() == SqlTableMapping.TableType.JOIN) continue;
                }
                sqlTableMappingByTableName.put(tableNameLowerCase, sqlTableMapping);
            }
        }
        Map<String, SqlTableMetadata> dbSqlTableMetadataMap = SchemaGenerator.getDbSqlTableMetadataList(connection, sqlTableMappingByTableName.keySet());
        for (Map.Entry sqlTableMappingEntry : sqlTableMappingByTableName.entrySet()) {
            String tableNameLowerCase = (String)sqlTableMappingEntry.getKey();
            SqlTableMapping sqlTableMapping = (SqlTableMapping)sqlTableMappingEntry.getValue();
            SqlTableMetadata dbSqlTableMetadata = dbSqlTableMetadataMap.get(tableNameLowerCase);
            if (dbSqlTableMetadata == null) {
                throw new SchemaValidationException("Schema validation failed. Expected table [" + sqlTableMapping.name() + "] not found");
            }
            sqlTableMappingValidator.validateTable(sqlTableMapping, dbSqlTableMetadata);
        }
    }

    private static Map<String, SqlTableMetadata> getDbSqlTableMetadataList(Connection connection, Set<String> wantedTableNames) throws SQLException {
        HashMap sqlTableMetadataList = CollectionUtils.newHashMap((int)50);
        String catalog = connection.getCatalog();
        String schema = connection.getSchema();
        String[] tableTypes = new String[]{"TABLE"};
        DatabaseMetaData metaData = connection.getMetaData();
        IdentifierNamingStrategy namingStrategy = SchemaGenerator.getIdentifierNamingStrategy(metaData);
        catalog = namingStrategy.apply(catalog);
        schema = namingStrategy.apply(schema);
        ResultSet tablesResultSet = metaData.getTables(catalog, schema, MATCH_ALL, tableTypes);
        while (tablesResultSet.next()) {
            String tableName = tablesResultSet.getString("TABLE_NAME");
            String tableNameLowerCase = tableName.toLowerCase();
            if (!wantedTableNames.contains(tableNameLowerCase)) continue;
            String tableCatalog = tablesResultSet.getString("TABLE_CAT");
            String tableSchema = tablesResultSet.getString("TABLE_SCHEM");
            SqlTableMetadata sqlTableMetadata = new SqlTableMetadata(tableCatalog, tableSchema, tableName);
            sqlTableMetadataList.put(tableNameLowerCase, sqlTableMetadata);
        }
        SchemaGenerator.populateSqlColumnMetadata(metaData, catalog, schema, sqlTableMetadataList);
        return sqlTableMetadataList;
    }

    private static void populateSqlColumnMetadata(DatabaseMetaData metaData, String catalog, String schema, Map<String, SqlTableMetadata> sqlTableMetadataMap) throws SQLException {
        ResultSet columnsResultSet = metaData.getColumns(catalog, schema, null, MATCH_ALL);
        SqlTableMetadata sqlTableMetadata = null;
        String currentTableName = "";
        while (columnsResultSet.next()) {
            String tableName = columnsResultSet.getString("TABLE_NAME").toLowerCase();
            if (!sqlTableMetadataMap.containsKey(tableName)) continue;
            if (!currentTableName.equals(tableName)) {
                currentTableName = tableName;
                sqlTableMetadata = sqlTableMetadataMap.get(currentTableName);
            }
            if (sqlTableMetadata == null) continue;
            SchemaGenerator.addExtractedColumnInformation(sqlTableMetadata, columnsResultSet);
        }
    }

    private static void addExtractedColumnInformation(SqlTableMetadata sqlTableMetadata, ResultSet columnsResultSet) throws SQLException {
        String columnName = columnsResultSet.getString("COLUMN_NAME");
        int columnType = columnsResultSet.getInt("DATA_TYPE");
        String typeName = columnsResultSet.getString("TYPE_NAME");
        int columnSize = columnsResultSet.getInt("COLUMN_SIZE");
        int decimalDigits = columnsResultSet.getInt("DECIMAL_DIGITS");
        int nullable = columnsResultSet.getInt("NULLABLE");
        sqlTableMetadata.addColumn(new SqlColumnMetadata(columnName, columnType, typeName, columnSize, decimalDigits, nullable == 1));
    }

    private static IdentifierNamingStrategy getIdentifierNamingStrategy(DatabaseMetaData metaData) throws SQLException {
        if (metaData.storesUpperCaseIdentifiers()) {
            return IdentifierNamingStrategy.UPPER;
        }
        if (metaData.storesLowerCaseIdentifiers()) {
            return IdentifierNamingStrategy.LOWER;
        }
        return IdentifierNamingStrategy.MIXED;
    }

    private static String resolveSql(PropertyPlaceholderResolver propertyPlaceholderResolver, String sql) {
        if (sql.contains(propertyPlaceholderResolver.getPrefix())) {
            return propertyPlaceholderResolver.resolveRequiredPlaceholders(sql);
        }
        return sql;
    }
}

