/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.operations;

import io.micronaut.aop.InvocationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.connection.ConnectionOperations;
import io.micronaut.data.connection.annotation.Connectable;
import io.micronaut.data.connection.jdbc.advice.DelegatingDataSource;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.jdbc.config.DataJdbcConfiguration;
import io.micronaut.data.jdbc.convert.JdbcConversionContext;
import io.micronaut.data.jdbc.mapper.ColumnIndexResultSetReader;
import io.micronaut.data.jdbc.mapper.ColumnNameResultSetReader;
import io.micronaut.data.jdbc.mapper.JdbcQueryStatement;
import io.micronaut.data.jdbc.mapper.SqlResultConsumer;
import io.micronaut.data.jdbc.operations.JdbcRepositoryOperations;
import io.micronaut.data.jdbc.operations.JdbcSchemaHandler;
import io.micronaut.data.jdbc.runtime.ConnectionCallback;
import io.micronaut.data.jdbc.runtime.PreparedStatementCallback;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.EntityOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.QueryResultInfo;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.model.runtime.convert.AttributeConverter;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.convert.RuntimePersistentPropertyConversionContext;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.mapper.DTOMapper;
import io.micronaut.data.runtime.mapper.QueryStatement;
import io.micronaut.data.runtime.mapper.ResultConsumer;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.data.runtime.mapper.TypeMapper;
import io.micronaut.data.runtime.mapper.sql.SqlDTOMapper;
import io.micronaut.data.runtime.mapper.sql.SqlResultEntityTypeMapper;
import io.micronaut.data.runtime.mapper.sql.SqlTypeMapper;
import io.micronaut.data.runtime.multitenancy.SchemaTenantResolver;
import io.micronaut.data.runtime.operations.ExecutorAsyncOperations;
import io.micronaut.data.runtime.operations.ExecutorReactiveOperations;
import io.micronaut.data.runtime.operations.internal.AbstractSyncEntitiesOperations;
import io.micronaut.data.runtime.operations.internal.AbstractSyncEntityOperations;
import io.micronaut.data.runtime.operations.internal.OperationContext;
import io.micronaut.data.runtime.operations.internal.SyncCascadeOperations;
import io.micronaut.data.runtime.operations.internal.query.BindableParametersStoredQuery;
import io.micronaut.data.runtime.operations.internal.sql.AbstractSqlRepositoryOperations;
import io.micronaut.data.runtime.operations.internal.sql.SqlJsonColumnMapperProvider;
import io.micronaut.data.runtime.operations.internal.sql.SqlPreparedQuery;
import io.micronaut.data.runtime.operations.internal.sql.SqlStoredQuery;
import io.micronaut.data.runtime.support.AbstractConversionContext;
import io.micronaut.json.JsonMapper;
import io.micronaut.transaction.TransactionOperations;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Named;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.sql.DataSource;

@EachBean(value=DataSource.class)
@Internal
public final class DefaultJdbcRepositoryOperations
extends AbstractSqlRepositoryOperations<ResultSet, PreparedStatement, SQLException>
implements JdbcRepositoryOperations,
AsyncCapableRepository,
ReactiveCapableRepository,
AutoCloseable,
SyncCascadeOperations.SyncCascadeOperationsHelper<JdbcOperationContext> {
    private final ConnectionOperations<Connection> connectionOperations;
    private final TransactionOperations<Connection> transactionOperations;
    private final DataSource dataSource;
    private final DataSource unwrapedDataSource;
    private ExecutorAsyncOperations asyncOperations;
    private ExecutorService executorService;
    private final SyncCascadeOperations<JdbcOperationContext> cascadeOperations;
    private final DataJdbcConfiguration jdbcConfiguration;
    @Nullable
    private final SchemaTenantResolver schemaTenantResolver;
    private final JdbcSchemaHandler schemaHandler;

    @Internal
    protected DefaultJdbcRepositoryOperations(@Parameter String dataSourceName, @Parameter DataJdbcConfiguration jdbcConfiguration, DataSource dataSource, @Parameter ConnectionOperations<Connection> connectionOperations, @Parameter TransactionOperations<Connection> transactionOperations, @Named(value="io") @Nullable ExecutorService executorService, BeanContext beanContext, @NonNull DateTimeProvider dateTimeProvider, RuntimeEntityRegistry entityRegistry, DataConversionService conversionService, AttributeConverterRegistry attributeConverterRegistry, @Nullable SchemaTenantResolver schemaTenantResolver, JdbcSchemaHandler schemaHandler, @Nullable JsonMapper jsonMapper, SqlJsonColumnMapperProvider<ResultSet> sqlJsonColumnMapperProvider) {
        super(dataSourceName, (ResultReader)new ColumnNameResultSetReader(conversionService), (ResultReader)new ColumnIndexResultSetReader(conversionService), (QueryStatement)new JdbcQueryStatement(conversionService), dateTimeProvider, entityRegistry, beanContext, conversionService, attributeConverterRegistry, jsonMapper, sqlJsonColumnMapperProvider);
        this.schemaTenantResolver = schemaTenantResolver;
        this.schemaHandler = schemaHandler;
        this.connectionOperations = connectionOperations;
        ArgumentUtils.requireNonNull((String)"dataSource", (Object)dataSource);
        ArgumentUtils.requireNonNull((String)"transactionOperations", transactionOperations);
        this.dataSource = dataSource;
        this.unwrapedDataSource = DelegatingDataSource.unwrapDataSource((DataSource)dataSource);
        this.transactionOperations = transactionOperations;
        this.executorService = executorService;
        this.cascadeOperations = new SyncCascadeOperations((ConversionService)conversionService, (SyncCascadeOperations.SyncCascadeOperationsHelper)this);
        this.jdbcConfiguration = jdbcConfiguration;
    }

    @NonNull
    private ExecutorService newLocalThreadPool() {
        this.executorService = Executors.newCachedThreadPool();
        return this.executorService;
    }

    public <T> T persistOne(JdbcOperationContext ctx, T value, RuntimePersistentEntity<T> persistentEntity) {
        SqlStoredQuery storedQuery = this.resolveEntityInsert(ctx.annotationMetadata, ctx.repositoryType, value.getClass(), persistentEntity);
        JdbcEntityOperations<T> persistOneOp = new JdbcEntityOperations<T>(ctx, storedQuery, persistentEntity, value, true);
        persistOneOp.persist();
        return (T)persistOneOp.getEntity();
    }

    public <T> List<T> persistBatch(JdbcOperationContext ctx, Iterable<T> values, RuntimePersistentEntity<T> childPersistentEntity, Predicate<T> predicate) {
        SqlStoredQuery storedQuery = this.resolveEntityInsert(ctx.annotationMetadata, ctx.repositoryType, childPersistentEntity.getIntrospection().getBeanType(), childPersistentEntity);
        JdbcEntitiesOperations<T> persistBatchOp = new JdbcEntitiesOperations<T>(ctx, childPersistentEntity, values, storedQuery, true);
        persistBatchOp.veto(predicate);
        persistBatchOp.persist();
        return persistBatchOp.getEntities();
    }

    public <T> T updateOne(JdbcOperationContext ctx, T value, RuntimePersistentEntity<T> persistentEntity) {
        SqlStoredQuery storedQuery = this.resolveEntityUpdate(ctx.annotationMetadata, ctx.repositoryType, value.getClass(), persistentEntity);
        JdbcEntityOperations<T> op = new JdbcEntityOperations<T>(ctx, persistentEntity, value, storedQuery);
        op.update();
        return (T)op.getEntity();
    }

    public void persistManyAssociation(JdbcOperationContext ctx, RuntimeAssociation runtimeAssociation, Object value, RuntimePersistentEntity<Object> persistentEntity, Object child, RuntimePersistentEntity<Object> childPersistentEntity) {
        SqlStoredQuery storedQuery = this.resolveSqlInsertAssociation(ctx.repositoryType, runtimeAssociation, persistentEntity, value);
        try {
            new JdbcEntityOperations<Object>(ctx, childPersistentEntity, child, storedQuery).execute();
        }
        catch (Exception e) {
            throw new DataAccessException("SQL error executing INSERT: " + e.getMessage(), (Throwable)e);
        }
    }

    public void persistManyAssociationBatch(JdbcOperationContext ctx, RuntimeAssociation runtimeAssociation, Object value, RuntimePersistentEntity<Object> persistentEntity, Iterable<Object> child, RuntimePersistentEntity<Object> childPersistentEntity) {
        SqlStoredQuery storedQuery = this.resolveSqlInsertAssociation(ctx.repositoryType, runtimeAssociation, persistentEntity, value);
        try {
            JdbcEntitiesOperations<Object> assocOp = new JdbcEntitiesOperations<Object>(ctx, childPersistentEntity, child, storedQuery);
            assocOp.veto(ctx.persisted::contains);
            assocOp.execute();
        }
        catch (Exception e) {
            throw new DataAccessException("SQL error executing INSERT: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ExecutorAsyncOperations async() {
        ExecutorAsyncOperations asyncOperations = this.asyncOperations;
        if (asyncOperations == null) {
            DefaultJdbcRepositoryOperations defaultJdbcRepositoryOperations = this;
            synchronized (defaultJdbcRepositoryOperations) {
                asyncOperations = this.asyncOperations;
                if (asyncOperations == null) {
                    this.asyncOperations = asyncOperations = new ExecutorAsyncOperations((RepositoryOperations)this, (Executor)(this.executorService != null ? this.executorService : this.newLocalThreadPool()));
                }
            }
        }
        return asyncOperations;
    }

    @NonNull
    public ReactiveRepositoryOperations reactive() {
        return new ExecutorReactiveOperations(this.async(), this.conversionService);
    }

    @Nullable
    public <T, R> R findOne(@NonNull PreparedQuery<T, R> pq) {
        return (R)this.executeRead(connection -> {
            SqlPreparedQuery preparedQuery = this.getSqlPreparedQuery(pq);
            RuntimePersistentEntity persistentEntity = preparedQuery.getPersistentEntity();
            try (PreparedStatement ps = (PreparedStatement)this.prepareStatement(connection::prepareStatement, (PreparedQuery)preparedQuery, false, true);){
                preparedQuery.bindParameters((BindableParametersStoredQuery.Binder)new JdbcParameterBinder((Connection)connection, ps, (SqlStoredQuery<?, ?>)preparedQuery));
                try (ResultSet rs = ps.executeQuery();){
                    QueryResultInfo queryResultInfo;
                    Class resultType = preparedQuery.getResultType();
                    if (preparedQuery.getResultDataType() == DataType.ENTITY) {
                        RuntimePersistentEntity resultPersistentEntity = this.getEntity(resultType);
                        BiFunction<RuntimePersistentEntity, Object, Object> loadListener = (loadedEntity, o) -> {
                            if (loadedEntity.hasPostLoadEventListeners()) {
                                return this.triggerPostLoad(o, (RuntimePersistentEntity)loadedEntity, preparedQuery.getAnnotationMetadata());
                            }
                            return o;
                        };
                        QueryResultInfo queryResultInfo2 = preparedQuery.getQueryResultInfo();
                        if (this.isJsonResult((PreparedQuery)preparedQuery, queryResultInfo2)) {
                            Object object = rs.next() ? this.mapQueryColumnResult(preparedQuery, rs, this.getJsonColumn(queryResultInfo2), this.getJsonDataType(queryResultInfo2), persistentEntity, resultType, ResultSet.class, loadListener) : null;
                            return object;
                        }
                        Set joinFetchPaths = preparedQuery.getJoinFetchPaths();
                        SqlResultEntityTypeMapper mapper = new SqlResultEntityTypeMapper(resultPersistentEntity, this.columnNameResultSetReader, joinFetchPaths, this.sqlJsonColumnMapperProvider.getJsonColumnReader(preparedQuery, ResultSet.class), loadListener, this.conversionService);
                        SqlResultEntityTypeMapper.PushingMapper oneMapper = mapper.readOneWithJoins();
                        if (rs.next()) {
                            oneMapper.processRow((Object)rs);
                        }
                        while (!joinFetchPaths.isEmpty() && rs.next()) {
                            oneMapper.processRow((Object)rs);
                        }
                        Object result = oneMapper.getResult();
                        if (preparedQuery.hasResultConsumer()) {
                            preparedQuery.getParameterInRole("sqlMappingFunction", SqlResultConsumer.class).ifPresent(consumer -> consumer.accept(result, this.newMappingContext(rs)));
                        }
                        Object object = result;
                        return object;
                    }
                    if (!rs.next()) return null;
                    if (preparedQuery.isDtoProjection()) {
                        queryResultInfo = preparedQuery.getQueryResultInfo();
                        if (this.isJsonResult((PreparedQuery)preparedQuery, queryResultInfo)) {
                            String column = this.getJsonColumn(queryResultInfo);
                            JsonDataType jsonDataType = this.getJsonDataType(queryResultInfo);
                            Object object = this.mapQueryColumnResult(preparedQuery, rs, column, jsonDataType, persistentEntity, resultType, ResultSet.class, null);
                            return object;
                        }
                        boolean isRawQuery = preparedQuery.isRawQuery();
                        SqlDTOMapper introspectedDataMapper = new SqlDTOMapper(persistentEntity, isRawQuery ? this.getEntity(preparedQuery.getResultType()) : persistentEntity, this.columnNameResultSetReader, this.sqlJsonColumnMapperProvider.getJsonColumnReader(preparedQuery, ResultSet.class), this.conversionService);
                        Object object = introspectedDataMapper.map((Object)rs, resultType);
                        return object;
                    }
                    queryResultInfo = preparedQuery.getQueryResultInfo();
                    if (this.isJsonResult((PreparedQuery)preparedQuery, queryResultInfo)) {
                        String column = this.getJsonColumn(queryResultInfo);
                        JsonDataType jsonDataType = this.getJsonDataType(queryResultInfo);
                        Object object = this.mapQueryColumnResult(preparedQuery, rs, column, jsonDataType, persistentEntity, resultType, ResultSet.class, null);
                        return object;
                    }
                    Object v = this.columnIndexResultSetReader.readDynamic((Object)rs, (Object)1, preparedQuery.getResultDataType());
                    if (v == null) {
                        Object var10_23 = null;
                        return var10_23;
                    }
                    if (resultType.isInstance(v)) {
                        Object object = v;
                        return object;
                    }
                    Object object = this.columnIndexResultSetReader.convertRequired(v, resultType);
                    return object;
                }
            }
            catch (SQLException e) {
                throw new DataAccessException("Error executing SQL Query: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    public <T> boolean exists(@NonNull PreparedQuery<T, Boolean> pq) {
        return this.executeRead(connection -> {
            try {
                SqlPreparedQuery preparedQuery = this.getSqlPreparedQuery(pq);
                try (PreparedStatement ps = (PreparedStatement)this.prepareStatement(connection::prepareStatement, (PreparedQuery)preparedQuery, false, true);){
                    Boolean bl;
                    block14: {
                        preparedQuery.bindParameters((BindableParametersStoredQuery.Binder)new JdbcParameterBinder((Connection)connection, ps, (SqlStoredQuery<?, ?>)preparedQuery));
                        ResultSet rs = ps.executeQuery();
                        try {
                            bl = rs.next();
                            if (rs == null) break block14;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return bl;
                }
            }
            catch (SQLException e) {
                throw new DataAccessException("Error executing SQL query: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    @NonNull
    public <T, R> Stream<R> findStream(@NonNull PreparedQuery<T, R> preparedQuery) {
        ConnectionContext connectionContext = this.getConnectionCtx();
        return this.findStream(preparedQuery, connectionContext.connection, connectionContext.needsToBeClosed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T, R> Stream<R> findStream(@NonNull PreparedQuery<T, R> pq, final Connection connection, final boolean closeConnection) {
        PreparedStatement ps;
        final SqlPreparedQuery preparedQuery = this.getSqlPreparedQuery(pq);
        final RuntimePersistentEntity persistentEntity = preparedQuery.getPersistentEntity();
        final Class resultType = preparedQuery.getResultType();
        final AtomicBoolean finished = new AtomicBoolean();
        try {
            ps = (PreparedStatement)this.prepareStatement(connection::prepareStatement, (PreparedQuery)preparedQuery, false, false);
            preparedQuery.bindParameters((BindableParametersStoredQuery.Binder)new JdbcParameterBinder(connection, ps, (SqlStoredQuery<?, ?>)preparedQuery));
        }
        catch (Exception e) {
            throw new DataAccessException("SQL Error preparing Query: " + e.getMessage(), (Throwable)e);
        }
        ResultSet openedRs = null;
        try {
            SqlTypeMapper mapper;
            SqlResultConsumer sqlMappingConsumer;
            Spliterators.AbstractSpliterator spliterator;
            boolean isEntity;
            final ResultSet rs = openedRs = ps.executeQuery();
            boolean dtoProjection = preparedQuery.isDtoProjection();
            boolean bl = isEntity = preparedQuery.getResultDataType() == DataType.ENTITY;
            if (!isEntity && !dtoProjection) {
                final QueryResultInfo queryResultInfo = preparedQuery.getQueryResultInfo();
                spliterator = new Spliterators.AbstractSpliterator<R>(Long.MAX_VALUE, 1040){

                    @Override
                    public boolean tryAdvance(Consumer<? super R> action) {
                        if (finished.get()) {
                            return false;
                        }
                        try {
                            boolean hasNext = rs.next();
                            if (hasNext) {
                                if (DefaultJdbcRepositoryOperations.this.isJsonResult((PreparedQuery)preparedQuery, queryResultInfo)) {
                                    String column = DefaultJdbcRepositoryOperations.this.getJsonColumn(queryResultInfo);
                                    JsonDataType jsonDataType = DefaultJdbcRepositoryOperations.this.getJsonDataType(queryResultInfo);
                                    action.accept(DefaultJdbcRepositoryOperations.this.mapQueryColumnResult(preparedQuery, rs, column, jsonDataType, persistentEntity, resultType, ResultSet.class, null));
                                } else {
                                    Object r;
                                    Object v = DefaultJdbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic((Object)rs, (Object)1, preparedQuery.getResultDataType());
                                    if (resultType.isInstance(v)) {
                                        action.accept(v);
                                    } else if (v != null && (r = DefaultJdbcRepositoryOperations.this.columnIndexResultSetReader.convertRequired(v, resultType)) != null) {
                                        action.accept(r);
                                    }
                                }
                            } else {
                                DefaultJdbcRepositoryOperations.this.closeResultSet(connection, ps, rs, finished, closeConnection);
                            }
                            return hasNext;
                        }
                        catch (SQLException e) {
                            throw new DataAccessException("Error retrieving next JDBC result: " + e.getMessage(), (Throwable)e);
                        }
                    }
                };
                return (Stream)StreamSupport.stream(spliterator, false).onClose(() -> this.closeResultSet(connection, ps, rs, finished, closeConnection));
            }
            SqlResultConsumer sqlResultConsumer = sqlMappingConsumer = preparedQuery.hasResultConsumer() ? (SqlResultConsumer)preparedQuery.getParameterInRole("sqlMappingFunction", SqlResultConsumer.class).orElse(null) : null;
            if (dtoProjection) {
                QueryResultInfo queryResultInfo = preparedQuery.getQueryResultInfo();
                if (this.isJsonResult((PreparedQuery)preparedQuery, queryResultInfo)) {
                    String column = this.getJsonColumn(queryResultInfo);
                    JsonDataType jsonDataType = this.getJsonDataType(queryResultInfo);
                    mapper = this.createQueryResultMapper(preparedQuery, column, jsonDataType, ResultSet.class, persistentEntity, null);
                } else {
                    boolean isRawQuery = preparedQuery.isRawQuery();
                    mapper = new SqlDTOMapper(persistentEntity, isRawQuery ? this.getEntity(preparedQuery.getResultType()) : persistentEntity, this.columnNameResultSetReader, this.sqlJsonColumnMapperProvider.getJsonColumnReader(preparedQuery, ResultSet.class), this.conversionService);
                }
            } else {
                BiFunction<RuntimePersistentEntity, Object, Object> loadListener = (loadedEntity, o) -> {
                    if (loadedEntity.hasPostLoadEventListeners()) {
                        return this.triggerPostLoad(o, (RuntimePersistentEntity)loadedEntity, preparedQuery.getAnnotationMetadata());
                    }
                    return o;
                };
                QueryResultInfo queryResultInfo = preparedQuery.getQueryResultInfo();
                if (this.isJsonResult((PreparedQuery)preparedQuery, queryResultInfo)) {
                    String column = this.getJsonColumn(queryResultInfo);
                    JsonDataType jsonDataType = this.getJsonDataType(queryResultInfo);
                    mapper = this.createQueryResultMapper(preparedQuery, column, jsonDataType, ResultSet.class, persistentEntity, loadListener);
                } else {
                    Set joinFetchPaths = preparedQuery.getJoinFetchPaths();
                    SqlResultEntityTypeMapper entityTypeMapper = new SqlResultEntityTypeMapper(this.getEntity(resultType), this.columnNameResultSetReader, joinFetchPaths, this.sqlJsonColumnMapperProvider.getJsonColumnReader(preparedQuery, ResultSet.class), loadListener, this.conversionService);
                    boolean onlySingleEndedJoins = this.isOnlySingleEndedJoins(persistentEntity, joinFetchPaths);
                    if (!onlySingleEndedJoins) {
                        try {
                            SqlResultEntityTypeMapper.PushingMapper manyMapper = entityTypeMapper.readAllWithJoins();
                            while (rs.next()) {
                                manyMapper.processRow((Object)rs);
                            }
                            Stream stream = ((List)manyMapper.getResult()).stream();
                            return stream;
                        }
                        finally {
                            this.closeResultSet(connection, ps, rs, finished, closeConnection);
                        }
                    }
                    mapper = entityTypeMapper;
                }
            }
            spliterator = new Spliterators.AbstractSpliterator<R>(Long.MAX_VALUE, 1040){

                @Override
                public boolean tryAdvance(Consumer<? super R> action) {
                    if (finished.get()) {
                        return false;
                    }
                    boolean hasNext = mapper.hasNext((Object)rs);
                    if (hasNext) {
                        Object o = mapper.map((Object)rs, resultType);
                        if (sqlMappingConsumer != null) {
                            sqlMappingConsumer.accept(rs, o);
                        }
                        action.accept(o);
                    } else {
                        DefaultJdbcRepositoryOperations.this.closeResultSet(connection, ps, rs, finished, closeConnection);
                    }
                    return hasNext;
                }
            };
            return (Stream)StreamSupport.stream(spliterator, false).onClose(() -> this.closeResultSet(connection, ps, rs, finished, closeConnection));
        }
        catch (Exception e) {
            this.closeResultSet(connection, ps, openedRs, finished, closeConnection);
            throw new DataAccessException("SQL Error executing Query: " + e.getMessage(), (Throwable)e);
        }
    }

    private void closeResultSet(Connection connection, PreparedStatement ps, ResultSet rs, AtomicBoolean finished, boolean closeConnection) {
        if (finished.compareAndSet(false, true)) {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (closeConnection) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new DataAccessException("Error closing JDBC result stream: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @NonNull
    public <T, R> Iterable<R> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        return this.executeRead(connection -> {
            try (Stream stream = this.findStream(preparedQuery, (Connection)connection, false);){
                List list = stream.collect(Collectors.toList());
                return list;
            }
        });
    }

    @NonNull
    public Optional<Number> executeUpdate(@NonNull PreparedQuery<?, Number> pq) {
        return this.executeWrite(connection -> {
            Optional<Integer> optional;
            block11: {
                SqlPreparedQuery preparedQuery = this.getSqlPreparedQuery(pq);
                PreparedStatement ps = (PreparedStatement)this.prepareStatement(connection::prepareStatement, (PreparedQuery)preparedQuery, true, false);
                try {
                    preparedQuery.bindParameters((BindableParametersStoredQuery.Binder)new JdbcParameterBinder((Connection)connection, ps, (SqlStoredQuery<?, ?>)preparedQuery));
                    int result = ps.executeUpdate();
                    if (QUERY_LOG.isTraceEnabled()) {
                        QUERY_LOG.trace("Update operation updated {} records", (Object)result);
                    }
                    if (preparedQuery.isOptimisticLock()) {
                        this.checkOptimisticLocking(1, result);
                    }
                    optional = Optional.of(result);
                    if (ps == null) break block11;
                }
                catch (Throwable result) {
                    try {
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable) {
                                result.addSuppressed(throwable);
                            }
                        }
                        throw result;
                    }
                    catch (SQLException e) {
                        Throwable throwable = DefaultJdbcRepositoryOperations.handleSqlException((SQLException)e, (Dialect)preparedQuery.getDialect());
                        if (throwable instanceof DataAccessException) {
                            DataAccessException dataAccessException = (DataAccessException)throwable;
                            throw dataAccessException;
                        }
                        throw new DataAccessException("Error executing SQL UPDATE: " + e.getMessage(), (Throwable)e);
                    }
                }
                ps.close();
            }
            return optional;
        });
    }

    private Integer sum(Stream<Integer> stream) {
        return stream.mapToInt(i -> i).sum();
    }

    public <T> Optional<Number> deleteAll(@NonNull DeleteBatchOperation<T> operation) {
        return Optional.ofNullable((Number)this.executeWrite(connection -> {
            SqlStoredQuery storedQuery = this.getSqlStoredQuery(operation.getStoredQuery());
            JdbcOperationContext ctx = this.createContext((EntityOperation)operation, (Connection)connection, (SqlStoredQuery)storedQuery);
            RuntimePersistentEntity persistentEntity = storedQuery.getPersistentEntity();
            if (this.isSupportsBatchDelete((PersistentEntity)persistentEntity, storedQuery.getDialect())) {
                JdbcEntitiesOperations op = new JdbcEntitiesOperations(ctx, persistentEntity, operation, storedQuery);
                op.delete();
                return op.rowsUpdated;
            }
            return this.sum(operation.split().stream().map(deleteOp -> {
                JdbcEntityOperations<Object> op = new JdbcEntityOperations<Object>(ctx, persistentEntity, deleteOp.getEntity(), storedQuery);
                op.delete();
                return op.rowsUpdated;
            }));
        }));
    }

    public <T> int delete(@NonNull DeleteOperation<T> operation) {
        return this.executeWrite((Function<Connection, JdbcEntityOperations>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$delete$11(io.micronaut.data.model.runtime.DeleteOperation java.sql.Connection ), (Ljava/sql/Connection;)Lio/micronaut/data/jdbc/operations/DefaultJdbcRepositoryOperations$JdbcEntityOperations;)((DefaultJdbcRepositoryOperations)this, operation)).rowsUpdated;
    }

    @NonNull
    public <T> T update(@NonNull UpdateOperation<T> operation) {
        return (T)this.executeWrite(connection -> {
            SqlStoredQuery storedQuery = this.getSqlStoredQuery(operation.getStoredQuery());
            JdbcOperationContext ctx = this.createContext((EntityOperation)operation, (Connection)connection, (SqlStoredQuery)storedQuery);
            JdbcEntityOperations<Object> op = new JdbcEntityOperations<Object>(ctx, storedQuery.getPersistentEntity(), operation.getEntity(), storedQuery);
            op.update();
            return op.getEntity();
        });
    }

    @NonNull
    public <T> Iterable<T> updateAll(@NonNull UpdateBatchOperation<T> operation) {
        return this.executeWrite(connection -> {
            SqlStoredQuery storedQuery = this.getSqlStoredQuery(operation.getStoredQuery());
            RuntimePersistentEntity persistentEntity = storedQuery.getPersistentEntity();
            JdbcOperationContext ctx = this.createContext((EntityOperation)operation, (Connection)connection, (SqlStoredQuery)storedQuery);
            if (!this.isSupportsBatchUpdate((PersistentEntity)persistentEntity, storedQuery.getDialect())) {
                return operation.split().stream().map(updateOp -> {
                    JdbcEntityOperations<Object> op = new JdbcEntityOperations<Object>(ctx, persistentEntity, updateOp.getEntity(), storedQuery);
                    op.update();
                    return op.getEntity();
                }).collect(Collectors.toList());
            }
            JdbcEntitiesOperations op = new JdbcEntitiesOperations(ctx, persistentEntity, operation, storedQuery);
            op.update();
            return op.getEntities();
        });
    }

    @NonNull
    public <T> T persist(@NonNull InsertOperation<T> operation) {
        return (T)this.executeWrite(connection -> {
            SqlStoredQuery storedQuery = this.getSqlStoredQuery(operation.getStoredQuery());
            JdbcOperationContext ctx = this.createContext((EntityOperation)operation, (Connection)connection, (SqlStoredQuery)storedQuery);
            JdbcEntityOperations<Object> op = new JdbcEntityOperations<Object>(ctx, storedQuery, storedQuery.getPersistentEntity(), operation.getEntity(), true);
            op.persist();
            return op;
        }).getEntity();
    }

    @Nullable
    public <T> T findOne(@NonNull Class<T> type, @NonNull Serializable id) {
        throw new UnsupportedOperationException("The findOne method by ID is not supported. Execute the SQL query directly");
    }

    @NonNull
    public <T> Iterable<T> findAll(@NonNull PagedQuery<T> query) {
        throw new UnsupportedOperationException("The findAll method without an explicit query is not supported. Use findAll(PreparedQuery) instead");
    }

    public <T> long count(PagedQuery<T> pagedQuery) {
        throw new UnsupportedOperationException("The count method without an explicit query is not supported. Use findAll(PreparedQuery) instead");
    }

    @NonNull
    public <T> Stream<T> findStream(@NonNull PagedQuery<T> query) {
        throw new UnsupportedOperationException("The findStream method without an explicit query is not supported. Use findStream(PreparedQuery) instead");
    }

    public <R> Page<R> findPage(@NonNull PagedQuery<R> query) {
        throw new UnsupportedOperationException("The findPage method without an explicit query is not supported. Use findPage(PreparedQuery) instead");
    }

    @NonNull
    public <T> Iterable<T> persistAll(@NonNull InsertBatchOperation<T> operation) {
        return this.executeWrite(connection -> {
            SqlStoredQuery storedQuery = this.getSqlStoredQuery(operation.getStoredQuery());
            RuntimePersistentEntity persistentEntity = storedQuery.getPersistentEntity();
            JdbcOperationContext ctx = this.createContext((EntityOperation)operation, (Connection)connection, (SqlStoredQuery)storedQuery);
            if (!this.isSupportsBatchInsert((PersistentEntity)persistentEntity, storedQuery.getDialect())) {
                return operation.split().stream().map(persistOp -> {
                    JdbcEntityOperations<Object> op = new JdbcEntityOperations<Object>(ctx, storedQuery, persistentEntity, persistOp.getEntity(), true);
                    op.persist();
                    return op.getEntity();
                }).collect(Collectors.toList());
            }
            JdbcEntitiesOperations op = new JdbcEntitiesOperations(ctx, persistentEntity, operation, storedQuery, true);
            op.persist();
            return op.getEntities();
        });
    }

    private <I> I executeRead(Function<Connection, I> fn) {
        if (!this.jdbcConfiguration.isAllowConnectionPerOperation() && this.connectionOperations.findConnectionStatus().isEmpty()) {
            throw this.connectionNotFoundAndNewNotAllowed();
        }
        return (I)this.connectionOperations.executeRead(status -> {
            Connection connection = (Connection)status.getConnection();
            this.applySchema(connection);
            return fn.apply(connection);
        });
    }

    private <I> I executeWrite(Function<Connection, I> fn) {
        if (!this.jdbcConfiguration.isAllowConnectionPerOperation() && this.connectionOperations.findConnectionStatus().isEmpty()) {
            throw this.connectionNotFoundAndNewNotAllowed();
        }
        return (I)this.connectionOperations.executeWrite(status -> {
            Connection connection = (Connection)status.getConnection();
            this.applySchema(connection);
            return fn.apply(connection);
        });
    }

    private DataAccessException connectionNotFoundAndNewNotAllowed() {
        return new DataAccessException("Connection is required for this operation. Annotate with @" + Connectable.class + ", @Transactional or enable `isAllowConnectionPerOperation`.");
    }

    @Override
    @PreDestroy
    public void close() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    private void applySchema(Connection connection) {
        if (this.schemaTenantResolver != null) {
            String schema = this.schemaTenantResolver.resolveTenantSchemaName();
            this.schemaHandler.useSchema(connection, this.jdbcConfiguration.getDialect(), schema);
        }
    }

    @Override
    @NonNull
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    @NonNull
    public Connection getConnection() {
        Connection connection = (Connection)this.connectionOperations.getConnectionStatus().getConnection();
        this.applySchema(connection);
        return connection;
    }

    @NonNull
    private ConnectionContext getConnectionCtx() {
        boolean needsToCloseConnection;
        Connection connection;
        if (!this.jdbcConfiguration.isAllowConnectionPerOperation() || this.transactionOperations.hasConnection()) {
            connection = (Connection)this.transactionOperations.getConnection();
            needsToCloseConnection = false;
        } else {
            connection = (Connection)this.connectionOperations.getConnectionStatus().getConnection();
            needsToCloseConnection = true;
        }
        this.applySchema(connection);
        return new ConnectionContext(connection, needsToCloseConnection);
    }

    @Override
    @NonNull
    public <R> R execute(@NonNull ConnectionCallback<R> callback) {
        return (R)this.executeWrite(connection -> {
            try {
                return callback.call((Connection)connection);
            }
            catch (SQLException e) {
                throw new DataAccessException("Error executing SQL Callback: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public <R> R prepareStatement(@NonNull String sql, @NonNull PreparedStatementCallback<R> callback) {
        ArgumentUtils.requireNonNull((String)"sql", (Object)sql);
        ArgumentUtils.requireNonNull((String)"callback", callback);
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Query: {}", (Object)sql);
        }
        ConnectionContext connectionCtx = this.getConnectionCtx();
        try {
            R result = null;
            try {
                R r;
                PreparedStatement ps = connectionCtx.connection.prepareStatement(sql);
                try {
                    r = result = (R)callback.call(ps);
                }
                catch (Throwable throwable) {
                    if (!(result instanceof AutoCloseable)) {
                        ps.close();
                    }
                    throw throwable;
                }
                if (!(result instanceof AutoCloseable)) {
                    ps.close();
                }
                return r;
            }
            finally {
                if (!(result instanceof AutoCloseable) && connectionCtx.needsToBeClosed) {
                    connectionCtx.connection.close();
                }
            }
        }
        catch (SQLException e) {
            throw new DataAccessException("Error preparing SQL statement: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @NonNull
    public <T> Stream<T> entityStream(@NonNull ResultSet resultSet, @NonNull Class<T> rootEntity) {
        return this.entityStream(resultSet, null, rootEntity);
    }

    @Override
    @NonNull
    public <E> E readEntity(@NonNull String prefix, @NonNull ResultSet resultSet, @NonNull Class<E> type) throws DataAccessException {
        return (E)new SqlResultEntityTypeMapper(prefix, this.getEntity(type), this.columnNameResultSetReader, this.jsonMapper != null ? () -> this.jsonMapper : null, this.conversionService).map((Object)resultSet, type);
    }

    @Override
    @NonNull
    public <E, D> D readDTO(@NonNull String prefix, @NonNull ResultSet resultSet, @NonNull Class<E> rootEntity, @NonNull Class<D> dtoType) throws DataAccessException {
        return (D)new DTOMapper(this.getEntity(rootEntity), this.columnNameResultSetReader, this.jsonMapper != null ? () -> this.jsonMapper : null, this.conversionService).map((Object)resultSet, dtoType);
    }

    @Override
    @NonNull
    public <T> Stream<T> entityStream(@NonNull ResultSet resultSet, @Nullable String prefix, @NonNull Class<T> rootEntity) {
        ArgumentUtils.requireNonNull((String)"resultSet", (Object)resultSet);
        ArgumentUtils.requireNonNull((String)"rootEntity", rootEntity);
        SqlResultEntityTypeMapper mapper = new SqlResultEntityTypeMapper(prefix, this.getEntity(rootEntity), this.columnNameResultSetReader, this.jsonMapper != null ? () -> this.jsonMapper : null, this.conversionService);
        Iterable iterable = () -> this.lambda$entityStream$24(resultSet, (TypeMapper)mapper, rootEntity);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    @NonNull
    private ResultConsumer.Context<ResultSet> newMappingContext(final ResultSet rs) {
        return new ResultConsumer.Context<ResultSet>(){

            public ResultSet getResultSet() {
                return rs;
            }

            public ResultReader<ResultSet, String> getResultReader() {
                return DefaultJdbcRepositoryOperations.this.columnNameResultSetReader;
            }

            @NonNull
            public <E> E readEntity(String prefix, Class<E> type) throws DataAccessException {
                RuntimePersistentEntity entity = DefaultJdbcRepositoryOperations.this.getEntity(type);
                SqlResultEntityTypeMapper mapper = new SqlResultEntityTypeMapper(prefix, entity, DefaultJdbcRepositoryOperations.this.columnNameResultSetReader, DefaultJdbcRepositoryOperations.this.jsonMapper != null ? () -> DefaultJdbcRepositoryOperations.this.jsonMapper : null, DefaultJdbcRepositoryOperations.this.conversionService);
                return (E)mapper.map((Object)rs, type);
            }

            @NonNull
            public <E, D> D readDTO(@NonNull String prefix, @NonNull Class<E> rootEntity, @NonNull Class<D> dtoType) throws DataAccessException {
                RuntimePersistentEntity entity = DefaultJdbcRepositoryOperations.this.getEntity(rootEntity);
                DTOMapper introspectedDataMapper = new DTOMapper(entity, DefaultJdbcRepositoryOperations.this.columnNameResultSetReader, DefaultJdbcRepositoryOperations.this.jsonMapper != null ? () -> DefaultJdbcRepositoryOperations.this.jsonMapper : null, DefaultJdbcRepositoryOperations.this.conversionService);
                return (D)introspectedDataMapper.map((Object)rs, dtoType);
            }
        };
    }

    private <T> JdbcOperationContext createContext(EntityOperation<T> operation, Connection connection, SqlStoredQuery<T, ?> storedQuery) {
        return new JdbcOperationContext(operation.getAnnotationMetadata(), operation.getInvocationContext(), operation.getRepositoryType(), storedQuery.getDialect(), connection);
    }

    private Object getGeneratedIdentity(@NonNull ResultSet generatedKeysResultSet, RuntimePersistentProperty<?> identity, Dialect dialect) {
        if (dialect == Dialect.POSTGRES) {
            return this.columnNameResultSetReader.readDynamic((Object)generatedKeysResultSet, (Object)identity.getPersistedName(), identity.getDataType());
        }
        return this.columnIndexResultSetReader.readDynamic((Object)generatedKeysResultSet, (Object)1, identity.getDataType());
    }

    public boolean isSupportsBatchInsert(JdbcOperationContext jdbcOperationContext, RuntimePersistentEntity<?> persistentEntity) {
        return this.isSupportsBatchInsert((PersistentEntity)persistentEntity, jdbcOperationContext.dialect);
    }

    private /* synthetic */ Iterator lambda$entityStream$24(final ResultSet resultSet, final TypeMapper mapper, final Class rootEntity) {
        return new Iterator<T>(){
            boolean fetched = false;
            boolean end = false;

            @Override
            public boolean hasNext() {
                if (this.fetched) {
                    return true;
                }
                if (this.end) {
                    return false;
                }
                try {
                    if (resultSet.next()) {
                        this.fetched = true;
                    } else {
                        this.end = true;
                    }
                }
                catch (SQLException e) {
                    throw new DataAccessException("Error retrieving next JDBC result: " + e.getMessage(), (Throwable)e);
                }
                return !this.end;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.fetched = false;
                return mapper.map((Object)resultSet, rootEntity);
            }
        };
    }

    private /* synthetic */ JdbcEntityOperations lambda$delete$11(DeleteOperation operation, Connection connection) {
        SqlStoredQuery storedQuery = this.getSqlStoredQuery(operation.getStoredQuery());
        JdbcOperationContext ctx = this.createContext((EntityOperation)operation, connection, (SqlStoredQuery)storedQuery);
        JdbcEntityOperations<Object> op = new JdbcEntityOperations<Object>(ctx, storedQuery.getPersistentEntity(), operation.getEntity(), storedQuery);
        op.delete();
        return op;
    }

    protected static class JdbcOperationContext
    extends OperationContext {
        public final Connection connection;
        public final Dialect dialect;
        private final InvocationContext<?, ?> invocationContext;

        @Deprecated
        public JdbcOperationContext(AnnotationMetadata annotationMetadata, Class<?> repositoryType, Dialect dialect, Connection connection) {
            this(annotationMetadata, null, repositoryType, dialect, connection);
        }

        public JdbcOperationContext(AnnotationMetadata annotationMetadata, InvocationContext<?, ?> invocationContext, Class<?> repositoryType, Dialect dialect, Connection connection) {
            super(annotationMetadata, repositoryType);
            this.dialect = dialect;
            this.connection = connection;
            this.invocationContext = invocationContext;
        }
    }

    private final class JdbcEntityOperations<T>
    extends AbstractSyncEntityOperations<JdbcOperationContext, T, SQLException> {
        private final SqlStoredQuery<T, ?> storedQuery;
        private Integer rowsUpdated;
        private Map<QueryParameterBinding, Object> previousValues;

        private JdbcEntityOperations(JdbcOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, T entity, SqlStoredQuery<T, ?> storedQuery) {
            this(ctx, storedQuery, persistentEntity, entity, false);
        }

        private JdbcEntityOperations(JdbcOperationContext ctx, SqlStoredQuery<T, ?> storedQuery, RuntimePersistentEntity<T> persistentEntity, T entity, boolean insert) {
            super((OperationContext)ctx, DefaultJdbcRepositoryOperations.this.cascadeOperations, DefaultJdbcRepositoryOperations.this.entityEventRegistry, persistentEntity, (ConversionService)DefaultJdbcRepositoryOperations.this.conversionService, entity, insert);
            this.storedQuery = storedQuery;
        }

        protected void collectAutoPopulatedPreviousValues() {
            this.previousValues = this.storedQuery.collectAutoPopulatedPreviousValues(this.entity);
        }

        private PreparedStatement prepare(Connection connection, SqlStoredQuery storedQuery) throws SQLException {
            if (storedQuery instanceof SqlPreparedQuery) {
                ((SqlPreparedQuery)storedQuery).prepare(this.entity);
            }
            if (this.insert) {
                Dialect dialect = storedQuery.getDialect();
                if (this.hasGeneratedId && (dialect == Dialect.ORACLE || dialect == Dialect.SQL_SERVER)) {
                    if (DefaultJdbcRepositoryOperations.this.isJsonEntityGeneratedId((StoredQuery)storedQuery, (PersistentEntity)this.persistentEntity)) {
                        CallableStatement callableStatement = connection.prepareCall(this.storedQuery.getQuery());
                        callableStatement.registerOutParameter(storedQuery.getQueryBindings().size() + 1, 2);
                        return callableStatement;
                    }
                    return connection.prepareStatement(this.storedQuery.getQuery(), new String[]{this.persistentEntity.getIdentity().getPersistedName()});
                }
                return connection.prepareStatement(this.storedQuery.getQuery(), this.hasGeneratedId ? 1 : 2);
            }
            return connection.prepareStatement(this.storedQuery.getQuery());
        }

        protected void execute() throws SQLException {
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing SQL query: {}", (Object)this.storedQuery.getQuery());
            }
            try (PreparedStatement ps = this.prepare(((JdbcOperationContext)this.ctx).connection, this.storedQuery);){
                block21: {
                    this.storedQuery.bindParameters((BindableParametersStoredQuery.Binder)new JdbcParameterBinder(((JdbcOperationContext)this.ctx).connection, ps, this.storedQuery), ((JdbcOperationContext)this.ctx).invocationContext, this.entity, this.previousValues);
                    this.rowsUpdated = ps.executeUpdate();
                    if (this.hasGeneratedId) {
                        if (DefaultJdbcRepositoryOperations.this.isJsonEntityGeneratedId(this.storedQuery, (PersistentEntity)this.persistentEntity) && ps instanceof CallableStatement) {
                            CallableStatement callableStatement = (CallableStatement)ps;
                            Object id = callableStatement.getObject(this.storedQuery.getQueryBindings().size() + 1);
                            BeanProperty property = this.persistentEntity.getIdentity().getProperty();
                            this.entity = this.updateEntityId(property, this.entity, id);
                        } else {
                            try (ResultSet generatedKeys = ps.getGeneratedKeys();){
                                if (generatedKeys.next()) {
                                    RuntimePersistentProperty identity = this.persistentEntity.getIdentity();
                                    Object id = DefaultJdbcRepositoryOperations.this.getGeneratedIdentity(generatedKeys, identity, this.storedQuery.getDialect());
                                    BeanProperty property = identity.getProperty();
                                    this.entity = this.updateEntityId(property, this.entity, id);
                                    break block21;
                                }
                                throw new DataAccessException("Failed to generate ID for entity: " + this.entity);
                            }
                        }
                    }
                }
                if (this.storedQuery.isOptimisticLock()) {
                    this.checkOptimisticLocking(1L, this.rowsUpdated.intValue());
                }
            }
            catch (SQLException e) {
                Throwable throwable = DefaultJdbcRepositoryOperations.handleSqlException((SQLException)e, (Dialect)((JdbcOperationContext)this.ctx).dialect);
                if (throwable instanceof DataAccessException) {
                    DataAccessException dataAccessException = (DataAccessException)throwable;
                    throw dataAccessException;
                }
                throw e;
            }
        }
    }

    private final class JdbcEntitiesOperations<T>
    extends AbstractSyncEntitiesOperations<JdbcOperationContext, T, SQLException> {
        private final SqlStoredQuery<T, ?> storedQuery;
        private int rowsUpdated;

        private JdbcEntitiesOperations(JdbcOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities, SqlStoredQuery<T, ?> storedQuery) {
            this(ctx, persistentEntity, entities, storedQuery, false);
        }

        private JdbcEntitiesOperations(JdbcOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities, SqlStoredQuery<T, ?> storedQuery, boolean insert) {
            super((OperationContext)ctx, DefaultJdbcRepositoryOperations.this.cascadeOperations, (ConversionService)DefaultJdbcRepositoryOperations.this.conversionService, DefaultJdbcRepositoryOperations.this.entityEventRegistry, persistentEntity, entities, insert);
            this.storedQuery = storedQuery;
        }

        protected void collectAutoPopulatedPreviousValues() {
            for (AbstractSyncEntitiesOperations.Data d : this.entities) {
                if (d.vetoed) continue;
                d.previousValues = this.storedQuery.collectAutoPopulatedPreviousValues(d.entity);
            }
        }

        private PreparedStatement prepare(Connection connection) throws SQLException {
            if (this.insert) {
                Dialect dialect = this.storedQuery.getDialect();
                if (this.hasGeneratedId && (dialect == Dialect.ORACLE || dialect == Dialect.SQL_SERVER)) {
                    if (DefaultJdbcRepositoryOperations.this.isJsonEntityGeneratedId(this.storedQuery, (PersistentEntity)this.persistentEntity)) {
                        CallableStatement callableStatement = connection.prepareCall(this.storedQuery.getQuery());
                        callableStatement.registerOutParameter(this.storedQuery.getQueryBindings().size() + 1, 2);
                        return callableStatement;
                    }
                    return connection.prepareStatement(this.storedQuery.getQuery(), new String[]{this.persistentEntity.getIdentity().getPersistedName()});
                }
                return connection.prepareStatement(this.storedQuery.getQuery(), this.hasGeneratedId ? 1 : 2);
            }
            return connection.prepareStatement(this.storedQuery.getQuery());
        }

        private void setParameters(PreparedStatement stmt, SqlStoredQuery<T, ?> storedQuery) throws SQLException {
            for (AbstractSyncEntitiesOperations.Data d : this.entities) {
                if (d.vetoed) continue;
                storedQuery.bindParameters((BindableParametersStoredQuery.Binder)new JdbcParameterBinder(((JdbcOperationContext)this.ctx).connection, stmt, storedQuery), ((JdbcOperationContext)this.ctx).invocationContext, d.entity, d.previousValues);
                stmt.addBatch();
            }
        }

        protected void execute() throws SQLException {
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing SQL query: {}", (Object)this.storedQuery.getQuery());
            }
            try (PreparedStatement ps = this.prepare(((JdbcOperationContext)this.ctx).connection);){
                this.setParameters(ps, this.storedQuery);
                this.rowsUpdated = Arrays.stream(ps.executeBatch()).sum();
                if (this.hasGeneratedId) {
                    RuntimePersistentProperty identity = this.persistentEntity.getIdentity();
                    ArrayList<Object> ids = new ArrayList<Object>();
                    try (ResultSet generatedKeys = ps.getGeneratedKeys();){
                        Dialect dialect = this.storedQuery.getDialect();
                        while (generatedKeys.next()) {
                            ids.add(DefaultJdbcRepositoryOperations.this.getGeneratedIdentity(generatedKeys, identity, dialect));
                        }
                    }
                    Iterator iterator = ids.iterator();
                    for (AbstractSyncEntitiesOperations.Data d2 : this.entities) {
                        if (d2.vetoed) continue;
                        if (!iterator.hasNext()) {
                            throw new DataAccessException("Failed to generate ID for entity: " + d2.entity);
                        }
                        Object id = iterator.next();
                        d2.entity = this.updateEntityId(identity.getProperty(), d2.entity, id);
                    }
                }
                if (this.storedQuery.isOptimisticLock()) {
                    int expected = (int)this.entities.stream().filter(d -> !d.vetoed).count();
                    this.checkOptimisticLocking(expected, this.rowsUpdated);
                }
            }
        }
    }

    private static final class ConnectionContext {
        private final Connection connection;
        private final boolean needsToBeClosed;

        private ConnectionContext(Connection connection, boolean needsToBeClosed) {
            this.connection = connection;
            this.needsToBeClosed = needsToBeClosed;
        }

        public Connection getConnection() {
            return this.connection;
        }
    }

    private final class JdbcParameterBinder
    implements BindableParametersStoredQuery.Binder {
        private final SqlStoredQuery<?, ?> sqlStoredQuery;
        private final Connection connection;
        private final PreparedStatement ps;
        private int index = 1;

        public JdbcParameterBinder(Connection connection, PreparedStatement ps, SqlStoredQuery<?, ?> sqlStoredQuery) {
            this.connection = connection;
            this.ps = ps;
            this.sqlStoredQuery = sqlStoredQuery;
        }

        public Object autoPopulateRuntimeProperty(RuntimePersistentProperty<?> persistentProperty, Object previousValue) {
            return DefaultJdbcRepositoryOperations.this.runtimeEntityRegistry.autoPopulateRuntimeProperty(persistentProperty, previousValue);
        }

        public Object convert(Object value, RuntimePersistentProperty<?> property) {
            AttributeConverter converter = property.getConverter();
            if (converter != null) {
                return converter.convertToPersistedValue(value, this.createTypeConversionContext(property, property.getArgument()));
            }
            return value;
        }

        public Object convert(Class<?> converterClass, Object value, Argument<?> argument) {
            if (converterClass == null) {
                return value;
            }
            AttributeConverter converter = DefaultJdbcRepositoryOperations.this.attributeConverterRegistry.getConverter(converterClass);
            ConversionContext conversionContext = this.createTypeConversionContext(null, argument);
            return converter.convertToPersistedValue(value, conversionContext);
        }

        private ConversionContext createTypeConversionContext(RuntimePersistentProperty<?> property, Argument<?> argument) {
            Objects.requireNonNull(this.connection);
            if (property != null) {
                return new RuntimePersistentPropertyJdbcCC(this.connection, property);
            }
            if (argument != null) {
                return new ArgumentJdbcCC(this.connection, argument);
            }
            return new JdbcConversionContextImpl(this.connection);
        }

        public void bindOne(QueryParameterBinding binding, Object value) {
            JsonDataType jsonDataType = null;
            if (binding.getDataType() == DataType.JSON) {
                jsonDataType = binding.getJsonDataType();
            }
            DefaultJdbcRepositoryOperations.this.setStatementParameter(this.ps, this.index, binding.getDataType(), jsonDataType, value, this.sqlStoredQuery);
            ++this.index;
        }

        public void bindMany(QueryParameterBinding binding, Collection<Object> values) {
            for (Object value : values) {
                this.bindOne(binding, value);
            }
        }

        public int currentIndex() {
            return this.index;
        }
    }

    private static class JdbcConversionContextImpl
    extends AbstractConversionContext
    implements JdbcConversionContext {
        private final Connection connection;

        public JdbcConversionContextImpl(Connection connection) {
            this(ConversionContext.DEFAULT, connection);
        }

        public JdbcConversionContextImpl(ConversionContext conversionContext, Connection connection) {
            super(conversionContext);
            this.connection = connection;
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }
    }

    private static final class ArgumentJdbcCC
    extends JdbcConversionContextImpl
    implements ArgumentConversionContext<Object> {
        private final Argument argument;

        public ArgumentJdbcCC(Connection connection, Argument argument) {
            super((ConversionContext)ConversionContext.of((Argument)argument), connection);
            this.argument = argument;
        }

        public Argument<Object> getArgument() {
            return this.argument;
        }
    }

    private static final class RuntimePersistentPropertyJdbcCC
    extends JdbcConversionContextImpl
    implements RuntimePersistentPropertyConversionContext {
        private final RuntimePersistentProperty<?> property;

        public RuntimePersistentPropertyJdbcCC(Connection connection, RuntimePersistentProperty<?> property) {
            super((ConversionContext)ConversionContext.of((Argument)property.getArgument()), connection);
            this.property = property;
        }

        public RuntimePersistentProperty<?> getRuntimePersistentProperty() {
            return this.property;
        }
    }
}

