/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.config;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.jdbc.config.DataJdbcConfiguration;
import io.micronaut.data.jdbc.operations.JdbcSchemaHandler;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.runtime.config.DataSettings;
import io.micronaut.data.runtime.config.SchemaGenerate;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.transaction.jdbc.DelegatingDataSource;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;

@Context
@Internal
public class SchemaGenerator {
    private final List<DataJdbcConfiguration> configurations;
    private final JdbcSchemaHandler schemaHandler;

    public SchemaGenerator(List<DataJdbcConfiguration> configurations, JdbcSchemaHandler schemaHandler) {
        this.configurations = configurations == null ? Collections.emptyList() : configurations;
        this.schemaHandler = schemaHandler;
    }

    @PostConstruct
    public void createSchema(BeanLocator beanLocator) {
        RuntimeEntityRegistry runtimeEntityRegistry = (RuntimeEntityRegistry)beanLocator.getBean(RuntimeEntityRegistry.class);
        for (DataJdbcConfiguration configuration : this.configurations) {
            SchemaGenerate schemaGenerate = configuration.getSchemaGenerate();
            if (schemaGenerate == null || schemaGenerate == SchemaGenerate.NONE) continue;
            Dialect dialect = configuration.getDialect();
            String name = configuration.getName();
            List<String> packages = configuration.getPackages();
            Collection introspections = CollectionUtils.isNotEmpty(packages) ? BeanIntrospector.SHARED.findIntrospections(MappedEntity.class, packages.toArray(new String[0])) : BeanIntrospector.SHARED.findIntrospections(MappedEntity.class);
            Object[] entities = (PersistentEntity[])introspections.stream().filter(i -> !i.getBeanType().getName().contains("$")).filter(i -> !Modifier.isAbstract(i.getBeanType().getModifiers())).map(beanIntrospection -> runtimeEntityRegistry.getEntity(beanIntrospection.getBeanType())).toArray(PersistentEntity[]::new);
            if (!ArrayUtils.isNotEmpty((Object[])entities)) continue;
            DataSource dataSource = DelegatingDataSource.unwrapDataSource((DataSource)((DataSource)beanLocator.getBean(DataSource.class, Qualifiers.byName((String)name))));
            try {
                try {
                    Connection connection = dataSource.getConnection();
                    try {
                        if (configuration.getSchemaGenerateNames() != null && !configuration.getSchemaGenerateNames().isEmpty()) {
                            for (String schemaName : configuration.getSchemaGenerateNames()) {
                                this.schemaHandler.createSchema(connection, dialect, schemaName);
                                this.schemaHandler.useSchema(connection, dialect, schemaName);
                                SchemaGenerator.generate(connection, configuration, (PersistentEntity[])entities);
                            }
                            continue;
                        }
                        if (configuration.getSchemaGenerateName() != null) {
                            this.schemaHandler.createSchema(connection, dialect, configuration.getSchemaGenerateName());
                            this.schemaHandler.useSchema(connection, dialect, configuration.getSchemaGenerateName());
                        }
                        SchemaGenerator.generate(connection, configuration, (PersistentEntity[])entities);
                    }
                    finally {
                        if (connection == null) continue;
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    throw new DataAccessException("Unable to create database schema: " + e.getMessage(), (Throwable)e);
                }
            }
            catch (NoSuchBeanException e) {
                throw new ConfigurationException("No DataSource configured for setting [datasources" + name + "]. Ensure the DataSource is configured correctly and try again.", (Throwable)e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void generate(Connection connection, DataJdbcConfiguration configuration, PersistentEntity[] entities) throws SQLException {
        block46: {
            block47: {
                dialect = configuration.getDialect();
                builder = new SqlQueryBuilder(dialect);
                if (!dialect.allowBatch() || !configuration.isBatchGenerate()) break block47;
                switch (1.$SwitchMap$io$micronaut$data$runtime$config$SchemaGenerate[configuration.getSchemaGenerate().ordinal()]) {
                    case 1: {
                        try {
                            sql = builder.buildBatchDropTableStatement(entities);
                            if (DataSettings.QUERY_LOG.isDebugEnabled()) {
                                DataSettings.QUERY_LOG.debug("Dropping Tables: \n{}", (Object)sql);
                            }
                            ps = connection.prepareStatement(sql);
                            try {
                                ps.executeUpdate();
                            }
                            finally {
                                if (ps != null) {
                                    ps.close();
                                }
                            }
                        }
                        catch (SQLException e) {
                            if (!DataSettings.QUERY_LOG.isTraceEnabled()) ** GOTO lbl22
                            DataSettings.QUERY_LOG.trace("Drop Unsuccessful: " + e.getMessage());
                        }
                    }
lbl22:
                    // 4 sources

                    case 2: {
                        sql = builder.buildBatchCreateTableStatement(entities);
                        if (DataSettings.QUERY_LOG.isDebugEnabled()) {
                            DataSettings.QUERY_LOG.debug("Creating Tables: \n{}", (Object)sql);
                        }
                        ps = connection.prepareStatement(sql);
                        try {
                            ps.executeUpdate();
                            break block46;
                        }
                        finally {
                            if (ps != null) {
                                ps.close();
                            }
                        }
                    }
                }
                break block46;
            }
            switch (1.$SwitchMap$io$micronaut$data$runtime$config$SchemaGenerate[configuration.getSchemaGenerate().ordinal()]) {
                case 1: {
                    for (PersistentEntity entity : entities) {
                        try {
                            statements = builder.buildDropTableStatements(entity);
                            for (String sql : statements) {
                                if (DataSettings.QUERY_LOG.isDebugEnabled()) {
                                    DataSettings.QUERY_LOG.debug("Dropping Table: \n{}", (Object)sql);
                                }
                                ps = connection.prepareStatement(sql);
                                try {
                                    ps.executeUpdate();
                                }
                                finally {
                                    if (ps != null) {
                                        ps.close();
                                    }
                                }
                            }
                        }
                        catch (SQLException e) {
                            if (!DataSettings.QUERY_LOG.isTraceEnabled()) continue;
                            DataSettings.QUERY_LOG.trace("Drop Unsuccessful: " + e.getMessage());
                        }
                    }
                }
                case 2: {
                    for (PersistentEntity entity : entities) {
                        for (String stmt : sql = builder.buildCreateTableStatements(entity)) {
                            if (DataSettings.QUERY_LOG.isDebugEnabled()) {
                                DataSettings.QUERY_LOG.debug("Executing CREATE statement: \n{}", (Object)stmt);
                            }
                            try {
                                ps = connection.prepareStatement(stmt);
                                try {
                                    ps.executeUpdate();
                                }
                                finally {
                                    if (ps != null) {
                                        ps.close();
                                    }
                                }
                            }
                            catch (SQLException e) {
                                if (!DataSettings.QUERY_LOG.isWarnEnabled()) continue;
                                DataSettings.QUERY_LOG.warn("CREATE Statement Unsuccessful: " + e.getMessage());
                            }
                        }
                    }
                    break;
                }
            }
        }
    }
}

