/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.mapper;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.DataType;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.mapper.ResultReader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public final class ColumnIndexResultSetReader
implements ResultReader<ResultSet, Integer> {
    private final ConversionService<?> conversionService;

    @Deprecated
    public ColumnIndexResultSetReader() {
        this(null);
    }

    public ColumnIndexResultSetReader(DataConversionService<?> conversionService) {
        this.conversionService = conversionService == null ? ConversionService.SHARED : conversionService;
    }

    public ConversionService<?> getConversionService() {
        return this.conversionService;
    }

    @Nullable
    public Object readDynamic(@NonNull ResultSet resultSet, @NonNull Integer index, @NonNull DataType dataType) {
        Object val = super.readDynamic((Object)resultSet, (Object)index, dataType);
        try {
            return resultSet.wasNull() ? null : val;
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public Timestamp readTimestamp(ResultSet resultSet, Integer index) {
        try {
            return resultSet.getTimestamp(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public long readLong(ResultSet resultSet, Integer index) {
        try {
            return resultSet.getLong(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public char readChar(ResultSet resultSet, Integer index) {
        try {
            return (char)resultSet.getInt(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public Date readDate(ResultSet resultSet, Integer index) {
        try {
            return resultSet.getDate(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    @Nullable
    public String readString(ResultSet resultSet, Integer index) {
        try {
            return resultSet.getString(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public int readInt(ResultSet resultSet, Integer index) {
        try {
            return resultSet.getInt(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public boolean readBoolean(ResultSet resultSet, Integer index) {
        try {
            return resultSet.getBoolean(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public float readFloat(ResultSet resultSet, Integer index) {
        try {
            return resultSet.getFloat(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public byte readByte(ResultSet resultSet, Integer index) {
        try {
            return resultSet.getByte(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public short readShort(ResultSet resultSet, Integer index) {
        try {
            return resultSet.getShort(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public double readDouble(ResultSet resultSet, Integer index) {
        try {
            return resultSet.getDouble(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public BigDecimal readBigDecimal(ResultSet resultSet, Integer index) {
        try {
            return resultSet.getBigDecimal(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public byte[] readBytes(ResultSet resultSet, Integer index) {
        try {
            return resultSet.getBytes(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public <T> T getRequiredValue(ResultSet resultSet, Integer index, Class<T> type) throws DataAccessException {
        try {
            Object o = Blob.class.isAssignableFrom(type) ? resultSet.getBlob(index) : (Clob.class.isAssignableFrom(type) ? resultSet.getClob(index) : resultSet.getObject(index));
            if (o == null) {
                return null;
            }
            if (type.isInstance(o)) {
                return (T)o;
            }
            return (T)this.convertRequired(o, type);
        }
        catch (ConversionErrorException | SQLException e) {
            throw this.exceptionForColumn(index, (Exception)e);
        }
    }

    public boolean next(ResultSet resultSet) {
        try {
            return resultSet.next();
        }
        catch (SQLException e) {
            throw new DataAccessException("Error calling next on SQL result set: " + e.getMessage(), (Throwable)e);
        }
    }

    private DataAccessException exceptionForColumn(Integer index, Exception e) {
        return new DataAccessException("Error reading object for index [" + index + "] from result set: " + e.getMessage(), (Throwable)e);
    }
}

