/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.operations;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.event.EntityEventContext;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.jdbc.mapper.ColumnIndexResultSetReader;
import io.micronaut.data.jdbc.mapper.ColumnNameResultSetReader;
import io.micronaut.data.jdbc.mapper.JdbcQueryStatement;
import io.micronaut.data.jdbc.mapper.SqlResultConsumer;
import io.micronaut.data.jdbc.operations.JdbcRepositoryOperations;
import io.micronaut.data.jdbc.runtime.ConnectionCallback;
import io.micronaut.data.jdbc.runtime.PreparedStatementCallback;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.event.DefaultEntityEventContext;
import io.micronaut.data.runtime.mapper.DTOMapper;
import io.micronaut.data.runtime.mapper.QueryStatement;
import io.micronaut.data.runtime.mapper.ResultConsumer;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.data.runtime.mapper.TypeMapper;
import io.micronaut.data.runtime.mapper.sql.SqlDTOMapper;
import io.micronaut.data.runtime.mapper.sql.SqlResultEntityTypeMapper;
import io.micronaut.data.runtime.mapper.sql.SqlTypeMapper;
import io.micronaut.data.runtime.operations.ExecutorAsyncOperations;
import io.micronaut.data.runtime.operations.ExecutorReactiveOperations;
import io.micronaut.data.runtime.operations.internal.AbstractSqlRepositoryOperations;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.transaction.TransactionOperations;
import io.micronaut.transaction.TransactionStatus;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EachBean(value=DataSource.class)
@Internal
public final class DefaultJdbcRepositoryOperations
extends AbstractSqlRepositoryOperations<Connection, ResultSet, PreparedStatement, SQLException>
implements JdbcRepositoryOperations,
AsyncCapableRepository,
ReactiveCapableRepository,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJdbcRepositoryOperations.class);
    private final TransactionOperations<Connection> transactionOperations;
    private final DataSource dataSource;
    private ExecutorAsyncOperations asyncOperations;
    private ExecutorService executorService;

    @Internal
    protected DefaultJdbcRepositoryOperations(@Parameter String dataSourceName, DataSource dataSource, @Parameter TransactionOperations<Connection> transactionOperations, @Named(value="io") @Nullable ExecutorService executorService, BeanContext beanContext, List<MediaTypeCodec> codecs, @NonNull DateTimeProvider dateTimeProvider, RuntimeEntityRegistry entityRegistry) {
        super(dataSourceName, (ResultReader)new ColumnNameResultSetReader(), (ResultReader)new ColumnIndexResultSetReader(), (QueryStatement)new JdbcQueryStatement(), codecs, dateTimeProvider, entityRegistry, beanContext);
        ArgumentUtils.requireNonNull((String)"dataSource", (Object)dataSource);
        ArgumentUtils.requireNonNull((String)"transactionOperations", transactionOperations);
        this.dataSource = dataSource;
        this.transactionOperations = transactionOperations;
        this.executorService = executorService;
    }

    @NonNull
    private ExecutorService newLocalThreadPool() {
        this.executorService = Executors.newCachedThreadPool();
        return this.executorService;
    }

    private <T> T cascadeEntity(T entity, RuntimePersistentEntity<T> persistentEntity, boolean isPost, Relation.Cascade cascadeType, Connection connection, Dialect dialect, AnnotationMetadata annotationMetadata, Class<?> repositoryType, List<Association> associations, Set<Object> persisted) {
        ArrayList cascadeOps = new ArrayList();
        this.cascade(dialect, annotationMetadata, repositoryType, isPost, cascadeType, AbstractSqlRepositoryOperations.CascadeContext.of(associations, entity), persistentEntity, entity, cascadeOps);
        for (AbstractSqlRepositoryOperations.CascadeOp cascadeOp : cascadeOps) {
            JdbcEntityOperations op;
            RuntimePersistentProperty identity;
            Object child;
            ListIterator<Object> iterator;
            List entities;
            Object op2;
            RuntimePersistentEntity childPersistentEntity;
            if (cascadeOp instanceof AbstractSqlRepositoryOperations.CascadeOneOp) {
                boolean hasId;
                AbstractSqlRepositoryOperations.CascadeOneOp cascadeOneOp = (AbstractSqlRepositoryOperations.CascadeOneOp)cascadeOp;
                childPersistentEntity = cascadeOp.childPersistentEntity;
                Object child2 = cascadeOneOp.child;
                if (persisted.contains(child2)) continue;
                boolean bl = hasId = childPersistentEntity.getIdentity().getProperty().get(child2) != null;
                if (!hasId && cascadeType == Relation.Cascade.PERSIST) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cascading PERSIST for '{}' association: '{}'", (Object)persistentEntity.getName(), (Object)cascadeOp.ctx.associations);
                    }
                    op2 = new JdbcEntityOperations(childPersistentEntity, child2);
                    AbstractSqlRepositoryOperations.SqlOperation childSqlPersistOperation = this.resolveEntityInsert(annotationMetadata, repositoryType, child2.getClass(), childPersistentEntity);
                    this.persistOne(connection, cascadeOneOp.annotationMetadata, cascadeOneOp.repositoryType, childSqlPersistOperation, associations, persisted, (AbstractSqlRepositoryOperations.EntityOperations)op2);
                    entity = this.afterCascadedOne(entity, cascadeOp.ctx.associations, child2, ((JdbcEntityOperations)((Object)op2)).entity);
                    child2 = ((JdbcEntityOperations)((Object)op2)).entity;
                } else if (hasId && cascadeType == Relation.Cascade.UPDATE) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cascading MERGE for '{}' ({}) association: '{}'", new Object[]{persistentEntity.getName(), persistentEntity.getIdentity().getProperty().get(entity), cascadeOp.ctx.associations});
                    }
                    op2 = new JdbcEntityOperations(childPersistentEntity, child2);
                    AbstractSqlRepositoryOperations.SqlOperation childSqlUpdateOperation = this.resolveEntityUpdate(annotationMetadata, repositoryType, child2.getClass(), childPersistentEntity);
                    this.updateOne(connection, cascadeOneOp.annotationMetadata, cascadeOneOp.repositoryType, childSqlUpdateOperation, associations, persisted, (AbstractSqlRepositoryOperations.EntityOperations)op2);
                    entity = this.afterCascadedOne(entity, cascadeOp.ctx.associations, child2, ((JdbcEntityOperations)((Object)op2)).entity);
                    child2 = ((JdbcEntityOperations)((Object)op2)).entity;
                }
                RuntimeAssociation association = (RuntimeAssociation)cascadeOp.ctx.getAssociation();
                if (!hasId && (cascadeType == Relation.Cascade.PERSIST || cascadeType == Relation.Cascade.UPDATE) && SqlQueryBuilder.isForeignKeyWithJoinTable((Association)association)) {
                    this.persistJoinTableAssociation(connection, repositoryType, dialect, (Association)association, entity, (AbstractSqlRepositoryOperations.BaseOperations)new JdbcEntityOperations(childPersistentEntity, child2));
                }
                persisted.add(child2);
                continue;
            }
            if (!(cascadeOp instanceof AbstractSqlRepositoryOperations.CascadeManyOp)) continue;
            AbstractSqlRepositoryOperations.CascadeManyOp cascadeManyOp = (AbstractSqlRepositoryOperations.CascadeManyOp)cascadeOp;
            childPersistentEntity = cascadeManyOp.childPersistentEntity;
            if (cascadeType == Relation.Cascade.UPDATE) {
                entities = CollectionUtils.iterableToList((Iterable)cascadeManyOp.children);
                AbstractSqlRepositoryOperations.SqlOperation childSqlUpdateOperation = this.resolveEntityUpdate(annotationMetadata, repositoryType, childPersistentEntity.getIntrospection().getBeanType(), childPersistentEntity);
                iterator = entities.listIterator();
                while (iterator.hasNext()) {
                    child = iterator.next();
                    if (persisted.contains(child) || (identity = childPersistentEntity.getIdentity()).getProperty().get(child) == null) continue;
                    op = new JdbcEntityOperations(childPersistentEntity, child);
                    this.updateOne(connection, cascadeManyOp.annotationMetadata, cascadeManyOp.repositoryType, childSqlUpdateOperation, associations, persisted, op);
                    iterator.set(op.entity);
                }
            } else {
                if (cascadeType != Relation.Cascade.PERSIST) continue;
                AbstractSqlRepositoryOperations.SqlOperation childSqlPersistOperation = this.resolveEntityInsert(annotationMetadata, repositoryType, childPersistentEntity.getIntrospection().getBeanType(), childPersistentEntity);
                if (this.isSupportsBatchInsert((PersistentEntity)childPersistentEntity, dialect)) {
                    op2 = new JdbcEntitiesOperations(childPersistentEntity, cascadeManyOp.children);
                    ((JdbcEntitiesOperations)((Object)op2)).veto(persisted::contains);
                    RuntimePersistentProperty identity2 = childPersistentEntity.getIdentity();
                    ((JdbcEntitiesOperations)((Object)op2)).veto(e -> identity2.getProperty().get(e) != null);
                    this.persistInBatch(connection, cascadeManyOp.annotationMetadata, cascadeManyOp.repositoryType, childSqlPersistOperation, associations, persisted, (AbstractSqlRepositoryOperations.EntitiesOperations)op2);
                    entities = ((JdbcEntitiesOperations)((Object)op2)).getEntities();
                } else {
                    entities = CollectionUtils.iterableToList((Iterable)cascadeManyOp.children);
                    iterator = entities.listIterator();
                    while (iterator.hasNext()) {
                        child = iterator.next();
                        if (persisted.contains(child) || (identity = childPersistentEntity.getIdentity()).getProperty().get(child) != null) continue;
                        op = new JdbcEntityOperations(childPersistentEntity, child);
                        this.persistOne(connection, cascadeManyOp.annotationMetadata, cascadeManyOp.repositoryType, childSqlPersistOperation, associations, persisted, op);
                        iterator.set(op.entity);
                    }
                }
            }
            entity = this.afterCascadedMany(entity, cascadeOp.ctx.associations, cascadeManyOp.children, entities);
            RuntimeAssociation association = (RuntimeAssociation)cascadeOp.ctx.getAssociation();
            if (SqlQueryBuilder.isForeignKeyWithJoinTable((Association)association) && !entities.isEmpty()) {
                if (dialect.allowBatch()) {
                    JdbcEntitiesOperations<Object> assocOp = new JdbcEntitiesOperations<Object>(childPersistentEntity, entities);
                    assocOp.veto(persisted::contains);
                    this.persistJoinTableAssociation(connection, repositoryType, dialect, (Association)association, cascadeOp.ctx.parent, (AbstractSqlRepositoryOperations.BaseOperations)assocOp);
                } else {
                    for (Object e2 : cascadeManyOp.children) {
                        if (persisted.contains(e2)) continue;
                        this.persistJoinTableAssociation(connection, repositoryType, dialect, (Association)association, cascadeOp.ctx.parent, (AbstractSqlRepositoryOperations.BaseOperations)new JdbcEntityOperations(childPersistentEntity, e2));
                    }
                }
            }
            persisted.addAll(entities);
        }
        return entity;
    }

    protected void prepareStatement(Connection connection, String query, AbstractSqlRepositoryOperations.DBOperation1<PreparedStatement, SQLException> fn) throws SQLException {
        try (PreparedStatement stmt = connection.prepareStatement(query);){
            fn.process((Object)stmt);
        }
    }

    protected void prepareStatement(Connection connection, Dialect dialect, PersistentProperty identity, boolean hasGeneratedID, String insertSql, AbstractSqlRepositoryOperations.DBOperation1<PreparedStatement, SQLException> fn) throws SQLException {
        if (hasGeneratedID && (dialect == Dialect.ORACLE || dialect == Dialect.SQL_SERVER)) {
            try (PreparedStatement stmt = connection.prepareStatement(insertSql, new String[]{identity.getPersistedName()});){
                fn.process((Object)stmt);
            }
        }
        try (PreparedStatement stmt = connection.prepareStatement(insertSql, hasGeneratedID ? 1 : 2);){
            fn.process((Object)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ExecutorAsyncOperations async() {
        ExecutorAsyncOperations asyncOperations = this.asyncOperations;
        if (asyncOperations == null) {
            DefaultJdbcRepositoryOperations defaultJdbcRepositoryOperations = this;
            synchronized (defaultJdbcRepositoryOperations) {
                asyncOperations = this.asyncOperations;
                if (asyncOperations == null) {
                    this.asyncOperations = asyncOperations = new ExecutorAsyncOperations((RepositoryOperations)this, (Executor)(this.executorService != null ? this.executorService : this.newLocalThreadPool()));
                }
            }
        }
        return asyncOperations;
    }

    @NonNull
    public ReactiveRepositoryOperations reactive() {
        return new ExecutorReactiveOperations(this.async());
    }

    @Nullable
    public <T, R> R findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (R)this.transactionOperations.executeRead(status -> {
            Connection connection = (Connection)status.getConnection();
            RuntimePersistentEntity persistentEntity = this.getEntity(preparedQuery.getRootEntity());
            try (PreparedStatement ps = (PreparedStatement)this.prepareStatement(connection::prepareStatement, preparedQuery, false, true);
                 ResultSet rs = ps.executeQuery();){
                Class resultType = preparedQuery.getResultType();
                if (preparedQuery.getResultDataType() == DataType.ENTITY) {
                    RuntimePersistentEntity resultPersistentEntity = this.getEntity(resultType);
                    Set joinFetchPaths = preparedQuery.getJoinFetchPaths();
                    SqlResultEntityTypeMapper mapper = new SqlResultEntityTypeMapper(resultPersistentEntity, this.columnNameResultSetReader, joinFetchPaths, this.jsonCodec, (loadedEntity, o) -> {
                        if (loadedEntity.hasPostLoadEventListeners()) {
                            return this.triggerPostLoad(o, (RuntimePersistentEntity)loadedEntity, preparedQuery.getAnnotationMetadata());
                        }
                        return o;
                    });
                    SqlResultEntityTypeMapper.PushingMapper oneMapper = mapper.readOneWithJoins();
                    if (rs.next()) {
                        oneMapper.processRow((Object)rs);
                    }
                    while (!joinFetchPaths.isEmpty() && rs.next()) {
                        oneMapper.processRow((Object)rs);
                    }
                    Object result = oneMapper.getResult();
                    if (preparedQuery.hasResultConsumer()) {
                        preparedQuery.getParameterInRole("sqlMappingFunction", SqlResultConsumer.class).ifPresent(consumer -> consumer.accept(result, this.newMappingContext(rs)));
                    }
                    Object object = result;
                    return object;
                }
                if (!rs.next()) return null;
                if (preparedQuery.isDtoProjection()) {
                    DTOMapper introspectedDataMapper = new DTOMapper(persistentEntity, this.columnNameResultSetReader, this.jsonCodec);
                    Object object = introspectedDataMapper.map((Object)rs, resultType);
                    return object;
                }
                Object v = this.columnIndexResultSetReader.readDynamic((Object)rs, (Object)1, preparedQuery.getResultDataType());
                if (v == null) {
                    Object var11_20 = null;
                    return var11_20;
                }
                if (resultType.isInstance(v)) {
                    Object object = v;
                    return object;
                }
                Object object = this.columnIndexResultSetReader.convertRequired(v, resultType);
                return object;
            }
            catch (SQLException e) {
                throw new DataAccessException("Error executing SQL Query: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    public <T> boolean exists(@NonNull PreparedQuery<T, Boolean> preparedQuery) {
        return (Boolean)this.transactionOperations.executeRead(status -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    @NonNull
    public <T, R> Stream<R> findStream(@NonNull PreparedQuery<T, R> preparedQuery) {
        return this.findStream(preparedQuery, (Connection)this.transactionOperations.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T, R> Stream<R> findStream(final @NonNull PreparedQuery<T, R> preparedQuery, Connection connection) {
        PreparedStatement ps;
        final Class resultType = preparedQuery.getResultType();
        final AtomicBoolean finished = new AtomicBoolean();
        try {
            ps = (PreparedStatement)this.prepareStatement(connection::prepareStatement, preparedQuery, false, false);
        }
        catch (Exception e) {
            throw new DataAccessException("SQL Error preparing Query: " + e.getMessage(), (Throwable)e);
        }
        ResultSet openedRs = null;
        try {
            SqlDTOMapper mapper;
            Spliterators.AbstractSpliterator spliterator;
            boolean isEntity;
            final ResultSet rs = openedRs = ps.executeQuery();
            boolean dtoProjection = preparedQuery.isDtoProjection();
            boolean bl = isEntity = preparedQuery.getResultDataType() == DataType.ENTITY;
            if (!isEntity && !dtoProjection) {
                spliterator = new Spliterators.AbstractSpliterator<R>(Long.MAX_VALUE, 1040){

                    @Override
                    public boolean tryAdvance(Consumer<? super R> action) {
                        if (finished.get()) {
                            return false;
                        }
                        try {
                            boolean hasNext = rs.next();
                            if (hasNext) {
                                Object r;
                                Object v = DefaultJdbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic((Object)rs, (Object)1, preparedQuery.getResultDataType());
                                if (resultType.isInstance(v)) {
                                    action.accept(v);
                                } else if (v != null && (r = DefaultJdbcRepositoryOperations.this.columnIndexResultSetReader.convertRequired(v, resultType)) != null) {
                                    action.accept(r);
                                }
                            } else {
                                DefaultJdbcRepositoryOperations.this.closeResultSet(ps, rs, finished);
                            }
                            return hasNext;
                        }
                        catch (SQLException e) {
                            throw new DataAccessException("Error retrieving next JDBC result: " + e.getMessage(), (Throwable)e);
                        }
                    }
                };
                return (Stream)StreamSupport.stream(spliterator, false).onClose(() -> this.closeResultSet(ps, rs, finished));
            }
            SqlResultConsumer sqlMappingConsumer = preparedQuery.hasResultConsumer() ? (SqlResultConsumer)preparedQuery.getParameterInRole("sqlMappingFunction", SqlResultConsumer.class).orElse(null) : null;
            RuntimePersistentEntity persistentEntity = this.getEntity(resultType);
            if (dtoProjection) {
                mapper = new SqlDTOMapper(persistentEntity, this.columnNameResultSetReader, this.jsonCodec);
            } else {
                Set joinFetchPaths = preparedQuery.getJoinFetchPaths();
                SqlResultEntityTypeMapper entityTypeMapper = new SqlResultEntityTypeMapper(persistentEntity, this.columnNameResultSetReader, joinFetchPaths, this.jsonCodec, (loadedEntity, o) -> {
                    if (loadedEntity.hasPostLoadEventListeners()) {
                        return this.triggerPostLoad(o, (RuntimePersistentEntity)loadedEntity, preparedQuery.getAnnotationMetadata());
                    }
                    return o;
                });
                boolean onlySingleEndedJoins = this.isOnlySingleEndedJoins(this.getEntity(preparedQuery.getRootEntity()), joinFetchPaths);
                if (!onlySingleEndedJoins) {
                    try {
                        SqlResultEntityTypeMapper.PushingMapper manyMapper = entityTypeMapper.readAllWithJoins();
                        while (rs.next()) {
                            manyMapper.processRow((Object)rs);
                        }
                        Stream stream = ((List)manyMapper.getResult()).stream();
                        return stream;
                    }
                    finally {
                        this.closeResultSet(ps, rs, finished);
                    }
                }
                mapper = entityTypeMapper;
            }
            spliterator = new Spliterators.AbstractSpliterator<R>(Long.MAX_VALUE, 1040, (SqlTypeMapper)mapper, rs, resultType, sqlMappingConsumer, ps){
                final /* synthetic */ SqlTypeMapper val$mapper;
                final /* synthetic */ ResultSet val$rs;
                final /* synthetic */ Class val$resultType;
                final /* synthetic */ SqlResultConsumer val$sqlMappingConsumer;
                final /* synthetic */ PreparedStatement val$ps;
                {
                    this.val$mapper = sqlTypeMapper;
                    this.val$rs = resultSet;
                    this.val$resultType = clazz;
                    this.val$sqlMappingConsumer = sqlResultConsumer;
                    this.val$ps = preparedStatement;
                    super(x0, x1);
                }

                @Override
                public boolean tryAdvance(Consumer<? super R> action) {
                    if (finished.get()) {
                        return false;
                    }
                    boolean hasNext = this.val$mapper.hasNext((Object)this.val$rs);
                    if (hasNext) {
                        Object o = this.val$mapper.map((Object)this.val$rs, this.val$resultType);
                        if (this.val$sqlMappingConsumer != null) {
                            this.val$sqlMappingConsumer.accept(this.val$rs, o);
                        }
                        action.accept(o);
                    } else {
                        DefaultJdbcRepositoryOperations.this.closeResultSet(this.val$ps, this.val$rs, finished);
                    }
                    return hasNext;
                }
            };
            return (Stream)StreamSupport.stream(spliterator, false).onClose(() -> this.closeResultSet(ps, rs, finished));
        }
        catch (Exception e) {
            this.closeResultSet(ps, openedRs, finished);
            throw new DataAccessException("SQL Error executing Query: " + e.getMessage(), (Throwable)e);
        }
    }

    private void closeResultSet(PreparedStatement ps, ResultSet rs, AtomicBoolean finished) {
        if (finished.compareAndSet(false, true)) {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                throw new DataAccessException("Error closing JDBC result stream: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @NonNull
    public <T, R> Iterable<R> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (Iterable)this.transactionOperations.executeRead(status -> {
            Connection connection = (Connection)status.getConnection();
            return this.findStream(preparedQuery, connection).collect(Collectors.toList());
        });
    }

    @NonNull
    public Optional<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return (Optional)this.transactionOperations.executeWrite(status -> {
            try {
                Connection connection = (Connection)status.getConnection();
                try (PreparedStatement ps = (PreparedStatement)this.prepareStatement(connection::prepareStatement, preparedQuery, true, false);){
                    int result = ps.executeUpdate();
                    if (QUERY_LOG.isTraceEnabled()) {
                        QUERY_LOG.trace("Update operation updated {} records", (Object)result);
                    }
                    if (preparedQuery.isOptimisticLock()) {
                        this.checkOptimisticLocking(1, result);
                    }
                    Optional<Integer> optional = Optional.of(result);
                    return optional;
                }
            }
            catch (SQLException e) {
                throw new DataAccessException("Error executing SQL UPDATE: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    private Integer sum(Stream<Integer> stream) {
        return stream.mapToInt(i -> i).sum();
    }

    public <T> Optional<Number> deleteAll(@NonNull DeleteBatchOperation<T> operation) {
        return Optional.ofNullable(this.transactionOperations.executeWrite(status -> {
            AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
            SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(operation.getRepositoryType(), DEFAULT_SQL_BUILDER);
            Dialect dialect = queryBuilder.dialect();
            RuntimePersistentEntity persistentEntity = this.getEntity(operation.getRootEntity());
            if (this.isSupportsBatchDelete((PersistentEntity)persistentEntity, dialect)) {
                JdbcEntitiesOperations op = new JdbcEntitiesOperations(this.getEntity(operation.getRootEntity()), (Iterable)operation);
                this.deleteInBatch(status.getConnection(), dialect, annotationMetadata, op);
                return op.rowsUpdated;
            }
            return this.sum(operation.split().stream().map(deleteOp -> {
                JdbcEntityOperations op = new JdbcEntityOperations(this.getEntity(deleteOp.getRootEntity()), deleteOp.getEntity());
                this.deleteOne(status.getConnection(), dialect, annotationMetadata, op, queryBuilder);
                return op.rowsUpdated;
            }));
        }));
    }

    public <T> int delete(@NonNull DeleteOperation<T> operation) {
        AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
        SqlQueryBuilder sqlQueryBuilder = this.queryBuilders.getOrDefault(operation.getRepositoryType(), DEFAULT_SQL_BUILDER);
        Dialect dialect = sqlQueryBuilder.dialect();
        return ((JdbcEntityOperations)((Object)this.transactionOperations.executeWrite(status -> {
            JdbcEntityOperations op = new JdbcEntityOperations(this.getEntity(operation.getRootEntity()), operation.getEntity());
            this.deleteOne(status.getConnection(), dialect, annotationMetadata, op, sqlQueryBuilder);
            return op;
        }))).rowsUpdated;
    }

    @NonNull
    public <T> T update(@NonNull UpdateOperation<T> operation) {
        AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
        HashSet persisted = new HashSet(10);
        Class repositoryType = operation.getRepositoryType();
        Dialect dialect = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER).dialect();
        AbstractSqlRepositoryOperations.StoredAnnotationMetadataSqlOperation sqlOperation = new AbstractSqlRepositoryOperations.StoredAnnotationMetadataSqlOperation((AbstractSqlRepositoryOperations)this, dialect, annotationMetadata);
        return (T)((JdbcEntityOperations)((Object)this.transactionOperations.executeWrite(arg_0 -> this.lambda$update$13(operation, annotationMetadata, repositoryType, (AbstractSqlRepositoryOperations.StoredSqlOperation)sqlOperation, persisted, arg_0)))).entity;
    }

    @NonNull
    public <T> Iterable<T> updateAll(@NonNull UpdateBatchOperation<T> operation) {
        return (Iterable)this.transactionOperations.executeWrite(status -> {
            AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
            HashSet persisted = new HashSet(10);
            Class repositoryType = operation.getRepositoryType();
            Dialect dialect = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER).dialect();
            RuntimePersistentEntity persistentEntity = this.getEntity(operation.getRootEntity());
            AbstractSqlRepositoryOperations.StoredAnnotationMetadataSqlOperation sqlOperation = new AbstractSqlRepositoryOperations.StoredAnnotationMetadataSqlOperation((AbstractSqlRepositoryOperations)this, dialect, annotationMetadata);
            if (!this.isSupportsBatchUpdate((PersistentEntity)persistentEntity, dialect)) {
                return operation.split().stream().map(arg_0 -> this.lambda$null$14(persistentEntity, status, annotationMetadata, repositoryType, (AbstractSqlRepositoryOperations.StoredSqlOperation)sqlOperation, persisted, arg_0)).collect(Collectors.toList());
            }
            JdbcEntitiesOperations op = new JdbcEntitiesOperations(persistentEntity, (Iterable)operation);
            this.updateInBatch(status.getConnection(), annotationMetadata, repositoryType, (AbstractSqlRepositoryOperations.StoredSqlOperation)sqlOperation, Collections.emptyList(), persisted, op);
            return op.getEntities();
        });
    }

    @NonNull
    public <T> T persist(@NonNull InsertOperation<T> operation) {
        AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
        Class repositoryType = operation.getRepositoryType();
        Dialect dialect = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER).dialect();
        AbstractSqlRepositoryOperations.StoredAnnotationMetadataSqlOperation sqlOperation = new AbstractSqlRepositoryOperations.StoredAnnotationMetadataSqlOperation((AbstractSqlRepositoryOperations)this, dialect, annotationMetadata);
        return (T)((JdbcEntityOperations)((Object)this.transactionOperations.executeWrite(arg_0 -> this.lambda$persist$16(operation, annotationMetadata, repositoryType, (AbstractSqlRepositoryOperations.SqlOperation)sqlOperation, arg_0)))).entity;
    }

    @Nullable
    public <T> T findOne(@NonNull Class<T> type, @NonNull Serializable id) {
        throw new UnsupportedOperationException("The findOne method by ID is not supported. Execute the SQL query directly");
    }

    @NonNull
    public <T> Iterable<T> findAll(@NonNull PagedQuery<T> query) {
        throw new UnsupportedOperationException("The findAll method without an explicit query is not supported. Use findAll(PreparedQuery) instead");
    }

    public <T> long count(PagedQuery<T> pagedQuery) {
        throw new UnsupportedOperationException("The count method without an explicit query is not supported. Use findAll(PreparedQuery) instead");
    }

    @NonNull
    public <T> Stream<T> findStream(@NonNull PagedQuery<T> query) {
        throw new UnsupportedOperationException("The findStream method without an explicit query is not supported. Use findStream(PreparedQuery) instead");
    }

    public <R> Page<R> findPage(@NonNull PagedQuery<R> query) {
        throw new UnsupportedOperationException("The findPage method without an explicit query is not supported. Use findPage(PreparedQuery) instead");
    }

    @NonNull
    public <T> Iterable<T> persistAll(@NonNull InsertBatchOperation<T> operation) {
        return (Iterable)this.transactionOperations.executeWrite(status -> {
            AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
            Class repositoryType = operation.getRepositoryType();
            Dialect dialect = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER).dialect();
            AbstractSqlRepositoryOperations.StoredAnnotationMetadataSqlOperation sqlOperation = new AbstractSqlRepositoryOperations.StoredAnnotationMetadataSqlOperation((AbstractSqlRepositoryOperations)this, dialect, annotationMetadata);
            RuntimePersistentEntity persistentEntity = this.getEntity(operation.getRootEntity());
            HashSet persisted = new HashSet(5);
            if (!this.isSupportsBatchInsert((PersistentEntity)persistentEntity, dialect)) {
                return operation.split().stream().map(arg_0 -> this.lambda$null$17(persistentEntity, status, annotationMetadata, repositoryType, (AbstractSqlRepositoryOperations.SqlOperation)sqlOperation, persisted, arg_0)).collect(Collectors.toList());
            }
            JdbcEntitiesOperations op = new JdbcEntitiesOperations(persistentEntity, (Iterable)operation);
            this.persistInBatch(status.getConnection(), operation.getAnnotationMetadata(), operation.getRepositoryType(), (AbstractSqlRepositoryOperations.SqlOperation)sqlOperation, Collections.emptyList(), persisted, op);
            return op.getEntities();
        });
    }

    @Override
    @PreDestroy
    public void close() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    @Override
    @NonNull
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    @NonNull
    public Connection getConnection() {
        return (Connection)this.transactionOperations.getConnection();
    }

    @Override
    @NonNull
    public <R> R execute(@NonNull ConnectionCallback<R> callback) {
        try {
            return callback.call((Connection)this.transactionOperations.getConnection());
        }
        catch (SQLException e) {
            throw new DataAccessException("Error executing SQL Callback: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public <R> R prepareStatement(@NonNull String sql, @NonNull PreparedStatementCallback<R> callback) {
        ArgumentUtils.requireNonNull((String)"sql", (Object)sql);
        ArgumentUtils.requireNonNull((String)"callback", callback);
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Query: {}", (Object)sql);
        }
        try {
            R result = null;
            PreparedStatement ps = ((Connection)this.transactionOperations.getConnection()).prepareStatement(sql);
            try {
                R r = result = (R)callback.call(ps);
                return r;
            }
            finally {
                if (!(result instanceof AutoCloseable)) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            throw new DataAccessException("Error preparing SQL statement: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @NonNull
    public <T> Stream<T> entityStream(@NonNull ResultSet resultSet, @NonNull Class<T> rootEntity) {
        return this.entityStream(resultSet, null, rootEntity);
    }

    @Override
    @NonNull
    public <E> E readEntity(@NonNull String prefix, @NonNull ResultSet resultSet, @NonNull Class<E> type) throws DataAccessException {
        return (E)new SqlResultEntityTypeMapper(prefix, this.getEntity(type), this.columnNameResultSetReader, this.jsonCodec).map((Object)resultSet, type);
    }

    @Override
    @NonNull
    public <E, D> D readDTO(@NonNull String prefix, @NonNull ResultSet resultSet, @NonNull Class<E> rootEntity, @NonNull Class<D> dtoType) throws DataAccessException {
        return (D)new DTOMapper(this.getEntity(rootEntity), this.columnNameResultSetReader, this.jsonCodec).map((Object)resultSet, dtoType);
    }

    @Override
    @NonNull
    public <T> Stream<T> entityStream(@NonNull ResultSet resultSet, @Nullable String prefix, @NonNull Class<T> rootEntity) {
        ArgumentUtils.requireNonNull((String)"resultSet", (Object)resultSet);
        ArgumentUtils.requireNonNull((String)"rootEntity", rootEntity);
        SqlResultEntityTypeMapper mapper = new SqlResultEntityTypeMapper(prefix, this.getEntity(rootEntity), this.columnNameResultSetReader, this.jsonCodec);
        Iterable iterable = () -> this.lambda$entityStream$19(resultSet, (TypeMapper)mapper, rootEntity);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    @NonNull
    protected ResultConsumer.Context<ResultSet> newMappingContext(final ResultSet rs) {
        return new ResultConsumer.Context<ResultSet>(){

            public ResultSet getResultSet() {
                return rs;
            }

            public ResultReader<ResultSet, String> getResultReader() {
                return DefaultJdbcRepositoryOperations.this.columnNameResultSetReader;
            }

            @NonNull
            public <E> E readEntity(String prefix, Class<E> type) throws DataAccessException {
                RuntimePersistentEntity entity = DefaultJdbcRepositoryOperations.this.getEntity(type);
                SqlResultEntityTypeMapper mapper = new SqlResultEntityTypeMapper(prefix, entity, DefaultJdbcRepositoryOperations.this.columnNameResultSetReader, DefaultJdbcRepositoryOperations.this.jsonCodec);
                return (E)mapper.map((Object)rs, type);
            }

            @NonNull
            public <E, D> D readDTO(@NonNull String prefix, @NonNull Class<E> rootEntity, @NonNull Class<D> dtoType) throws DataAccessException {
                RuntimePersistentEntity entity = DefaultJdbcRepositoryOperations.this.getEntity(rootEntity);
                DTOMapper introspectedDataMapper = new DTOMapper(entity, DefaultJdbcRepositoryOperations.this.columnNameResultSetReader, DefaultJdbcRepositoryOperations.this.jsonCodec);
                return (D)introspectedDataMapper.map((Object)rs, dtoType);
            }
        };
    }

    private /* synthetic */ Iterator lambda$entityStream$19(final ResultSet resultSet, final TypeMapper mapper, final Class rootEntity) {
        return new Iterator<T>(){
            boolean nextCalled = false;

            @Override
            public boolean hasNext() {
                try {
                    if (!this.nextCalled) {
                        this.nextCalled = true;
                        return resultSet.next();
                    }
                    return this.nextCalled;
                }
                catch (SQLException e) {
                    throw new DataAccessException("Error retrieving next JDBC result: " + e.getMessage(), (Throwable)e);
                }
            }

            @Override
            public T next() {
                this.nextCalled = false;
                return mapper.map((Object)resultSet, rootEntity);
            }
        };
    }

    private /* synthetic */ Object lambda$null$17(RuntimePersistentEntity persistentEntity, TransactionStatus status, AnnotationMetadata annotationMetadata, Class repositoryType, AbstractSqlRepositoryOperations.SqlOperation sqlOperation, HashSet persisted, InsertOperation persistOp) {
        JdbcEntityOperations op = new JdbcEntityOperations(persistentEntity, persistOp.getEntity());
        this.persistOne(status.getConnection(), annotationMetadata, repositoryType, sqlOperation, Collections.emptyList(), persisted, op);
        return op.entity;
    }

    private /* synthetic */ JdbcEntityOperations lambda$persist$16(InsertOperation operation, AnnotationMetadata annotationMetadata, Class repositoryType, AbstractSqlRepositoryOperations.SqlOperation sqlOperation, TransactionStatus status) throws Exception {
        JdbcEntityOperations op = new JdbcEntityOperations(this.getEntity(operation.getRootEntity()), operation.getEntity());
        this.persistOne(status.getConnection(), annotationMetadata, repositoryType, sqlOperation, Collections.emptyList(), new HashSet(5), op);
        return op;
    }

    private /* synthetic */ Object lambda$null$14(RuntimePersistentEntity persistentEntity, TransactionStatus status, AnnotationMetadata annotationMetadata, Class repositoryType, AbstractSqlRepositoryOperations.StoredSqlOperation sqlOperation, Set persisted, UpdateOperation updateOp) {
        JdbcEntityOperations op = new JdbcEntityOperations(persistentEntity, updateOp.getEntity());
        this.updateOne(status.getConnection(), annotationMetadata, repositoryType, (AbstractSqlRepositoryOperations.SqlOperation)sqlOperation, Collections.emptyList(), persisted, op);
        return op.entity;
    }

    private /* synthetic */ JdbcEntityOperations lambda$update$13(UpdateOperation operation, AnnotationMetadata annotationMetadata, Class repositoryType, AbstractSqlRepositoryOperations.StoredSqlOperation sqlOperation, Set persisted, TransactionStatus status) throws Exception {
        JdbcEntityOperations op = new JdbcEntityOperations(this.getEntity(operation.getRootEntity()), operation.getEntity());
        this.updateOne(status.getConnection(), annotationMetadata, repositoryType, (AbstractSqlRepositoryOperations.SqlOperation)sqlOperation, Collections.emptyList(), persisted, op);
        return op;
    }

    private final class JdbcEntitiesOperations<T>
    extends AbstractSqlRepositoryOperations.EntitiesOperations<T> {
        private final List<Data> entities;
        private int rowsUpdated;

        private JdbcEntitiesOperations(RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities) {
            super((AbstractSqlRepositoryOperations)DefaultJdbcRepositoryOperations.this, persistentEntity);
            Objects.requireNonNull(entities, "Entities cannot be null");
            if (!entities.iterator().hasNext()) {
                throw new IllegalStateException("Entities cannot be empty");
            }
            Stream stream = entities instanceof Collection ? ((Collection)entities).stream() : CollectionUtils.iterableToList(entities).stream();
            this.entities = stream.map(entity -> {
                Data d = new Data();
                d.entity = entity;
                return d;
            }).collect(Collectors.toList());
        }

        protected void cascadePre(Relation.Cascade cascadeType, Connection connection, Dialect dialect, AnnotationMetadata annotationMetadata, Class<?> repositoryType, List<Association> associations, Set<Object> persisted) {
            for (Data d : this.entities) {
                if (d.vetoed) continue;
                d.entity = DefaultJdbcRepositoryOperations.this.cascadeEntity(d.entity, this.persistentEntity, false, cascadeType, connection, dialect, annotationMetadata, repositoryType, associations, persisted);
            }
        }

        protected void cascadePost(Relation.Cascade cascadeType, Connection connection, Dialect dialect, AnnotationMetadata annotationMetadata, Class<?> repositoryType, List<Association> associations, Set<Object> persisted) {
            for (Data d : this.entities) {
                if (d.vetoed) continue;
                d.entity = DefaultJdbcRepositoryOperations.this.cascadeEntity(d.entity, this.persistentEntity, true, cascadeType, connection, dialect, annotationMetadata, repositoryType, associations, persisted);
            }
        }

        protected void collectAutoPopulatedPreviousValues(AbstractSqlRepositoryOperations.SqlOperation sqlOperation) {
            for (Data d : this.entities) {
                if (d.vetoed) continue;
                sqlOperation.collectAutoPopulatedPreviousValues(this.persistentEntity, d.entity);
            }
        }

        protected void veto(Predicate<T> predicate) {
            for (Data d : this.entities) {
                if (d.vetoed) continue;
                d.vetoed = predicate.test(d.entity);
            }
        }

        protected boolean triggerPre(Function<EntityEventContext<Object>, Boolean> fn) {
            boolean allVetoed = true;
            for (Data d : this.entities) {
                if (d.vetoed) continue;
                DefaultEntityEventContext event = new DefaultEntityEventContext(this.persistentEntity, d.entity);
                if (!fn.apply((EntityEventContext<Object>)event).booleanValue()) {
                    d.vetoed = true;
                    continue;
                }
                d.entity = event.getEntity();
                allVetoed = false;
            }
            return allVetoed;
        }

        protected void triggerPost(Consumer<EntityEventContext<Object>> fn) {
            for (Data d : this.entities) {
                if (d.vetoed) continue;
                DefaultEntityEventContext event = new DefaultEntityEventContext(this.persistentEntity, d.entity);
                fn.accept((EntityEventContext<Object>)event);
                d.entity = event.getEntity();
            }
        }

        protected void setParameters(PreparedStatement stmt, AbstractSqlRepositoryOperations.SqlOperation sqlOperation) throws SQLException {
            for (Data d : this.entities) {
                if (d.vetoed) continue;
                sqlOperation.setParameters((Object)stmt, this.persistentEntity, d.entity, d.previousValues);
                stmt.addBatch();
            }
        }

        protected void executeUpdate(PreparedStatement stmt) throws SQLException {
            this.rowsUpdated = Arrays.stream(stmt.executeBatch()).sum();
        }

        protected void executeUpdate(PreparedStatement stmt, AbstractSqlRepositoryOperations.DBOperation2<Integer, Integer, SQLException> fn) throws SQLException {
            this.rowsUpdated = Arrays.stream(stmt.executeBatch()).sum();
            int expected = (int)this.entities.stream().filter(d -> !d.vetoed).count();
            fn.process((Object)expected, (Object)this.rowsUpdated);
        }

        protected void executeUpdateSetGeneratedId(PreparedStatement stmt) throws SQLException {
            RuntimePersistentProperty identity = this.persistentEntity.getIdentity();
            this.rowsUpdated = Arrays.stream(stmt.executeBatch()).sum();
            ArrayList<Object> ids = new ArrayList<Object>();
            ResultSet generatedKeys = stmt.getGeneratedKeys();
            Object object = null;
            try {
                while (generatedKeys.next()) {
                    ids.add(DefaultJdbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic((Object)generatedKeys, (Object)1, identity.getDataType()));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (generatedKeys != null) {
                    if (object != null) {
                        try {
                            generatedKeys.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        generatedKeys.close();
                    }
                }
            }
            Iterator iterator = ids.iterator();
            for (Data d : this.entities) {
                if (d.vetoed) continue;
                if (!iterator.hasNext()) {
                    throw new DataAccessException("Failed to generate ID for entity: " + d.entity);
                }
                Object id = iterator.next();
                d.entity = this.updateEntityId(identity.getProperty(), d.entity, id);
            }
        }

        protected List<T> getEntities() {
            return this.entities.stream().map(d -> d.entity).collect(Collectors.toList());
        }

        class Data {
            T entity;
            Map<String, Object> previousValues;
            boolean vetoed = false;

            Data() {
            }
        }
    }

    private final class JdbcEntityOperations<T>
    extends AbstractSqlRepositoryOperations.EntityOperations<T> {
        private T entity;
        private Integer rowsUpdated;
        private Map<String, Object> previousValues;

        private JdbcEntityOperations(RuntimePersistentEntity<T> persistentEntity, T entity) {
            super((AbstractSqlRepositoryOperations)DefaultJdbcRepositoryOperations.this, persistentEntity);
            Objects.requireNonNull(entity, "Passed entity cannot be null");
            this.entity = entity;
        }

        protected void cascadePre(Relation.Cascade cascadeType, Connection connection, Dialect dialect, AnnotationMetadata annotationMetadata, Class<?> repositoryType, List<Association> associations, Set<Object> persisted) {
            this.entity = DefaultJdbcRepositoryOperations.this.cascadeEntity(this.entity, this.persistentEntity, false, cascadeType, connection, dialect, annotationMetadata, repositoryType, associations, persisted);
        }

        protected void cascadePost(Relation.Cascade cascadeType, Connection connection, Dialect dialect, AnnotationMetadata annotationMetadata, Class<?> repositoryType, List<Association> associations, Set<Object> persisted) {
            this.entity = DefaultJdbcRepositoryOperations.this.cascadeEntity(this.entity, this.persistentEntity, true, cascadeType, connection, dialect, annotationMetadata, repositoryType, associations, persisted);
        }

        protected void collectAutoPopulatedPreviousValues(AbstractSqlRepositoryOperations.SqlOperation sqlOperation) {
            this.previousValues = sqlOperation.collectAutoPopulatedPreviousValues(this.persistentEntity, this.entity);
        }

        protected void checkForParameterToBeExpanded(AbstractSqlRepositoryOperations.SqlOperation sqlOperation, SqlQueryBuilder queryBuilder) {
            if (AbstractSqlRepositoryOperations.StoredSqlOperation.class.isInstance(sqlOperation)) {
                ((AbstractSqlRepositoryOperations.StoredSqlOperation)sqlOperation).checkForParameterToBeExpanded(this.persistentEntity, this.entity, queryBuilder);
            }
        }

        protected void setParameters(PreparedStatement stmt, AbstractSqlRepositoryOperations.SqlOperation sqlOperation) {
            sqlOperation.setParameters((Object)stmt, this.persistentEntity, this.entity, this.previousValues);
        }

        protected void executeUpdate(PreparedStatement stmt, AbstractSqlRepositoryOperations.DBOperation2<Integer, Integer, SQLException> fn) throws SQLException {
            int ru = stmt.executeUpdate();
            fn.process((Object)1, (Object)ru);
            this.rowsUpdated = ru;
        }

        protected void executeUpdate(PreparedStatement stmt) throws SQLException {
            this.rowsUpdated = stmt.executeUpdate();
        }

        protected void executeUpdateSetGeneratedId(PreparedStatement stmt) throws SQLException {
            block13: {
                this.rowsUpdated = stmt.executeUpdate();
                try (ResultSet generatedKeys = stmt.getGeneratedKeys();){
                    if (generatedKeys.next()) {
                        RuntimePersistentProperty identity = this.persistentEntity.getIdentity();
                        Object id = DefaultJdbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic((Object)generatedKeys, (Object)1, identity.getDataType());
                        BeanProperty property = identity.getProperty();
                        this.entity = this.updateEntityId(property, this.entity, id);
                        break block13;
                    }
                    throw new DataAccessException("Failed to generate ID for entity: " + this.entity);
                }
            }
        }

        protected boolean triggerPre(Function<EntityEventContext<Object>, Boolean> fn) {
            boolean vetoed;
            DefaultEntityEventContext event = new DefaultEntityEventContext(this.persistentEntity, this.entity);
            boolean bl = vetoed = fn.apply((EntityEventContext<Object>)event) == false;
            if (vetoed) {
                return true;
            }
            Object newEntity = event.getEntity();
            if (this.entity != newEntity) {
                this.entity = newEntity;
            }
            return false;
        }

        protected void triggerPost(Consumer<EntityEventContext<Object>> fn) {
            DefaultEntityEventContext event = new DefaultEntityEventContext(this.persistentEntity, this.entity);
            fn.accept((EntityEventContext<Object>)event);
        }

        protected void veto(Predicate<T> predicate) {
            throw new IllegalStateException("Not supported");
        }
    }
}

