/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.mapper;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.DataType;
import io.micronaut.data.runtime.mapper.ResultReader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

public final class ColumnNameResultSetReader
implements ResultReader<ResultSet, String> {
    private final ConversionService<?> conversionService = ConversionService.SHARED;

    @Nullable
    public Object readDynamic(@NonNull ResultSet resultSet, @NonNull String index, @NonNull DataType dataType) {
        Object val = super.readDynamic((Object)resultSet, (Object)index, dataType);
        try {
            return resultSet.wasNull() ? null : val;
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public boolean next(ResultSet resultSet) {
        try {
            return resultSet.next();
        }
        catch (SQLException e) {
            throw new DataAccessException("Error calling next on SQL result set: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> T convertRequired(@NonNull Object value, Class<T> type) {
        if (value == null) {
            throw new DataAccessException("Cannot convert type null value to target type: " + type + ". Consider defining a TypeConverter bean to handle this case.");
        }
        Class wrapperType = ReflectionUtils.getWrapperType(type);
        if (wrapperType.isInstance(value)) {
            return (T)value;
        }
        return this.conversionService.convert(value, type).orElseThrow(() -> new DataAccessException("Cannot convert type [" + value.getClass() + "] with value [" + value + "] to target type: " + type + ". Consider defining a TypeConverter bean to handle this case."));
    }

    public Date readTimestamp(ResultSet resultSet, String index) {
        try {
            return resultSet.getTimestamp(index);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(index, e);
        }
    }

    public long readLong(ResultSet resultSet, String name) {
        try {
            return resultSet.getLong(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public char readChar(ResultSet resultSet, String name) {
        try {
            return (char)resultSet.getInt(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public Date readDate(ResultSet resultSet, String name) {
        try {
            return resultSet.getDate(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    @Nullable
    public String readString(ResultSet resultSet, String name) {
        try {
            return resultSet.getString(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public int readInt(ResultSet resultSet, String name) {
        try {
            return resultSet.getInt(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public boolean readBoolean(ResultSet resultSet, String name) {
        try {
            return resultSet.getBoolean(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public float readFloat(ResultSet resultSet, String name) {
        try {
            return resultSet.getFloat(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public byte readByte(ResultSet resultSet, String name) {
        try {
            return resultSet.getByte(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public short readShort(ResultSet resultSet, String name) {
        try {
            return resultSet.getShort(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public double readDouble(ResultSet resultSet, String name) {
        try {
            return resultSet.getDouble(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public BigDecimal readBigDecimal(ResultSet resultSet, String name) {
        try {
            return resultSet.getBigDecimal(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public byte[] readBytes(ResultSet resultSet, String name) {
        try {
            return resultSet.getBytes(name);
        }
        catch (SQLException e) {
            throw this.exceptionForColumn(name, e);
        }
    }

    public <T> T getRequiredValue(ResultSet resultSet, String name, Class<T> type) throws DataAccessException {
        try {
            Object o = Blob.class.isAssignableFrom(type) ? resultSet.getBlob(name) : (Clob.class.isAssignableFrom(type) ? resultSet.getClob(name) : resultSet.getObject(name));
            if (o == null) {
                return null;
            }
            if (type.isInstance(o)) {
                return (T)o;
            }
            return this.convertRequired(o, type);
        }
        catch (ConversionErrorException | SQLException e) {
            throw this.exceptionForColumn(name, (Exception)e);
        }
    }

    private DataAccessException exceptionForColumn(String name, Exception e) {
        return new DataAccessException("Error reading object for name [" + name + "] from result set: " + e.getMessage(), (Throwable)e);
    }
}

