/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.operations;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.Property;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.annotation.DateCreated;
import io.micronaut.data.annotation.DateUpdated;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.EntityOperation;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.config.DataSettings;
import io.micronaut.data.runtime.mapper.QueryStatement;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.MediaTypeCodec;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public abstract class AbstractSqlRepositoryOperations<RS, PS>
implements RepositoryOperations {
    protected static final Logger QUERY_LOG = DataSettings.QUERY_LOG;
    protected static final SqlQueryBuilder DEFAULT_SQL_BUILDER = new SqlQueryBuilder();
    protected static final Pattern IN_EXPRESSION_PATTERN = Pattern.compile("\\s\\?\\$IN\\((\\d+)\\)");
    protected static final String NOT_TRUE_EXPRESSION = "1 = 2";
    protected final ResultReader<RS, String> columnNameResultSetReader;
    protected final ResultReader<RS, Integer> columnIndexResultSetReader;
    protected final QueryStatement<PS, Integer> preparedStatementWriter;
    protected final Map<Class, Dialect> dialects = new HashMap<Class, Dialect>(10);
    protected final Map<Dialect, SqlQueryBuilder> queryBuilders = new HashMap<Dialect, SqlQueryBuilder>(Dialect.values().length);
    protected final MediaTypeCodec jsonCodec;
    private final Map<Class, StoredInsert> storedInserts = new ConcurrentHashMap<Class, StoredInsert>(10);
    private final Map<Class, RuntimePersistentEntity> entities = new ConcurrentHashMap<Class, RuntimePersistentEntity>(10);
    private final Map<Class, RuntimePersistentProperty> idReaders = new ConcurrentHashMap<Class, RuntimePersistentProperty>(10);

    protected AbstractSqlRepositoryOperations(ResultReader<RS, String> columnNameResultSetReader, ResultReader<RS, Integer> columnIndexResultSetReader, QueryStatement<PS, Integer> preparedStatementWriter, List<MediaTypeCodec> codecs) {
        this.columnNameResultSetReader = columnNameResultSetReader;
        this.columnIndexResultSetReader = columnIndexResultSetReader;
        this.preparedStatementWriter = preparedStatementWriter;
        this.jsonCodec = this.resolveJsonCodec(codecs);
    }

    private MediaTypeCodec resolveJsonCodec(List<MediaTypeCodec> codecs) {
        return CollectionUtils.isNotEmpty(codecs) ? (MediaTypeCodec)codecs.stream().filter(c -> c.getMediaTypes().contains(MediaType.APPLICATION_JSON_TYPE)).findFirst().orElse(null) : null;
    }

    @NonNull
    public final <T> RuntimePersistentEntity<T> getEntity(@NonNull Class<T> type) {
        ArgumentUtils.requireNonNull((String)"type", type);
        RuntimePersistentEntity entity = this.entities.get(type);
        if (entity == null) {
            entity = new RuntimePersistentEntity<T>(type){

                protected RuntimePersistentEntity<T> getEntity(Class<T> type) {
                    return AbstractSqlRepositoryOperations.this.getEntity(type);
                }
            };
            this.entities.put(type, entity);
        }
        return entity;
    }

    protected final <T> void setInsertParameters(@NonNull StoredInsert<T> insert, @NonNull T entity, @NonNull PS stmt) {
        Date now = null;
        RuntimePersistentEntity<T> persistentEntity = insert.getPersistentEntity();
        for (Map.Entry<String, Integer> entry : insert.getParameterBinding().entrySet()) {
            String propName = entry.getKey();
            RuntimePersistentProperty prop = persistentEntity.getPropertyByName(propName);
            if (prop == null) {
                Association assoc;
                RuntimePersistentProperty embeddedProp;
                int i = propName.indexOf(46);
                if (i <= -1 || (embeddedProp = (RuntimePersistentProperty)persistentEntity.getPropertyByPath(propName).orElse(null)) == null || !((prop = persistentEntity.getPropertyByName(propName.substring(0, i))) instanceof Association) || (assoc = (Association)prop).getKind() != Relation.Kind.EMBEDDED) continue;
                Object value = prop.getProperty().get(entity);
                Object embeddedValue = embeddedProp.getProperty().get(value);
                int index = entry.getValue();
                this.preparedStatementWriter.setDynamic(stmt, (Object)index, embeddedProp.getDataType(), embeddedValue);
                continue;
            }
            DataType type = prop.getDataType();
            BeanProperty beanProperty = prop.getProperty();
            Object value = beanProperty.get(entity);
            int index = entry.getValue();
            if (prop instanceof Association) {
                Association association = (Association)prop;
                if (association.isForeignKey()) continue;
                RuntimePersistentEntity associatedEntity = (RuntimePersistentEntity)association.getAssociatedEntity();
                RuntimePersistentProperty identity = associatedEntity.getIdentity();
                if (identity == null) {
                    throw new IllegalArgumentException("Associated entity has not ID: " + associatedEntity.getName());
                }
                type = identity.getDataType();
                BeanProperty identityProperty = identity.getProperty();
                if (value != null) {
                    value = identityProperty.get(value);
                }
                if (DataSettings.QUERY_LOG.isTraceEnabled()) {
                    DataSettings.QUERY_LOG.trace("Binding value {} to parameter at position: {}", value, (Object)index);
                }
                this.preparedStatementWriter.setDynamic(stmt, (Object)index, type, value);
                continue;
            }
            if (prop.isGenerated()) continue;
            if (beanProperty.hasStereotype(AutoPopulated.class)) {
                if (beanProperty.hasAnnotation(DateCreated.class)) {
                    Date date = now = now != null ? now : new Date();
                    if (DataSettings.QUERY_LOG.isTraceEnabled()) {
                        DataSettings.QUERY_LOG.trace("Binding value {} to parameter at position: {}", (Object)now, (Object)index);
                    }
                    this.preparedStatementWriter.setDynamic(stmt, (Object)index, type, (Object)now);
                    beanProperty.convertAndSet(entity, (Object)now);
                    continue;
                }
                if (beanProperty.hasAnnotation(DateUpdated.class)) {
                    Date date = now = now != null ? now : new Date();
                    if (DataSettings.QUERY_LOG.isTraceEnabled()) {
                        DataSettings.QUERY_LOG.trace("Binding value {} to parameter at position: {}", (Object)now, (Object)index);
                    }
                    this.preparedStatementWriter.setDynamic(stmt, (Object)index, type, (Object)now);
                    beanProperty.convertAndSet(entity, (Object)now);
                    continue;
                }
                if (UUID.class.isAssignableFrom(beanProperty.getType())) {
                    UUID uuid = UUID.randomUUID();
                    if (DataSettings.QUERY_LOG.isTraceEnabled()) {
                        DataSettings.QUERY_LOG.trace("Binding value {} to parameter at position: {}", (Object)uuid, (Object)index);
                    }
                    this.preparedStatementWriter.setDynamic(stmt, (Object)index, type, (Object)uuid);
                    beanProperty.set(entity, (Object)uuid);
                    continue;
                }
                throw new DataAccessException("Unsupported auto-populated annotation type: " + beanProperty.getAnnotationTypeByStereotype(AutoPopulated.class).orElse(null));
            }
            if (DataSettings.QUERY_LOG.isTraceEnabled()) {
                DataSettings.QUERY_LOG.trace("Binding value {} to parameter at position: {}", value, (Object)index);
            }
            if (type == DataType.JSON && this.jsonCodec != null) {
                value = new String(this.jsonCodec.encode(value), StandardCharsets.UTF_8);
            }
            this.preparedStatementWriter.setDynamic(stmt, (Object)index, type, value);
        }
    }

    @NonNull
    protected final <T> StoredInsert resolveInsert(@NonNull EntityOperation<T> operation) {
        return this.storedInserts.computeIfAbsent(operation.getRootEntity(), aClass -> {
            AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
            String insertStatement = annotationMetadata.stringValue(DataMethod.class, "insertStatement").orElse(null);
            if (insertStatement == null) {
                throw new IllegalStateException("No insert statement present in repository. Ensure it extends GenericRepository and is annotated with @JdbcRepository");
            }
            RuntimePersistentEntity persistentEntity = this.getEntity(operation.getRootEntity());
            Map<String, Integer> parameterBinding = this.buildSqlParameterBinding(annotationMetadata);
            Dialect dialect = annotationMetadata.enumValue(Repository.class, "dialect", Dialect.class).orElse(Dialect.ANSI);
            boolean supportsBatch = dialect != Dialect.SQL_SERVER;
            return new StoredInsert(insertStatement, persistentEntity, parameterBinding, supportsBatch, dialect);
        });
    }

    @NonNull
    protected final RuntimePersistentProperty<Object> getIdReader(@NonNull Object o) {
        Class<?> type = o.getClass();
        RuntimePersistentProperty beanProperty = this.idReaders.get(type);
        if (beanProperty == null) {
            RuntimePersistentEntity<?> entity = this.getEntity(type);
            RuntimePersistentProperty identity = entity.getIdentity();
            if (identity == null) {
                throw new DataAccessException("Entity has no ID: " + entity.getName());
            }
            beanProperty = identity;
            this.idReaders.put(type, beanProperty);
        }
        return beanProperty;
    }

    private <T> Map<String, Integer> buildSqlParameterBinding(AnnotationMetadata annotationMetadata) {
        Map<String, Integer> parameterValues;
        AnnotationValue annotation = annotationMetadata.getAnnotation(DataMethod.class);
        if (annotation == null) {
            return Collections.emptyMap();
        }
        List parameterData = annotation.getAnnotations("insertBinding", Property.class);
        if (CollectionUtils.isNotEmpty((Collection)parameterData)) {
            parameterValues = new HashMap<String, Integer>(parameterData.size());
            for (AnnotationValue annotationValue : parameterData) {
                String name = annotationValue.stringValue("name").orElse(null);
                Integer argument = annotationValue.intValue("value").orElseThrow(() -> new IllegalArgumentException("Query indices should be stored as integers"));
                if (name == null) continue;
                parameterValues.put(name, argument);
            }
        } else {
            parameterValues = Collections.emptyMap();
        }
        return parameterValues;
    }

    @NonNull
    protected final <T> Sort sortById(RuntimePersistentEntity<T> persistentEntity) {
        RuntimePersistentProperty identity = persistentEntity.getIdentity();
        if (identity == null) {
            throw new DataAccessException("Pagination requires an entity ID on SQL Server");
        }
        Sort sort = Sort.unsorted().order(Sort.Order.asc((String)identity.getName()));
        return sort;
    }

    protected final boolean isSqlServerWithoutOrderBy(String query, Dialect dialect) {
        return dialect == Dialect.SQL_SERVER && !query.contains(" ORDER BY ");
    }

    protected final int sizeOf(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).size();
        }
        if (value instanceof Iterable) {
            int i = 0;
            for (Object ignored : (Iterable)value) {
                ++i;
            }
            return i;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value);
        }
        return 1;
    }

    protected final void setStatementParameter(PS preparedStatement, int index, DataType dataType, Object value) {
        switch (dataType) {
            case JSON: {
                if (value != null && this.jsonCodec != null) {
                    value = new String(this.jsonCodec.encode(value), StandardCharsets.UTF_8);
                }
                this.preparedStatementWriter.setDynamic(preparedStatement, (Object)index, dataType, value);
                break;
            }
            case ENTITY: {
                if (value != null) {
                    RuntimePersistentProperty<Object> idReader = this.getIdReader(value);
                    Object id = idReader.getProperty().get(value);
                    if (id == null) {
                        throw new DataAccessException("Supplied entity is a transient instance: " + value);
                    }
                    value = id;
                    dataType = idReader.getDataType();
                }
            }
            default: {
                this.preparedStatementWriter.setDynamic(preparedStatement, (Object)index, dataType, value);
            }
        }
    }

    protected final class StoredInsert<T> {
        private final Map<String, Integer> parameterBinding;
        private final RuntimePersistentProperty identity;
        private final boolean generateId;
        private final String sql;
        private final boolean supportsBatch;
        private final RuntimePersistentEntity<T> persistentEntity;
        private final Dialect dialect;

        StoredInsert(String sql, RuntimePersistentEntity<T> persistentEntity, Map<String, Integer> parameterBinding, boolean supportsBatch, Dialect dialect) {
            this.sql = sql;
            this.persistentEntity = persistentEntity;
            this.parameterBinding = parameterBinding;
            this.identity = persistentEntity.getIdentity();
            this.generateId = this.identity != null && this.identity.isGenerated();
            this.supportsBatch = supportsBatch;
            this.dialect = dialect;
        }

        @NonNull
        public Dialect getDialect() {
            return this.dialect;
        }

        public RuntimePersistentEntity<T> getPersistentEntity() {
            return this.persistentEntity;
        }

        public boolean doesSupportBatch() {
            return this.supportsBatch;
        }

        @NonNull
        public String getSql() {
            return this.sql;
        }

        @NonNull
        public Map<String, Integer> getParameterBinding() {
            return this.parameterBinding;
        }

        @Nullable
        public BeanProperty<T, Object> getIdentityProperty() {
            if (this.identity != null) {
                return this.identity.getProperty();
            }
            return null;
        }

        RuntimePersistentProperty getIdentity() {
            return this.identity;
        }

        public boolean isGenerateId() {
            return this.generateId;
        }
    }
}

