/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.operations;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.hibernate.operations.HibernateJpaOperations;
import io.micronaut.data.jdbc.annotation.JdbcRepository;
import io.micronaut.data.jdbc.mapper.ColumnIndexResultSetReader;
import io.micronaut.data.jdbc.mapper.ColumnNameResultSetReader;
import io.micronaut.data.jdbc.mapper.JdbcQueryStatement;
import io.micronaut.data.jdbc.mapper.SqlResultConsumer;
import io.micronaut.data.jdbc.operations.AbstractSqlRepositoryOperations;
import io.micronaut.data.jdbc.operations.JdbcRepositoryOperations;
import io.micronaut.data.jdbc.runtime.ConnectionCallback;
import io.micronaut.data.jdbc.runtime.PreparedStatementCallback;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.BatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.repository.GenericRepository;
import io.micronaut.data.runtime.mapper.DTOMapper;
import io.micronaut.data.runtime.mapper.ResultConsumer;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.data.runtime.mapper.TypeMapper;
import io.micronaut.data.runtime.mapper.sql.SqlDTOMapper;
import io.micronaut.data.runtime.mapper.sql.SqlResultEntityTypeMapper;
import io.micronaut.data.runtime.mapper.sql.SqlTypeMapper;
import io.micronaut.data.runtime.operations.ExecutorAsyncOperations;
import io.micronaut.data.runtime.operations.ExecutorReactiveOperations;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.transaction.TransactionOperations;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import javax.sql.DataSource;

@EachBean(value=DataSource.class)
@Requires(missingBeans={HibernateJpaOperations.class})
public class DefaultJdbcRepositoryOperations
extends AbstractSqlRepositoryOperations<ResultSet, PreparedStatement>
implements JdbcRepositoryOperations,
AsyncCapableRepository,
ReactiveCapableRepository,
AutoCloseable {
    private static final Object IGNORED_PARAMETER = new Object();
    private final TransactionOperations<Connection> transactionOperations;
    private final DataSource dataSource;
    private ExecutorAsyncOperations asyncOperations;
    private ExecutorService executorService;

    protected DefaultJdbcRepositoryOperations(@Parameter String dataSourceName, DataSource dataSource, @Parameter TransactionOperations<Connection> transactionOperations, @Named(value="io") @Nullable ExecutorService executorService, BeanContext beanContext, List<MediaTypeCodec> codecs) {
        super(new ColumnNameResultSetReader(), new ColumnIndexResultSetReader(), new JdbcQueryStatement(), codecs);
        ArgumentUtils.requireNonNull((String)"dataSource", (Object)dataSource);
        ArgumentUtils.requireNonNull((String)"transactionOperations", transactionOperations);
        this.dataSource = dataSource;
        this.transactionOperations = transactionOperations;
        this.executorService = executorService;
        Collection beanDefinitions = beanContext.getBeanDefinitions(GenericRepository.class, Qualifiers.byStereotype(Repository.class));
        for (BeanDefinition beanDefinition : beanDefinitions) {
            String targetDs = beanDefinition.stringValue(Repository.class).orElse("default");
            if (!targetDs.equalsIgnoreCase(dataSourceName)) continue;
            Dialect dialect = beanDefinition.findAnnotation(JdbcRepository.class).flatMap(av -> av.enumValue("dialect", Dialect.class)).orElse(Dialect.ANSI);
            this.dialects.put(beanDefinition.getBeanType(), dialect);
            QueryBuilder qb = (QueryBuilder)this.queryBuilders.get(dialect);
            if (qb != null) continue;
            this.queryBuilders.put(dialect, new SqlQueryBuilder(dialect));
        }
    }

    @NonNull
    private ExecutorService newLocalThreadPool() {
        this.executorService = Executors.newCachedThreadPool();
        return this.executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ExecutorAsyncOperations async() {
        ExecutorAsyncOperations asyncOperations = this.asyncOperations;
        if (asyncOperations == null) {
            DefaultJdbcRepositoryOperations defaultJdbcRepositoryOperations = this;
            synchronized (defaultJdbcRepositoryOperations) {
                asyncOperations = this.asyncOperations;
                if (asyncOperations == null) {
                    this.asyncOperations = asyncOperations = new ExecutorAsyncOperations((RepositoryOperations)this, (Executor)(this.executorService != null ? this.executorService : this.newLocalThreadPool()));
                }
            }
        }
        return asyncOperations;
    }

    @NonNull
    public ReactiveRepositoryOperations reactive() {
        return new ExecutorReactiveOperations(this.async());
    }

    @Nullable
    public <T, R> R findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (R)this.transactionOperations.executeRead(status -> {
            Connection connection = (Connection)status.getConnection();
            try (PreparedStatement ps = this.prepareStatement(connection, preparedQuery, false, true);
                 ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                Class rootEntity = preparedQuery.getRootEntity();
                Class resultType = preparedQuery.getResultType();
                if (resultType == rootEntity) {
                    RuntimePersistentEntity persistentEntity = this.getEntity(rootEntity);
                    SqlResultEntityTypeMapper mapper = new SqlResultEntityTypeMapper(persistentEntity, this.columnNameResultSetReader, preparedQuery.getJoinFetchPaths(), this.jsonCodec);
                    Object result = mapper.map((Object)rs, resultType);
                    if (preparedQuery.hasResultConsumer()) {
                        preparedQuery.getParameterInRole("sqlMappingFunction", SqlResultConsumer.class).ifPresent(consumer -> consumer.accept(result, this.newMappingContext(rs)));
                    }
                    Object object = result;
                    return object;
                }
                if (preparedQuery.isDtoProjection()) {
                    RuntimePersistentEntity persistentEntity = this.getEntity(preparedQuery.getRootEntity());
                    DTOMapper introspectedDataMapper = new DTOMapper(persistentEntity, this.columnNameResultSetReader);
                    Object object = introspectedDataMapper.map((Object)rs, resultType);
                    return object;
                }
                Object v = this.columnIndexResultSetReader.readDynamic((Object)rs, (Object)1, preparedQuery.getResultDataType());
                if (resultType.isInstance(v)) {
                    Object object = v;
                    return object;
                }
                Object object = this.columnIndexResultSetReader.convertRequired(v, resultType);
                return object;
            }
            catch (SQLException e) {
                throw new DataAccessException("Error executing SQL Query: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    @NonNull
    private ResultConsumer.Context<ResultSet> newMappingContext(final ResultSet rs) {
        return new ResultConsumer.Context<ResultSet>(){

            public ResultSet getResultSet() {
                return rs;
            }

            public ResultReader<ResultSet, String> getResultReader() {
                return DefaultJdbcRepositoryOperations.this.columnNameResultSetReader;
            }

            @NonNull
            public <E> E readEntity(String prefix, Class<E> type) throws DataAccessException {
                RuntimePersistentEntity<E> entity = DefaultJdbcRepositoryOperations.this.getEntity(type);
                SqlResultEntityTypeMapper mapper = new SqlResultEntityTypeMapper(prefix, entity, DefaultJdbcRepositoryOperations.this.columnNameResultSetReader, DefaultJdbcRepositoryOperations.this.jsonCodec);
                return (E)mapper.map((Object)rs, type);
            }

            @NonNull
            public <E, D> D readDTO(@NonNull String prefix, @NonNull Class<E> rootEntity, @NonNull Class<D> dtoType) throws DataAccessException {
                RuntimePersistentEntity<E> entity = DefaultJdbcRepositoryOperations.this.getEntity(rootEntity);
                DTOMapper introspectedDataMapper = new DTOMapper(entity, DefaultJdbcRepositoryOperations.this.columnNameResultSetReader);
                return (D)introspectedDataMapper.map((Object)rs, dtoType);
            }
        };
    }

    public <T, R> boolean exists(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (Boolean)this.transactionOperations.executeRead(status -> {
            try {
                Connection connection = (Connection)status.getConnection();
                PreparedStatement ps = this.prepareStatement(connection, preparedQuery, false, true);
                ResultSet rs = ps.executeQuery();
                return rs.next();
            }
            catch (SQLException e) {
                throw new DataAccessException("Error executing SQL query: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    @NonNull
    public <T, R> Stream<R> findStream(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (Stream)this.transactionOperations.executeRead(status -> {
            Connection connection = (Connection)status.getConnection();
            return this.findStream(preparedQuery, connection);
        });
    }

    private <T, R> Stream<R> findStream(final @NonNull PreparedQuery<T, R> preparedQuery, Connection connection) {
        Spliterators.AbstractSpliterator spliterator;
        ResultSet rs;
        PreparedStatement ps;
        Class rootEntity = preparedQuery.getRootEntity();
        final Class resultType = preparedQuery.getResultType();
        try {
            ps = this.prepareStatement(connection, preparedQuery, false, false);
        }
        catch (SQLException e) {
            throw new DataAccessException("SQL Error preparing Query: " + e.getMessage(), (Throwable)e);
        }
        try {
            rs = ps.executeQuery();
        }
        catch (SQLException e) {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new DataAccessException("SQL Error executing Query: " + e.getMessage(), (Throwable)e);
        }
        boolean dtoProjection = preparedQuery.isDtoProjection();
        boolean isRootResult = resultType == rootEntity;
        final AtomicBoolean finished = new AtomicBoolean();
        if (isRootResult || dtoProjection) {
            SqlResultConsumer sqlMappingConsumer = preparedQuery.hasResultConsumer() ? (SqlResultConsumer)preparedQuery.getParameterInRole("sqlMappingFunction", SqlResultConsumer.class).orElse(null) : null;
            Object mapper = dtoProjection ? new SqlDTOMapper(this.getEntity(rootEntity), this.columnNameResultSetReader) : new SqlResultEntityTypeMapper(this.getEntity(resultType), this.columnNameResultSetReader, preparedQuery.getJoinFetchPaths(), this.jsonCodec);
            spliterator = new Spliterators.AbstractSpliterator<R>(Long.MAX_VALUE, 1040, (SqlTypeMapper)mapper, rs, resultType, sqlMappingConsumer, ps){
                final /* synthetic */ SqlTypeMapper val$mapper;
                final /* synthetic */ ResultSet val$rs;
                final /* synthetic */ Class val$resultType;
                final /* synthetic */ SqlResultConsumer val$sqlMappingConsumer;
                final /* synthetic */ PreparedStatement val$ps;
                {
                    this.val$mapper = sqlTypeMapper;
                    this.val$rs = resultSet;
                    this.val$resultType = clazz;
                    this.val$sqlMappingConsumer = sqlResultConsumer;
                    this.val$ps = preparedStatement;
                    super(x0, x1);
                }

                @Override
                public boolean tryAdvance(Consumer<? super R> action) {
                    if (finished.get()) {
                        return false;
                    }
                    boolean hasNext = this.val$mapper.hasNext((Object)this.val$rs);
                    if (hasNext) {
                        Object o = this.val$mapper.map((Object)this.val$rs, this.val$resultType);
                        if (this.val$sqlMappingConsumer != null) {
                            this.val$sqlMappingConsumer.accept(this.val$rs, o);
                        }
                        action.accept(o);
                    } else {
                        DefaultJdbcRepositoryOperations.this.closeResultSet(this.val$ps, this.val$rs, finished);
                    }
                    return hasNext;
                }
            };
        } else {
            spliterator = new Spliterators.AbstractSpliterator<R>(Long.MAX_VALUE, 1040){

                @Override
                public boolean tryAdvance(Consumer<? super R> action) {
                    if (finished.get()) {
                        return false;
                    }
                    try {
                        boolean hasNext = rs.next();
                        if (hasNext) {
                            Object v = DefaultJdbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic((Object)rs, (Object)1, preparedQuery.getResultDataType());
                            if (resultType.isInstance(v)) {
                                action.accept(v);
                            } else {
                                Object r = DefaultJdbcRepositoryOperations.this.columnIndexResultSetReader.convertRequired(v, resultType);
                                action.accept(r);
                            }
                        } else {
                            DefaultJdbcRepositoryOperations.this.closeResultSet(ps, rs, finished);
                        }
                        return hasNext;
                    }
                    catch (SQLException e) {
                        throw new DataAccessException("Error retrieving next JDBC result: " + e.getMessage(), (Throwable)e);
                    }
                }
            };
        }
        return (Stream)StreamSupport.stream(spliterator, false).onClose(() -> this.closeResultSet(ps, rs, finished));
    }

    private void closeResultSet(PreparedStatement ps, ResultSet rs, AtomicBoolean finished) {
        if (finished.compareAndSet(false, true)) {
            try {
                rs.close();
                ps.close();
            }
            catch (SQLException e) {
                throw new DataAccessException("Error closing JDBC result stream: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @NonNull
    public <T, R> Iterable<R> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (Iterable)this.transactionOperations.executeRead(status -> {
            Connection connection = (Connection)status.getConnection();
            return this.findStream(preparedQuery, connection).collect(Collectors.toList());
        });
    }

    @NonNull
    public Optional<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return (Optional)this.transactionOperations.executeWrite(status -> {
            try {
                Connection connection = (Connection)status.getConnection();
                try (PreparedStatement ps = this.prepareStatement(connection, preparedQuery, true, false);){
                    Optional<Integer> optional = Optional.of(ps.executeUpdate());
                    return optional;
                }
            }
            catch (SQLException e) {
                throw new DataAccessException("Error executing SQL UPDATE: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    public <T> Optional<Number> deleteAll(@NonNull BatchOperation<T> operation) {
        throw new UnsupportedOperationException("The deleteAll method via batch is unsupported. Execute the SQL update directly");
    }

    @NonNull
    public <T> T persist(@NonNull InsertOperation<T> operation) {
        AbstractSqlRepositoryOperations.StoredInsert insert = this.resolveInsert(operation);
        return (T)this.transactionOperations.executeWrite(status -> {
            try {
                Connection connection = (Connection)status.getConnection();
                Object entity = operation.getEntity();
                boolean generateId = insert.isGenerateId();
                String insertSql = insert.getSql();
                if (QUERY_LOG.isDebugEnabled()) {
                    QUERY_LOG.debug("Executing SQL Insert: {}", (Object)insertSql);
                }
                PreparedStatement stmt = connection.prepareStatement(insertSql, generateId ? 1 : 2);
                this.setInsertParameters(insert, entity, stmt);
                stmt.executeUpdate();
                BeanProperty identity = insert.getIdentity();
                if (generateId && identity != null) {
                    ResultSet generatedKeys = stmt.getGeneratedKeys();
                    if (generatedKeys.next()) {
                        long id = generatedKeys.getLong(1);
                        if (identity.getType().isInstance(id)) {
                            identity.set(entity, (Object)id);
                        } else {
                            identity.convertAndSet(entity, (Object)id);
                        }
                    } else {
                        throw new DataAccessException("ID failed to generate. No result returned.");
                    }
                }
                return entity;
            }
            catch (SQLException e) {
                throw new DataAccessException("SQL Error executing INSERT: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T, R> PreparedStatement prepareStatement(Connection connection, @NonNull PreparedQuery<T, R> preparedQuery, boolean isUpdate, boolean isSingleResult) throws SQLException {
        Pageable pageable;
        Object[] queryParameters = preparedQuery.getParameterArray();
        int[] parameterBinding = preparedQuery.getIndexedParameterBinding();
        DataType[] parameterTypes = preparedQuery.getIndexedParameterTypes();
        String query = preparedQuery.getQuery();
        boolean hasIn = preparedQuery.hasInExpression();
        if (hasIn) {
            Matcher matcher = IN_EXPRESSION_PATTERN.matcher(query);
            while (matcher.find()) {
                int inIndex = Integer.valueOf(matcher.group(1));
                int queryParameterIndex = parameterBinding[inIndex - 1];
                Object value = queryParameters[queryParameterIndex];
                if (value == null) {
                    query = matcher.replaceFirst("1 = 2");
                    queryParameters[queryParameterIndex] = IGNORED_PARAMETER;
                } else {
                    int size = this.sizeOf(value);
                    if (size == 0) {
                        queryParameters[queryParameterIndex] = IGNORED_PARAMETER;
                        query = matcher.replaceFirst("1 = 2");
                    } else {
                        String replacement = " IN(" + String.join((CharSequence)",", Collections.nCopies(size, "?")) + ")";
                        query = matcher.replaceFirst(replacement);
                    }
                }
                matcher = IN_EXPRESSION_PATTERN.matcher(query);
            }
        }
        if (!isUpdate && (pageable = preparedQuery.getPageable()) != Pageable.UNPAGED) {
            Class rootEntity = preparedQuery.getRootEntity();
            Sort sort = pageable.getSort();
            Dialect dialect = this.dialects.getOrDefault(preparedQuery.getRepositoryType(), Dialect.ANSI);
            QueryBuilder queryBuilder = (QueryBuilder)this.queryBuilders.getOrDefault(dialect, DEFAULT_SQL_BUILDER);
            if (sort.isSorted()) {
                query = query + queryBuilder.buildOrderBy(this.getEntity(rootEntity), sort).getQuery();
            } else if (this.isSqlServerWithoutOrderBy(query, dialect)) {
                RuntimePersistentEntity persistentEntity = this.getEntity(rootEntity);
                sort = this.sortById(persistentEntity);
                query = query + queryBuilder.buildOrderBy(persistentEntity, sort).getQuery();
            }
            if (isSingleResult && pageable.getOffset() > 0L) {
                pageable = Pageable.from((int)pageable.getNumber(), (int)1);
            }
            query = query + queryBuilder.buildPagination(pageable).getQuery();
        }
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Query: {}", (Object)query);
        }
        PreparedStatement ps = connection.prepareStatement(query);
        int index = 1;
        for (int i = 0; i < parameterBinding.length; ++i) {
            Object value;
            int parameterIndex = parameterBinding[i];
            DataType dataType = parameterTypes[i];
            if (parameterIndex > -1) {
                value = queryParameters[parameterIndex];
            } else {
                String[] indexedParameterPaths = preparedQuery.getIndexedParameterPaths();
                String propertyPath = indexedParameterPaths[i];
                if (propertyPath == null) throw new IllegalStateException("Invalid query [" + query + "]. Unable to establish parameter value for parameter at position: " + (i + 1));
                String string = preparedQuery.getLastUpdatedProperty();
                if (string != null && string.equals(propertyPath)) {
                    Class lastUpdatedType = preparedQuery.getLastUpdatedType();
                    if (lastUpdatedType == null) {
                        throw new IllegalStateException("Could not establish last updated time for entity: " + preparedQuery.getRootEntity());
                    }
                    Object timestamp = ConversionService.SHARED.convert((Object)OffsetDateTime.now(), lastUpdatedType).orElse(null);
                    if (timestamp == null) {
                        throw new IllegalStateException("Unsupported date type: " + lastUpdatedType);
                    }
                    value = timestamp;
                } else {
                    int j = propertyPath.indexOf(46);
                    if (j <= -1) throw new IllegalStateException("Invalid query [" + query + "]. Unable to establish parameter value for parameter at position: " + (i + 1));
                    String subProp = propertyPath.substring(j + 1);
                    value = queryParameters[Integer.valueOf(propertyPath.substring(0, j))];
                    value = BeanWrapper.getWrapper((Object)value).getRequiredProperty(subProp, Object.class);
                }
            }
            if (QUERY_LOG.isTraceEnabled()) {
                QUERY_LOG.trace("Binding parameter at position {} to value {}", (Object)index, value);
            }
            if (value == null) {
                this.setStatementParameter(ps, index++, dataType, null);
                continue;
            }
            if (value == IGNORED_PARAMETER) continue;
            if (value instanceof Iterable) {
                Iterable iter = (Iterable)value;
                for (Object e : iter) {
                    this.setStatementParameter(ps, index++, dataType, e);
                }
                continue;
            }
            if (value.getClass().isArray()) {
                int len = Array.getLength(value);
                for (int j = 0; j < len; ++j) {
                    Object object = Array.get(value, j);
                    this.setStatementParameter(ps, index++, dataType, object);
                }
                continue;
            }
            this.setStatementParameter(ps, index++, dataType, value);
        }
        return ps;
    }

    @Nullable
    public <T> T findOne(@NonNull Class<T> type, @NonNull Serializable id) {
        throw new UnsupportedOperationException("The findOne method by ID is not supported. Execute the SQL query directly");
    }

    @NonNull
    public <T> Iterable<T> findAll(@NonNull PagedQuery<T> query) {
        throw new UnsupportedOperationException("The findAll method without an explicit query is not supported. Use findAll(PreparedQuery) instead");
    }

    public <T> long count(PagedQuery<T> pagedQuery) {
        throw new UnsupportedOperationException("The count method without an explicit query is not supported. Use findAll(PreparedQuery) instead");
    }

    @NonNull
    public <T> Stream<T> findStream(@NonNull PagedQuery<T> query) {
        throw new UnsupportedOperationException("The findStream method without an explicit query is not supported. Use findStream(PreparedQuery) instead");
    }

    public <R> Page<R> findPage(@NonNull PagedQuery<R> query) {
        throw new UnsupportedOperationException("The findPage method without an explicit query is not supported. Use findPage(PreparedQuery) instead");
    }

    @NonNull
    public <T> Iterable<T> persistAll(final @NonNull BatchOperation<T> operation) {
        AbstractSqlRepositoryOperations.StoredInsert insert = this.resolveInsert(operation);
        if (!insert.doesSupportBatch()) {
            ArrayList<T> results = new ArrayList<T>();
            for (final Object entity : operation) {
                results.add(this.persist(new InsertOperation<T>(){

                    @NonNull
                    public T getEntity() {
                        return entity;
                    }

                    @NonNull
                    public Class<T> getRootEntity() {
                        return operation.getRootEntity();
                    }

                    public String getName() {
                        return operation.getName();
                    }

                    public AnnotationMetadata getAnnotationMetadata() {
                        return operation.getAnnotationMetadata();
                    }
                }));
            }
            return results;
        }
        return (Iterable)this.transactionOperations.executeWrite(status -> {
            Connection connection = (Connection)status.getConnection();
            ArrayList results = new ArrayList(10);
            boolean generateId = insert.isGenerateId();
            String insertSql = insert.getSql();
            try {
                PreparedStatement stmt = connection.prepareStatement(insertSql, generateId ? 1 : 2);
                if (QUERY_LOG.isDebugEnabled()) {
                    QUERY_LOG.debug("Executing Batch SQL Insert: {}", (Object)insertSql);
                }
                for (Object entity : operation) {
                    this.setInsertParameters(insert, entity, stmt);
                    stmt.addBatch();
                    results.add(entity);
                }
                stmt.executeBatch();
                BeanProperty identity = insert.getIdentity();
                if (generateId && identity != null) {
                    Iterator resultIterator = results.iterator();
                    ResultSet generatedKeys = stmt.getGeneratedKeys();
                    while (resultIterator.hasNext()) {
                        Object entity = resultIterator.next();
                        if (!generatedKeys.next()) {
                            throw new DataAccessException("Failed to generate ID for entity: " + entity);
                        }
                        long id = generatedKeys.getLong(1);
                        if (identity.getType().isInstance(id)) {
                            identity.set(entity, (Object)id);
                            continue;
                        }
                        identity.convertAndSet(entity, (Object)id);
                    }
                }
                return results;
            }
            catch (SQLException e) {
                throw new DataAccessException("SQL error executing INSERT: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    @Override
    @PreDestroy
    public void close() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    @Override
    @NonNull
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    @NonNull
    public Connection getConnection() {
        return (Connection)this.transactionOperations.getConnection();
    }

    @Override
    @NonNull
    public <R> R execute(@NonNull ConnectionCallback<R> callback) {
        try {
            return callback.call((Connection)this.transactionOperations.getConnection());
        }
        catch (SQLException e) {
            throw new DataAccessException("Error executing SQL Callback: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @NonNull
    public <R> R prepareStatement(@NonNull String sql, @NonNull PreparedStatementCallback<R> callback) {
        ArgumentUtils.requireNonNull((String)"sql", (Object)sql);
        ArgumentUtils.requireNonNull((String)"callback", callback);
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Query: {}", (Object)sql);
        }
        try {
            return callback.call(((Connection)this.transactionOperations.getConnection()).prepareStatement(sql));
        }
        catch (SQLException e) {
            throw new DataAccessException("Error preparing SQL statement: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @NonNull
    public <T> Stream<T> entityStream(@NonNull ResultSet resultSet, @NonNull Class<T> rootEntity) {
        return this.entityStream(resultSet, null, rootEntity);
    }

    @Override
    @NonNull
    public <E> E readEntity(@NonNull String prefix, @NonNull ResultSet resultSet, @NonNull Class<E> type) throws DataAccessException {
        return (E)new SqlResultEntityTypeMapper(prefix, this.getEntity(type), this.columnNameResultSetReader, this.jsonCodec).map((Object)resultSet, type);
    }

    @Override
    @NonNull
    public <E, D> D readDTO(@NonNull String prefix, @NonNull ResultSet resultSet, @NonNull Class<E> rootEntity, @NonNull Class<D> dtoType) throws DataAccessException {
        return (D)new DTOMapper(this.getEntity(rootEntity), this.columnNameResultSetReader).map((Object)resultSet, dtoType);
    }

    @Override
    @NonNull
    public <T> Stream<T> entityStream(@NonNull ResultSet resultSet, @Nullable String prefix, @NonNull Class<T> rootEntity) {
        ArgumentUtils.requireNonNull((String)"resultSet", (Object)resultSet);
        ArgumentUtils.requireNonNull((String)"rootEntity", rootEntity);
        SqlResultEntityTypeMapper mapper = new SqlResultEntityTypeMapper(prefix, this.getEntity(rootEntity), this.columnNameResultSetReader, this.jsonCodec);
        Iterable iterable = () -> this.lambda$entityStream$10(resultSet, (TypeMapper)mapper, rootEntity);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    private /* synthetic */ Iterator lambda$entityStream$10(final ResultSet resultSet, final TypeMapper mapper, final Class rootEntity) {
        return new Iterator<T>(){
            boolean nextCalled = false;

            @Override
            public boolean hasNext() {
                try {
                    if (!this.nextCalled) {
                        this.nextCalled = true;
                        return resultSet.next();
                    }
                    return this.nextCalled;
                }
                catch (SQLException e) {
                    throw new DataAccessException("Error retrieving next JDBC result: " + e.getMessage(), (Throwable)e);
                }
            }

            @Override
            public T next() {
                this.nextCalled = false;
                return mapper.map((Object)resultSet, rootEntity);
            }
        };
    }
}

