/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.runtime.spring;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.transaction.TransactionCallback;
import io.micronaut.data.transaction.TransactionOperations;
import io.micronaut.data.transaction.exceptions.NoTransactionException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

@EachBean(value=DataSourceTransactionManager.class)
@Internal
@Requires(classes={DataSourceTransactionManager.class})
public class SpringJdbcTransactionOperations
implements TransactionOperations<Connection> {
    private final TransactionTemplate writeTransactionTemplate;
    private final TransactionTemplate readTransactionTemplate;
    private final DataSource dataSource;

    protected SpringJdbcTransactionOperations(DataSourceTransactionManager transactionManager) {
        this.dataSource = transactionManager.getDataSource();
        this.writeTransactionTemplate = new TransactionTemplate((PlatformTransactionManager)transactionManager);
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setReadOnly(true);
        this.readTransactionTemplate = new TransactionTemplate((PlatformTransactionManager)transactionManager, (TransactionDefinition)transactionDefinition);
    }

    @Nullable
    public <R> R executeWrite(@NonNull TransactionCallback<Connection, R> callback) {
        return (R)this.writeTransactionTemplate.execute(status -> callback.apply((io.micronaut.data.transaction.TransactionStatus)new JdbcTransactionStatus(status)));
    }

    @Nullable
    public <R> R executeRead(@NonNull TransactionCallback<Connection, R> callback) {
        return (R)this.readTransactionTemplate.execute(status -> {
            Connection connection = DataSourceUtils.getConnection((DataSource)this.dataSource);
            try {
                Object object = callback.apply((io.micronaut.data.transaction.TransactionStatus)new JdbcTransactionStatus(status));
                return object;
            }
            finally {
                DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
            }
        });
    }

    @NonNull
    public Connection getConnection() {
        try {
            Connection connection = DataSourceUtils.doGetConnection((DataSource)this.dataSource);
            if (DataSourceUtils.isConnectionTransactional((Connection)connection, (DataSource)this.dataSource)) {
                return connection;
            }
            connection.close();
            throw new NoTransactionException("No transaction declared. Define @Transactional on the surrounding method prior to calling getConnection()");
        }
        catch (SQLException e) {
            throw new DataAccessException("Error retrieving JDBC connection: " + e.getMessage(), (Throwable)e);
        }
    }

    private final class JdbcTransactionStatus
    implements io.micronaut.data.transaction.TransactionStatus<Connection> {
        private final TransactionStatus springStatus;

        JdbcTransactionStatus(TransactionStatus springStatus) {
            this.springStatus = springStatus;
        }

        @NonNull
        public Connection getResource() {
            return SpringJdbcTransactionOperations.this.getConnection();
        }

        public boolean isNewTransaction() {
            return this.springStatus.isNewTransaction();
        }

        public void setRollbackOnly() {
            this.springStatus.setRollbackOnly();
        }

        public boolean isRollbackOnly() {
            return this.springStatus.isRollbackOnly();
        }

        public boolean isCompleted() {
            return this.springStatus.isCompleted();
        }
    }
}

