/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.document.processor.matchers;

import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.Map;
import java.util.Optional;

public class MongoExecutorQueryMethodMatcher
implements MethodMatcher {
    public final int getOrder() {
        return -2001;
    }

    public MethodMatcher.MethodMatch match(final MethodMatchContext matchContext) {
        ParameterElement parameter2;
        ParameterElement parameter1;
        ParameterElement parameter;
        ParameterElement[] parameters;
        Optional executor = matchContext.getVisitorContext().getClassElement("io.micronaut.data.mongodb.repository.MongoQueryExecutor");
        if (executor.isPresent() && ((ClassElement)executor.get()).isAssignable(matchContext.getRepositoryClass())) {
            return null;
        }
        String methodName = matchContext.getMethodElement().getName();
        if ("findAll".equals(methodName) || "findOne".equals(methodName)) {
            parameters = matchContext.getParameters();
            switch (parameters.length) {
                case 1: {
                    parameter = parameters[0];
                    if (this.isBson(parameter)) {
                        return new MongoQueryExecutorMatch(DataMethod.OperationType.QUERY){

                            @Override
                            protected void apply(MethodMatchInfo matchInfo) {
                                matchInfo.addParameterRole((CharSequence)"filter", parameter.getName());
                            }
                        };
                    }
                    if (this.isPipeline(parameter)) {
                        return new MongoQueryExecutorMatch(DataMethod.OperationType.QUERY){

                            @Override
                            protected void apply(MethodMatchInfo matchInfo) {
                                matchInfo.addParameterRole((CharSequence)"pipeline", parameter.getName());
                            }
                        };
                    }
                    if (!parameter.getType().isAssignable("io.micronaut.data.mongodb.operations.options.MongoFindOptions")) break;
                    return new MongoQueryExecutorMatch(DataMethod.OperationType.QUERY){

                        @Override
                        protected void apply(MethodMatchInfo matchInfo) {
                            matchInfo.addParameterRole((CharSequence)"findOptions", parameter.getName());
                        }
                    };
                }
                case 2: {
                    parameter1 = parameters[0];
                    parameter2 = parameters[1];
                    if (this.isBson(parameter1) && parameter2.getType().isAssignable("io.micronaut.data.mongodb.operations.options.MongoFindOptions")) {
                        return new MongoQueryExecutorMatch(DataMethod.OperationType.QUERY){

                            @Override
                            protected void apply(MethodMatchInfo matchInfo) {
                                matchInfo.addParameterRole((CharSequence)"filter", parameter1.getName());
                                matchInfo.addParameterRole((CharSequence)"findOptions", parameter2.getName());
                            }
                        };
                    }
                    if (this.isPipeline(parameter1) && parameter2.getType().isAssignable("io.micronaut.data.mongodb.operations.options.MongoAggregationOptions")) {
                        return new MongoQueryExecutorMatch(DataMethod.OperationType.QUERY){

                            @Override
                            protected void apply(MethodMatchInfo matchInfo) {
                                matchInfo.addParameterRole((CharSequence)"pipeline", parameter1.getName());
                                matchInfo.addParameterRole((CharSequence)"aggregateOptions", parameter2.getName());
                            }
                        };
                    }
                    if ("findOne".equals(methodName)) break;
                    final ParameterElement p1 = parameters[0];
                    final ParameterElement p2 = parameters[1];
                    if (this.isBson(p1) && p2.getType().isAssignable("io.micronaut.data.model.Pageable")) {
                        return new MongoQueryExecutorMatch(DataMethod.OperationType.QUERY){

                            @Override
                            protected void apply(MethodMatchInfo matchInfo) {
                                matchInfo.addParameterRole((CharSequence)"filter", p1.getName());
                                matchInfo.addParameterRole((CharSequence)"pageable", p2.getName());
                                matchContext.getMethodElement().annotate(Query.class, builder -> builder.member("countQuery", "{}"));
                            }
                        };
                    }
                    if (!p1.getType().isAssignable("io.micronaut.data.mongodb.operations.options.MongoFindOptions") || !p2.getType().isAssignable("io.micronaut.data.model.Pageable")) break;
                    return new MongoQueryExecutorMatch(DataMethod.OperationType.QUERY){

                        @Override
                        protected void apply(MethodMatchInfo matchInfo) {
                            matchInfo.addParameterRole((CharSequence)"findOptions", p1.getName());
                            matchInfo.addParameterRole((CharSequence)"pageable", p2.getName());
                            matchContext.getMethodElement().annotate(Query.class, builder -> builder.member("countQuery", "{}"));
                        }
                    };
                }
                default: {
                    return null;
                }
            }
        }
        if ("count".equals(methodName)) {
            parameters = matchContext.getParameters();
            if (parameters.length == 1 && this.isBson(parameter = parameters[0])) {
                return new MongoQueryExecutorMatch(DataMethod.OperationType.COUNT){

                    @Override
                    protected void apply(MethodMatchInfo matchInfo) {
                        matchInfo.addParameterRole((CharSequence)"filter", parameter.getName());
                    }
                };
            }
            return null;
        }
        if ("deleteAll".equals(methodName)) {
            parameters = matchContext.getParameters();
            switch (parameters.length) {
                case 1: {
                    parameter = parameters[0];
                    if (!this.isBson(parameter)) break;
                    return new MongoQueryExecutorMatch(DataMethod.OperationType.DELETE){

                        @Override
                        protected void apply(MethodMatchInfo matchInfo) {
                            matchInfo.addParameterRole((CharSequence)"filter", parameter.getName());
                        }
                    };
                }
                case 2: {
                    parameter1 = parameters[0];
                    parameter2 = parameters[1];
                    if (!this.isBson(parameter1) || !parameter2.getType().isAssignable("com.mongodb.client.model.DeleteOptions")) break;
                    return new MongoQueryExecutorMatch(DataMethod.OperationType.DELETE){

                        @Override
                        protected void apply(MethodMatchInfo matchInfo) {
                            matchInfo.addParameterRole((CharSequence)"filter", parameter1.getName());
                            matchInfo.addParameterRole((CharSequence)"deleteOptions", parameter2.getName());
                        }
                    };
                }
                default: {
                    return null;
                }
            }
        }
        if ("updateAll".equals(methodName)) {
            parameters = matchContext.getParameters();
            switch (parameters.length) {
                case 2: {
                    final ParameterElement parameter12 = parameters[0];
                    final ParameterElement parameter22 = parameters[1];
                    if (!this.isBson(parameter12) || !this.isBson(parameter22)) break;
                    return new MongoQueryExecutorMatch(DataMethod.OperationType.UPDATE){

                        @Override
                        protected void apply(MethodMatchInfo matchInfo) {
                            matchInfo.addParameterRole((CharSequence)"filter", parameter12.getName());
                            matchInfo.addParameterRole((CharSequence)"update", parameter22.getName());
                        }
                    };
                }
                case 3: {
                    final ParameterElement filter = parameters[0];
                    final ParameterElement update = parameters[1];
                    final ParameterElement options = parameters[2];
                    if (!this.isBson(filter) || !this.isBson(update) || !options.getType().isAssignable("com.mongodb.client.model.UpdateOptions")) break;
                    return new MongoQueryExecutorMatch(DataMethod.OperationType.UPDATE){

                        @Override
                        protected void apply(MethodMatchInfo matchInfo) {
                            matchInfo.addParameterRole((CharSequence)"filter", filter.getName());
                            matchInfo.addParameterRole((CharSequence)"update", update.getName());
                            matchInfo.addParameterRole((CharSequence)"updateOptions", options.getName());
                        }
                    };
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    private boolean isPipeline(ParameterElement parameter) {
        if (!parameter.getType().isAssignable(Iterable.class)) {
            return false;
        }
        Optional firstTypeArgument = parameter.getType().getFirstTypeArgument();
        return firstTypeArgument.isPresent() && ((ClassElement)firstTypeArgument.get()).isAssignable("org.bson.conversions.Bson");
    }

    private boolean isBson(ParameterElement parameter) {
        return parameter.getType().isAssignable("org.bson.conversions.Bson");
    }

    private static abstract class MongoQueryExecutorMatch
    implements MethodMatcher.MethodMatch {
        private final DataMethod.OperationType operationType;

        public MongoQueryExecutorMatch(DataMethod.OperationType operationType) {
            this.operationType = operationType;
        }

        protected abstract void apply(MethodMatchInfo var1);

        public MethodMatchInfo buildMatchInfo(MethodMatchContext matchContext) {
            Map.Entry entry = FindersUtils.resolveInterceptorTypeByOperationType((boolean)false, (boolean)false, (DataMethod.OperationType)this.operationType, (MethodMatchContext)matchContext);
            MethodMatchInfo methodMatchInfo = new MethodMatchInfo(this.operationType, (TypedElement)entry.getKey(), FindersUtils.getInterceptorElement((MethodMatchContext)matchContext, (Class)((Class)entry.getValue())));
            matchContext.getMethodElement().annotate(Query.class, builder -> {
                builder.value("{}");
                if (this.operationType == DataMethod.OperationType.UPDATE) {
                    builder.member("update", "{}");
                }
            });
            this.apply(methodMatchInfo);
            return methodMatchInfo;
        }
    }
}

