/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.document.processor.mapper;

import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.document.serde.CustomConverterDeserializer;
import io.micronaut.data.document.serde.CustomConverterSerializer;
import io.micronaut.data.model.runtime.convert.AttributeConverter;
import io.micronaut.inject.annotation.TypedAnnotationMapper;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.serde.config.annotation.SerdeConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MappedPropertyMapper
implements TypedAnnotationMapper<MappedProperty> {
    public Class<MappedProperty> annotationType() {
        return MappedProperty.class;
    }

    public List<AnnotationValue<?>> map(AnnotationValue<MappedProperty> annotation, VisitorContext visitorContext) {
        AnnotationValueBuilder builder = AnnotationValue.builder(SerdeConfig.class);
        annotation.stringValue().ifPresent(property -> builder.member("property", property));
        annotation.stringValue("converter").ifPresent(val -> {
            visitorContext.getClassElement(val).ifPresent(attributeConverterClassElement -> {
                ClassElement converterPersistedType;
                ClassElement genericType = attributeConverterClassElement.getGenericType();
                Map typeArguments = genericType.getTypeArguments(AttributeConverter.class.getName());
                if (typeArguments.isEmpty()) {
                    typeArguments = genericType.getTypeArguments("javax.persistence.AttributeConverter");
                }
                if (typeArguments.isEmpty()) {
                    typeArguments = genericType.getTypeArguments("jakarta.persistence.AttributeConverter");
                }
                if ((converterPersistedType = (ClassElement)typeArguments.get("Y")) != null) {
                    builder.member("serAs", new AnnotationClassValue[]{new AnnotationClassValue(converterPersistedType.getName())});
                    builder.member("deserAs", new AnnotationClassValue[]{new AnnotationClassValue(converterPersistedType.getName())});
                }
            });
            builder.member("serializerClass", CustomConverterSerializer.class);
            builder.member("deserializerClass", CustomConverterDeserializer.class);
        });
        return Collections.singletonList(builder.build());
    }
}

