/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.document.model.query.builder;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.exceptions.MappingException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.query.BindingParameter;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.serde.config.annotation.SerdeConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;

@Internal
public final class MongoQueryBuilder
implements QueryBuilder {
    public static final String QUERY_PARAMETER_PLACEHOLDER = "$mn_qp";
    private final Map<Class, CriterionHandler> queryHandlers = new HashMap<Class, CriterionHandler>(30);

    public MongoQueryBuilder() {
        this.addCriterionHandler(QueryModel.Negation.class, (ctx, obj, negation) -> {
            if (negation.getCriteria().size() != 1) throw new IllegalStateException("Negation not supported on multiple criterion: " + negation);
            QueryModel.Criterion criterion = (QueryModel.Criterion)negation.getCriteria().iterator().next();
            if (criterion instanceof QueryModel.In) {
                QueryModel.In in = (QueryModel.In)criterion;
                this.handleCriterion(ctx, obj, (QueryModel.Criterion)new QueryModel.NotIn(in.getName(), in.getValue()));
                return;
            }
            if (criterion instanceof QueryModel.NotIn) {
                QueryModel.NotIn notIn = (QueryModel.NotIn)criterion;
                this.handleCriterion(ctx, obj, (QueryModel.Criterion)new QueryModel.In(notIn.getName(), notIn.getValue()));
                return;
            }
            if (!(criterion instanceof QueryModel.PropertyCriterion) && !(criterion instanceof QueryModel.PropertyComparisonCriterion)) throw new IllegalStateException("Negation is not supported for this criterion: " + criterion);
            LinkedHashMap<String, Object> neg = new LinkedHashMap<String, Object>();
            this.handleCriterion(ctx, neg, criterion);
            if (neg.size() != 1) {
                throw new IllegalStateException("Expected size of 1");
            }
            String key = (String)neg.keySet().iterator().next();
            obj.put(key, Collections.singletonMap("$not", neg.get(key)));
        });
        this.addCriterionHandler(QueryModel.Conjunction.class, (ctx, sb, conjunction) -> this.handleJunction(ctx, sb, (QueryModel.Junction)conjunction, "$and"));
        this.addCriterionHandler(QueryModel.Disjunction.class, (ctx, sb, disjunction) -> this.handleJunction(ctx, sb, (QueryModel.Junction)disjunction, "$or"));
        this.addCriterionHandler(QueryModel.IsTrue.class, (context, sb, criterion) -> this.handleCriterion(context, sb, (QueryModel.Criterion)new QueryModel.Equals(criterion.getProperty(), (Object)true)));
        this.addCriterionHandler(QueryModel.IsFalse.class, (context, sb, criterion) -> this.handleCriterion(context, sb, (QueryModel.Criterion)new QueryModel.Equals(criterion.getProperty(), (Object)false)));
        this.addCriterionHandler(QueryModel.Equals.class, this.propertyOperatorExpression("$eq"));
        this.addCriterionHandler(QueryModel.IdEquals.class, (context, sb, criterion) -> this.handleCriterion(context, sb, (QueryModel.Criterion)new QueryModel.Equals("id", criterion.getValue())));
        this.addCriterionHandler(QueryModel.VersionEquals.class, (context, sb, criterion) -> this.handleCriterion(context, sb, (QueryModel.Criterion)new QueryModel.Equals(context.getPersistentEntity().getVersion().getName(), criterion.getValue())));
        this.addCriterionHandler(QueryModel.NotEquals.class, this.propertyOperatorExpression("$ne"));
        this.addCriterionHandler(QueryModel.GreaterThan.class, this.propertyOperatorExpression("$gt"));
        this.addCriterionHandler(QueryModel.GreaterThanEquals.class, this.propertyOperatorExpression("$gte"));
        this.addCriterionHandler(QueryModel.LessThan.class, this.propertyOperatorExpression("$lt"));
        this.addCriterionHandler(QueryModel.LessThanEquals.class, this.propertyOperatorExpression("$lte"));
        this.addCriterionHandler(QueryModel.IsNull.class, (context, sb, criterion) -> this.handleCriterion(context, sb, (QueryModel.Criterion)new QueryModel.Equals(criterion.getProperty(), null)));
        this.addCriterionHandler(QueryModel.IsNotNull.class, (context, sb, criterion) -> this.handleCriterion(context, sb, (QueryModel.Criterion)new QueryModel.NotEquals(criterion.getProperty(), null)));
        this.addCriterionHandler(QueryModel.IsNotNull.class, (context, sb, criterion) -> this.handleCriterion(context, sb, (QueryModel.Criterion)new QueryModel.NotEquals(criterion.getProperty(), null)));
        this.addCriterionHandler(QueryModel.GreaterThanProperty.class, this.comparison("$gt"));
        this.addCriterionHandler(QueryModel.GreaterThanEqualsProperty.class, this.comparison("$gte"));
        this.addCriterionHandler(QueryModel.LessThanProperty.class, this.comparison("$lt"));
        this.addCriterionHandler(QueryModel.LessThanEqualsProperty.class, this.comparison("$lte"));
        this.addCriterionHandler(QueryModel.EqualsProperty.class, this.comparison("$eq"));
        this.addCriterionHandler(QueryModel.NotEqualsProperty.class, this.comparison("$ne"));
        this.addCriterionHandler(QueryModel.Between.class, (context, obj, criterion) -> {
            QueryModel.Conjunction conjunction = new QueryModel.Conjunction();
            conjunction.add((QueryModel.Criterion)new QueryModel.GreaterThanEquals(criterion.getProperty(), criterion.getFrom()));
            conjunction.add((QueryModel.Criterion)new QueryModel.LessThanEquals(criterion.getProperty(), criterion.getTo()));
            this.handleCriterion(context, obj, (QueryModel.Criterion)conjunction);
        });
        this.addCriterionHandler(QueryModel.Regex.class, this.propertyOperatorExpression("$regex", value -> {
            if (value instanceof BindingParameter) {
                return value;
            }
            return new RegexPattern(value.toString());
        }));
        this.addCriterionHandler(QueryModel.IsEmpty.class, (context, obj, criterion) -> obj.put("$or", Arrays.asList(Collections.singletonMap(criterion.getProperty(), Collections.singletonMap("$eq", "")), Collections.singletonMap(criterion.getProperty(), Collections.singletonMap("$exists", false)))));
        this.addCriterionHandler(QueryModel.IsNotEmpty.class, (context, obj, criterion) -> obj.put("$and", Arrays.asList(Collections.singletonMap(criterion.getProperty(), Collections.singletonMap("$ne", "")), Collections.singletonMap(criterion.getProperty(), Collections.singletonMap("$exists", true)))));
        this.addCriterionHandler(QueryModel.In.class, (context, obj, criterion) -> {
            PersistentPropertyPath propertyPath = context.getRequiredProperty((QueryModel.PropertyNameCriterion)criterion);
            Object value = criterion.getValue();
            if (value instanceof Iterable) {
                List values = CollectionUtils.iterableToList((Iterable)((Iterable)value));
                obj.put(criterion.getProperty(), Collections.singletonMap("$in", values.stream().map(val -> this.valueRepresentation(context, propertyPath, val)).collect(Collectors.toList())));
            } else {
                obj.put(criterion.getProperty(), Collections.singletonMap("$in", Collections.singletonList(this.valueRepresentation(context, propertyPath, value))));
            }
        });
        this.addCriterionHandler(QueryModel.NotIn.class, (context, obj, criterion) -> {
            PersistentPropertyPath propertyPath = context.getRequiredProperty((QueryModel.PropertyNameCriterion)criterion);
            Object value = criterion.getValue();
            if (value instanceof Iterable) {
                List values = CollectionUtils.iterableToList((Iterable)((Iterable)value));
                obj.put(criterion.getProperty(), Collections.singletonMap("$nin", values.stream().map(val -> this.valueRepresentation(context, propertyPath, val)).collect(Collectors.toList())));
            } else {
                obj.put(criterion.getProperty(), Collections.singletonMap("$nin", Collections.singletonList(this.valueRepresentation(context, propertyPath, value))));
            }
        });
    }

    private <T extends QueryModel.PropertyCriterion> CriterionHandler<T> propertyOperatorExpression(String op) {
        return this.propertyOperatorExpression(op, null);
    }

    private <T extends QueryModel.PropertyCriterion> CriterionHandler<T> propertyOperatorExpression(String op, Function<Object, Object> mapper) {
        return (context, obj, criterion) -> {
            Object value = criterion.getValue();
            if (mapper != null) {
                value = mapper.apply(value);
            }
            PersistentPropertyPath propertyPath = context.getRequiredProperty((QueryModel.PropertyNameCriterion)criterion);
            Object finalValue = value;
            this.traversePersistentProperties(propertyPath.getAssociations(), propertyPath.getProperty(), (associations, property) -> {
                String path = this.asPath((List<Association>)associations, (PersistentProperty)property);
                obj.put(path, Collections.singletonMap(op, this.valueRepresentation(context, propertyPath, PersistentPropertyPath.of((List)associations, (PersistentProperty)property), finalValue)));
            });
        };
    }

    private String getPropertyPersistName(PersistentProperty property) {
        if (property.getOwner() != null && property.getOwner().getIdentity() == property) {
            return "_id";
        }
        return property.getAnnotationMetadata().stringValue(SerdeConfig.class, "property").orElseGet(() -> ((PersistentProperty)property).getName());
    }

    private Object valueRepresentation(CriteriaContext context, PersistentPropertyPath propertyPath, Object value) {
        return this.valueRepresentation(context, propertyPath, propertyPath, value);
    }

    private Object valueRepresentation(CriteriaContext context, PersistentPropertyPath inPropertyPath, PersistentPropertyPath outPropertyPath, Object value) {
        if (value instanceof BindingParameter) {
            int index = context.pushParameter((BindingParameter)value, this.newBindingContext(inPropertyPath, outPropertyPath));
            return Collections.singletonMap(QUERY_PARAMETER_PLACEHOLDER, index);
        }
        return this.asLiteral(value);
    }

    private <T extends QueryModel.PropertyComparisonCriterion> CriterionHandler<T> comparison(String operator) {
        return (ctx, obj, comparisonCriterion) -> {
            PersistentPropertyPath p1 = ctx.getRequiredProperty(comparisonCriterion.getProperty(), comparisonCriterion.getClass());
            PersistentPropertyPath p2 = ctx.getRequiredProperty(comparisonCriterion.getOtherProperty(), comparisonCriterion.getClass());
            obj.put("$expr", Collections.singletonMap(operator, Arrays.asList("$" + p1.getPath(), "$" + p2.getPath())));
        };
    }

    private Object asLiteral(@Nullable Object value) {
        if (value instanceof RegexPattern) {
            return "'" + Pattern.quote(((RegexPattern)value).value) + "'";
        }
        return value;
    }

    public QueryResult buildInsert(AnnotationMetadata repositoryMetadata, PersistentEntity entity) {
        return null;
    }

    public QueryResult buildQuery(AnnotationMetadata annotationMetadata, final QueryModel query) {
        ArgumentUtils.requireNonNull((String)"annotationMetadata", (Object)annotationMetadata);
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        final QueryState queryState = new QueryState(query, true);
        Map<Object, Object> predicateObj = new LinkedHashMap();
        LinkedHashMap<String, Object> group = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> projectionObj = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> countObj = new LinkedHashMap<String, Object>();
        this.addLookups(query.getJoinPaths(), queryState);
        List pipeline = queryState.rootLookups.pipeline;
        this.buildProjection(query.getProjections(), query.getPersistentEntity(), group, projectionObj, countObj);
        QueryModel.Junction criteria = query.getCriteria();
        if (!criteria.isEmpty()) {
            predicateObj = this.buildWhereClause(annotationMetadata, criteria, queryState);
        }
        if (!predicateObj.isEmpty()) {
            pipeline.add(Collections.singletonMap("$match", predicateObj));
        }
        if (!group.isEmpty()) {
            group.put("_id", null);
            pipeline.add(Collections.singletonMap("$group", group));
        }
        if (!countObj.isEmpty()) {
            pipeline.add(countObj);
        }
        if (!projectionObj.isEmpty()) {
            pipeline.add(Collections.singletonMap("$project", projectionObj));
        } else {
            String customProjection = annotationMetadata.stringValue("io.micronaut.data.mongodb.annotation.MongoProjection").orElse(null);
            if (customProjection != null) {
                pipeline.add(Collections.singletonMap("$project", new RawJsonValue(customProjection)));
            }
        }
        Sort sort = query.getSort();
        if (sort.isSorted() && !sort.getOrderBy().isEmpty()) {
            LinkedHashMap sortObj = new LinkedHashMap();
            sort.getOrderBy().forEach(order -> sortObj.put(order.getProperty(), order.isAscending() ? 1 : -1));
            pipeline.add(Collections.singletonMap("$sort", sortObj));
        } else {
            String customSort = annotationMetadata.stringValue("io.micronaut.data.mongodb.annotation.MongoSort").orElse(null);
            if (customSort != null) {
                pipeline.add(Collections.singletonMap("$sort", new RawJsonValue(customSort)));
            }
        }
        if (query.getOffset() > 0L) {
            pipeline.add(Collections.singletonMap("$skip", query.getOffset()));
        }
        if (query.getMax() != -1) {
            pipeline.add(Collections.singletonMap("$limit", query.getMax()));
        }
        final String q = pipeline.isEmpty() ? "{}" : (this.isMatchOnlyStage(pipeline) ? this.toJsonString(predicateObj) : this.toJsonString(pipeline));
        return new QueryResult(){

            @NonNull
            public String getQuery() {
                return q;
            }

            public int getMax() {
                return query.getMax();
            }

            public long getOffset() {
                return query.getOffset();
            }

            public List<String> getQueryParts() {
                return Collections.emptyList();
            }

            public List<QueryParameterBinding> getParameterBindings() {
                return queryState.getParameterBindings();
            }

            public Map<String, String> getAdditionalRequiredParameters() {
                return Collections.emptyMap();
            }
        };
    }

    private void addLookups(Collection<JoinPath> joins, QueryState queryState) {
        if (joins.isEmpty()) {
            return;
        }
        List joined = joins.stream().map(JoinPath::getPath).sorted((o1, o2) -> Comparator.comparingInt(String::length).thenComparing(String::compareTo).compare((String)o1, (String)o2)).collect(Collectors.toList());
        for (String join : joined) {
            StringJoiner rootPath = new StringJoiner(".");
            StringJoiner currentEntityPath = new StringJoiner(".");
            LookupsStage currentLookup = queryState.rootLookups;
            for (String path : StringUtils.splitOmitEmptyStrings((CharSequence)join, (char)'.')) {
                Association association;
                rootPath.add(path);
                currentEntityPath.add(path);
                String thisPath = currentEntityPath.toString();
                if (currentLookup.subLookups.containsKey(thisPath)) {
                    currentLookup = (LookupsStage)currentLookup.subLookups.get(path);
                    currentEntityPath = new StringJoiner(".");
                    continue;
                }
                PersistentPropertyPath propertyPath = currentLookup.persistentEntity.getPropertyPath(thisPath);
                PersistentProperty property = propertyPath.getProperty();
                if (!(property instanceof Association) || (association = (Association)property).getKind() == Relation.Kind.EMBEDDED) continue;
                LookupsStage lookupStage = new LookupsStage(association.getAssociatedEntity());
                List pipeline = currentLookup.pipeline;
                Optional<Association> inverseSide = association.getInverseSide().map(Function.identity());
                PersistentEntity persistentEntity = association.getOwner();
                String joinedCollectionName = association.getAssociatedEntity().getPersistedName();
                String ownerCollectionName = persistentEntity.getPersistedName();
                if (association.getKind() == Relation.Kind.MANY_TO_MANY || association.isForeignKey() && !inverseSide.isPresent()) {
                    PersistentEntity associatedEntity = association.getAssociatedEntity();
                    PersistentEntity associationOwner = association.getOwner();
                    PersistentProperty identity = associatedEntity.getIdentity();
                    if (identity == null) {
                        throw new IllegalArgumentException("Associated entity [" + associatedEntity.getName() + "] defines no ID. Cannot join.");
                    }
                    PersistentProperty associatedId = associationOwner.getIdentity();
                    if (associatedId == null) {
                        throw new MappingException("Cannot join on entity [" + associationOwner.getName() + "] that has no declared ID");
                    }
                    Association owningAssociation = inverseSide.orElse(association);
                    boolean isAssociationOwner = !association.getInverseSide().isPresent();
                    NamingStrategy namingStrategy = associationOwner.getNamingStrategy();
                    AnnotationMetadata annotationMetadata = owningAssociation.getAnnotationMetadata();
                    List<String> ownerJoinFields = this.resolveJoinTableAssociatedFields(annotationMetadata, isAssociationOwner, associationOwner, namingStrategy);
                    List<String> ownerJoinCollectionFields = this.resolveJoinTableJoinFields(annotationMetadata, isAssociationOwner, associationOwner, namingStrategy);
                    List<String> associationJoinFields = this.resolveJoinTableAssociatedFields(annotationMetadata, !isAssociationOwner, associatedEntity, namingStrategy);
                    List<String> associationJoinCollectionFields = this.resolveJoinTableJoinFields(annotationMetadata, !isAssociationOwner, associatedEntity, namingStrategy);
                    String joinCollectionName = namingStrategy.mappedName(owningAssociation);
                    ArrayList<Map<String, Object>> joinCollectionLookupPipeline = new ArrayList<Map<String, Object>>();
                    pipeline.add(this.lookup(joinCollectionName, "_id", ownerCollectionName, joinCollectionLookupPipeline, thisPath));
                    joinCollectionLookupPipeline.add(this.lookup(joinedCollectionName, joinedCollectionName, "_id", (List<Map<String, Object>>)lookupStage.pipeline, joinedCollectionName));
                    joinCollectionLookupPipeline.add(this.unwind("$" + joinedCollectionName, true));
                    joinCollectionLookupPipeline.add(Collections.singletonMap("$replaceRoot", Collections.singletonMap("newRoot", "$" + joinedCollectionName)));
                } else {
                    String currentPath = this.asPath(propertyPath.getAssociations(), propertyPath.getProperty());
                    if (association.isForeignKey()) {
                        String mappedBy = (String)association.getAnnotationMetadata().stringValue(Relation.class, "mappedBy").orElseThrow(IllegalStateException::new);
                        PersistentPropertyPath mappedByPath = association.getAssociatedEntity().getPropertyPath(mappedBy);
                        if (mappedByPath == null) {
                            throw new IllegalStateException("Cannot find mapped path: " + mappedBy);
                        }
                        if (!(mappedByPath.getProperty() instanceof Association)) {
                            throw new IllegalStateException("Expected association as a mapped path: " + mappedBy);
                        }
                        ArrayList<String> localMatchFields = new ArrayList<String>();
                        ArrayList<String> foreignMatchFields = new ArrayList<String>();
                        this.traversePersistentProperties(currentLookup.persistentEntity.getIdentity(), (associations, p) -> {
                            String fieldPath = this.asPath((List<Association>)associations, (PersistentProperty)p);
                            localMatchFields.add(fieldPath);
                        });
                        ArrayList<Association> mappedAssociations = new ArrayList<Association>(mappedByPath.getAssociations());
                        mappedAssociations.add((Association)mappedByPath.getProperty());
                        this.traversePersistentProperties(mappedAssociations, currentLookup.persistentEntity.getIdentity(), (associations, p) -> {
                            String fieldPath = this.asPath((List<Association>)associations, (PersistentProperty)p);
                            foreignMatchFields.add(fieldPath);
                        });
                        pipeline.add(this.lookup(joinedCollectionName, localMatchFields, foreignMatchFields, (List<Map<String, Object>>)lookupStage.pipeline, currentPath));
                    } else {
                        ArrayList<Association> mappedAssociations = new ArrayList<Association>(propertyPath.getAssociations());
                        mappedAssociations.add((Association)propertyPath.getProperty());
                        ArrayList<String> localMatchFields = new ArrayList<String>();
                        ArrayList<String> foreignMatchFields = new ArrayList<String>();
                        PersistentProperty identity = lookupStage.persistentEntity.getIdentity();
                        if (identity == null) {
                            throw new IllegalStateException("Null identity of persistent entity: " + lookupStage.persistentEntity);
                        }
                        this.traversePersistentProperties(mappedAssociations, identity, (associations, p) -> {
                            String fieldPath = this.asPath((List<Association>)associations, (PersistentProperty)p);
                            localMatchFields.add(fieldPath);
                        });
                        this.traversePersistentProperties(identity, (associations, p) -> {
                            String fieldPath = this.asPath((List<Association>)associations, (PersistentProperty)p);
                            foreignMatchFields.add(fieldPath);
                        });
                        pipeline.add(this.lookup(joinedCollectionName, localMatchFields, foreignMatchFields, (List<Map<String, Object>>)lookupStage.pipeline, currentPath));
                    }
                    if (association.getKind().isSingleEnded()) {
                        pipeline.add(this.unwind("$" + currentPath, true));
                    }
                }
                currentLookup.subLookups.put(currentEntityPath.toString(), lookupStage);
            }
            queryState.joinPaths.add(join);
        }
    }

    @NonNull
    private List<String> resolveJoinTableJoinFields(AnnotationMetadata annotationMetadata, boolean associationOwner, PersistentEntity entity, NamingStrategy namingStrategy) {
        List<String> joinColumns = this.getJoinedFields(annotationMetadata, associationOwner, "name");
        if (!joinColumns.isEmpty()) {
            return joinColumns;
        }
        ArrayList<String> fields = new ArrayList<String>();
        this.traversePersistentProperties(entity.getIdentity(), (associations, property) -> fields.add(this.asPath((List<Association>)associations, (PersistentProperty)property)));
        return fields;
    }

    @NonNull
    private List<String> resolveJoinTableAssociatedFields(AnnotationMetadata annotationMetadata, boolean associationOwner, PersistentEntity entity, NamingStrategy namingStrategy) {
        List<String> joinColumns = this.getJoinedFields(annotationMetadata, associationOwner, "referencedColumnName");
        if (!joinColumns.isEmpty()) {
            return joinColumns;
        }
        PersistentProperty identity = entity.getIdentity();
        if (identity == null) {
            throw new MappingException("Cannot have a foreign key association without an ID on entity: " + entity.getName());
        }
        ArrayList<String> fields = new ArrayList<String>();
        this.traversePersistentProperties(identity, (associations, property) -> fields.add(this.asPath((List<Association>)associations, (PersistentProperty)property)));
        return fields;
    }

    @NonNull
    private List<String> getJoinedFields(AnnotationMetadata annotationMetadata, boolean associationOwner, String columnType) {
        return Collections.emptyList();
    }

    private String asPath(List<Association> associations, PersistentProperty property) {
        if (associations.isEmpty()) {
            return this.getPropertyPersistName(property);
        }
        StringJoiner joiner = new StringJoiner(".");
        for (Association association : associations) {
            joiner.add(this.getPropertyPersistName((PersistentProperty)association));
        }
        joiner.add(this.getPropertyPersistName(property));
        return joiner.toString();
    }

    private Map<String, Object> lookup(String from, String localField, String foreignField, List<Map<String, Object>> pipeline, String as) {
        LinkedHashMap<String, Object> lookup = new LinkedHashMap<String, Object>();
        lookup.put("from", from);
        lookup.put("localField", localField);
        lookup.put("foreignField", foreignField);
        lookup.put("pipeline", pipeline);
        lookup.put("as", as);
        return Collections.singletonMap("$lookup", lookup);
    }

    private Map<String, Object> lookup(String from, List<String> localFields, List<String> foreignFields, List<Map<String, Object>> pipeline, String as) {
        if (localFields.size() != foreignFields.size()) {
            throw new IllegalStateException("Un-matching join columns size: " + localFields.size() + " != " + foreignFields.size() + " " + localFields + ", " + foreignFields);
        }
        if (localFields.size() == 1) {
            return this.lookup(from, localFields.iterator().next(), foreignFields.iterator().next(), pipeline, as);
        }
        ArrayList<Map<String, List<String>>> matches = new ArrayList<Map<String, List<String>>>(localFields.size());
        LinkedHashMap<String, Object> let = new LinkedHashMap<String, Object>();
        int i = 1;
        Iterator<String> foreignIt = foreignFields.iterator();
        for (String localField : localFields) {
            String var = "v" + i++;
            let.put(var, "$" + localField);
            matches.add(Collections.singletonMap("$eq", Arrays.asList("$$" + var, "$" + foreignIt.next())));
        }
        Map<String, Object> match = matches.size() > 1 ? Collections.singletonMap("$match", Collections.singletonMap("$expr", Collections.singletonMap("$and", matches))) : Collections.singletonMap("$match", Collections.singletonMap("$expr", matches.iterator().next()));
        return this.lookup(from, let, match, pipeline, as);
    }

    private Map<String, Object> lookup(String from, Map<String, Object> let, Map<String, Object> match, List<Map<String, Object>> pipeline, String as) {
        pipeline.add(match);
        LinkedHashMap<String, Object> lookup = new LinkedHashMap<String, Object>();
        lookup.put("from", from);
        lookup.put("let", let);
        lookup.put("pipeline", pipeline);
        lookup.put("as", as);
        return Collections.singletonMap("$lookup", lookup);
    }

    private Map<String, Object> unwind(String path, boolean preserveNullAndEmptyArrays) {
        LinkedHashMap<String, Object> unwind = new LinkedHashMap<String, Object>();
        unwind.put("path", path);
        unwind.put("preserveNullAndEmptyArrays", preserveNullAndEmptyArrays);
        return Collections.singletonMap("$unwind", unwind);
    }

    private boolean isMatchOnlyStage(List<Map<String, Object>> pipeline) {
        return pipeline.size() == 1 && pipeline.iterator().next().containsKey("$match");
    }

    private Map<String, Object> buildWhereClause(AnnotationMetadata annotationMetadata, QueryModel.Junction criteria, final QueryState queryState) {
        CriteriaContext ctx = new CriteriaContext(){

            @Override
            public QueryState getQueryState() {
                return queryState;
            }

            @Override
            public PersistentEntity getPersistentEntity() {
                return queryState.getEntity();
            }

            @Override
            public PersistentPropertyPath getRequiredProperty(String name, Class<?> criterionClazz) {
                return MongoQueryBuilder.this.findProperty(queryState, name, criterionClazz);
            }
        };
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        this.handleCriterion(ctx, obj, (QueryModel.Criterion)criteria);
        return obj;
    }

    private void buildProjection(List<QueryModel.Projection> projectionList, PersistentEntity entity, Map<String, Object> groupObj, Map<String, Object> projectionObj, Map<String, Object> countObj) {
        if (!projectionList.isEmpty()) {
            for (QueryModel.Projection projection : projectionList) {
                if (projection instanceof QueryModel.LiteralProjection) {
                    QueryModel.LiteralProjection literalProjection = (QueryModel.LiteralProjection)projection;
                    projectionObj.put("val", Collections.singletonMap("$literal", this.asLiteral(literalProjection.getValue())));
                    continue;
                }
                if (projection instanceof QueryModel.CountProjection) {
                    countObj.put("$count", "result");
                    continue;
                }
                if (projection instanceof QueryModel.DistinctProjection) {
                    throw new UnsupportedOperationException("Not implemented yet");
                }
                if (projection instanceof QueryModel.IdProjection) {
                    projectionObj.put("_id", 1);
                    continue;
                }
                if (!(projection instanceof QueryModel.PropertyProjection)) continue;
                QueryModel.PropertyProjection pp = (QueryModel.PropertyProjection)projection;
                if (projection instanceof QueryModel.AvgProjection) {
                    this.addProjection(groupObj, pp, "$avg");
                    continue;
                }
                if (projection instanceof QueryModel.DistinctPropertyProjection) {
                    throw new UnsupportedOperationException("Not implemented yet");
                }
                if (projection instanceof QueryModel.SumProjection) {
                    this.addProjection(groupObj, pp, "$sum");
                    continue;
                }
                if (projection instanceof QueryModel.MinProjection) {
                    this.addProjection(groupObj, pp, "$min");
                    continue;
                }
                if (projection instanceof QueryModel.MaxProjection) {
                    this.addProjection(groupObj, pp, "$max");
                    continue;
                }
                if (projection instanceof QueryModel.CountDistinctProjection) {
                    throw new UnsupportedOperationException("Not implemented yet");
                }
                String propertyName = pp.getPropertyName();
                PersistentPropertyPath propertyPath = entity.getPropertyPath(propertyName);
                if (propertyPath == null) {
                    throw new IllegalArgumentException("Cannot project on non-existent property: " + propertyName);
                }
                projectionObj.put(this.getPropertyPersistName(propertyPath.getProperty()), 1);
            }
        }
    }

    private void addProjection(Map<String, Object> groupBy, QueryModel.PropertyProjection pr, String op) {
        groupBy.put(pr.getPropertyName(), Collections.singletonMap(op, "$" + pr.getPropertyName()));
    }

    @NonNull
    private PersistentPropertyPath findProperty(QueryState queryState, String name, Class criterionType) {
        return this.findPropertyInternal(queryState, queryState.getEntity(), name, criterionType);
    }

    private PersistentPropertyPath findPropertyInternal(QueryState queryState, PersistentEntity entity, String name, Class criterionType) {
        PersistentPropertyPath propertyPath = entity.getPropertyPath(name);
        if (propertyPath != null) {
            String joinStringPath;
            if (propertyPath.getAssociations().isEmpty()) {
                return propertyPath;
            }
            Association joinAssociation = null;
            StringJoiner joinPathJoiner = new StringJoiner(".");
            for (Association association : propertyPath.getAssociations()) {
                joinPathJoiner.add(association.getName());
                if (association instanceof Embedded) continue;
                if (joinAssociation == null) {
                    joinAssociation = association;
                    continue;
                }
                if (association != joinAssociation.getAssociatedEntity().getIdentity()) {
                    if (!queryState.isAllowJoins()) {
                        throw new IllegalArgumentException("Joins cannot be used in a DELETE or UPDATE operation");
                    }
                    String joinStringPath2 = joinPathJoiner.toString();
                    if (!queryState.isJoined(joinStringPath2)) {
                        throw new IllegalArgumentException("Property is not joined at path: " + joinStringPath2);
                    }
                    joinAssociation = association;
                    continue;
                }
                joinAssociation = null;
            }
            PersistentProperty property = propertyPath.getProperty();
            if (joinAssociation != null && property != joinAssociation.getAssociatedEntity().getIdentity() && !queryState.isJoined(joinStringPath = joinPathJoiner.toString())) {
                throw new IllegalArgumentException("Property is not joined at path: " + joinStringPath);
            }
        } else if ("id".equals(name) && entity.getIdentity() != null) {
            return PersistentPropertyPath.of(Collections.emptyList(), (PersistentProperty)entity.getIdentity(), (String)entity.getIdentity().getName());
        }
        if (propertyPath == null) {
            if (criterionType == null || criterionType == Sort.Order.class) {
                throw new IllegalArgumentException("Cannot order on non-existent property path: " + name);
            }
            throw new IllegalArgumentException("Cannot use [" + criterionType.getSimpleName() + "] criterion on non-existent property path: " + name);
        }
        return propertyPath;
    }

    private void handleJunction(CriteriaContext ctx, Map<String, Object> query, QueryModel.Junction criteria, String operator) {
        if (criteria.getCriteria().size() == 1) {
            this.handleCriterion(ctx, query, (QueryModel.Criterion)criteria.getCriteria().iterator().next());
        } else {
            ArrayList<LinkedHashMap<String, Object>> ops = new ArrayList<LinkedHashMap<String, Object>>(criteria.getCriteria().size());
            query.put(operator, ops);
            for (QueryModel.Criterion criterion : criteria.getCriteria()) {
                LinkedHashMap<String, Object> criterionObj = new LinkedHashMap<String, Object>();
                ops.add(criterionObj);
                this.handleCriterion(ctx, criterionObj, criterion);
            }
        }
    }

    private void handleCriterion(CriteriaContext ctx, Map<String, Object> query, QueryModel.Criterion criterion) {
        CriterionHandler criterionHandler = this.queryHandlers.get(criterion.getClass());
        if (criterionHandler == null) {
            throw new IllegalArgumentException("Queries of type " + criterion.getClass().getSimpleName() + " are not supported by this implementation");
        }
        criterionHandler.handle(ctx, query, criterion);
    }

    public QueryResult buildUpdate(AnnotationMetadata annotationMetadata, QueryModel query, List<String> propertiesToUpdate) {
        throw new IllegalStateException("Only 'buildUpdate' with 'Map<String, Object> propertiesToUpdate' is supported");
    }

    public QueryResult buildUpdate(AnnotationMetadata annotationMetadata, QueryModel query, Map<String, Object> propertiesToUpdate) {
        ArgumentUtils.requireNonNull((String)"annotationMetadata", (Object)annotationMetadata);
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        ArgumentUtils.requireNonNull((String)"propertiesToUpdate", propertiesToUpdate);
        final QueryState queryState = new QueryState(query, true);
        QueryModel.Junction criteria = query.getCriteria();
        String predicateQuery = "";
        if (!criteria.isEmpty()) {
            Map<String, Object> predicate = this.buildWhereClause(annotationMetadata, criteria, queryState);
            predicateQuery = this.toJsonString(predicate);
        }
        LinkedHashMap<String, Object> sets = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> e : propertiesToUpdate.entrySet()) {
            if (e.getValue() instanceof BindingParameter) {
                PersistentPropertyPath propertyPath = this.findProperty(queryState, e.getKey(), null);
                int index = queryState.pushParameter((BindingParameter)e.getValue(), this.newBindingContext(propertyPath));
                sets.put(e.getKey(), Collections.singletonMap(QUERY_PARAMETER_PLACEHOLDER, index));
                continue;
            }
            sets.put(e.getKey(), e.getValue());
        }
        final String update = this.toJsonString(Collections.singletonMap("$set", sets));
        final String finalPredicateQuery = predicateQuery;
        return new QueryResult(){

            @NonNull
            public String getQuery() {
                return finalPredicateQuery;
            }

            public String getUpdate() {
                return update;
            }

            public List<String> getQueryParts() {
                return Collections.emptyList();
            }

            public List<QueryParameterBinding> getParameterBindings() {
                return queryState.getParameterBindings();
            }

            public Map<String, String> getAdditionalRequiredParameters() {
                return Collections.emptyMap();
            }
        };
    }

    public QueryResult buildDelete(AnnotationMetadata annotationMetadata, QueryModel query) {
        ArgumentUtils.requireNonNull((String)"annotationMetadata", (Object)annotationMetadata);
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        QueryState queryState = new QueryState(query, true);
        QueryModel.Junction criteria = query.getCriteria();
        String predicateQuery = "";
        if (!criteria.isEmpty()) {
            Map<String, Object> predicate = this.buildWhereClause(annotationMetadata, criteria, queryState);
            predicateQuery = this.toJsonString(predicate);
        }
        return QueryResult.of((String)predicateQuery, Collections.emptyList(), queryState.getParameterBindings(), queryState.getAdditionalRequiredParameters(), (int)query.getMax(), (long)query.getOffset());
    }

    public QueryResult buildOrderBy(PersistentEntity entity, Sort sort) {
        throw new UnsupportedOperationException();
    }

    public QueryResult buildPagination(Pageable pageable) {
        throw new UnsupportedOperationException();
    }

    private String toJsonString(Object obj) {
        StringBuilder sb = new StringBuilder();
        this.append(sb, obj);
        return sb.toString();
    }

    private void appendMap(StringBuilder sb, Map<String, Object> map) {
        sb.append("{");
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> e = iterator.next();
            String key = e.getKey();
            Object value = e.getValue();
            if (this.skipValue(value)) continue;
            if (this.shouldEscapeKey(key)) {
                sb.append("'").append(key).append("'");
            } else {
                sb.append(key);
            }
            sb.append(":");
            this.append(sb, value);
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
    }

    private boolean skipValue(Object obj) {
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        return false;
    }

    private void appendArray(StringBuilder sb, Collection<Object> collection) {
        sb.append("[");
        Iterator<Object> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            this.append(sb, value);
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
    }

    private void append(StringBuilder sb, Object obj) {
        if (obj instanceof Map) {
            this.appendMap(sb, (Map)obj);
        } else if (obj instanceof Collection) {
            this.appendArray(sb, (Collection)obj);
        } else if (obj instanceof RawJsonValue) {
            sb.append(((RawJsonValue)obj).value);
        } else if (obj == null) {
            sb.append("null");
        } else if (obj instanceof Boolean) {
            sb.append(obj.toString().toLowerCase(Locale.ROOT));
        } else if (obj instanceof Number) {
            sb.append(obj);
        } else {
            sb.append("'");
            sb.append(obj);
            sb.append("'");
        }
    }

    private boolean shouldEscapeKey(String s) {
        for (char c : s.toCharArray()) {
            if (Character.isAlphabetic(c) || Character.isDigit(c) || c == '$' || c == '_') continue;
            return true;
        }
        return false;
    }

    private <T extends QueryModel.Criterion> void addCriterionHandler(Class<T> clazz, CriterionHandler<T> handler) {
        this.queryHandlers.put(clazz, handler);
    }

    private BindingParameter.BindingContext newBindingContext(@Nullable PersistentPropertyPath ref) {
        return this.newBindingContext(ref, ref);
    }

    private BindingParameter.BindingContext newBindingContext(@Nullable PersistentPropertyPath in, @Nullable PersistentPropertyPath out) {
        return BindingParameter.BindingContext.create().incomingMethodParameterProperty(in).outgoingQueryParameterProperty(out);
    }

    private void traversePersistentProperties(PersistentProperty property, BiConsumer<List<Association>, PersistentProperty> consumer) {
        this.traversePersistentProperties(Collections.emptyList(), property, consumer);
    }

    private void traversePersistentProperties(List<Association> associations, PersistentProperty property, BiConsumer<List<Association>, PersistentProperty> consumerProperty) {
        if (property instanceof Embedded) {
            Embedded embedded = (Embedded)property;
            PersistentEntity embeddedEntity = embedded.getAssociatedEntity();
            Collection embeddedProperties = embeddedEntity.getPersistentProperties();
            ArrayList<Association> newAssociations = new ArrayList<Association>(associations);
            newAssociations.add((Association)property);
            for (PersistentProperty embeddedProperty : embeddedProperties) {
                this.traversePersistentProperties(newAssociations, embeddedProperty, consumerProperty);
            }
        } else if (property instanceof Association) {
            Association association = (Association)property;
            if (association.isForeignKey()) {
                return;
            }
            ArrayList<Association> newAssociations = new ArrayList<Association>(associations);
            newAssociations.add((Association)property);
            PersistentEntity associatedEntity = association.getAssociatedEntity();
            PersistentProperty assocIdentity = associatedEntity.getIdentity();
            if (assocIdentity == null) {
                throw new IllegalStateException("Identity cannot be missing for: " + associatedEntity);
            }
            if (assocIdentity instanceof Association) {
                this.traversePersistentProperties(newAssociations, assocIdentity, consumerProperty);
            } else {
                consumerProperty.accept(newAssociations, assocIdentity);
            }
        } else {
            consumerProperty.accept(associations, property);
        }
    }

    private static final class RegexPattern {
        private final String value;

        private RegexPattern(String value) {
            this.value = value;
        }
    }

    private static interface PropertyParameterCreator {
        public int pushParameter(@NotNull BindingParameter var1, @NotNull BindingParameter.BindingContext var2);
    }

    @Internal
    protected final class QueryState
    implements PropertyParameterCreator {
        private final Set<String> joinPaths = new TreeSet<String>();
        private final AtomicInteger position = new AtomicInteger(0);
        private final Map<String, String> additionalRequiredParameters = new LinkedHashMap<String, String>();
        private final List<QueryParameterBinding> parameterBindings;
        private final boolean allowJoins;
        private final PersistentEntity entity;
        private final LookupsStage rootLookups;

        private QueryState(QueryModel query, boolean allowJoins) {
            this.allowJoins = allowJoins;
            this.entity = query.getPersistentEntity();
            this.parameterBindings = new ArrayList<QueryParameterBinding>(this.entity.getPersistentPropertyNames().size());
            this.rootLookups = new LookupsStage(this.entity);
        }

        public PersistentEntity getEntity() {
            return this.entity;
        }

        public boolean isAllowJoins() {
            return this.allowJoins;
        }

        public boolean isJoined(String associationPath) {
            for (String joinPath : this.joinPaths) {
                if (!joinPath.startsWith(associationPath)) continue;
                return true;
            }
            return this.joinPaths.contains(associationPath);
        }

        @NotNull
        public Map<String, String> getAdditionalRequiredParameters() {
            return this.additionalRequiredParameters;
        }

        public List<QueryParameterBinding> getParameterBindings() {
            return this.parameterBindings;
        }

        @Override
        public int pushParameter(@NotNull BindingParameter bindingParameter, @NotNull BindingParameter.BindingContext bindingContext) {
            int index = this.position.getAndIncrement();
            bindingContext = bindingContext.index(index);
            this.parameterBindings.add(bindingParameter.bind(bindingContext));
            return index;
        }
    }

    private static final class LookupsStage {
        private final PersistentEntity persistentEntity;
        private final List<Map<String, Object>> pipeline = new ArrayList<Map<String, Object>>();
        private final Map<String, LookupsStage> subLookups = new HashMap<String, LookupsStage>();

        private LookupsStage(PersistentEntity persistentEntity) {
            this.persistentEntity = persistentEntity;
        }
    }

    private static interface CriteriaContext
    extends PropertyParameterCreator {
        public QueryState getQueryState();

        public PersistentEntity getPersistentEntity();

        public PersistentPropertyPath getRequiredProperty(String var1, Class<?> var2);

        @Override
        default public int pushParameter(@NotNull BindingParameter bindingParameter, @NotNull BindingParameter.BindingContext bindingContext) {
            return this.getQueryState().pushParameter(bindingParameter, bindingContext);
        }

        default public PersistentPropertyPath getRequiredProperty(QueryModel.PropertyNameCriterion propertyCriterion) {
            return this.getRequiredProperty(propertyCriterion.getProperty(), propertyCriterion.getClass());
        }
    }

    private static interface CriterionHandler<T extends QueryModel.Criterion> {
        public void handle(CriteriaContext var1, Map<String, Object> var2, T var3);
    }

    private static final class RawJsonValue {
        private final String value;

        private RawJsonValue(String value) {
            this.value = value;
        }
    }
}

