/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.connection.support;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.connection.ConnectionOperations;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.connection.SynchronousConnectionManager;
import io.micronaut.data.connection.exceptions.ConnectionException;
import io.micronaut.data.connection.exceptions.NoConnectionException;
import io.micronaut.data.connection.support.ConnectionCustomizer;
import io.micronaut.data.connection.support.DefaultConnectionStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractConnectionOperations<C>
implements ConnectionOperations<C>,
SynchronousConnectionManager<C> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<ConnectionCustomizer<C>> connectionCustomizers = new ArrayList<ConnectionCustomizer<C>>(10);

    @Override
    public boolean managesConnection(ConnectionStatus<C> connectionStatus) {
        if (connectionStatus instanceof DefaultConnectionStatus) {
            DefaultConnectionStatus propagatedConnectionStatus = (DefaultConnectionStatus)connectionStatus;
            return propagatedConnectionStatus.isConnectionOf(this);
        }
        return false;
    }

    public void addConnectionCustomizer(@NonNull ConnectionCustomizer<C> connectionCustomizer) {
        this.connectionCustomizers.add(connectionCustomizer);
        OrderUtil.sort(this.connectionCustomizers);
    }

    protected abstract C openConnection(ConnectionDefinition var1);

    protected abstract void setupConnection(ConnectionStatus<C> var1);

    protected abstract void closeConnection(ConnectionStatus<C> var1);

    @Override
    public final Optional<ConnectionStatus<C>> findConnectionStatus() {
        return PropagatedContext.getOrEmpty().findAll(ConnectionStatus.class).filter(element -> this.managesConnection((ConnectionStatus<C>)element)).map(v -> v).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <R> R execute(@NonNull ConnectionDefinition definition, @NonNull Function<ConnectionStatus<C>, R> callback) {
        ConnectionStatus connection = this.getConnection(definition);
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing with a connection: [{}]", (Object)connection);
            }
            this.setupConnection(connection);
            Object object = connection.propagate(() -> AbstractConnectionOperations.lambda$execute$0(callback, (DefaultConnectionStatus)connection));
            return (R)object;
        }
        finally {
            this.complete(connection);
        }
    }

    @Override
    public @NonNull DefaultConnectionStatus<C> getConnection(@NonNull ConnectionDefinition definition) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Getting a connection for a definition: [{}]", (Object)definition);
        }
        ConnectionStatus existingConnection = this.findConnectionStatus().orElse(null);
        return switch (definition.getPropagationBehavior()) {
            case ConnectionDefinition.Propagation.REQUIRED -> {
                if (existingConnection == null) {
                    yield this.openNewConnectionInternal(definition);
                }
                yield this.reuseExistingConnectionInternal(existingConnection);
            }
            case ConnectionDefinition.Propagation.MANDATORY -> {
                if (existingConnection == null) {
                    throw new NoConnectionException("No existing connection found for connection marked with propagation 'mandatory'");
                }
                yield this.reuseExistingConnectionInternal(existingConnection);
            }
            case ConnectionDefinition.Propagation.REQUIRES_NEW -> {
                if (existingConnection == null) {
                    yield this.openNewConnectionInternal(definition);
                }
                yield this.openNewConnectionInternal(definition);
            }
            default -> throw new ConnectionException("Unknown propagation: " + String.valueOf((Object)definition.getPropagationBehavior()));
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(@NonNull ConnectionStatus<C> status) {
        DefaultConnectionStatus connectionStatus = (DefaultConnectionStatus)status;
        try {
            connectionStatus.complete();
        }
        finally {
            try {
                connectionStatus.beforeClosed();
            }
            finally {
                try {
                    if (connectionStatus.isNew()) {
                        this.closeConnection(status);
                    }
                }
                finally {
                    connectionStatus.afterClosed();
                }
            }
        }
    }

    private DefaultConnectionStatus<C> openNewConnectionInternal(@NonNull ConnectionDefinition definition) {
        C connection = this.openConnection(definition);
        return new DefaultConnectionStatus<C>(connection, definition, true, this);
    }

    private DefaultConnectionStatus<C> reuseExistingConnectionInternal(@NonNull ConnectionStatus<C> existingStatus) {
        return new DefaultConnectionStatus<C>(existingStatus.getConnection(), existingStatus.getDefinition(), false, this);
    }

    private static /* synthetic */ Object lambda$execute$0(Function callback, DefaultConnectionStatus connection) {
        return callback.apply(connection);
    }
}

