/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.connection;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.connection.ConnectionOperations;
import io.micronaut.data.connection.ConnectionOperationsRegistry;
import io.micronaut.data.connection.async.AsyncConnectionOperations;
import io.micronaut.data.connection.reactive.ReactiveStreamsConnectionOperations;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.inject.Singleton;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
@Singleton
final class DefaultConnectionOperationsRegistry
implements ConnectionOperationsRegistry {
    private final BeanLocator beanLocator;

    DefaultConnectionOperationsRegistry(BeanLocator beanLocator) {
        this.beanLocator = beanLocator;
    }

    @Override
    public <T extends ConnectionOperations<?>> @NonNull T provideSynchronous(@NonNull Class<T> connectionOperationsType, @Nullable String dataSourceName) {
        if (dataSourceName == null) {
            try {
                return (T)((ConnectionOperations)this.beanLocator.getBean(connectionOperationsType, null));
            }
            catch (NoSuchBeanException e) {
                throw new ConfigurationException("No backing ConnectionOperations configured. Check your configuration and try again", (Throwable)e);
            }
        }
        try {
            return (T)((ConnectionOperations)this.beanLocator.getBean(connectionOperationsType, Qualifiers.byName((String)dataSourceName)));
        }
        catch (NoSuchBeanException e) {
            throw new ConfigurationException("No backing ConnectionOperations configured for datasource: [" + dataSourceName + "]. Check your configuration and try again", (Throwable)e);
        }
    }

    @Override
    public <T extends ReactiveStreamsConnectionOperations<?>> @NonNull T provideReactive(@NonNull Class<T> connectionOperationsType, @Nullable String dataSourceName) {
        if (dataSourceName == null) {
            try {
                return (T)((ReactiveStreamsConnectionOperations)this.beanLocator.getBean(connectionOperationsType, null));
            }
            catch (NoSuchBeanException e) {
                throw new ConfigurationException("No reactive connection management has been configured. Ensure you have correctly configured a reactive capable connection manager");
            }
        }
        try {
            return (T)((ReactiveStreamsConnectionOperations)this.beanLocator.getBean(connectionOperationsType, Qualifiers.byName((String)dataSourceName)));
        }
        catch (NoSuchBeanException e) {
            throw new ConfigurationException("No reactive connection management has been configured for datasource: [" + dataSourceName + "]. Ensure you have correctly configured a reactive capable connection manager");
        }
    }

    @Override
    public <T extends AsyncConnectionOperations<?>> @NonNull T provideAsync(@NonNull Class<T> connectionOperationsType, @Nullable String dataSourceName) {
        if (dataSourceName == null) {
            try {
                return (T)((AsyncConnectionOperations)this.beanLocator.getBean(connectionOperationsType, null));
            }
            catch (NoSuchBeanException e) {
                throw new ConfigurationException("No reactive connection management has been configured. Ensure you have correctly configured a async capable connection manager");
            }
        }
        try {
            return (T)((AsyncConnectionOperations)this.beanLocator.getBean(connectionOperationsType, Qualifiers.byName((String)dataSourceName)));
        }
        catch (NoSuchBeanException e) {
            throw new ConfigurationException("No reactive connection management has been configured for datasource: [" + dataSourceName + "]. Ensure you have correctly configured a async capable connection manager");
        }
    }
}

